/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.newcheck20241015;

import cn.hutool.core.bean.BeanUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.dao.work.check.newcheck20241015.PhcPhysicalCheckReportMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckReport;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckSearchParam;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckStaffBasicInfo;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckStaffFactorConclusion;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.check.newcheck20241015.IPhcPhysicalCheckReportService;
import cn.smarthse.modules.health.service.work.check.newcheck20241015.IPhcPhysicalCheckStaffBasicInfoService;
import cn.smarthse.modules.health.service.work.check.newcheck20241015.IPhcPhysicalCheckStaffFactorConclusionService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.vo.work.check.CheckStaffInfo;
import cn.smarthse.modules.health.vo.work.check.ReportVo;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckReportServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckReportMapper, PhcPhysicalCheckReport>
implements IPhcPhysicalCheckReportService {
    private final IPhcPhysicalCheckStaffBasicInfoService phcPhysicalCheckStaffBasicInfoService;
    private final IPhcPhysicalCheckStaffFactorConclusionService phcPhysicalCheckStaffFactorConclusionService;
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    private final ICompanyOrganizationService companyOrganizationService;
    private final IStaffBasicInfoService staffBasicInfoService;
    private final IStaffInfoService staffInfoService;
    private final IStaffBasicWorkService staffBasicWorkService;
    private final IStaffWorkRoleService staffWorkRoleService;
    private final IStaffFieldChangeLogService staffFieldChangeLogService;
    private final IReformItemBasicNewService reformItemBasicNewService;
    private final DataSourceTransactionManager transactionManager;

    public void convertData(String unifiedSocialCc) {
        long startTime = System.currentTimeMillis();
        int pageSize = 5;
        Integer count = ((PhcPhysicalCheckReportMapper)this.dao).countNum(unifiedSocialCc);
        int pages = (int)Math.ceil((double)count.intValue() * 1.0 / (double)pageSize);
        int currentPage = 1;
        this.logger.info("\u4f53\u68c0\u8f6c\u6362\u4efb\u52a1\u5f00\u59cb\uff0c\u5171{}\u9875", (Object)pages);
        for (int i = 1; i <= pages; ++i) {
            this.logger.info("\u5f00\u59cb\u8f6c\u6362\u7b2c{}\u9875\u6570\u636e", (Object)i);
            PageHelper.startPage((int)currentPage, (int)pageSize, (boolean)false);
            Map<String, Long> unifiedSocialCcCidMap = this.queryUnifiedSocialCcCidMap(unifiedSocialCc, pageSize);
            if (MapUtils.isEmpty(unifiedSocialCcCidMap)) {
                this.logger.error("\u7b2c{}\u9875\u6570\u636e\u4e3a\u7a7a", (Object)i);
                continue;
            }
            ArrayList<String> creditCodeEmployerList = new ArrayList<String>(unifiedSocialCcCidMap.keySet());
            List<PhcPhysicalCheckReport> list = ((PhcPhysicalCheckReportMapper)this.dao).getPhcPhysicalCheckReportList(creditCodeEmployerList);
            if (CollectionUtils.isEmpty(list)) {
                this.logger.error("\u7b2c{}\u9875\u6570\u636e\u4e3a\u7a7a", (Object)i);
                continue;
            }
            List<PhcPhysicalCheckReport> dbList = this.queryDbList(list);
            ArrayList<PhcPhysicalCheckReport> insertList = new ArrayList<PhcPhysicalCheckReport>();
            ArrayList<PhcPhysicalCheckReport> updateList = new ArrayList<PhcPhysicalCheckReport>();
            this.separateData(insertList, updateList, list, dbList);
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                if (CollectionUtils.isNotEmpty(insertList)) {
                    for (PhcPhysicalCheckReport report : insertList) {
                        report.setId(Long.valueOf(this.idworker.nextId()));
                        report.setCreateDate(new Date());
                        report.setCreateBy(Long.valueOf(0L));
                        report.setUpdateBy(Long.valueOf(0L));
                        report.setUpdateDate(new Date());
                        report.setIsValid(Boolean.valueOf(true));
                    }
                    int reportNum = ((PhcPhysicalCheckReportMapper)this.dao).insertList2(insertList);
                    this.logger.info("\u4f53\u68c0\u4e3b\u8868\u63d2\u5165{}\u6761\u6570\u636e", (Object)reportNum);
                }
                if (CollectionUtils.isNotEmpty(updateList)) {
                    int reportNum = this.batchUpdateOrInsert(updateList, PhcPhysicalCheckReportMapper.class, (item, mapper) -> {
                        item.setUpdateDate(new Date());
                        return mapper.updateByPrimaryKeySelective(item);
                    });
                    this.logger.info("\u4f53\u68c0\u4e3b\u8868\u66f4\u65b0{}\u6761\u6570\u636e", (Object)reportNum);
                }
                this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb", (Object)i);
                Set<String> cardIds = this.convertedStaffInfo(creditCodeEmployerList, list);
                this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f", (Object)i);
                this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u5f00\u59cb", (Object)i);
                this.settingIsConvertedByCardIds(cardIds);
                this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u7ed3\u675f", (Object)i);
                this.transactionManager.commit(status);
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\u5931\u8d25,msg:{}", (Object)i, (Object)e.getMessage());
                this.transactionManager.rollback(status);
                e.printStackTrace();
                ++currentPage;
            }
        }
        this.logger.info("\u4f53\u68c0\u8f6c\u6362\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - startTime) / 1000L));
    }

    public PhcPhysicalStatisticsModel statisticsYearNum(Long cid, Integer year) {
        return ((PhcPhysicalCheckReportMapper)this.dao).statisticsYearNum(cid, year);
    }

    public List<Integer> queryYearList(Long cid) {
        List<Integer> yearList = ((PhcPhysicalCheckReportMapper)this.dao).queryYearList(cid);
        return CollectionUtils.isEmpty(yearList) ? Collections.singletonList(DateUtils.getThisYear()) : yearList;
    }

    public List<ReportVo> queryReportList(PhcPhysicalCheckSearchParam param) {
        return ((PhcPhysicalCheckReportMapper)this.dao).queryReportList(param);
    }

    public PageInfo<ReportVo> queryReportListPage(PhcPhysicalCheckSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(this.queryReportList(param));
    }

    public ReportVo info(Long id) {
        List<String> otherConclusion = Arrays.asList("1", "2", "5");
        ReportVo detail = ((PhcPhysicalCheckReportMapper)this.dao).queryDetailById(id);
        List<CheckStaffInfo> checkStaffInfoList = ((PhcPhysicalCheckReportMapper)this.dao).queryCheckStaff(id);
        long numberOfOther = checkStaffInfoList.stream().filter(c -> otherConclusion.contains(c.getConclusion())).map(CheckStaffInfo::getIdcardCode).distinct().count();
        List hazardCodes = checkStaffInfoList.stream().map(CheckStaffInfo::getHazardCode).distinct().collect(Collectors.toList());
        String contactHazardCodes = this.dictionaryService.getContactHazardCodes(hazardCodes);
        List factorNameList = cn.smarthse.common.util.StringUtils.parseToStringList((String)contactHazardCodes, (String)",");
        detail.setNumberOfOther(Integer.valueOf((int)numberOfOther));
        detail.setFactorNameList(factorNameList);
        return detail;
    }

    private void settingIsConvertedByCardIds(Set<String> cardIds) {
        ((PhcPhysicalCheckReportMapper)this.dao).settingIsConvertedByCardIds(cardIds);
    }

    private void separateData(List<PhcPhysicalCheckReport> insertList, List<PhcPhysicalCheckReport> updateList, List<PhcPhysicalCheckReport> list, List<PhcPhysicalCheckReport> dbList) {
        if (CollectionUtils.isEmpty(dbList)) {
            insertList.addAll(list);
            return;
        }
        Map<Long, List<PhcPhysicalCheckReport>> listMap = list.stream().collect(Collectors.groupingBy(PhcPhysicalCheckReport::getCid));
        Map<Long, List<PhcPhysicalCheckReport>> dbMap = dbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckReport::getCid));
        for (Long cid : listMap.keySet()) {
            if (!dbMap.containsKey(cid)) {
                insertList.addAll((Collection<PhcPhysicalCheckReport>)listMap.get(cid));
                continue;
            }
            List<PhcPhysicalCheckReport> sigleCompanyList = listMap.get(cid);
            List<PhcPhysicalCheckReport> sigleCompanyDbList = dbMap.get(cid);
            Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckReport>>>> map = sigleCompanyDbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckReport::getOrgName, Collectors.groupingBy(PhcPhysicalCheckReport::getCheckTime, Collectors.groupingBy(PhcPhysicalCheckReport::getBodyCheckType))));
            for (PhcPhysicalCheckReport check : sigleCompanyList) {
                Map<Date, Map<Integer, List<PhcPhysicalCheckReport>>> map_1 = map.get(check.getOrgName());
                if (MapUtils.isEmpty(map_1)) {
                    insertList.add(check);
                    continue;
                }
                Map<Integer, List<PhcPhysicalCheckReport>> map_2 = map_1.get(check.getCheckTime());
                if (MapUtils.isEmpty(map_2)) {
                    insertList.add(check);
                    continue;
                }
                List<PhcPhysicalCheckReport> resultList = map_2.get(check.getBodyCheckType());
                if (CollectionUtils.isEmpty(resultList)) {
                    insertList.add(check);
                    continue;
                }
                PhcPhysicalCheckReport dbData = resultList.get(0);
                dbData.setNumberOfCheck(Integer.valueOf(dbData.getNumberOfCheck() + check.getNumberOfCheck()));
                dbData.setNumberOfXfc(Integer.valueOf(dbData.getNumberOfXfc() + check.getNumberOfXfc()));
                dbData.setNumberOfYsjjz(Integer.valueOf(dbData.getNumberOfYsjjz() + check.getNumberOfYsjjz()));
                dbData.setNumberOfYszyb(Integer.valueOf(dbData.getNumberOfYszyb() + check.getNumberOfYszyb()));
                dbData.setNumberOfMan(Integer.valueOf(dbData.getNumberOfMan() + check.getNumberOfMan()));
                dbData.setNumberOfWoman(Integer.valueOf(dbData.getNumberOfWoman() + check.getNumberOfWoman()));
                dbData.setNumberOfReexamination(Integer.valueOf(dbData.getNumberOfReexamination() + check.getNumberOfReexamination()));
                updateList.add(dbData);
            }
        }
    }

    private List<PhcPhysicalCheckReport> queryDbList(List<PhcPhysicalCheckReport> list) {
        Example example = new Example(PhcPhysicalCheckReport.class);
        List cidList = list.stream().map(PhcPhysicalCheckReport::getCid).distinct().collect(Collectors.toList());
        List bodyCheckTypeList = list.stream().map(PhcPhysicalCheckReport::getBodyCheckType).distinct().collect(Collectors.toList());
        List OrgNameList = list.stream().map(PhcPhysicalCheckReport::getOrgName).distinct().collect(Collectors.toList());
        List checkDateList = list.stream().map(PhcPhysicalCheckReport::getCheckTime).distinct().collect(Collectors.toList());
        example.createCriteria().andIn("cid", cidList).andIn("bodyCheckType", bodyCheckTypeList).andIn("orgName", OrgNameList).andIn("checkTime", checkDateList);
        return this.getListByExample(example);
    }

    private Set<String> convertedStaffInfo(List<String> creditCodeEmployerList, List<PhcPhysicalCheckReport> reportList) {
        ArrayList factorConclusionList = new ArrayList();
        Map<String, Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckReport>>>>> reportMap = reportList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckReport::getCreditCodeEmployer, Collectors.groupingBy(PhcPhysicalCheckReport::getOrgName, Collectors.groupingBy(PhcPhysicalCheckReport::getCheckTime, Collectors.groupingBy(PhcPhysicalCheckReport::getBodyCheckType)))));
        List<PhcPhysicalStaffCheckInfo> staffCheckInfoList = ((PhcPhysicalCheckReportMapper)this.dao).getStaffCheckInfoByCreditCode(creditCodeEmployerList);
        Map<String, List<PhcPhysicalStaffCheckInfo>> cardIdMap = staffCheckInfoList.stream().collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCardId));
        HashMap<String, PhcPhysicalCheckStaffBasicInfo> staffCheckBasicInfoMap = new HashMap<String, PhcPhysicalCheckStaffBasicInfo>();
        for (String cardId : cardIdMap.keySet()) {
            List<PhcPhysicalStaffCheckInfo> phcPhysicalStaffCheckInfos = cardIdMap.get(cardId);
            if (!staffCheckBasicInfoMap.containsKey(cardId)) {
                PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo = phcPhysicalStaffCheckInfos.get(0);
                PhcPhysicalCheckStaffBasicInfo staffCheckBasicInfo = new PhcPhysicalCheckStaffBasicInfo();
                BeanUtils.copyProperties((Object)phcPhysicalStaffCheckInfo, (Object)staffCheckBasicInfo);
                staffCheckBasicInfo.setId(Long.valueOf(this.idworker.nextId()));
                staffCheckBasicInfo.setCreateDate(new Date());
                staffCheckBasicInfo.setCreateBy(Long.valueOf(0L));
                staffCheckBasicInfo.setUpdateBy(Long.valueOf(0L));
                staffCheckBasicInfo.setUpdateDate(new Date());
                staffCheckBasicInfo.setIsValid(Boolean.valueOf(true));
                int bodyCheckType = Integer.parseInt(phcPhysicalStaffCheckInfo.getBodyCheckType());
                staffCheckBasicInfo.setBodyCheckType(Integer.valueOf(bodyCheckType));
                List<PhcPhysicalCheckReport> phcPhysicalCheckReports = reportMap.get(phcPhysicalStaffCheckInfo.getCreditCodeEmployer()).get(phcPhysicalStaffCheckInfo.getOrgName()).get(phcPhysicalStaffCheckInfo.getCheckTime()).get(bodyCheckType);
                if (CollectionUtils.isNotEmpty(phcPhysicalCheckReports)) {
                    PhcPhysicalCheckReport report = phcPhysicalCheckReports.get(0);
                    staffCheckBasicInfo.setReportId(report.getId());
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                if (StringUtils.isNotEmpty((String)staffCheckBasicInfo.getBirthday())) {
                    try {
                        Date date = DateUtils.StringToDate((String)staffCheckBasicInfo.getBirthday());
                        if (date != null) {
                            staffCheckBasicInfo.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)((Date)format.parseObject(staffCheckBasicInfo.getBirthday())), (Date)staffCheckBasicInfo.getCheckTime())));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u751f\u65e5\u8f6c\u6362\u51fa\u9519\uff1a{},id:{}", (Object)staffCheckBasicInfo.getBirthday(), (Object)staffCheckBasicInfo.getId());
                        e.printStackTrace();
                    }
                }
                staffCheckBasicInfoMap.put(cardId, staffCheckBasicInfo);
            }
            Set factorConclusions = phcPhysicalStaffCheckInfos.stream().map(p -> {
                PhcPhysicalCheckStaffFactorConclusion factorConclusion = new PhcPhysicalCheckStaffFactorConclusion();
                BeanUtils.copyProperties((Object)p, (Object)factorConclusion);
                factorConclusion.setId(Long.valueOf(this.idworker.nextId()));
                factorConclusion.setCreateDate(new Date());
                factorConclusion.setCreateBy(Long.valueOf(0L));
                factorConclusion.setUpdateBy(Long.valueOf(0L));
                factorConclusion.setUpdateDate(new Date());
                factorConclusion.setIsValid(Boolean.valueOf(true));
                factorConclusion.setStaffCheckId(((PhcPhysicalCheckStaffBasicInfo)staffCheckBasicInfoMap.get(cardId)).getId());
                return factorConclusion;
            }).collect(Collectors.toSet());
            factorConclusionList.addAll(factorConclusions);
        }
        ArrayList<PhcPhysicalCheckStaffBasicInfo> staffCheckBasicInfos = new ArrayList<PhcPhysicalCheckStaffBasicInfo>(staffCheckBasicInfoMap.values());
        if (CollectionUtils.isNotEmpty(staffCheckBasicInfos)) {
            int n = this.phcPhysicalCheckStaffBasicInfoService.batchInsert(staffCheckBasicInfos);
        }
        if (CollectionUtils.isNotEmpty(factorConclusionList)) {
            int n = this.phcPhysicalCheckStaffFactorConclusionService.batchInsert(factorConclusionList);
        }
        this.batchInsertOrUpdateStaffInfo(staffCheckBasicInfos);
        return staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toSet());
    }

    private void batchInsertAbnormalRisk(List<PhcPhysicalCheckStaffBasicInfo> staffCheckBasicInfos, List<PhcPhysicalCheckStaffFactorConclusion> factorConclusions) {
        List<String> conclusionList = Arrays.asList("3", "4");
        List addRiskList = factorConclusions.stream().filter(f -> conclusionList.contains(f.getConclusion())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(addRiskList)) {
            return;
        }
        Map<Long, PhcPhysicalCheckStaffBasicInfo> staffMap = staffCheckBasicInfos.stream().collect(Collectors.toMap(PhcPhysicalCheckStaffBasicInfo::getId, v -> v, (v1, v2) -> v1));
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        List cardIdList = staffCheckBasicInfos.stream().map(PhcPhysicalCheckStaffBasicInfo::getCardId).distinct().collect(Collectors.toList());
        List riskList = this.reformItemBasicNewService.getListByTjBusinessIds(cardIdList);
        Map<String, ReformItemBasic> tjMap = riskList.stream().collect(Collectors.toMap(ReformItemBasic::getTjBusinessId, v -> v));
        List addParamList = addRiskList.stream().filter(f -> Objects.isNull(tjMap.get(f.getCardId()))).filter(f -> DateUtils.getYear((Date)((PhcPhysicalCheckStaffBasicInfo)staffMap.get(f.getStaffCheckId())).getCheckTime()) >= 2024).map(f -> {
            PhcPhysicalCheckStaffBasicInfo s = (PhcPhysicalCheckStaffBasicInfo)staffMap.get(f.getStaffCheckId());
            ReformAddParam addParam = new ReformAddParam();
            Byte source = null;
            if (f.getConclusion().equals("3")) {
                source = ReformGenerationSourceEnum.YSZYB.getValue();
            } else if (f.getConclusion().equals("4")) {
                source = ReformGenerationSourceEnum.JJZ.getValue();
            }
            addParam.setGenerationSource(source);
            addParam.setReformItemSourceId(s.getReportId());
            addParam.setReformMeasure(null);
            String businessName = this.setBusinessName(s, DateUtils.getYear((Date)s.getCheckTime()), jobMap, bodyCheckTypeMap, f.getConclusion());
            addParam.setFinderName(s.getOrgName());
            addParam.setName(businessName);
            addParam.setFindTime(s.getCreateDate());
            addParam.setCid(s.getCid());
            addParam.setReformItemSource(ReformSourceLiteEnum.ZYJKTJ.getValue());
            addParam.setDataSource(Byte.valueOf((byte)1));
            addParam.setTjBusinessId(s.getCardId());
            return addParam;
        }).collect(Collectors.toList());
        this.reformItemBasicNewService.generateReform(addParamList);
    }

    private String setBusinessName(PhcPhysicalCheckStaffBasicInfo checkStaffBasicInfo, Integer year, Map<String, String> jobMap, Map<String, String> bodyCheckTypeMap, String conclusion) {
        Object businessName = String.valueOf(year);
        String workName = "";
        workName = !"99-9999".equals(checkStaffBasicInfo.getJobCode()) ? jobMap.get(checkStaffBasicInfo.getJobCode()) : checkStaffBasicInfo.getOtherJobName();
        if (StringUtils.isNotEmpty((String)checkStaffBasicInfo.getWorkshop()) && StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + checkStaffBasicInfo.getWorkshop() + "/" + workName;
        } else if (StringUtils.isNotEmpty((String)checkStaffBasicInfo.getWorkshop())) {
            businessName = (String)businessName + "-" + checkStaffBasicInfo.getWorkshop();
        } else if (StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + workName;
        }
        String conclusionStr = "";
        if ("3".equals(conclusion)) {
            conclusionStr = "\u7591\u4f3c\u804c\u4e1a\u75c5";
        } else if ("4".equals(conclusion)) {
            conclusionStr = "\u804c\u4e1a\u7981\u5fcc\u8bc1";
        }
        businessName = (String)businessName + "-" + checkStaffBasicInfo.getName() + "-" + bodyCheckTypeMap.get(checkStaffBasicInfo.getBodyCheckType().toString()) + "-" + conclusionStr;
        return businessName;
    }

    private void batchInsertOrUpdateStaffInfo(List<PhcPhysicalCheckStaffBasicInfo> staffCheckBasicInfos) {
        Map<String, StaffInfo> stringStaffInfoMap = this.computedStaffInfoMap(staffCheckBasicInfos);
        ArrayList<StaffInfo> updateList = new ArrayList<StaffInfo>();
        ArrayList<StaffInfo> staffInfoList = new ArrayList<StaffInfo>(stringStaffInfoMap.values());
        Set<String> idCards = stringStaffInfoMap.keySet();
        HashSet idCardList = new HashSet();
        if (CollectionUtils.isNotEmpty(idCards)) {
            idCards.forEach(i -> idCardList.add(SpringEncryptUtils.encrypt((String)i)));
        }
        Example example = new Example(StaffBasicInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIsNotNull("cid").andIn("idCard", idCardList);
        List staffBasicInfoList = this.staffBasicInfoService.getListByExample(example);
        Iterator iterator = staffInfoList.iterator();
        block0: while (iterator.hasNext()) {
            StaffInfo next = (StaffInfo)iterator.next();
            StaffBasicInfo staffBasicInfo = next.getStaffBasicInfo();
            if (staffBasicInfo == null) continue;
            for (StaffBasicInfo sbi : staffBasicInfoList) {
                if (sbi == null || !staffBasicInfo.getCid().equals(sbi.getCid()) || !staffBasicInfo.getIdCard().equalsIgnoreCase(sbi.getIdCard())) continue;
                updateList.add(next);
                iterator.remove();
                continue block0;
            }
        }
        ArrayList<StaffInfo> addStaffInfoList = new ArrayList<StaffInfo>();
        ArrayList<StaffBasicInfo> addStaffBasicInfoList = new ArrayList<StaffBasicInfo>();
        ArrayList<StaffBasicWork> addStaffBasicWorkList = new ArrayList<StaffBasicWork>();
        ArrayList<StaffWorkRole> addStaffWorkRoleList = new ArrayList<StaffWorkRole>();
        List<CompanyOrganization> companyOrganizationList = new ArrayList<CompanyOrganization>();
        for (StaffInfo staffInfo : staffInfoList) {
            addStaffInfoList.add(staffInfo);
            StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
            addStaffBasicInfoList.add(staffBasicInfo);
            StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
            addStaffBasicWorkList.add(staffBasicWork);
            StaffWorkRole currentStaffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            addStaffWorkRoleList.add(currentStaffWorkRole);
            CompanyOrganization companyOrganization = staffBasicWork.getCompanyOrganization();
            companyOrganizationList.add(companyOrganization);
        }
        int pageSize = 1000;
        int maxSize = Stream.of(addStaffInfoList.size(), addStaffBasicInfoList.size(), addStaffBasicWorkList.size(), addStaffWorkRoleList.size()).max(Comparator.naturalOrder()).orElse(0);
        int page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i2 = 0; i2 < page; ++i2) {
            List<StaffWorkRole> subAddStaffWorkRoleList;
            List<StaffBasicWork> subAddStaffBasicWorkList;
            Object subAddStaffBasicInfoList;
            List<StaffInfo> subAddStaffInfoList = addStaffInfoList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(subAddStaffInfoList)) {
                ((PhcPhysicalCheckReportMapper)this.dao).batchInsertStaffInfo(subAddStaffInfoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(subAddStaffBasicInfoList = addStaffBasicInfoList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList())))) {
                ((PhcPhysicalCheckReportMapper)this.dao).batchInsertStaffBasicInfo((List<StaffBasicInfo>)subAddStaffBasicInfoList);
            }
            if (CollectionUtils.isNotEmpty(subAddStaffBasicWorkList = addStaffBasicWorkList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList()))) {
                ((PhcPhysicalCheckReportMapper)this.dao).batchInsertStaffBasicWork(subAddStaffBasicWorkList);
            }
            if (!CollectionUtils.isNotEmpty(subAddStaffWorkRoleList = addStaffWorkRoleList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList()))) continue;
            ((PhcPhysicalCheckReportMapper)this.dao).batchInsertStaffWorkRole(subAddStaffWorkRoleList);
        }
        addStaffInfoList.clear();
        addStaffBasicInfoList.clear();
        addStaffBasicWorkList.clear();
        addStaffWorkRoleList.clear();
        ArrayList<StaffFieldChangeLog> staffFieldChangeLogList = new ArrayList<StaffFieldChangeLog>();
        for (StaffInfo staffInfo : updateList) {
            StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
            StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
            StaffWorkRole currentStaffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            CompanyOrganization companyOrganization = staffBasicWork.getCompanyOrganization();
            StaffBasicInfo sbi = this.staffBasicInfoService.getStaffBasicInfoByIdCard(staffBasicInfo.getIdCard(), null, staffBasicInfo.getCid());
            StaffInfo si = this.staffInfoService.getStaffInfoByStaffBasicId(sbi.getId(), staffInfo.getCid());
            if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)staffBasicInfo.getJobName()) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)sbi.getJobName()) && !sbi.getJobName().equals(staffBasicInfo.getJobName())) {
                StaffFieldChangeLog staffFieldChangeLog = new StaffFieldChangeLog();
                staffFieldChangeLog.setStaffId(si.getId());
                staffFieldChangeLog.setCid(staffInfo.getCid());
                staffFieldChangeLog.setBeforeInfo(sbi.getJobName());
                staffFieldChangeLog.setAfterInfo(staffBasicInfo.getJobName());
                staffFieldChangeLog.setField(StaffFieldChangeEnum.JOB_NAME.getCode());
                staffFieldChangeLogList.add(staffFieldChangeLog);
            }
            this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, null);
            BeanUtil.copyProperties((Object)staffBasicInfo, (Object)sbi, (String[])new String[]{"id", "idCard", "cid"});
            addStaffBasicInfoList.add(sbi);
            if (si != null) {
                BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid"});
                addStaffInfoList.add(si);
            } else {
                staffInfo.setStaffBasicId(sbi.getId());
                staffInfo.setDataUpdateSource(Byte.valueOf((byte)2));
                addStaffInfoList.add(staffInfo);
            }
            if (si != null && si.getId() != null) {
                StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(si.getId());
                if (sbw != null) {
                    BeanUtil.copyProperties((Object)staffBasicWork, (Object)sbw, (String[])new String[]{"id", "cid", "staffId"});
                    addStaffBasicWorkList.add(sbw);
                } else {
                    staffBasicWork.setStaffId(si.getId());
                    staffBasicWork.setDataUpdateSource(Byte.valueOf((byte)2));
                    addStaffBasicWorkList.add(staffBasicWork);
                }
                StaffWorkRole swr = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(si.getId());
                if (swr != null) {
                    if (swr.getBeginTime() == null) {
                        swr.setIsHistory(Boolean.valueOf(true));
                        swr.setDataUpdateSource(Byte.valueOf((byte)1));
                        swr.setBeginTime(currentStaffWorkRole.getBeginTime());
                        addStaffWorkRoleList.add(swr);
                    }
                } else {
                    currentStaffWorkRole.setIsHistory(Boolean.valueOf(false));
                    currentStaffWorkRole.setDataUpdateSource(Byte.valueOf((byte)2));
                    currentStaffWorkRole.setStaffId(si.getId());
                    addStaffWorkRoleList.add(currentStaffWorkRole);
                }
            }
            companyOrganizationList.add(companyOrganization);
        }
        this.staffInfoService.batchUpdateOrInsert(addStaffInfoList, StaffInfoMapper.class, (item, mapper) -> {
            if (item.getDataUpdateSource() != null && Objects.equals(item.getDataUpdateSource(), (byte)2)) {
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffBasicInfoService.batchUpdateOrInsert(addStaffBasicInfoList, StaffBasicInfoMapper.class, (item, mapper) -> {
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffBasicWorkService.batchUpdateOrInsert(addStaffBasicWorkList, StaffBasicWorkMapper.class, (item, mapper) -> {
            if (item.getDataUpdateSource() != null && Objects.equals(item.getDataUpdateSource(), (byte)2)) {
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffWorkRoleService.batchUpdateOrInsert(addStaffWorkRoleList, StaffWorkRoleMapper.class, (item, mapper) -> {
            if (item.getIsHistory().booleanValue()) {
                item.setIsHistory(Boolean.valueOf(false));
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                item.setDataUpdateSource(Byte.valueOf((byte)1));
                item.setDataSource(null);
                return mapper.updateByPrimaryKeySelective(item);
            }
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataSource(Byte.valueOf((byte)1));
            return mapper.insertSelective(item);
        });
        companyOrganizationList = Optional.of(companyOrganizationList.stream().filter(item -> Objects.nonNull(item.getNewAdd()) && item.getNewAdd() != null && item.getNewAdd() != false && item.getId() != null).distinct().collect(Collectors.toList())).orElse(new ArrayList());
        maxSize = Optional.of(companyOrganizationList.size()).orElse(0);
        page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i3 = 0; i3 < page; ++i3) {
            List<CompanyOrganization> subCompanyOrganizationList = companyOrganizationList.stream().skip((long)i3 * (long)pageSize).limit(pageSize).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(subCompanyOrganizationList)) continue;
            ((PhcPhysicalCheckReportMapper)this.dao).batchInsertCompanyOrganization(subCompanyOrganizationList);
        }
    }

    private Map<String, StaffInfo> computedStaffInfoMap(List<PhcPhysicalCheckStaffBasicInfo> staffCheckBasicInfos) {
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map map = staffCheckBasicInfos.stream().peek(p -> p.setIdcardCode(p.getIdcardCode().toUpperCase())).collect(Collectors.toMap(PhcPhysicalCheckStaffBasicInfo::getIdcardCode, Function.identity(), (c1, c2) -> c1.getCheckTime().compareTo(c2.getCheckTime()) > 0 ? c1 : c2));
        Map idCardMap = this.sysAreaService.getNativePlaceByIdCards(map.keySet());
        HashMap<String, StaffInfo> siMap = new HashMap<String, StaffInfo>();
        Set cidSet = staffCheckBasicInfos.stream().map(PhcPhysicalCheckStaffBasicInfo::getCid).collect(Collectors.toSet());
        Map companyOrganizationMap = this.companyOrganizationService.getAllCompanyOrganizationByCids(cidSet);
        List<Integer> leaveWorkStatus = Arrays.asList(3, 4);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = entry.getKey();
            PhcPhysicalCheckStaffBasicInfo value = (PhcPhysicalCheckStaffBasicInfo)entry.getValue();
            StaffBasicInfo sbi = new StaffBasicInfo();
            sbi.setId(Long.valueOf(this.idworker.nextId()));
            sbi.setRealName(value.getName());
            sbi.setGender(Byte.valueOf(value.getSexCode().equals("\u7537") ? (byte)1 : 0));
            sbi.setIdCard(value.getIdcardCode());
            if (StringUtils.isNotEmpty((String)value.getBirthday())) {
                try {
                    Date date = DateUtils.StringToDate((String)value.getBirthday());
                    if (date != null) {
                        sbi.setBirthday(date);
                        sbi.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)sbi.getBirthday())));
                    }
                }
                catch (Exception e) {
                    this.logger.info("\u751f\u65e5\u8f6c\u6362\u51fa\u9519\uff1a{},id:{}", (Object)value.getBirthday(), (Object)value.getId());
                    e.printStackTrace();
                }
            }
            String nativePlace = (String)idCardMap.get(value.getIdcardCode().substring(0, 6) + "000000");
            sbi.setNativePlace(nativePlace);
            sbi.setMobile(value.getTelPhone());
            sbi.setCid(value.getCid());
            sbi.setCreateDate(new Date());
            sbi.setUpdateDate(new Date());
            sbi.setIsValid(Boolean.valueOf(true));
            sbi.setDataSource(Byte.valueOf((byte)1));
            String jobCode = value.getJobCode();
            String workName = "";
            workName = !"99-9999".equals(jobCode) ? (String)jobMap.get(jobCode) : value.getOtherJobName();
            sbi.setJobName(workName);
            StaffInfo sInfo = new StaffInfo();
            sInfo.setId(Long.valueOf(this.idworker.nextId()));
            sInfo.setStaffBasicId(sbi.getId());
            sInfo.setCid(value.getCid());
            sInfo.setIsThirdParty(Boolean.valueOf(false));
            sInfo.setCheckStatus(Byte.valueOf((byte)2));
            sInfo.setAddFrom(Integer.valueOf(StaffAddFromEnum.wanda_physical_import.getValue().byteValue()));
            sInfo.setCreateDate(new Date());
            sInfo.setUpdateDate(new Date());
            sInfo.setIsValid(Boolean.valueOf(true));
            sInfo.setDataSource(Byte.valueOf((byte)1));
            CompanyOrganization companyOrganization = new CompanyOrganization();
            String comOrgKey = value.getCid() + "-" + value.getWorkshop();
            if (companyOrganizationMap.get(comOrgKey) == null) {
                if (StringUtils.isNotEmpty((String)value.getWorkshop())) {
                    companyOrganization.setId(Long.valueOf(this.idworker.nextId()));
                    companyOrganization.setCid(value.getCid());
                    companyOrganization.setOrganizationName(value.getWorkshop());
                    companyOrganization.setLevel(Byte.valueOf((byte)1));
                    companyOrganization.setNewAdd(Boolean.valueOf(true));
                    companyOrganization.setCreateDate(new Date());
                    companyOrganization.setUpdateDate(new Date());
                    companyOrganization.setIsValid(Boolean.valueOf(true));
                    companyOrganization.setDataSource(Byte.valueOf((byte)1));
                    companyOrganizationMap.put(comOrgKey, companyOrganization);
                }
            } else {
                companyOrganization = (CompanyOrganization)companyOrganizationMap.get(comOrgKey);
            }
            StaffBasicWork staffBasicWork = new StaffBasicWork();
            staffBasicWork.setId(Long.valueOf(this.idworker.nextId()));
            staffBasicWork.setCid(value.getCid());
            staffBasicWork.setStaffId(sInfo.getId());
            staffBasicWork.setOrgId(companyOrganization.getId());
            staffBasicWork.setCreateDate(new Date());
            staffBasicWork.setUpdateDate(new Date());
            staffBasicWork.setIsValid(Boolean.valueOf(true));
            staffBasicWork.setDataSource(Byte.valueOf((byte)1));
            StaffWorkRole staffWorkRole = new StaffWorkRole();
            staffWorkRole.setId(Long.valueOf(this.idworker.nextId()));
            staffWorkRole.setCid(value.getCid());
            staffWorkRole.setStaffId(sInfo.getId());
            staffWorkRole.setWorkProperty(Byte.valueOf((byte)1));
            staffWorkRole.setIsThirdParty(Boolean.valueOf(false));
            staffWorkRole.setIsHistory(Boolean.valueOf(false));
            staffWorkRole.setCreateDate(new Date());
            staffWorkRole.setUpdateDate(new Date());
            staffWorkRole.setIsValid(Boolean.valueOf(true));
            staffWorkRole.setDataSource(Byte.valueOf((byte)1));
            if (value.getBodyCheckType() != null && leaveWorkStatus.contains(value.getBodyCheckType())) {
                staffWorkRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
            } else {
                staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
            }
            sInfo.setStaffBasicInfo(sbi);
            staffBasicWork.setCompanyOrganization(companyOrganization);
            staffBasicWork.setCurrentStaffWorkRole(staffWorkRole);
            sInfo.setStaffBasicWork(staffBasicWork);
            siMap.put(value.getIdcardCode(), sInfo);
        }
        return siMap;
    }

    private Map<String, Long> queryUnifiedSocialCcCidMap(String unifiedSocialCc, int pageSize) {
        List<PhcPhysicalCheckReport> list = ((PhcPhysicalCheckReportMapper)this.dao).getNeedConvertData(unifiedSocialCc, pageSize);
        return list.stream().collect(Collectors.toMap(PhcPhysicalCheckReport::getCreditCodeEmployer, PhcPhysicalCheckReport::getCid));
    }

    @Generated
    public PhcPhysicalCheckReportServiceImpl(IPhcPhysicalCheckStaffBasicInfoService phcPhysicalCheckStaffBasicInfoService, IPhcPhysicalCheckStaffFactorConclusionService phcPhysicalCheckStaffFactorConclusionService, ICompanyOrganizationService companyOrganizationService, IStaffBasicInfoService staffBasicInfoService, IStaffInfoService staffInfoService, IStaffBasicWorkService staffBasicWorkService, IStaffWorkRoleService staffWorkRoleService, IStaffFieldChangeLogService staffFieldChangeLogService, IReformItemBasicNewService reformItemBasicNewService, DataSourceTransactionManager transactionManager) {
        this.phcPhysicalCheckStaffBasicInfoService = phcPhysicalCheckStaffBasicInfoService;
        this.phcPhysicalCheckStaffFactorConclusionService = phcPhysicalCheckStaffFactorConclusionService;
        this.companyOrganizationService = companyOrganizationService;
        this.staffBasicInfoService = staffBasicInfoService;
        this.staffInfoService = staffInfoService;
        this.staffBasicWorkService = staffBasicWorkService;
        this.staffWorkRoleService = staffWorkRoleService;
        this.staffFieldChangeLogService = staffFieldChangeLogService;
        this.reformItemBasicNewService = reformItemBasicNewService;
        this.transactionManager = transactionManager;
    }
}

