/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.checkv3222;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffFieldChangeLogMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.dao.work.check.checkv3222.PhcPhysicalCheckV3222Mapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCompanyInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.check.checkV3222.PhcPhysicalCheckStaffConclusionV3222;
import cn.smarthse.modules.health.entity.work.check.checkV3222.PhcPhysicalCheckStaffV3222;
import cn.smarthse.modules.health.entity.work.check.checkV3222.PhcPhysicalCheckV3222;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckSearchParam;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCompanyInfoService;
import cn.smarthse.modules.health.service.work.check.checkv3222.IPhcPhysicalCheckStaffConclusionV3222Service;
import cn.smarthse.modules.health.service.work.check.checkv3222.IPhcPhysicalCheckStaffV3222Service;
import cn.smarthse.modules.health.service.work.check.checkv3222.IPhcPhysicalCheckV3222Service;
import cn.smarthse.modules.health.vo.work.check.CheckStaffInfo;
import cn.smarthse.modules.health.vo.work.check.ReportVo;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckV3222ServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckV3222Mapper, PhcPhysicalCheckV3222>
implements IPhcPhysicalCheckV3222Service {
    private final IPhcPhysicalCheckStaffV3222Service phcPhysicalCheckStaffV3222Service;
    private final IPhcPhysicalCheckStaffConclusionV3222Service phcPhysicalCheckStaffConclusionV3222Service;
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    private final ICompanyOrganizationService companyOrganizationService;
    private final IStaffBasicInfoService staffBasicInfoService;
    private final IStaffInfoService staffInfoService;
    private final IStaffBasicWorkService staffBasicWorkService;
    private final IStaffWorkRoleService staffWorkRoleService;
    private final IStaffFieldChangeLogService staffFieldChangeLogService;
    private final DataSourceTransactionManager transactionManager;
    private final IPhcPhysicalCompanyInfoService phcPhysicalCompanyInfoService;
    private final IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private StaffFieldChangeLogMapper staffFieldChangeLogMapper;

    @Transactional(readOnly=false)
    public void phcPhysicalCheckTask(String unifiedSocialCcs, Date endTime) {
        this.logger.error("\u8fdb\u5165service\u65b9\u6cd5");
        List<String> unifiedSocialCcList = null;
        if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)unifiedSocialCcs)) {
            unifiedSocialCcList = Arrays.asList(unifiedSocialCcs.split(","));
        }
        Integer pageSize = 5;
        Integer currentPage = 1;
        int num = ((PhcPhysicalCheckV3222Mapper)this.dao).countNum(unifiedSocialCcList);
        long startTime = System.currentTimeMillis();
        int pages = (int)Math.ceil((double)num * 1.0 / (double)pageSize.intValue());
        this.logger.error("\u5206\u9875\u67e5\u8be2\u7ed3\u679c\uff1a{}\u9875", (Object)pages);
        for (int i = 1; i <= pages; ++i) {
            this.logger.error("\u5f00\u59cb\u5faa\u73af\uff1a{}\u9875", (Object)i);
            TransactionStatus status = null;
            try {
                if (this.transactionManager != null) {
                    DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                    def.setPropagationBehavior(3);
                    status = this.transactionManager.getTransaction((TransactionDefinition)def);
                    this.logger.error("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                }
                this.logger.error("\u5f00\u59cb\u8f6c\u6362\u4e1a\u52a1");
                List<String> codeList = this.convertData(unifiedSocialCcList, currentPage, pageSize);
                if (status != null) {
                    this.transactionManager.commit(status);
                    this.logger.error(i + "\u9875\u4e8b\u52a1\u63d0\u4ea4");
                }
                this.logger.error("\u8f6c\u6362\u5b8c\u6210");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                String join = cn.smarthse.common.util.StringUtils.join((Iterable)Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList()), (String)"\n");
                this.logger.error("\u4f53\u68c0\u8f6c\u6362\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)join);
                if (status != null) {
                    this.transactionManager.rollback(status);
                    this.logger.error(i + "\u9875\u4e8b\u52a1\u56de\u6eda");
                }
                currentPage = currentPage + 1;
            }
        }
        this.logger.info("\u4f53\u68c0\u8f6c\u6362\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - startTime) / 1000L));
    }

    @Transactional(readOnly=false)
    public List<String> convertData(List<String> unifiedSocialCcList, Integer page, Integer pageSize) {
        Map<String, Long> unifiedSocialCcCidMap;
        if (ObjectUtil.isNotNull((Object)page) && ObjectUtil.isNotNull((Object)pageSize)) {
            PageHelper.startPage((int)page, (int)pageSize, (boolean)false);
        }
        if (MapUtils.isEmpty(unifiedSocialCcCidMap = this.queryUnifiedSocialCcCidMap(unifiedSocialCcList, pageSize))) {
            this.logger.error("\u5206\u7ec4map\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        ArrayList<String> creditCodeList = new ArrayList<String>(unifiedSocialCcCidMap.keySet());
        List<PhcPhysicalCheckV3222> list = ((PhcPhysicalCheckV3222Mapper)this.dao).getPhcPhysicalCheckV3222List(creditCodeList);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.error("\u7b2c{}\u9875\u6570\u636e\u4e3a\u7a7a", (Object)page);
            return Collections.emptyList();
        }
        List<PhcPhysicalCheckV3222> dbList = this.queryDbList(list);
        ArrayList<PhcPhysicalCheckV3222> insertList = new ArrayList<PhcPhysicalCheckV3222>();
        ArrayList<PhcPhysicalCheckV3222> updateList = new ArrayList<PhcPhysicalCheckV3222>();
        this.separateData(insertList, updateList, list, dbList);
        if (CollectionUtils.isNotEmpty(insertList)) {
            int batchSize = 1000;
            int total = insertList.size();
            int count = 0;
            for (int i = 0; i < total; i += batchSize) {
                int end = Math.min(i + batchSize, total);
                List batchList = insertList.subList(i, end);
                for (PhcPhysicalCheckV3222 report : batchList) {
                    report.setId(Long.valueOf(this.idworker.nextId()));
                    report.setCreateDate(new Date());
                    report.setCreateBy(Long.valueOf(0L));
                    report.setUpdateBy(Long.valueOf(0L));
                    report.setUpdateDate(new Date());
                    report.setIsValid(Boolean.valueOf(true));
                }
                int reportNum = ((PhcPhysicalCheckV3222Mapper)this.dao).insertList2(batchList);
                count += reportNum;
            }
            this.logger.info("\u4f53\u68c0\u4e3b\u8868\u63d2\u5165\u5b8c\u6210\uff0c\u603b\u8ba1 {} \u6761\u6570\u636e", (Object)count);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            int reportNum = this.batchUpdateOrInsert(updateList, PhcPhysicalCheckV3222Mapper.class, (item, mapper) -> {
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
            this.logger.info("\u4f53\u68c0\u4e3b\u8868\u66f4\u65b0{}\u6761\u6570\u636e", (Object)reportNum);
        }
        this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb", (Object)page);
        Set<String> cardIds = this.convertedStaffInfo(creditCodeList, list);
        this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f", (Object)page);
        this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u5f00\u59cb", (Object)page);
        this.settingIsConvertedByCardIds(cardIds);
        this.logger.info("\u7b2c{}\u9875\u4f53\u68c0\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u7ed3\u675f", (Object)page);
        return creditCodeList;
    }

    public PhcPhysicalStatisticsModel statisticsYearNum(Long cid, Integer year) {
        return ((PhcPhysicalCheckV3222Mapper)this.dao).statisticsYearNum(cid, year);
    }

    public List<Integer> queryYearList(Long cid) {
        List<Integer> yearList = ((PhcPhysicalCheckV3222Mapper)this.dao).queryYearList(cid);
        return CollectionUtils.isEmpty(yearList) ? Collections.singletonList(DateUtils.getThisYear()) : yearList;
    }

    public List<ReportVo> queryReportList(PhcPhysicalCheckSearchParam param) {
        return ((PhcPhysicalCheckV3222Mapper)this.dao).queryReportList(param);
    }

    public PageInfo<ReportVo> queryReportListPage(PhcPhysicalCheckSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(this.queryReportList(param));
    }

    public ReportVo info(Long id) {
        List<String> otherConclusion = Arrays.asList("1", "2", "5");
        ReportVo detail = ((PhcPhysicalCheckV3222Mapper)this.dao).queryDetailById(id);
        List<CheckStaffInfo> checkStaffInfoList = ((PhcPhysicalCheckV3222Mapper)this.dao).queryCheckStaff(id);
        long numberOfOther = checkStaffInfoList.stream().filter(c -> otherConclusion.contains(c.getConclusion())).map(CheckStaffInfo::getIdcardCode).distinct().count();
        List hazardCodes = checkStaffInfoList.stream().map(CheckStaffInfo::getHazardCode).distinct().collect(Collectors.toList());
        String contactHazardCodes = this.dictionaryService.getContactHazardCodes(hazardCodes);
        List factorNameList = cn.smarthse.common.util.StringUtils.parseToStringList((String)contactHazardCodes, (String)",");
        detail.setNumberOfOther(Integer.valueOf((int)numberOfOther));
        detail.setFactorNameList(factorNameList);
        return detail;
    }

    private void settingIsConvertedByCardIds(Set<String> cardIds) {
        ((PhcPhysicalCheckV3222Mapper)this.dao).settingIsConvertedByCardIds(cardIds);
    }

    private void separateData(List<PhcPhysicalCheckV3222> insertList, List<PhcPhysicalCheckV3222> updateList, List<PhcPhysicalCheckV3222> list, List<PhcPhysicalCheckV3222> dbList) {
        if (CollectionUtils.isEmpty(dbList)) {
            insertList.addAll(list);
            return;
        }
        Map<Long, List<PhcPhysicalCheckV3222>> listMap = list.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3222::getCid));
        Map<Long, List<PhcPhysicalCheckV3222>> dbMap = dbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3222::getCid));
        for (Long cid : listMap.keySet()) {
            if (!dbMap.containsKey(cid)) {
                insertList.addAll((Collection<PhcPhysicalCheckV3222>)listMap.get(cid));
                continue;
            }
            List<PhcPhysicalCheckV3222> sigleCompanyList = listMap.get(cid);
            List<PhcPhysicalCheckV3222> sigleCompanyDbList = dbMap.get(cid);
            Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckV3222>>>> map = sigleCompanyDbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3222::getOrgName, Collectors.groupingBy(PhcPhysicalCheckV3222::getCheckTime, Collectors.groupingBy(PhcPhysicalCheckV3222::getBodyCheckType))));
            for (PhcPhysicalCheckV3222 check : sigleCompanyList) {
                Map<Date, Map<Integer, List<PhcPhysicalCheckV3222>>> map_1 = map.get(check.getOrgName());
                if (MapUtils.isEmpty(map_1)) {
                    insertList.add(check);
                    continue;
                }
                Map<Integer, List<PhcPhysicalCheckV3222>> map_2 = map_1.get(check.getCheckTime());
                if (MapUtils.isEmpty(map_2)) {
                    insertList.add(check);
                    continue;
                }
                List<PhcPhysicalCheckV3222> resultList = map_2.get(check.getBodyCheckType());
                if (CollectionUtils.isEmpty(resultList)) {
                    insertList.add(check);
                    continue;
                }
                PhcPhysicalCheckV3222 dbData = resultList.get(0);
                check.setId(dbData.getId());
                dbData.setNumberOfCheck(Integer.valueOf(dbData.getNumberOfCheck() + check.getNumberOfCheck()));
                dbData.setNumberOfXfc(Integer.valueOf(dbData.getNumberOfXfc() + check.getNumberOfXfc()));
                dbData.setNumberOfYsjjz(Integer.valueOf(dbData.getNumberOfYsjjz() + check.getNumberOfYsjjz()));
                dbData.setNumberOfYszyb(Integer.valueOf(dbData.getNumberOfYszyb() + check.getNumberOfYszyb()));
                dbData.setNumberOfMan(Integer.valueOf(dbData.getNumberOfMan() + check.getNumberOfMan()));
                dbData.setNumberOfWoman(Integer.valueOf(dbData.getNumberOfWoman() + check.getNumberOfWoman()));
                dbData.setNumberOfReexamination(Integer.valueOf(dbData.getNumberOfReexamination() + check.getNumberOfReexamination()));
                updateList.add(dbData);
            }
        }
    }

    private List<PhcPhysicalCheckV3222> queryDbList(List<PhcPhysicalCheckV3222> list) {
        Example example = new Example(PhcPhysicalCheckV3222.class);
        List cidList = list.stream().map(PhcPhysicalCheckV3222::getCid).distinct().collect(Collectors.toList());
        List bodyCheckTypeList = list.stream().map(PhcPhysicalCheckV3222::getBodyCheckType).distinct().collect(Collectors.toList());
        List OrgNameList = list.stream().map(PhcPhysicalCheckV3222::getOrgName).distinct().collect(Collectors.toList());
        List checkDateList = list.stream().map(PhcPhysicalCheckV3222::getCheckTime).distinct().collect(Collectors.toList());
        example.createCriteria().andIn("cid", cidList).andIn("bodyCheckType", bodyCheckTypeList).andIn("orgName", OrgNameList).andIn("checkTime", checkDateList);
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public void convertedCompanyInfo(List<String> unifiedSocialCcList, Map<String, PhcPhysicalCheckV3222> creditCodeMap) {
        List companyList = this.phcPhysicalCompanyInfoService.getCompanyInfoByCreditCode(unifiedSocialCcList);
        for (PhcPhysicalCompanyInfo companyInfo : companyList) {
            PhcPhysicalCheckV3222 check = creditCodeMap.get(companyInfo.getCreditCode());
            if (check == null) continue;
            companyInfo.setCid(check.getCid());
        }
        this.phcPhysicalCompanyInfoService.batchUpdateOrInsertComInfo(companyList);
        List employerList = this.phcPhysicalCompanyInfoService.getEmployerInfoByCreditCode(unifiedSocialCcList);
        this.phcPhysicalCompanyInfoService.batchUpdateOrInsertEmpInfo(employerList);
    }

    private Set<String> convertedStaffInfo(List<String> creditCodeEmployerList, List<PhcPhysicalCheckV3222> reportList) {
        ArrayList factorConclusionList = new ArrayList();
        Map<String, Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckV3222>>>>> reportMap = reportList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3222::getCreditCodeEmployer, Collectors.groupingBy(PhcPhysicalCheckV3222::getOrgName, Collectors.groupingBy(PhcPhysicalCheckV3222::getCheckTime, Collectors.groupingBy(PhcPhysicalCheckV3222::getBodyCheckType)))));
        List<PhcPhysicalStaffCheckInfo> staffCheckInfoList = ((PhcPhysicalCheckV3222Mapper)this.dao).getStaffCheckInfoByCreditCode(creditCodeEmployerList);
        Map<String, List<PhcPhysicalStaffCheckInfo>> cardIdMap = staffCheckInfoList.stream().collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCardId));
        HashMap<String, PhcPhysicalCheckStaffV3222> staffCheckBasicInfoMap = new HashMap<String, PhcPhysicalCheckStaffV3222>();
        for (String cardId : cardIdMap.keySet()) {
            List<PhcPhysicalStaffCheckInfo> phcPhysicalStaffCheckInfos = cardIdMap.get(cardId);
            if (!staffCheckBasicInfoMap.containsKey(cardId)) {
                PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo = phcPhysicalStaffCheckInfos.get(0);
                if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getOtherDisease())) {
                    phcPhysicalStaffCheckInfo.setOtherDisease(phcPhysicalStaffCheckInfo.getOtherDisease().replace("null;", ""));
                }
                if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getCheckResultCode())) {
                    phcPhysicalStaffCheckInfo.setCheckResultCode(phcPhysicalStaffCheckInfo.getCheckResultCode().replace("......", "").replace("null;", ""));
                }
                PhcPhysicalCheckStaffV3222 checkStaffV3222 = new PhcPhysicalCheckStaffV3222();
                BeanUtils.copyProperties((Object)phcPhysicalStaffCheckInfo, (Object)checkStaffV3222);
                checkStaffV3222.setId(Long.valueOf(this.idworker.nextId()));
                checkStaffV3222.setCreateDate(new Date());
                checkStaffV3222.setCreateBy(Long.valueOf(0L));
                checkStaffV3222.setUpdateBy(Long.valueOf(0L));
                checkStaffV3222.setUpdateDate(new Date());
                checkStaffV3222.setIsValid(Boolean.valueOf(true));
                int bodyCheckType = Integer.parseInt(phcPhysicalStaffCheckInfo.getBodyCheckType());
                checkStaffV3222.setBodyCheckType(Integer.valueOf(bodyCheckType));
                List<PhcPhysicalCheckV3222> checkV3222s = reportMap.get(phcPhysicalStaffCheckInfo.getCreditCodeEmployer()).get(phcPhysicalStaffCheckInfo.getOrgName()).get(phcPhysicalStaffCheckInfo.getCheckTime()).get(bodyCheckType);
                if (CollectionUtils.isNotEmpty(checkV3222s)) {
                    PhcPhysicalCheckV3222 report = checkV3222s.get(0);
                    checkStaffV3222.setReportId(report.getId());
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)checkStaffV3222.getBirthday())) {
                    try {
                        Date date = DateUtils.StringToDate((String)checkStaffV3222.getBirthday());
                        if (date != null) {
                            checkStaffV3222.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)((Date)format.parseObject(checkStaffV3222.getBirthday())), (Date)checkStaffV3222.getCheckTime())));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u751f\u65e5\u8f6c\u6362\u51fa\u9519\uff1a{},id:{}", (Object)checkStaffV3222.getBirthday(), (Object)checkStaffV3222.getId());
                        e.printStackTrace();
                    }
                }
                staffCheckBasicInfoMap.put(cardId, checkStaffV3222);
            }
            Set factorConclusions = phcPhysicalStaffCheckInfos.stream().map(p -> {
                PhcPhysicalCheckStaffConclusionV3222 factorConclusion = new PhcPhysicalCheckStaffConclusionV3222();
                BeanUtils.copyProperties((Object)p, (Object)factorConclusion);
                factorConclusion.setId(Long.valueOf(this.idworker.nextId()));
                factorConclusion.setCreateDate(new Date());
                factorConclusion.setCreateBy(Long.valueOf(0L));
                factorConclusion.setUpdateBy(Long.valueOf(0L));
                factorConclusion.setUpdateDate(new Date());
                factorConclusion.setIsValid(Boolean.valueOf(true));
                factorConclusion.setStaffCheckId(((PhcPhysicalCheckStaffV3222)staffCheckBasicInfoMap.get(cardId)).getId());
                return factorConclusion;
            }).collect(Collectors.toSet());
            factorConclusionList.addAll(factorConclusions);
        }
        ArrayList<PhcPhysicalCheckStaffV3222> checkStaffV3222s = new ArrayList<PhcPhysicalCheckStaffV3222>(staffCheckBasicInfoMap.values());
        if (CollectionUtils.isNotEmpty(checkStaffV3222s)) {
            int n = this.phcPhysicalCheckStaffV3222Service.batchInsert(checkStaffV3222s);
        }
        if (CollectionUtils.isNotEmpty(factorConclusionList)) {
            int n = this.phcPhysicalCheckStaffConclusionV3222Service.batchInsert(factorConclusionList);
        }
        this.batchInsertOrUpdateStaffInfo(checkStaffV3222s);
        return staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toSet());
    }

    private void batchInsertOrUpdateStaffInfo(List<PhcPhysicalCheckStaffV3222> staffCheckBasicInfos) {
        Map<String, StaffInfo> stringStaffInfoMap = this.computedStaffInfoMap(staffCheckBasicInfos);
        ArrayList<StaffInfo> updateList = new ArrayList<StaffInfo>();
        ArrayList<StaffInfo> staffInfoList = new ArrayList<StaffInfo>(stringStaffInfoMap.values());
        Set<String> idCards = stringStaffInfoMap.keySet();
        HashSet idCardList = new HashSet();
        if (CollectionUtils.isNotEmpty(idCards)) {
            idCards.forEach(i -> idCardList.add(SpringEncryptUtils.encrypt((String)i)));
        }
        Example example = new Example(StaffBasicInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIsNotNull("cid").andIn("idCard", idCardList);
        List staffBasicInfoList = this.staffBasicInfoService.getListByExample(example);
        Iterator iterator = staffInfoList.iterator();
        block0: while (iterator.hasNext()) {
            StaffInfo next = (StaffInfo)iterator.next();
            StaffBasicInfo staffBasicInfo = next.getStaffBasicInfo();
            if (staffBasicInfo == null) continue;
            for (StaffBasicInfo sbi : staffBasicInfoList) {
                if (sbi == null || !staffBasicInfo.getCid().equals(sbi.getCid()) || !staffBasicInfo.getIdCard().equalsIgnoreCase(sbi.getIdCard())) continue;
                updateList.add(next);
                iterator.remove();
                continue block0;
            }
        }
        ArrayList<StaffInfo> addStaffInfoList = new ArrayList<StaffInfo>();
        ArrayList<StaffBasicInfo> addStaffBasicInfoList = new ArrayList<StaffBasicInfo>();
        ArrayList<StaffBasicWork> addStaffBasicWorkList = new ArrayList<StaffBasicWork>();
        ArrayList<StaffWorkRole> addStaffWorkRoleList = new ArrayList<StaffWorkRole>();
        List<CompanyOrganization> companyOrganizationList = new ArrayList<CompanyOrganization>();
        ArrayList<StaffFieldChangeLog> staffFieldChangeLogList = new ArrayList<StaffFieldChangeLog>();
        for (StaffInfo staffInfo : staffInfoList) {
            if (ObjectUtil.isNotNull((Object)staffInfo)) {
                StaffFieldChangeLog log = new StaffFieldChangeLog();
                log.setStaffId(staffInfo.getId());
                log.setCid(staffInfo.getCid());
                log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                log.setBeforeInfo("-");
                log.setAfterInfo(Boolean.TRUE.equals(staffInfo.getIsThirdParty()) ? "\u5916\u6765\u4eba\u5458" : "\u672c\u4f01\u4e1a\u4eba\u5458");
                log.setChangeReason("\u4f53\u68c0\u6570\u636e\u65b0\u589e");
                staffFieldChangeLogList.add(log);
            }
            addStaffInfoList.add(staffInfo);
            StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
            addStaffBasicInfoList.add(staffBasicInfo);
            StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
            addStaffBasicWorkList.add(staffBasicWork);
            StaffWorkRole currentStaffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            addStaffWorkRoleList.add(currentStaffWorkRole);
            CompanyOrganization companyOrganization = staffBasicWork.getCompanyOrganization();
            companyOrganizationList.add(companyOrganization);
        }
        int pageSize = 1000;
        int maxSize = Stream.of(addStaffInfoList.size(), addStaffBasicInfoList.size(), addStaffBasicWorkList.size(), addStaffWorkRoleList.size()).max(Comparator.naturalOrder()).orElse(0);
        int page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i2 = 0; i2 < page; ++i2) {
            List<StaffWorkRole> subAddStaffWorkRoleList;
            List<StaffBasicWork> subAddStaffBasicWorkList;
            List<StaffBasicInfo> subAddStaffBasicInfoList;
            List subAddStaffInfoList = addStaffInfoList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)subAddStaffInfoList)) {
                ((PhcPhysicalCheckV3222Mapper)this.dao).batchInsertStaffInfo(subAddStaffInfoList);
            }
            if (CollectionUtils.isNotEmpty(subAddStaffBasicInfoList = addStaffBasicInfoList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList()))) {
                ((PhcPhysicalCheckV3222Mapper)this.dao).batchInsertStaffBasicInfo(subAddStaffBasicInfoList);
            }
            if (CollectionUtils.isNotEmpty(subAddStaffBasicWorkList = addStaffBasicWorkList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList()))) {
                ((PhcPhysicalCheckV3222Mapper)this.dao).batchInsertStaffBasicWork(subAddStaffBasicWorkList);
            }
            if (!CollectionUtils.isNotEmpty(subAddStaffWorkRoleList = addStaffWorkRoleList.stream().skip((long)i2 * (long)pageSize).limit(pageSize).collect(Collectors.toList()))) continue;
            ((PhcPhysicalCheckV3222Mapper)this.dao).batchInsertStaffWorkRole(subAddStaffWorkRoleList);
        }
        addStaffInfoList.clear();
        addStaffBasicInfoList.clear();
        addStaffBasicWorkList.clear();
        addStaffWorkRoleList.clear();
        for (StaffInfo staffInfo : updateList) {
            StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
            StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
            StaffWorkRole currentStaffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            CompanyOrganization companyOrganization = staffBasicWork.getCompanyOrganization();
            StaffBasicInfo sbi = this.staffBasicInfoService.getStaffBasicInfoByIdCard(staffBasicInfo.getIdCard(), null, staffBasicInfo.getCid());
            StaffInfo si = this.staffInfoService.getStaffInfoByStaffBasicId(sbi.getId(), staffInfo.getCid());
            if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)staffBasicInfo.getJobName()) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)sbi.getJobName()) && !sbi.getJobName().equals(staffBasicInfo.getJobName())) {
                StaffFieldChangeLog staffFieldChangeLog = new StaffFieldChangeLog();
                staffFieldChangeLog.setStaffId(ObjectUtil.isNotNull((Object)si) ? si.getId() : null);
                staffFieldChangeLog.setCid(staffInfo.getCid());
                staffFieldChangeLog.setBeforeInfo(sbi.getJobName());
                staffFieldChangeLog.setAfterInfo(staffBasicInfo.getJobName());
                staffFieldChangeLog.setField(StaffFieldChangeEnum.JOB_NAME.getCode());
                staffFieldChangeLog.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                staffFieldChangeLogList.add(staffFieldChangeLog);
            }
            BeanUtil.copyProperties((Object)staffBasicInfo, (Object)sbi, (String[])new String[]{"id", "idCard", "cid"});
            addStaffBasicInfoList.add(sbi);
            if (si != null) {
                Boolean isThirdParty = staffInfo.getIsThirdParty();
                Boolean oldIsThirdParty = si.getIsThirdParty();
                if (Boolean.TRUE.equals(isThirdParty) && Boolean.FALSE.equals(oldIsThirdParty)) {
                    Integer count = this.staffFieldChangeLogMapper.getChangeCount(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode(), si.getId(), si.getCid(), "\u5916\u6765\u4eba\u5458", "\u672c\u4f01\u4e1a\u4eba\u5458");
                    if (ObjectUtil.isNotNull((Object)count) && count > 0) {
                        BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid", "isThirdParty", "outsource", "otherCompany"});
                    } else {
                        BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid"});
                        if (ObjectUtil.isNotNull((Object)si)) {
                            StaffFieldChangeLog log = new StaffFieldChangeLog();
                            log.setStaffId(si.getId());
                            log.setCid(si.getCid());
                            log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                            log.setBeforeInfo(Boolean.TRUE.equals(si.getIsThirdParty()) ? "\u672c\u4f01\u4e1a\u4eba\u5458" : "\u5916\u6765\u4eba\u5458");
                            log.setAfterInfo(Boolean.TRUE.equals(si.getIsThirdParty()) ? "\u5916\u6765\u4eba\u5458" : "\u672c\u4f01\u4e1a\u4eba\u5458");
                            log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                            staffFieldChangeLogList.add(log);
                        }
                    }
                } else {
                    BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid", "isThirdParty", "outsource", "otherCompany"});
                }
                addStaffInfoList.add(si);
            } else {
                staffInfo.setStaffBasicId(sbi.getId());
                staffInfo.setDataUpdateSource(Byte.valueOf((byte)2));
                if (ObjectUtil.isNotNull((Object)staffInfo)) {
                    StaffFieldChangeLog log = new StaffFieldChangeLog();
                    log.setStaffId(staffInfo.getId());
                    log.setCid(staffInfo.getCid());
                    log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                    log.setBeforeInfo("-");
                    log.setAfterInfo(Boolean.TRUE.equals(staffInfo.getIsThirdParty()) ? "\u5916\u6765\u4eba\u5458" : "\u672c\u4f01\u4e1a\u4eba\u5458");
                    log.setChangeReason("\u4f53\u68c0\u6570\u636e\u65b0\u589e");
                    staffFieldChangeLogList.add(log);
                }
                addStaffInfoList.add(staffInfo);
            }
            if (si != null && si.getId() != null) {
                StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(si.getId());
                if (sbw != null) {
                    BeanUtil.copyProperties((Object)staffBasicWork, (Object)sbw, (String[])new String[]{"id", "cid", "staffId"});
                    addStaffBasicWorkList.add(sbw);
                } else {
                    staffBasicWork.setStaffId(si.getId());
                    staffBasicWork.setDataUpdateSource(Byte.valueOf((byte)2));
                    addStaffBasicWorkList.add(staffBasicWork);
                }
                StaffWorkRole swr = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(si.getId());
                if (swr != null) {
                    Boolean falg = false;
                    if (swr.getBeginTime() == null) {
                        swr.setIsHistory(Boolean.valueOf(true));
                        swr.setDataUpdateSource(Byte.valueOf((byte)1));
                        swr.setBeginTime(currentStaffWorkRole.getBeginTime());
                        falg = true;
                    }
                    String wandaHealthCardSourceId = currentStaffWorkRole.getWandaHealthCardSourceId();
                    String idCard = staffBasicInfo.getIdCard();
                    Long cid = staffBasicInfo.getCid();
                    if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)wandaHealthCardSourceId) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)idCard) && ObjectUtil.isNotNull((Object)cid)) {
                        String encs = SpringEncryptUtils.encrypt((String)idCard);
                        PhcPhysicalCheckStaffV3222 phcPhysicalStaffCheckInfo = ((PhcPhysicalCheckV3222Mapper)this.dao).selectLatestPhcPhysicalStaffCheckInfo(encs, cid);
                        Date checkTime = phcPhysicalStaffCheckInfo.getCheckTime();
                        if (ObjectUtil.isNotNull((Object)phcPhysicalStaffCheckInfo) && wandaHealthCardSourceId.equals(phcPhysicalStaffCheckInfo.getCardId()) && ObjectUtil.isNotNull((Object)checkTime)) {
                            Byte status = swr.getStatus();
                            Date beginTime = swr.getBeginTime();
                            Date leaveTime = swr.getLeaveTime();
                            Integer bodyCheckType = phcPhysicalStaffCheckInfo.getBodyCheckType();
                            StaffFieldChangeLog log = new StaffFieldChangeLog();
                            log.setStaffId(si.getId());
                            log.setCid(cid);
                            log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
                            if (ObjectUtil.isNotNull((Object)status) && status == 1 && (ObjectUtil.isNull((Object)beginTime) || beginTime.before(checkTime))) {
                                if (ObjectUtil.isNotNull((Object)bodyCheckType) && 3 == bodyCheckType) {
                                    swr.setIsHistory(Boolean.valueOf(true));
                                    swr.setDataUpdateSource(Byte.valueOf((byte)1));
                                    swr.setStatus(Byte.valueOf((byte)2));
                                    swr.setLeaveTime(phcPhysicalStaffCheckInfo.getCheckTime());
                                    falg = true;
                                    log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)1));
                                    log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)2));
                                    log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                                    staffFieldChangeLogList.add(log);
                                }
                            } else if (ObjectUtil.isNotNull((Object)status) && status == 2 && (ObjectUtil.isNull((Object)leaveTime) || leaveTime.before(checkTime)) && ObjectUtil.isNotNull((Object)bodyCheckType) && (1 == bodyCheckType || 2 == bodyCheckType)) {
                                swr.setIsHistory(Boolean.valueOf(true));
                                swr.setDataUpdateSource(Byte.valueOf((byte)1));
                                swr.setStatus(Byte.valueOf((byte)1));
                                falg = true;
                                log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)2));
                                log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)1));
                                log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                                staffFieldChangeLogList.add(log);
                            }
                        }
                    }
                    if (falg.booleanValue()) {
                        addStaffWorkRoleList.add(swr);
                    }
                } else {
                    currentStaffWorkRole.setIsHistory(Boolean.valueOf(false));
                    currentStaffWorkRole.setDataUpdateSource(Byte.valueOf((byte)2));
                    currentStaffWorkRole.setStaffId(si.getId());
                    addStaffWorkRoleList.add(currentStaffWorkRole);
                }
            }
            companyOrganizationList.add(companyOrganization);
        }
        this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, null);
        this.staffInfoService.batchUpdateOrInsert(addStaffInfoList, StaffInfoMapper.class, (item, mapper) -> {
            if (item.getDataUpdateSource() != null && Objects.equals(item.getDataUpdateSource(), (byte)2)) {
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffBasicInfoService.batchUpdateOrInsert(addStaffBasicInfoList, StaffBasicInfoMapper.class, (item, mapper) -> {
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffBasicWorkService.batchUpdateOrInsert(addStaffBasicWorkList, StaffBasicWorkMapper.class, (item, mapper) -> {
            if (item.getDataUpdateSource() != null && Objects.equals(item.getDataUpdateSource(), (byte)2)) {
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffWorkRoleService.batchUpdateOrInsert(addStaffWorkRoleList, StaffWorkRoleMapper.class, (item, mapper) -> {
            if (item.getIsHistory().booleanValue()) {
                item.setIsHistory(Boolean.valueOf(false));
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                item.setDataUpdateSource(Byte.valueOf((byte)1));
                item.setDataSource(null);
                return mapper.updateByPrimaryKeySelective(item);
            }
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataSource(Byte.valueOf((byte)1));
            return mapper.insertSelective(item);
        });
        companyOrganizationList = Optional.of(companyOrganizationList.stream().filter(item -> Objects.nonNull(item.getNewAdd()) && item.getNewAdd() != null && item.getNewAdd() != false && item.getId() != null).distinct().collect(Collectors.toList())).orElse(new ArrayList());
        maxSize = Optional.of(companyOrganizationList.size()).orElse(0);
        page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i3 = 0; i3 < page; ++i3) {
            List<CompanyOrganization> subCompanyOrganizationList = companyOrganizationList.stream().skip((long)i3 * (long)pageSize).limit(pageSize).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(subCompanyOrganizationList)) continue;
            ((PhcPhysicalCheckV3222Mapper)this.dao).batchInsertCompanyOrganization(subCompanyOrganizationList);
        }
    }

    private Map<String, StaffInfo> computedStaffInfoMap(List<PhcPhysicalCheckStaffV3222> staffCheckBasicInfos) {
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map map = staffCheckBasicInfos.stream().peek(p -> p.setIdcardCode(p.getIdcardCode().toUpperCase())).collect(Collectors.toMap(PhcPhysicalCheckStaffV3222::getIdcardCode, Function.identity(), (c1, c2) -> c1.getCheckTime().compareTo(c2.getCheckTime()) > 0 ? c1 : c2));
        Map idCardMap = this.sysAreaService.getNativePlaceByIdCards(map.keySet());
        HashMap<String, StaffInfo> siMap = new HashMap<String, StaffInfo>();
        Set cidSet = staffCheckBasicInfos.stream().map(PhcPhysicalCheckStaffV3222::getCid).collect(Collectors.toSet());
        Map companyOrganizationMap = this.companyOrganizationService.getAllCompanyOrganizationByCids(cidSet);
        Map workRoleInfoMap = this.workRoleInfoService.getAllWorkRoleInfoByCids(cidSet);
        List<Integer> leaveWorkStatus = Arrays.asList(3, 4);
        for (Map.Entry entry : map.entrySet()) {
            String idCard = entry.getKey();
            PhcPhysicalCheckStaffV3222 value = (PhcPhysicalCheckStaffV3222)entry.getValue();
            StaffBasicInfo sbi = new StaffBasicInfo();
            sbi.setId(Long.valueOf(this.idworker.nextId()));
            sbi.setRealName(value.getName());
            sbi.setGender(Byte.valueOf("\u7537".equals(value.getSexCode()) ? (byte)1 : 0));
            sbi.setIdCard(idCard);
            if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)value.getBirthday())) {
                try {
                    Date date = DateUtils.StringToDate((String)value.getBirthday());
                    if (date != null) {
                        sbi.setBirthday(date);
                        sbi.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)sbi.getBirthday())));
                    }
                }
                catch (Exception e) {
                    this.logger.info("\u751f\u65e5\u8f6c\u6362\u51fa\u9519\uff1a{},id:{}", (Object)value.getBirthday(), (Object)value.getId());
                    e.printStackTrace();
                }
            }
            String nativePlace = (String)idCardMap.get(value.getIdcardCode().substring(0, 6) + "000000");
            sbi.setNativePlace(nativePlace);
            sbi.setMobile(value.getTelPhone());
            sbi.setCid(value.getCid());
            sbi.setCreateDate(new Date());
            sbi.setUpdateDate(new Date());
            sbi.setIsValid(Boolean.valueOf(true));
            sbi.setDataSource(Byte.valueOf((byte)1));
            String workName = !"99-9999".equals(value.getJobCode()) ? (String)jobMap.get(value.getJobCode()) : value.getOtherJobName();
            sbi.setJobName(workName);
            StaffInfo sInfo = new StaffInfo();
            sInfo.setId(Long.valueOf(this.idworker.nextId()));
            sInfo.setStaffBasicId(sbi.getId());
            sInfo.setCid(value.getCid());
            if (StringUtils.isNotEmpty((String)value.getCreditCodeEmployer()) && !value.getCreditCodeEmployer().equals(value.getCreditCode())) {
                sInfo.setIsThirdParty(Boolean.valueOf(true));
                sInfo.setOutsource(Byte.valueOf((byte)1));
                sInfo.setOtherCompany(value.getEmployerName());
            } else {
                sInfo.setIsThirdParty(Boolean.valueOf(false));
                sInfo.setOutsource(null);
                sInfo.setOtherCompany(null);
            }
            sInfo.setCheckStatus(Byte.valueOf((byte)2));
            sInfo.setAddFrom(Integer.valueOf(StaffAddFromEnum.wanda_physical_import.getValue().byteValue()));
            sInfo.setCreateDate(new Date());
            sInfo.setUpdateDate(new Date());
            sInfo.setIsValid(Boolean.valueOf(true));
            sInfo.setDataSource(Byte.valueOf((byte)1));
            CompanyOrganization companyOrganization = new CompanyOrganization();
            String comOrgKey = value.getCid() + "-" + value.getWorkshop();
            if (companyOrganizationMap.get(comOrgKey) == null) {
                companyOrganization.setId(Long.valueOf(this.idworker.nextId()));
                companyOrganization.setCid(value.getCid());
                companyOrganization.setOrganizationName(value.getWorkshop());
                companyOrganization.setLevel(Byte.valueOf((byte)1));
                companyOrganization.setNewAdd(Boolean.valueOf(true));
                companyOrganization.setCreateDate(new Date());
                companyOrganization.setUpdateDate(new Date());
                companyOrganization.setIsValid(Boolean.valueOf(true));
                companyOrganization.setDataSource(Byte.valueOf((byte)1));
                companyOrganizationMap.put(comOrgKey, companyOrganization);
            } else {
                companyOrganization = (CompanyOrganization)companyOrganizationMap.get(comOrgKey);
            }
            StaffBasicWork staffBasicWork = new StaffBasicWork();
            staffBasicWork.setId(Long.valueOf(this.idworker.nextId()));
            staffBasicWork.setCid(value.getCid());
            staffBasicWork.setStaffId(sInfo.getId());
            staffBasicWork.setOrgId(companyOrganization.getId());
            staffBasicWork.setCreateDate(new Date());
            staffBasicWork.setUpdateDate(new Date());
            staffBasicWork.setIsValid(Boolean.valueOf(true));
            staffBasicWork.setDataSource(Byte.valueOf((byte)1));
            StaffWorkRole staffWorkRole = new StaffWorkRole();
            staffWorkRole.setId(Long.valueOf(this.idworker.nextId()));
            staffWorkRole.setCid(value.getCid());
            staffWorkRole.setStaffId(sInfo.getId());
            staffWorkRole.setWorkProperty(Byte.valueOf((byte)1));
            staffWorkRole.setIsThirdParty(Boolean.valueOf(false));
            staffWorkRole.setIsHistory(Boolean.valueOf(false));
            staffWorkRole.setCreateDate(new Date());
            staffWorkRole.setUpdateDate(new Date());
            staffWorkRole.setIsValid(Boolean.valueOf(true));
            staffWorkRole.setDataSource(Byte.valueOf((byte)1));
            if (value.getBodyCheckType() != null && leaveWorkStatus.contains(value.getBodyCheckType())) {
                staffWorkRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
            } else {
                staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
            }
            sInfo.setStaffBasicInfo(sbi);
            staffWorkRole.setWandaHealthCardSourceId(value.getCardId());
            staffBasicWork.setCompanyOrganization(companyOrganization);
            staffBasicWork.setCurrentStaffWorkRole(staffWorkRole);
            sInfo.setStaffBasicWork(staffBasicWork);
            siMap.put(value.getIdcardCode(), sInfo);
        }
        return siMap;
    }

    private Map<String, Long> queryUnifiedSocialCcCidMap(List<String> unifiedSocialCcList, int pageSize) {
        List<PhcPhysicalCheckV3222> list = ((PhcPhysicalCheckV3222Mapper)this.dao).getNeedConvertData(unifiedSocialCcList, pageSize);
        this.logger.error("\u8f6c\u6362\u7684\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801---\u300b{}", list.stream().map(PhcPhysicalCheckV3222::getCreditCodeEmployer).toList());
        return list.stream().collect(Collectors.toMap(PhcPhysicalCheckV3222::getCreditCodeEmployer, PhcPhysicalCheckV3222::getCid));
    }

    @Generated
    public PhcPhysicalCheckV3222ServiceImpl(IPhcPhysicalCheckStaffV3222Service phcPhysicalCheckStaffV3222Service, IPhcPhysicalCheckStaffConclusionV3222Service phcPhysicalCheckStaffConclusionV3222Service, ICompanyOrganizationService companyOrganizationService, IStaffBasicInfoService staffBasicInfoService, IStaffInfoService staffInfoService, IStaffBasicWorkService staffBasicWorkService, IStaffWorkRoleService staffWorkRoleService, IStaffFieldChangeLogService staffFieldChangeLogService, DataSourceTransactionManager transactionManager, IPhcPhysicalCompanyInfoService phcPhysicalCompanyInfoService, IWorkRoleInfoService workRoleInfoService) {
        this.phcPhysicalCheckStaffV3222Service = phcPhysicalCheckStaffV3222Service;
        this.phcPhysicalCheckStaffConclusionV3222Service = phcPhysicalCheckStaffConclusionV3222Service;
        this.companyOrganizationService = companyOrganizationService;
        this.staffBasicInfoService = staffBasicInfoService;
        this.staffInfoService = staffInfoService;
        this.staffBasicWorkService = staffBasicWorkService;
        this.staffWorkRoleService = staffWorkRoleService;
        this.staffFieldChangeLogService = staffFieldChangeLogService;
        this.transactionManager = transactionManager;
        this.phcPhysicalCompanyInfoService = phcPhysicalCompanyInfoService;
        this.workRoleInfoService = workRoleInfoService;
    }
}

