/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.checkV3221;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.dao.work.check.checkV3221.ZyjjzStatementMapper;
import cn.smarthse.modules.health.entity.work.check.ZyjjzResult;
import cn.smarthse.modules.health.entity.work.check.ZyjjzStatement;
import cn.smarthse.modules.health.entity.work.check.ZyjjzStatementMonth;
import cn.smarthse.modules.health.entity.work.check.ZyjjzStatementParam;
import cn.smarthse.modules.health.entity.work.check.ZyjjzStatementYear;
import cn.smarthse.modules.health.service.work.check.checkV3221.IZyjjzStatementService;
import cn.smarthse.modules.health.supervise.entity.sys.Param;
import cn.smarthse.modules.health.supervise.service.sys.IParamService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ZyjjzStatementServiceImpl
extends BaseServiceImpl<ZyjjzStatementMapper, ZyjjzStatement>
implements IZyjjzStatementService {
    private static final int BATCH_SIZE = 50;
    @DubboReference
    private IParamService paramService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private ISMSProviderWelinkService smsWelinkService;

    @Transactional
    public void countZyjjzAndSendSms() {
        Map paramMap = this.paramService.getMapByKeyListAndArea(IParamService.smsOccParamKeyList, Long.valueOf(330000000000L));
        int monthThreshold = Integer.parseInt(((Param)paramMap.get("company_occ_month_threshold")).getParamValue());
        int yearThreshold = Integer.parseInt(((Param)paramMap.get("company_occ_year_threshold")).getParamValue());
        LocalDate today = LocalDate.now();
        LocalDate windowStart = today.minusMonths(12L);
        LocalDate windowEnd = today;
        ZyjjzStatementParam param = new ZyjjzStatementParam();
        param.setStartDate(windowStart);
        param.setEndDate(windowEnd);
        List<ZyjjzStatement> allData = ((ZyjjzStatementMapper)this.dao).selectAllZyjjz(param);
        Map<Long, List<ZyjjzStatement>> groupedByCid = allData.stream().collect(Collectors.groupingBy(ZyjjzStatement::getCid));
        HashMap<Long, ZyjjzResult> resultMap = new HashMap<Long, ZyjjzResult>();
        ArrayList<Long> batchList = new ArrayList<Long>(50);
        for (Map.Entry<Long, List<ZyjjzStatement>> entry : groupedByCid.entrySet()) {
            Long cid = entry.getKey();
            List<ZyjjzStatement> list = entry.getValue();
            ZyjjzResult result = this.analyzeZyjjz(list, monthThreshold, yearThreshold, windowStart, windowEnd);
            resultMap.put(cid, result);
            batchList.add(cid);
            if (batchList.size() < 50) continue;
            this.batchProcess(batchList, resultMap);
            batchList.clear();
        }
        if (!batchList.isEmpty()) {
            this.batchProcess(batchList, resultMap);
            batchList.clear();
        }
        List<Long> monthThresholdCids = resultMap.entrySet().stream().filter(e -> ((ZyjjzResult)e.getValue()).isMonthExceeded()).map(Map.Entry::getKey).collect(Collectors.toList());
        List<Long> yearThresholdCids = resultMap.entrySet().stream().filter(e -> ((ZyjjzResult)e.getValue()).isYearExceeded()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.sendSmsOnce(LocalDate.now(), monthThresholdCids, yearThresholdCids);
    }

    public PageInfo<ZyjjzStatement> listData(ZyjjzStatementParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ZyjjzStatement> list = ((ZyjjzStatementMapper)this.dao).listData(param);
        return new PageInfo(list);
    }

    public PageInfo<ZyjjzStatementYear> getYearByCid(ZyjjzStatementParam param) {
        Map paramMap = this.paramService.getMapByKeyListAndArea(IParamService.smsOccParamKeyList, Long.valueOf(330000000000L));
        int yearThreshold = Integer.parseInt(((Param)paramMap.get("company_occ_year_threshold")).getParamValue());
        param.setYearThreshold(Integer.valueOf(yearThreshold));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ZyjjzStatementYear> list = ((ZyjjzStatementMapper)this.dao).getYearByCid(param);
        return new PageInfo(list);
    }

    public PageInfo<ZyjjzStatementMonth> getMonthByCid(ZyjjzStatementParam param) {
        Map paramMap = this.paramService.getMapByKeyListAndArea(IParamService.smsOccParamKeyList, Long.valueOf(330000000000L));
        int monthThreshold = Integer.parseInt(((Param)paramMap.get("company_occ_month_threshold")).getParamValue());
        param.setMonthThreshold(Integer.valueOf(monthThreshold));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ZyjjzStatementMonth> list = ((ZyjjzStatementMapper)this.dao).getMonthByCid(param);
        return new PageInfo(list);
    }

    @Transactional
    public Integer delAllZyjjzSmsLog(List<Long> cidList) {
        return ((ZyjjzStatementMapper)this.dao).delAllZyjjzSmsLog(cidList);
    }

    private void sendSmsOnce(LocalDate execDate, List<Long> monthThresholdCids, List<Long> yearThresholdCids) {
        Map paramMap = this.paramService.getMapByKeyListAndArea(IParamService.smsOccParamKeyList, Long.valueOf(330000000000L));
        int monthThreshold = Integer.parseInt(((Param)paramMap.get("company_occ_month_threshold")).getParamValue());
        int yearThreshold = Integer.parseInt(((Param)paramMap.get("company_occ_year_threshold")).getParamValue());
        String tel = ((Param)paramMap.get("company_occ_tel")).getParamValue();
        Set<Long> sentMonthCids = ((ZyjjzStatementMapper)this.dao).selectSentCids(execDate, "month");
        Set<Long> sentYearCids = ((ZyjjzStatementMapper)this.dao).selectSentCids(execDate, "year");
        monthThresholdCids.removeAll(sentMonthCids);
        yearThresholdCids.removeAll(sentYearCids);
        if (!monthThresholdCids.isEmpty()) {
            String monthCompanyName = this.companyProvideByHSEService.getCompanyNameById(monthThresholdCids.get(0));
            int monthNum = monthThresholdCids.size();
            String monthContent = String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011%s\u7b49%d\u5bb6\u4f01\u4e1a\uff0c\u4e00\u4e2a\u6708\u5185\u53d1\u73b0\u804c\u4e1a\u7981\u5fcc\u8bc1\u5df2\u8d85\u8fc7%s\u4eba\u3002", monthCompanyName, monthNum, monthThreshold);
            ((ZyjjzStatementMapper)this.dao).insertSmsLog(0L, "month", execDate, monthNum, monthContent);
            ((ZyjjzStatementMapper)this.dao).insertSmsLogBatch(monthThresholdCids, "month", execDate);
            this.smsWelinkService.singleSendSms(tel, monthContent);
        }
        if (!yearThresholdCids.isEmpty()) {
            String yearCompanyNames = this.companyProvideByHSEService.getCompanyNameById(yearThresholdCids.get(0));
            int yearNum = yearThresholdCids.size();
            String yearContent = String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011%s\u7b49%d\u5bb6\u4f01\u4e1a\uff0c\u524d12\u4e2a\u6708\u53d1\u73b0\u804c\u4e1a\u7981\u5fcc\u8bc1\u5df2\u8d85\u8fc7%s\u4eba\u3002", yearCompanyNames, yearNum, yearThreshold);
            ((ZyjjzStatementMapper)this.dao).insertSmsLog(0L, "year", execDate, yearNum, yearContent);
            ((ZyjjzStatementMapper)this.dao).insertSmsLogBatch(yearThresholdCids, "year", execDate);
            this.smsWelinkService.singleSendSms(tel, yearContent);
        }
    }

    public ZyjjzResult analyzeZyjjz(List<ZyjjzStatement> list, int monthThreshold, int yearThreshold, LocalDate windowStart, LocalDate windowEnd) {
        ZyjjzResult result = new ZyjjzResult();
        if (list == null || list.isEmpty()) {
            return result;
        }
        Map<String, ZyjjzStatement> unique = list.stream().collect(Collectors.toMap(ZyjjzStatement::getIdcardCode, v -> v, (v1, v2) -> v1.getCheckTime().after(v2.getCheckTime()) ? v1 : v2));
        ArrayList<ZyjjzStatement> persons = new ArrayList<ZyjjzStatement>(unique.values());
        java.util.Date lastCheck = persons.stream().map(ZyjjzStatement::getCheckTime).max(java.util.Date::compareTo).orElse(null);
        result.setLastCheckTime(lastCheck);
        Map<String, Long> monthCounts = persons.stream().collect(Collectors.groupingBy(x -> this.formatMonth(x.getCheckTime()), Collectors.counting()));
        result.setMonthCounts(monthCounts);
        String currentMonth = windowEnd.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        long currentMonthCount = monthCounts.getOrDefault(currentMonth, 0L);
        result.setCurrentMonthCount(currentMonthCount);
        result.setMonthExceeded(currentMonthCount >= (long)monthThreshold);
        int last12MonthsCount = (int)persons.stream().filter(x -> {
            LocalDate d = this.toLocalDate(x.getCheckTime());
            return !d.isBefore(windowStart) && d.isBefore(windowEnd);
        }).count();
        result.setYearCount(last12MonthsCount);
        result.setYearExceeded(last12MonthsCount >= yearThreshold);
        result.setWindowStart(windowStart);
        result.setWindowEnd(windowEnd);
        result.setMonthThreshold(monthThreshold);
        result.setYearThreshold(yearThreshold);
        return result;
    }

    @Transactional
    public void batchProcess(List<Long> cidList, Map<Long, ZyjjzResult> resultMap) {
        if (cidList == null || cidList.isEmpty()) {
            return;
        }
        ZyjjzResult sample = resultMap.get(cidList.get(0));
        Date yearStart = Date.valueOf(sample.getWindowStart());
        Date yearEnd = Date.valueOf(sample.getWindowEnd());
        List<ZyjjzStatement> existingStatements = ((ZyjjzStatementMapper)this.dao).selectStatementByCidList(cidList);
        Map<Long, ZyjjzStatement> existingStatementMap = existingStatements.stream().collect(Collectors.toMap(ZyjjzStatement::getCid, s -> s, (s1, s2) -> s1));
        List<ZyjjzStatementYear> existingYears = ((ZyjjzStatementMapper)this.dao).selectStatementYearByCidList(cidList, yearStart, yearEnd);
        HashMap<Object, ZyjjzStatementYear> existingYearMap = new HashMap<Object, ZyjjzStatementYear>();
        for (ZyjjzStatementYear y : existingYears) {
            String key = y.getCid() + "_" + y.getStartDate().toString() + "_" + y.getEndDate().toString();
            existingYearMap.put(key, y);
        }
        List<ZyjjzStatementMonth> existingMonths = ((ZyjjzStatementMapper)this.dao).selectStatementMonthByCidList(cidList, yearStart, yearEnd);
        HashMap<CallSite, ZyjjzStatementMonth> existingMonthMap = new HashMap<CallSite, ZyjjzStatementMonth>();
        for (ZyjjzStatementMonth m : existingMonths) {
            String key = m.getCid() + "_" + m.getYear() + "_" + m.getMonth();
            existingMonthMap.put((CallSite)((Object)key), m);
        }
        ArrayList<ZyjjzStatement> upsertStatements = new ArrayList<ZyjjzStatement>();
        ArrayList<ZyjjzStatementYear> upsertYears = new ArrayList<ZyjjzStatementYear>();
        ArrayList<ZyjjzStatementMonth> upsertMonths = new ArrayList<ZyjjzStatementMonth>();
        for (Long cid : cidList) {
            ZyjjzResult res = resultMap.get(cid);
            if (res == null) continue;
            java.util.Date lastCheck = res.getLastCheckTime();
            int monthsExceedCount = (int)res.getMonthCounts().values().stream().filter(v -> v >= (long)res.getMonthThreshold()).count();
            int yearsFlag = res.isYearExceeded() ? 1 : 0;
            ZyjjzStatement existingS = existingStatementMap.get(cid);
            if (existingS == null) {
                ZyjjzStatement s3 = new ZyjjzStatement();
                s3.setCid(cid);
                s3.setMonths(Integer.valueOf(monthsExceedCount));
                s3.setYears(Integer.valueOf(yearsFlag));
                s3.setLastCheckTime(lastCheck);
                s3.setUpdateDate(new java.util.Date());
                if (res.isYearExceeded()) {
                    s3.setFirstYearExceededTime(new java.util.Date());
                }
                upsertStatements.add(s3);
            } else if (!(Objects.equals(existingS.getMonths(), monthsExceedCount) && Objects.equals(existingS.getYears(), yearsFlag) && Objects.equals(existingS.getLastCheckTime(), lastCheck))) {
                existingS.setMonths(Integer.valueOf(monthsExceedCount));
                existingS.setYears(Integer.valueOf(yearsFlag));
                existingS.setLastCheckTime(lastCheck);
                existingS.setUpdateDate(new java.util.Date());
                if (res.isYearExceeded() && existingS.getFirstYearExceededTime() == null) {
                    existingS.setFirstYearExceededTime(new java.util.Date());
                }
                upsertStatements.add(existingS);
            }
            String yearKey = cid + "_" + ((java.util.Date)yearStart).toString() + "_" + ((java.util.Date)yearEnd).toString();
            ZyjjzStatementYear existingY = (ZyjjzStatementYear)existingYearMap.get(yearKey);
            if (existingY == null) {
                ZyjjzStatementYear y = new ZyjjzStatementYear();
                y.setCid(cid);
                y.setStartDate((java.util.Date)yearStart);
                y.setEndDate((java.util.Date)yearEnd);
                y.setNum(Integer.valueOf(res.getYearCount()));
                y.setLastCheckTime(lastCheck);
                y.setUpdateDate(new java.util.Date());
                upsertYears.add(y);
            }
            for (Map.Entry me : res.getMonthCounts().entrySet()) {
                int month;
                String ym = (String)me.getKey();
                String[] arr = ym.split("-");
                int year = Integer.parseInt(arr[0]);
                String monthKey = cid + "_" + year + "_" + (month = Integer.parseInt(arr[1]));
                ZyjjzStatementMonth existingM = (ZyjjzStatementMonth)existingMonthMap.get(monthKey);
                if (existingM == null) {
                    ZyjjzStatementMonth m = new ZyjjzStatementMonth();
                    m.setCid(cid);
                    m.setYear(Integer.valueOf(year));
                    m.setMonth(Integer.valueOf(month));
                    m.setNum(Integer.valueOf(((Long)me.getValue()).intValue()));
                    m.setLastCheckTime(lastCheck);
                    m.setUpdateDate(new java.util.Date());
                    upsertMonths.add(m);
                    continue;
                }
                if (Objects.equals(existingM.getNum(), ((Long)me.getValue()).intValue()) && Objects.equals(existingM.getLastCheckTime(), lastCheck)) continue;
                existingM.setNum(Integer.valueOf(((Long)me.getValue()).intValue()));
                existingM.setLastCheckTime(lastCheck);
                existingM.setUpdateDate(new java.util.Date());
                upsertMonths.add(existingM);
            }
        }
        if (!upsertStatements.isEmpty()) {
            ((ZyjjzStatementMapper)this.dao).batchUpsertStatement(upsertStatements);
        }
        if (!upsertYears.isEmpty()) {
            ((ZyjjzStatementMapper)this.dao).batchUpsertStatementYear(upsertYears);
        }
        if (!upsertMonths.isEmpty()) {
            ((ZyjjzStatementMapper)this.dao).batchUpsertStatementMonth(upsertMonths);
        }
    }

    private String formatMonth(java.util.Date date) {
        return new SimpleDateFormat("yyyy-MM").format(date);
    }

    private LocalDate toLocalDate(java.util.Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

