/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.checkV3221;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.bx.service.IBxYszybService;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffFieldChangeLogMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalCheckV3221Mapper;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalStaffCheckInfoMapper;
import cn.smarthse.modules.health.dao.work.reform.ReformItemBasicMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.noEnvo.PhcPhysicalStaffCheckInfoNoEn;
import cn.smarthse.modules.health.entity.work.check.earliestCheckModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.model.phyphcCheck.AddCheckStaffModel;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221OrgService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckDataParam;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.entity.WandaHcRItems;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalStaffCheckInfoServiceImpl
extends BaseServiceImpl<PhcPhysicalStaffCheckInfoMapper, PhcPhysicalStaffCheckInfo>
implements IPhcPhysicalStaffCheckInfoService {
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @Autowired
    private IPhcPhysicalCheckDataService phcPhysicalCheckDataService;
    @Autowired
    private IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private PhcPhysicalCheckV3221Mapper phcPhysicalCheckV3221Mapper;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @DubboReference
    private IBxYszybService yszybService;
    @Autowired
    private StaffFieldChangeLogMapper staffFieldChangeLogMapper;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @DubboReference
    IDiseaseThirdService diseaseThirdService;
    @Autowired
    @Lazy
    IPhcPhysicalCheckV3221OrgService phcPhysicalCheckV3221OrgService;
    @Autowired
    IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;

    @Transactional(readOnly=false)
    public void batchInsertStaffCheckInfo(List<PhcPhysicalStaffCheckInfo> staffCheckInfoList) {
        if (CollectionUtils.isEmpty(staffCheckInfoList)) {
            return;
        }
        int pageSize = 1000;
        int page = (int)Math.ceil((double)staffCheckInfoList.size() * 1.0 / (double)pageSize);
        for (int i = 0; i < page; ++i) {
            List<PhcPhysicalStaffCheckInfo> subList = staffCheckInfoList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
            ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertStaffCheckInfo(subList);
        }
    }

    public List<PhcPhysicalStaffCheckInfo> getStaffCheckInfoListByCheckId(Long id) {
        if (id == null) {
            return new ArrayList<PhcPhysicalStaffCheckInfo>();
        }
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("sourceId", (Object)id);
        return this.getListByExample(example);
    }

    public List<PhcPhysicalStaffCheckInfo> getStaffCheckInfoListByCheck(PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        boolean noMatch;
        if (searchVo == null) {
            return new ArrayList<PhcPhysicalStaffCheckInfo>();
        }
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("sourceId", (Object)searchVo.getId()).andEqualTo("creditCode", (Object)searchVo.getUnifiedSocialCc());
        List<PhcPhysicalStaffCheckInfo> companyPhyList = this.getListByExample(example);
        List<PhcPhysicalStaffCheckInfo> matchPhyList = Objects.equals(isSearchThirdMatch, 1) ? this.phcPhysicalCheckV3221Mapper.getListAssociationMatchById(searchVo.getId()) : null;
        boolean bl = noMatch = matchPhyList == null || matchPhyList.isEmpty();
        if (noMatch) {
            return companyPhyList;
        }
        matchPhyList.addAll(companyPhyList);
        return matchPhyList;
    }

    public PageInfo<PhcPhysicalStaffCheckInfo> getPhcPhysicalResult(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        if (searchVo.getId() == null) {
            return new PageInfo();
        }
        PhcPhysicalCheckV3221 check = this.phcPhysicalCheckV3221Mapper.getByid(searchVo.getId());
        List<Object> list = new ArrayList();
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        list = check.getDataSource() == 2 ? this.loadOrgData(searchVo) : this.loadWandaData(searchVo, isSearchThirdMatch);
        return new PageInfo(list);
    }

    private List<PhcPhysicalStaffCheckInfo> loadOrgData(PhcPhysicalCheckSearchVo searchVo) {
        List list = this.phcPhysicalCheckV3221OrgService.checkStaffList(searchVo.getId(), searchVo.getConclusion().toString(), searchVo.getKeyword());
        List<PhcPhysicalStaffCheckInfo> collect = list.stream().map(item -> {
            PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo = new PhcPhysicalStaffCheckInfo();
            BeanUtils.copyProperties((Object)item, (Object)phcPhysicalStaffCheckInfo);
            phcPhysicalStaffCheckInfo.setConclusionName(item.getCheckResultCode());
            phcPhysicalStaffCheckInfo.setId(item.getCheckStaffId());
            phcPhysicalStaffCheckInfo.setItemId(item.getFcItem());
            return phcPhysicalStaffCheckInfo;
        }).collect(Collectors.toList());
        return collect;
    }

    private List<PhcPhysicalStaffCheckInfo> loadWandaData(PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        boolean noMatch;
        List<PhcPhysicalStaffCheckInfo> companyPhyList = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getPhcPhysicalResult(searchVo);
        List<PhcPhysicalStaffCheckInfo> matchPhyList = Objects.equals(isSearchThirdMatch, 1) ? ((PhcPhysicalStaffCheckInfoMapper)this.dao).getPhyAssociationMatchResult(searchVo) : null;
        boolean bl = noMatch = matchPhyList == null || matchPhyList.isEmpty();
        if (CollectionUtils.isNotEmpty(companyPhyList)) {
            this.settingDicValue(companyPhyList);
            List<String> cardIds = companyPhyList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toList());
            Map<String, String> writeDateMap = this.getWriteDatesFromWandaHealthCard(cardIds);
            for (PhcPhysicalStaffCheckInfo staff : companyPhyList) {
                String writeDate = writeDateMap.get(staff.getCardId());
                staff.setWriteDate(writeDate);
            }
        }
        if (noMatch) {
            return companyPhyList;
        }
        this.settingDicValue(matchPhyList);
        matchPhyList.addAll(companyPhyList);
        return matchPhyList;
    }

    public List<PhcPhysicalStaffCheckInfo> settingDicValue(List<PhcPhysicalStaffCheckInfo> list) {
        Map allWandRiskFactors = this.dictionaryService.getAllWandRiskFactorByCache();
        allWandRiskFactors.put("11", new WandaDictValue().setId(Long.valueOf(11L)).setValueLabel("\u7c89\u5c18"));
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map itemMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(10L));
        Map zyjjzMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(20L));
        Map ysjzbMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(21L));
        Map conclusionMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(19L));
        List<String> otherHazardCode = Arrays.asList("16", "11999", "12999", "13999", "14999", "15999");
        for (PhcPhysicalStaffCheckInfo checkInfo : list) {
            String[] dictValue;
            if (checkInfo == null) continue;
            String conclusionName = (String)conclusionMap.get(checkInfo.getConclusion());
            checkInfo.setConclusionName(conclusionName);
            List<Object> hazardNameList = new ArrayList<String>();
            String contactHazardCode = checkInfo.getContactHazardCode();
            String contactOtherHazardName = checkInfo.getContactOtherHazardName();
            if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)contactHazardCode)) {
                String[] contactHazardCodeArr;
                for (String code : contactHazardCodeArr = contactHazardCode.split(",")) {
                    if (otherHazardCode.contains(code) || (dictValue = (String[])allWandRiskFactors.get(code)) == null) continue;
                    String value = dictValue.getValueLabel();
                    hazardNameList.add(value);
                }
            }
            if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)contactOtherHazardName)) {
                hazardNameList.addAll(Arrays.asList(contactOtherHazardName.split(",")));
            }
            hazardNameList = hazardNameList.stream().distinct().collect(Collectors.toList());
            checkInfo.setContactHazardName(cn.smarthse.common.util.StringUtils.join(hazardNameList, (String)","));
            if (checkInfo.getDataSource() == null || checkInfo.getDataSource() == 1) {
                switch (checkInfo.getConclusion()) {
                    case "3": {
                        String sptId = checkInfo.getSptId();
                        StringBuilder sptStr = new StringBuilder();
                        if (!StringUtil.isEmpty((String)sptId) && sptId.endsWith(";")) {
                            String[] split;
                            dictValue = split = sptId.split(";");
                            int value = dictValue.length;
                            for (int i = 0; i < value; ++i) {
                                String s = dictValue[i];
                                sptStr.append((String)ysjzbMap.get(s)).append(";");
                            }
                            checkInfo.setSptId(sptStr.toString());
                            break;
                        }
                        checkInfo.setSptId((String)ysjzbMap.get(sptId));
                        break;
                    }
                    case "4": {
                        String hazardCode = checkInfo.getHazardCode();
                        StringBuilder cotStr = new StringBuilder();
                        if (!StringUtil.isEmpty((String)hazardCode) && hazardCode.contains(",")) {
                            String[] split;
                            for (String s : split = hazardCode.split(",")) {
                                WandaDictValue wandaDictValue = (WandaDictValue)allWandRiskFactors.get(s);
                                if (wandaDictValue == null) continue;
                                cotStr.append(wandaDictValue.getValueLabel()).append(",");
                            }
                            checkInfo.setCotId(cotStr.toString());
                            break;
                        }
                        WandaDictValue wandaDictValue = (WandaDictValue)allWandRiskFactors.get(hazardCode);
                        if (wandaDictValue == null) break;
                        String valueLabel = wandaDictValue.getValueLabel();
                        checkInfo.setCotId(valueLabel);
                        break;
                    }
                    case "2": {
                        List<WandaHcRItems> hcRItemsList = this.getXfcItem(checkInfo);
                        StringBuilder builder = new StringBuilder();
                        for (WandaHcRItems hcRItems : hcRItemsList) {
                            String repeatItemId = hcRItems.getRepeatItemId();
                            if ("90001".equals(repeatItemId)) {
                                builder.append(hcRItems.getOtherItemName()).append(",");
                                continue;
                            }
                            String itemName = (String)itemMap.get(repeatItemId);
                            if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)itemName)) continue;
                            builder.append(itemName).append(",");
                        }
                        if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)builder.toString())) break;
                        checkInfo.setItemId(builder.substring(0, builder.length() - 1));
                        break;
                    }
                }
            }
            if (!"99-9999".equals(checkInfo.getJobCode()) && StringUtil.isEmpty((String)checkInfo.getOtherJobName())) {
                checkInfo.setOtherJobName((String)jobMap.get(checkInfo.getJobCode()));
            }
            checkInfo.setJobCode(checkInfo.getOtherJobName());
        }
        return list;
    }

    public List<WandaHcRItems> getXfcItem(PhcPhysicalStaffCheckInfo checkInfo) {
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).getXfcItem(checkInfo);
    }

    public PhcPhysicalStaffCheckInfo getPhcPhysicalResultView(PhcPhysicalCheckSearchVo searchVo) {
        PhcPhysicalStaffCheckInfo checkInfo = new PhcPhysicalStaffCheckInfo();
        if (searchVo.getId() == null) {
            return checkInfo;
        }
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andEqualTo("id", (Object)searchVo.getId()).andEqualTo("isValid", (Object)true).andEqualTo("conclusion", (Object)searchVo.getConclusion());
        List<PhcPhysicalStaffCheckInfo> list = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            this.settingDicValue(list);
            checkInfo = list.get(0);
        }
        return checkInfo;
    }

    public PhcPhysicalStaffCheckInfo getStaffCheckInfoById(PhcPhysicalCheckSearchVo searchVo) {
        String fullDate;
        if (searchVo.getCardId() == null) {
            return new PhcPhysicalStaffCheckInfo();
        }
        if (searchVo.getDataSource() != null && searchVo.getDataSource() == 3) {
            List list = this.yszybService.getYszybByCid(searchVo);
            if (CollectionUtils.isEmpty((Collection)list) || list.size() < 1) {
                return null;
            }
            this.settingIdCardInfo(list);
            PhcPhysicalStaffCheckInfo checkInfo = (PhcPhysicalStaffCheckInfo)list.get(0);
            DesensitizationUtils.setDesensitizationFieldFromObject((Object)checkInfo);
            return checkInfo;
        }
        PhcPhysicalCheckV3221 check = cn.smarthse.common.util.StringUtils.isNotEmpty((String)searchVo.getCardId()) && !searchVo.getCardId().equalsIgnoreCase("undefined") ? this.phcPhysicalCheckV3221Mapper.getByCardId(searchVo.getCardId()) : this.phcPhysicalCheckV3221Mapper.getByCheckStaffId(searchVo.getCheckStaffId());
        ArrayList<PhcPhysicalStaffCheckInfo> list = new ArrayList<PhcPhysicalStaffCheckInfo>();
        if (check.getDataSource() == 2) {
            AddCheckStaffModel checkStaff = this.phcPhysicalCheckV3221OrgService.getCheckStaff(searchVo.getCheckStaffId());
            PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo = new PhcPhysicalStaffCheckInfo();
            BeanUtils.copyProperties((Object)checkStaff, (Object)phcPhysicalStaffCheckInfo);
            phcPhysicalStaffCheckInfo.setConclusionName(checkStaff.getCheckResultCode());
            phcPhysicalStaffCheckInfo.setIdcardCode(checkStaff.getIdCardCode());
            String contactHazardCodeStr = this.harmFactorService.getHarmNames(checkStaff.getContactHazardCode());
            phcPhysicalStaffCheckInfo.setContactHazardName(contactHazardCodeStr);
            phcPhysicalStaffCheckInfo.setItemId(checkStaff.getFcItem());
            if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)checkStaff.getCotId())) {
                List cotHarm = this.harmFactorService.getHarmByIds(checkStaff.getCotId());
                phcPhysicalStaffCheckInfo.setCotId(cotHarm.stream().map(HarmFactor::getNameCh).collect(Collectors.joining(",")));
            }
            if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)checkStaff.getSptId())) {
                List l = this.diseaseThirdService.listDiseases(Integer.valueOf(Integer.parseInt(checkStaff.getSptId())));
                phcPhysicalStaffCheckInfo.setSptId(l.stream().map(i -> "\u7591\u4f3c" + i.getDiseaseName()).collect(Collectors.joining(",")));
            }
            DesensitizationUtils.setDesensitizationFieldFromObject((Object)phcPhysicalStaffCheckInfo);
            return phcPhysicalStaffCheckInfo;
        }
        PhcPhysicalStaffCheckInfo checkInfo = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getStaffCheckInfoById(searchVo);
        if (checkInfo == null) {
            return null;
        }
        List<WandaHealthCard> writeDates = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getWriteDatesByCardIds(Arrays.asList(searchVo.getCardId()));
        if (writeDates != null && !writeDates.isEmpty() && (fullDate = writeDates.get(0).getWriteDate()) != null && fullDate.length() >= 10) {
            checkInfo.setWriteDate(fullDate.substring(0, 10));
        }
        list.add(checkInfo);
        this.settingDicValue(list);
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)checkInfo);
        return checkInfo;
    }

    public PageInfo<PhcPhysicalStaffCheckInfo> getListByConclusion(JqGridParam param, PhcPhysicalCheckSearchVo searchVo) {
        if (searchVo.getConclusion() == null) {
            return new PageInfo();
        }
        searchVo.setHazardCodeList(this.splitToList(searchVo.getHazardCode()));
        List<PhcPhysicalStaffCheckInfo> list = new ArrayList<PhcPhysicalStaffCheckInfo>();
        if (Objects.equals(searchVo.getConclusion(), (byte)3)) {
            list.addAll(((PhcPhysicalStaffCheckInfoMapper)this.dao).getListByConclusion(searchVo));
            searchVo.setHazardCodeList(this.splitToList(searchVo.getHazardName()));
            list.addAll(this.yszybService.getYszybByCid(searchVo));
            list = this.distinctByYearAndIdcard(list);
        } else {
            list.addAll(((PhcPhysicalStaffCheckInfoMapper)this.dao).getListByConclusion(searchVo));
        }
        if (CollectionUtils.isEmpty(list)) {
            return new PageInfo();
        }
        List<PhcPhysicalStaffCheckInfo> orgList = list.stream().filter(i -> i.getDataSource() == 2).toList();
        List<PhcPhysicalStaffCheckInfo> wandaList = list.stream().filter(i -> i.getDataSource() == 1).toList();
        List<PhcPhysicalStaffCheckInfo> bxList = list.stream().filter(i -> i.getDataSource() == 3).toList();
        if (CollectionUtils.isNotEmpty(wandaList)) {
            this.settingDicValue(wandaList);
        }
        if (CollectionUtils.isNotEmpty(orgList)) {
            for (PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo : orgList) {
                if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)phcPhysicalStaffCheckInfo.getCotId())) {
                    List cotHarm = this.harmFactorService.getHarmByIds(phcPhysicalStaffCheckInfo.getCotId());
                    phcPhysicalStaffCheckInfo.setCotId(cotHarm.stream().map(HarmFactor::getNameCh).collect(Collectors.joining(",")));
                }
                if (!cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)phcPhysicalStaffCheckInfo.getSptId())) continue;
                List l = this.diseaseThirdService.listDiseases(Integer.valueOf(Integer.parseInt(phcPhysicalStaffCheckInfo.getSptId())));
                phcPhysicalStaffCheckInfo.setSptId(l.stream().map(i -> "\u7591\u4f3c" + i.getDiseaseName()).collect(Collectors.joining(",")));
            }
        }
        if (CollectionUtils.isNotEmpty(bxList)) {
            this.settingIdCardInfo(bxList);
        }
        List processedList = Stream.of(orgList, wandaList, bxList).flatMap(Collection::stream).collect(Collectors.toList());
        return PageUtil.getPageInfo(processedList, (int)param.getPage(), (int)param.getRows());
    }

    private void settingIdCardInfo(List<PhcPhysicalStaffCheckInfo> bxList) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        bxList.forEach(e -> {
            if (e.getIdcardCode() != null && cn.smarthse.common.util.StringUtils.isNotEmpty((String)e.getIdcardCode())) {
                String idcard = e.getIdcardCode();
                e.setAge(Integer.valueOf(IDCardUtil.getAge((String)idcard)));
                Date birthdayDate = IDCardUtil.getBirthday((String)idcard);
                if (birthdayDate != null) {
                    e.setBirthday(sdf.format(birthdayDate));
                }
                e.setSexCode(IDCardUtil.getGenderName((String)idcard));
            }
        });
    }

    private List<PhcPhysicalStaffCheckInfo> distinctByYearAndIdcard(List<PhcPhysicalStaffCheckInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        List validList = list.stream().filter(e -> e != null && cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)e.getIdcardCode()) && cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)e.getWriteDate()) && e.getWriteDate().length() >= 4).collect(Collectors.toList());
        List invalidList = list.stream().filter(e -> e == null || cn.smarthse.common.util.StringUtils.isBlank((CharSequence)e.getIdcardCode()) || cn.smarthse.common.util.StringUtils.isBlank((CharSequence)e.getWriteDate()) || e.getWriteDate().length() < 4).collect(Collectors.toList());
        ArrayList<PhcPhysicalStaffCheckInfo> distinctList = new ArrayList<PhcPhysicalStaffCheckInfo>(validList.stream().collect(Collectors.toMap(e -> e.getIdcardCode() + "_" + e.getWriteDate().substring(0, 4), e -> e, (e1, e2) -> e1)).values());
        distinctList.addAll(invalidList);
        return distinctList;
    }

    private List<String> splitToList(String value) {
        return cn.smarthse.common.util.StringUtils.isNotEmpty((String)value) ? Arrays.asList(value.split(",")) : new ArrayList();
    }

    public PhcPhysicalStaffCheckInfo getPhcPhysicalStaffCheckInfoByCardId(String idCard, Long cid) {
        if (cn.smarthse.common.util.StringUtils.isEmpty((CharSequence)idCard) || cid == null) {
            return null;
        }
        String encs = SpringEncryptUtils.encrypt((String)idCard);
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).getPhcPhysicalStaffCheckInfoByCardId(encs, cid);
    }

    public void batchInsertStaffInfo(List<StaffInfo> staffInfoList, Set<String> idcardCodeList, List<PhcPhysicalCheckData> phcPhysicalCheckDataList) {
        ArrayList<StaffInfo> updateList = new ArrayList<StaffInfo>();
        Map<Object, Object> phcPhysicalCheckDataMap = new HashMap();
        if (CollectionUtils.isNotEmpty(phcPhysicalCheckDataList)) {
            phcPhysicalCheckDataMap = phcPhysicalCheckDataList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckData::getStaffId));
        }
        HashSet idCardList = new HashSet();
        if (CollectionUtils.isNotEmpty(idcardCodeList)) {
            idcardCodeList.forEach(i -> idCardList.add(SpringEncryptUtils.encrypt((String)i)));
        }
        Example example = new Example(StaffBasicInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("idCard", idCardList);
        List staffBasicInfoList = this.staffBasicInfoService.getListByExample(example);
        Iterator<StaffInfo> iterator = staffInfoList.iterator();
        block0: while (iterator.hasNext()) {
            StaffInfo next = iterator.next();
            StaffBasicInfo staffBasicInfo = next.getStaffBasicInfo();
            if (staffBasicInfo == null) continue;
            for (StaffBasicInfo sbi : staffBasicInfoList) {
                if (sbi == null || Objects.isNull(staffBasicInfo.getCid()) || Objects.isNull(sbi.getCid()) || Objects.isNull(staffBasicInfo.getIdCard()) || Objects.isNull(sbi.getIdCard()) || !staffBasicInfo.getCid().equals(sbi.getCid()) || !staffBasicInfo.getIdCard().equalsIgnoreCase(sbi.getIdCard())) continue;
                updateList.add(next);
                iterator.remove();
                continue block0;
            }
        }
        ArrayList<StaffInfo> addStaffInfoList = new ArrayList<StaffInfo>();
        ArrayList<StaffBasicInfo> addStaffBasicInfoList = new ArrayList<StaffBasicInfo>();
        ArrayList<StaffBasicWork> addStaffBasicWorkList = new ArrayList<StaffBasicWork>();
        List<WorkRoleInfo> addWorkRoleInfoList = new ArrayList<WorkRoleInfo>();
        ArrayList<StaffWorkRole> addStaffWorkRoleList = new ArrayList<StaffWorkRole>();
        List<CompanyOrganization> companyOrganizationList = new ArrayList<CompanyOrganization>();
        ArrayList<StaffFieldChangeLog> staffFieldChangeLogList = new ArrayList<StaffFieldChangeLog>();
        for (StaffInfo staffInfo : staffInfoList) {
            if (ObjectUtil.isNotNull((Object)staffInfo)) {
                StaffFieldChangeLog log = new StaffFieldChangeLog();
                log.setStaffId(staffInfo.getId());
                log.setCid(staffInfo.getCid());
                log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                log.setBeforeInfo("-");
                log.setAfterInfo(Boolean.TRUE.equals(staffInfo.getIsThirdParty()) ? "\u5916\u6765\u4eba\u5458" : "\u672c\u4f01\u4e1a\u4eba\u5458");
                log.setChangeReason("\u4f53\u68c0\u6570\u636e\u65b0\u589e");
                staffFieldChangeLogList.add(log);
            }
            addStaffInfoList.add(staffInfo);
            StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
            addStaffBasicInfoList.add(staffBasicInfo);
            StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
            addStaffBasicWorkList.add(staffBasicWork);
            StaffWorkRole currentStaffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            addStaffWorkRoleList.add(currentStaffWorkRole);
            WorkRoleInfo workRoleInfo = currentStaffWorkRole.getWorkRoleInfo();
            addWorkRoleInfoList.add(workRoleInfo);
            CompanyOrganization companyOrganization = staffBasicWork.getCompanyOrganization();
            companyOrganizationList.add(companyOrganization);
        }
        int pageSize = 1000;
        int maxSize = Stream.of(addStaffInfoList.size(), addStaffBasicInfoList.size(), addStaffBasicWorkList.size(), addStaffWorkRoleList.size()).max(Comparator.naturalOrder()).orElse(0);
        int page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i2 = 0; i2 < page; ++i2) {
            List<StaffWorkRole> subAddStaffWorkRoleList;
            List<StaffBasicWork> subAddStaffBasicWorkList;
            List<StaffBasicInfo> subAddStaffBasicInfoList;
            List subAddStaffInfoList = addStaffInfoList.stream().skip(i2 * pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)subAddStaffInfoList)) {
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertStaffInfo(subAddStaffInfoList);
            }
            if (CollectionUtils.isNotEmpty(subAddStaffBasicInfoList = addStaffBasicInfoList.stream().skip(i2 * pageSize).limit(pageSize).collect(Collectors.toList()))) {
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertStaffBasicInfo(subAddStaffBasicInfoList);
            }
            if (CollectionUtils.isNotEmpty(subAddStaffBasicWorkList = addStaffBasicWorkList.stream().skip(i2 * pageSize).limit(pageSize).collect(Collectors.toList()))) {
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertStaffBasicWork(subAddStaffBasicWorkList);
            }
            if (!CollectionUtils.isNotEmpty(subAddStaffWorkRoleList = addStaffWorkRoleList.stream().skip(i2 * pageSize).limit(pageSize).collect(Collectors.toList()))) continue;
            ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertStaffWorkRole(subAddStaffWorkRoleList);
        }
        addStaffInfoList.clear();
        addStaffBasicInfoList.clear();
        addStaffBasicWorkList.clear();
        addStaffWorkRoleList.clear();
        for (StaffInfo staffInfo : updateList) {
            StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
            StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
            StaffWorkRole currentStaffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            WorkRoleInfo workRoleInfo = currentStaffWorkRole.getWorkRoleInfo();
            CompanyOrganization companyOrganization = staffBasicWork.getCompanyOrganization();
            StaffBasicInfo sbi = this.staffBasicInfoService.getStaffBasicInfoByIdCard(staffBasicInfo.getIdCard(), null, staffBasicInfo.getCid());
            StaffInfo si = this.staffInfoService.getStaffInfoByStaffBasicId(sbi.getId(), staffInfo.getCid());
            if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)staffBasicInfo.getJobName()) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)sbi.getJobName()) && !sbi.getJobName().equals(staffBasicInfo.getJobName())) {
                StaffFieldChangeLog staffFieldChangeLog = new StaffFieldChangeLog();
                staffFieldChangeLog.setStaffId(ObjectUtil.isNotNull((Object)si) ? si.getId() : null);
                staffFieldChangeLog.setCid(staffInfo.getCid());
                staffFieldChangeLog.setBeforeInfo(sbi.getJobName());
                staffFieldChangeLog.setAfterInfo(staffBasicInfo.getJobName());
                staffFieldChangeLog.setField(StaffFieldChangeEnum.JOB_NAME.getCode());
                staffFieldChangeLog.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                staffFieldChangeLogList.add(staffFieldChangeLog);
            }
            BeanUtil.copyProperties((Object)staffBasicInfo, (Object)sbi, (String[])new String[]{"id", "idCard", "cid"});
            addStaffBasicInfoList.add(sbi);
            if (si != null) {
                List dataList = (List)phcPhysicalCheckDataMap.get(staffInfo.getId());
                if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                    for (PhcPhysicalCheckData p : dataList) {
                        p.setStaffId(si.getId());
                    }
                }
                Boolean isThirdParty = staffInfo.getIsThirdParty();
                Boolean oldIsThirdParty = si.getIsThirdParty();
                if (Boolean.TRUE.equals(isThirdParty) && Boolean.FALSE.equals(oldIsThirdParty)) {
                    Integer count = this.staffFieldChangeLogMapper.getChangeCount(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode(), si.getId(), si.getCid(), "\u5916\u6765\u4eba\u5458", "\u672c\u4f01\u4e1a\u4eba\u5458");
                    if (ObjectUtil.isNotNull((Object)count) && count > 0) {
                        BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid", "isThirdParty", "outsource", "otherCompany"});
                    } else {
                        BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid"});
                        if (ObjectUtil.isNotNull((Object)si)) {
                            StaffFieldChangeLog log = new StaffFieldChangeLog();
                            log.setStaffId(si.getId());
                            log.setCid(si.getCid());
                            log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                            log.setBeforeInfo(Boolean.TRUE.equals(si.getIsThirdParty()) ? "\u672c\u4f01\u4e1a\u4eba\u5458" : "\u5916\u6765\u4eba\u5458");
                            log.setAfterInfo(Boolean.TRUE.equals(si.getIsThirdParty()) ? "\u5916\u6765\u4eba\u5458" : "\u672c\u4f01\u4e1a\u4eba\u5458");
                            log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                            staffFieldChangeLogList.add(log);
                        }
                    }
                } else {
                    BeanUtil.copyProperties((Object)staffInfo, (Object)si, (String[])new String[]{"id", "staffBasicId", "userId", "cid", "isThirdParty", "outsource", "otherCompany"});
                }
                addStaffInfoList.add(si);
            } else {
                staffInfo.setStaffBasicId(sbi.getId());
                staffInfo.setDataUpdateSource(Byte.valueOf((byte)2));
                if (ObjectUtil.isNotNull((Object)staffInfo)) {
                    StaffFieldChangeLog log = new StaffFieldChangeLog();
                    log.setStaffId(staffInfo.getId());
                    log.setCid(staffInfo.getCid());
                    log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                    log.setBeforeInfo("-");
                    log.setAfterInfo(Boolean.TRUE.equals(staffInfo.getIsThirdParty()) ? "\u5916\u6765\u4eba\u5458" : "\u672c\u4f01\u4e1a\u4eba\u5458");
                    log.setChangeReason("\u4f53\u68c0\u6570\u636e\u65b0\u589e");
                    staffFieldChangeLogList.add(log);
                }
                addStaffInfoList.add(staffInfo);
            }
            if (si != null && si.getId() != null) {
                StaffBasicWork sbw = this.staffBasicWorkService.getStaffBasicWorkByStaffId(si.getId());
                if (sbw != null) {
                    BeanUtil.copyProperties((Object)staffBasicWork, (Object)sbw, (String[])new String[]{"id", "cid", "staffId"});
                    addStaffBasicWorkList.add(sbw);
                } else {
                    staffBasicWork.setStaffId(si.getId());
                    staffBasicWork.setDataUpdateSource(Byte.valueOf((byte)2));
                    addStaffBasicWorkList.add(staffBasicWork);
                }
                StaffWorkRole swr = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(si.getId());
                if (swr != null) {
                    Boolean falg = false;
                    if (swr.getBeginTime() == null) {
                        swr.setIsHistory(Boolean.valueOf(true));
                        swr.setDataUpdateSource(Byte.valueOf((byte)1));
                        swr.setBeginTime(currentStaffWorkRole.getBeginTime());
                        falg = true;
                    }
                    String wandaHealthCardSourceId = currentStaffWorkRole.getWandaHealthCardSourceId();
                    String idCard = staffBasicInfo.getIdCard();
                    Long cid = staffBasicInfo.getCid();
                    if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)wandaHealthCardSourceId) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)idCard) && ObjectUtil.isNotNull((Object)cid)) {
                        String encs = SpringEncryptUtils.encrypt((String)idCard);
                        PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo = ((PhcPhysicalStaffCheckInfoMapper)this.dao).selectLatestPhcPhysicalStaffCheckInfo(encs, cid);
                        Date checkTime = phcPhysicalStaffCheckInfo.getCheckTime();
                        if (ObjectUtil.isNotNull((Object)phcPhysicalStaffCheckInfo) && wandaHealthCardSourceId.equals(phcPhysicalStaffCheckInfo.getCardId()) && ObjectUtil.isNotNull((Object)checkTime)) {
                            Byte status = swr.getStatus();
                            Date beginTime = swr.getBeginTime();
                            Date leaveTime = swr.getLeaveTime();
                            String bodyCheckType = phcPhysicalStaffCheckInfo.getBodyCheckType();
                            StaffFieldChangeLog log = new StaffFieldChangeLog();
                            log.setStaffId(si.getId());
                            log.setCid(cid);
                            log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
                            if (ObjectUtil.isNotNull((Object)status) && status == 1 && (ObjectUtil.isNull((Object)beginTime) || beginTime.before(checkTime))) {
                                if (cn.smarthse.common.util.StringUtils.isNotEmpty((String)bodyCheckType) && "3".contains(bodyCheckType)) {
                                    swr.setIsHistory(Boolean.valueOf(true));
                                    swr.setDataUpdateSource(Byte.valueOf((byte)1));
                                    swr.setStatus(Byte.valueOf((byte)2));
                                    swr.setLeaveTime(phcPhysicalStaffCheckInfo.getCheckTime());
                                    falg = true;
                                    log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)1));
                                    log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)2));
                                    log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                                    staffFieldChangeLogList.add(log);
                                }
                            } else if (ObjectUtil.isNotNull((Object)status) && status == 2 && (ObjectUtil.isNull((Object)leaveTime) || leaveTime.before(checkTime)) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)bodyCheckType) && "1,2".contains(bodyCheckType)) {
                                swr.setIsHistory(Boolean.valueOf(true));
                                swr.setDataUpdateSource(Byte.valueOf((byte)1));
                                swr.setStatus(Byte.valueOf((byte)1));
                                falg = true;
                                log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)2));
                                log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)1));
                                log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                                staffFieldChangeLogList.add(log);
                            }
                        }
                    }
                    if (falg.booleanValue()) {
                        addStaffWorkRoleList.add(swr);
                    }
                } else {
                    currentStaffWorkRole.setIsHistory(Boolean.valueOf(false));
                    currentStaffWorkRole.setDataUpdateSource(Byte.valueOf((byte)2));
                    currentStaffWorkRole.setStaffId(si.getId());
                    addStaffWorkRoleList.add(currentStaffWorkRole);
                }
            }
            addWorkRoleInfoList.add(workRoleInfo);
            companyOrganizationList.add(companyOrganization);
        }
        this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, null);
        this.staffInfoService.batchUpdateOrInsert(addStaffInfoList, StaffInfoMapper.class, (item, mapper) -> {
            if (item.getDataUpdateSource() != null && Objects.equals(item.getDataUpdateSource(), (byte)2)) {
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffBasicInfoService.batchUpdateOrInsert(addStaffBasicInfoList, StaffBasicInfoMapper.class, (item, mapper) -> {
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffBasicWorkService.batchUpdateOrInsert(addStaffBasicWorkList, StaffBasicWorkMapper.class, (item, mapper) -> {
            if (item.getDataUpdateSource() != null && Objects.equals(item.getDataUpdateSource(), (byte)2)) {
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataUpdateSource(Byte.valueOf((byte)1));
            item.setDataSource(null);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.staffWorkRoleService.batchUpdateOrInsert(addStaffWorkRoleList, StaffWorkRoleMapper.class, (item, mapper) -> {
            if (item.getIsHistory().booleanValue()) {
                item.setIsHistory(Boolean.valueOf(false));
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                item.setDataUpdateSource(Byte.valueOf((byte)1));
                item.setDataSource(null);
                return mapper.updateByPrimaryKeySelective(item);
            }
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            item.setDataSource(Byte.valueOf((byte)1));
            return mapper.insertSelective(item);
        });
        if (CollectionUtils.isNotEmpty(addWorkRoleInfoList)) {
            addWorkRoleInfoList = Optional.of(addWorkRoleInfoList.stream().filter(item -> Objects.nonNull(item.getNewAdd()) && item.getNewAdd() != false && item.getId() != null).distinct().collect(Collectors.toList())).orElse(new ArrayList());
        }
        companyOrganizationList = Optional.of(companyOrganizationList.stream().filter(item -> Objects.nonNull(item.getNewAdd()) && item.getNewAdd() != null && item.getNewAdd() != false && item.getId() != null).distinct().collect(Collectors.toList())).orElse(new ArrayList());
        maxSize = Stream.of(addWorkRoleInfoList.size(), companyOrganizationList.size()).max(Comparator.naturalOrder()).orElse(0);
        page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i3 = 0; i3 < page; ++i3) {
            List<CompanyOrganization> subCompanyOrganizationList;
            List<WorkRoleInfo> subAddWorkRoleInfoList = addWorkRoleInfoList.stream().skip(i3 * pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(subAddWorkRoleInfoList)) {
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertWorkRoleInfo(subAddWorkRoleInfoList);
            }
            if (!CollectionUtils.isNotEmpty(subCompanyOrganizationList = companyOrganizationList.stream().skip(i3 * pageSize).limit(pageSize).collect(Collectors.toList()))) continue;
            ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertCompanyOrganization(subCompanyOrganizationList);
        }
    }

    public void batchInsertPhcPhysicalCheckInfo(List<PhcPhysicalCheck> phcPhysicalCheckList, List<PhcPhysicalCheckData> phcPhysicalCheckDataList, List<PhcPhysicalCheckDataResult> phcPhysicalCheckDataResultList) {
        int pageSize = 1000;
        int maxSize = Stream.of(phcPhysicalCheckList.size(), phcPhysicalCheckDataList.size(), phcPhysicalCheckDataResultList.size()).max(Comparator.naturalOrder()).orElse(0);
        int page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i = 0; i < page; ++i) {
            List<PhcPhysicalCheckDataResult> subPhcPhysicalCheckDataResult;
            List<PhcPhysicalCheckData> subPhcPhysicalCheckData;
            List<PhcPhysicalCheck> subPhcPhysicalCheckList = phcPhysicalCheckList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(subPhcPhysicalCheckList)) {
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertPhcPhysicalCheck(subPhcPhysicalCheckList);
            }
            if (CollectionUtils.isNotEmpty(subPhcPhysicalCheckData = phcPhysicalCheckDataList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList()))) {
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertPhcPhysicalCheckData(subPhcPhysicalCheckData);
            }
            if (!CollectionUtils.isNotEmpty(subPhcPhysicalCheckDataResult = phcPhysicalCheckDataResultList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList()))) continue;
            ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertPhcPhysicalCheckDataResult(subPhcPhysicalCheckDataResult);
        }
    }

    @Transactional(readOnly=false)
    public void batchInsertReformItemBasic(List<ReformItemBasic> reformItemBasicList, List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList) {
        int pageSize = 1000;
        int maxSize = Stream.of(reformItemBasicList.size(), reformItemAcceptanceRecordList.size()).max(Comparator.naturalOrder()).orElse(0);
        int page = (int)Math.ceil((double)maxSize * 1.0 / (double)pageSize);
        for (int i = 0; i < page; ++i) {
            List<ReformItemAcceptanceRecord> subReformItemAcceptanceRecordList;
            List<ReformItemBasic> subReformItemBasicList = reformItemBasicList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(subReformItemBasicList)) {
                for (ReformItemBasic basic : subReformItemBasicList) {
                    basic.setStatus(Byte.valueOf((byte)0));
                    basic.setBusinessStatus(Byte.valueOf((byte)0));
                    basic.setIsShowInReformModular(Boolean.valueOf(true));
                    basic.setIsAutoGeneration(Boolean.valueOf(true));
                    basic.setBatchNum(Integer.valueOf(1));
                    basic.setCreateDate(new Date());
                    basic.setUpdateDate(new Date());
                    basic.setIsValid(Boolean.valueOf(true));
                }
                ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertReformItemBasic(subReformItemBasicList);
            }
            if (!CollectionUtils.isNotEmpty(subReformItemAcceptanceRecordList = reformItemAcceptanceRecordList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList()))) continue;
            for (ReformItemAcceptanceRecord record : subReformItemAcceptanceRecordList) {
                record.setStatus(Byte.valueOf((byte)0));
                record.setUpdateDate(new Date());
                record.setCreateDate(new Date());
                record.setIsValid(Boolean.valueOf(true));
            }
            ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchInsertReformItemAcceptanceRecord(subReformItemAcceptanceRecordList);
        }
    }

    @Transactional(readOnly=false)
    public void changeGeneratedData(String unifiedSocialCcs) {
        List<String> unifiedSocialCcList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)unifiedSocialCcs)) {
            unifiedSocialCcList = Arrays.asList(unifiedSocialCcs.split(","));
        }
        List<String> employerList = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getAllEmployerByCreditCode(unifiedSocialCcList);
        int pageSize = 10;
        int page = (int)Math.ceil((double)employerList.size() * 1.0 / (double)pageSize);
        for (int i = 0; i < page; ++i) {
            List list;
            block23: {
                List subEmployerList = employerList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
                Example example = new Example(PhcPhysicalStaffCheckInfo.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("isValid", (Object)true);
                if (CollectionUtils.isNotEmpty(subEmployerList)) {
                    criteria.andEqualTo("creditCode", unifiedSocialCcList);
                }
                if (CollectionUtils.isEmpty(list = this.getListByExample(example))) continue;
                Set<String> cardIdList = list.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toSet());
                Map<String, PhcPhysicalStaffCheckInfo> itemMap = this.phcPhysicalCheckV3221Mapper.getItemMap(cardIdList);
                for (PhcPhysicalStaffCheckInfo checkInfo : list) {
                    String cardId = checkInfo.getCardId();
                    PhcPhysicalStaffCheckInfo itemInfo = itemMap.get(cardId);
                    if (itemInfo == null || !cn.smarthse.common.util.StringUtils.isEmpty((CharSequence)checkInfo.getItemId())) continue;
                    checkInfo.setItemId(itemInfo.getItemId());
                    checkInfo.setItemGroupName(itemInfo.getItemGroupName());
                    checkInfo.setAnomalyItems(itemInfo.getAnomalyItems());
                }
                TransactionStatus itemStatus = null;
                if (this.transactionManager != null) {
                    DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                    def.setPropagationBehavior(3);
                    itemStatus = this.transactionManager.getTransaction((TransactionDefinition)def);
                }
                try {
                    this.batchUpdateOrInsert(list, PhcPhysicalStaffCheckInfoMapper.class, (item, mapper) -> {
                        item.setUpdateDate(new Date());
                        return mapper.updateByPrimaryKeySelective(item);
                    });
                    if (itemStatus != null) {
                        this.transactionManager.commit(itemStatus);
                    }
                    this.logger.error("\u4f53\u68c0\u540e\u7eed\u6dfb\u52a0\u4f53\u68c0\u9879\u76ee\u6210\u529f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("\u4f53\u68c0\u540e\u7eed\u6dfb\u52a0\u4f53\u68c0\u9879\u76ee\u5f02\u5e38\uff1a" + e.getMessage());
                    if (itemStatus == null) break block23;
                    this.transactionManager.rollback(itemStatus);
                }
            }
            List yszybOrYsjjzList = list.stream().filter(item -> "3".equals(item.getConclusion()) || "4".equals(item.getConclusion())).collect(Collectors.toList());
            HashMap map = new HashMap();
            if (CollectionUtils.isEmpty(yszybOrYsjjzList)) continue;
            Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
            Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
            List cidList = yszybOrYsjjzList.stream().map(PhcPhysicalStaffCheckInfo::getCid).distinct().collect(Collectors.toList());
            Example reformExample = new Example(ReformItemBasic.class);
            reformExample.createCriteria().andIn("cid", cidList).andEqualTo("reformItemSource", (Object)ReformSourceLiteEnum.ZYJKTJ.getValue()).andIn("generationSource", Arrays.asList(ReformGenerationSourceEnum.YSZYB.getValue(), ReformGenerationSourceEnum.JJZ.getValue())).andEqualTo("isValid", (Object)true).andEqualTo("dataSource", (Object)1);
            List reformItemBasicList = this.reformItemBasicService.getListByExample(reformExample);
            if (CollectionUtils.isEmpty((Collection)reformItemBasicList)) continue;
            Map reformItemMap = reformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getName, HashMap::new, Collectors.collectingAndThen(Collectors.toList(), subList -> subList.stream().sorted(Comparator.comparing(ReformItemBasic::getFindTime).reversed()).collect(Collectors.toList()))));
            HashMap<String, ArrayList<PhcPhysicalStaffCheckInfo>> staffCheckInfoMap = new HashMap<String, ArrayList<PhcPhysicalStaffCheckInfo>>();
            for (PhcPhysicalStaffCheckInfo checkInfo : yszybOrYsjjzList) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(checkInfo.getCheckTime());
                int n = calendar.get(1);
                String businessName = this.getBusinessName(checkInfo, n, jobMap, bodyCheckTypeMap);
                if (cn.smarthse.common.util.StringUtils.isEmpty((CharSequence)businessName)) continue;
                List<Object> subStaffCheckInfoList = (ArrayList<PhcPhysicalStaffCheckInfo>)staffCheckInfoMap.get(businessName);
                if (CollectionUtils.isNotEmpty((Collection)subStaffCheckInfoList)) {
                    subStaffCheckInfoList.add(checkInfo);
                } else {
                    subStaffCheckInfoList = new ArrayList<PhcPhysicalStaffCheckInfo>();
                    subStaffCheckInfoList.add(checkInfo);
                }
                subStaffCheckInfoList = subStaffCheckInfoList.stream().sorted(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime).reversed()).collect(Collectors.toList());
                staffCheckInfoMap.put(businessName, (ArrayList<PhcPhysicalStaffCheckInfo>)subStaffCheckInfoList);
            }
            ArrayList<ReformItemBasic> updateList = new ArrayList<ReformItemBasic>();
            Set entries = reformItemMap.entrySet();
            for (Map.Entry entry : entries) {
                PhcPhysicalStaffCheckInfo checkInfo;
                ReformItemBasic basic;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                List staffCheckInfoList = (List)staffCheckInfoMap.get(key);
                if (CollectionUtils.isEmpty((Collection)staffCheckInfoList)) continue;
                if (value.size() == 1 && staffCheckInfoList.size() == 1) {
                    ReformItemBasic basic2 = (ReformItemBasic)value.get(0);
                    PhcPhysicalStaffCheckInfo checkInfo2 = (PhcPhysicalStaffCheckInfo)staffCheckInfoList.get(0);
                    if (basic2.getReformItemSourceId() == null) {
                        basic2.setReformItemSourceId(checkInfo2.getSourceId());
                    }
                    basic2.setTjBusinessId(checkInfo2.getCardId());
                    basic2.setFindTime(checkInfo2.getCheckTime());
                    updateList.add(basic2);
                    continue;
                }
                if (value.size() <= staffCheckInfoList.size()) {
                    for (int j = 0; j < value.size(); ++j) {
                        basic = (ReformItemBasic)value.get(j);
                        checkInfo = (PhcPhysicalStaffCheckInfo)staffCheckInfoList.get(j);
                        if (basic.getReformItemSourceId() == null) {
                            basic.setReformItemSourceId(checkInfo.getSourceId());
                        }
                        basic.setTjBusinessId(checkInfo.getCardId());
                        basic.setFindTime(checkInfo.getCheckTime());
                        updateList.add(basic);
                    }
                    continue;
                }
                for (int j = 0; j < staffCheckInfoList.size(); ++j) {
                    basic = (ReformItemBasic)value.get(j);
                    checkInfo = (PhcPhysicalStaffCheckInfo)staffCheckInfoList.get(j);
                    if (basic.getReformItemSourceId() == null) {
                        basic.setReformItemSourceId(checkInfo.getSourceId());
                    }
                    basic.setTjBusinessId(checkInfo.getCardId());
                    basic.setFindTime(checkInfo.getCheckTime());
                    updateList.add(basic);
                }
            }
            TransactionStatus reformStatus = null;
            if (this.transactionManager != null) {
                DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
                defaultTransactionDefinition.setPropagationBehavior(3);
                reformStatus = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            }
            try {
                this.reformItemBasicService.batchUpdateOrInsert(updateList, ReformItemBasicMapper.class, (item, mapper) -> {
                    item.setUpdateDate(new Date());
                    return mapper.updateByPrimaryKeySelective(item);
                });
                if (reformStatus != null) {
                    this.transactionManager.commit(reformStatus);
                }
                this.logger.error("\u4f53\u68c0\u540e\u7eed\u4fee\u6539\u751f\u6210\u6574\u6539\u6570\u636e\u6765\u6e90\u4e0e\u4f53\u68c0\u9879\u76ee\u6765\u6e90\u5b57\u6bb5\u6210\u529f");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logger.error("\u4f53\u68c0\u540e\u7eed\u4fee\u6539\u751f\u6210\u6574\u6539\u6570\u636e\u6765\u6e90\u4e0e\u4f53\u68c0\u9879\u76ee\u6765\u6e90\u5b57\u6bb5\u5f02\u5e38\uff1a" + exception.getMessage());
                if (reformStatus == null) continue;
                this.transactionManager.rollback(reformStatus);
            }
        }
    }

    public PageInfo<CheckDataInfo> pageCheckData(JqGridParam jparam, PageCheckDataParam param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<CheckDataInfo> list = ((PhcPhysicalStaffCheckInfoMapper)this.dao).pageCheckData(param);
        for (CheckDataInfo checkDataInfo : list) {
            if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)checkDataInfo.getHarmIds())) continue;
            checkDataInfo.setHarmNames(this.getHarmNames(checkDataInfo.getHarmIds()));
        }
        return new PageInfo(list);
    }

    public List<PhcPhysicalStaffCheckInfo> getListByCardId(String cardId) {
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).getListByCardId(cardId);
    }

    public JqGridData<PhcPhysicalStaffCheckInfo> laborDispatchList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalStaffCheckInfo> list = ((PhcPhysicalStaffCheckInfoMapper)this.dao).laborDispatchList(searchVo);
        PageInfo pageInfo = new PageInfo(list);
        return new JqGridData(pageInfo, param);
    }

    public JqGridData<PhcPhysicalStaffCheckInfo> laborDispatchAssociationMatchList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalStaffCheckInfo> list = ((PhcPhysicalStaffCheckInfoMapper)this.dao).laborDispatchAssociationMatchList(searchVo);
        PageInfo pageInfo = new PageInfo(list);
        return new JqGridData(pageInfo, param);
    }

    public PhcPhysicalStaffCheckInfo getByCardIdWhereSource2(Long dataId) {
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andEqualTo("cardId", (Object)dataId.toString()).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return new PhcPhysicalStaffCheckInfo();
        }
        return (PhcPhysicalStaffCheckInfo)list.get(0);
    }

    public List<PhcPhysicalStaffCheckInfo> getLIstByCardIds(List<String> cardIds) {
        if (CollectionUtils.isEmpty(cardIds)) {
            return null;
        }
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andIn("cardId", cardIds).andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    public List<PhcPhysicalCheckV3221> countYszybNum(List<Long> cids, Integer year) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).countYszybNum(cids, year);
    }

    public List<PhcPhysicalStaffCheckInfoNoEn> queryCompliancePhysicalCheckInfo(List<Long> cids) {
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).queryCompliancePhysicalCheckInfo(cids);
    }

    public List<PhcPhysicalStaffCheckInfo> getStaffCheckList(PhcPhysicalCheckSearchVo searchVo) {
        List<PhcPhysicalStaffCheckInfo> staffCheckList = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getStaffCheckList(searchVo);
        this.settingDicValue(staffCheckList);
        return staffCheckList;
    }

    public PageInfo<PhcPhysicalStaffCheckInfo> getStaffCheckListPage(JqGridParam gparam, PhcPhysicalCheckSearchVo searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalStaffCheckInfo> staffCheckList = this.getStaffCheckList(searchVo);
        Map<Object, Object> map = new HashMap();
        Map itemMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(10L));
        List<Long> sourceIdList = staffCheckList.stream().filter(s -> cn.smarthse.common.util.StringUtils.isNumeric((CharSequence)s.getOrgCode())).map(PhcPhysicalStaffCheckInfo::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sourceIdList)) {
            List<PhcPhysicalCheckV3221> orgNames = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getOrgNames(sourceIdList);
            map = orgNames.stream().collect(Collectors.toMap(PhcPhysicalCheckV3221::getOrgCode, PhcPhysicalCheckV3221::getOrgName));
        }
        for (PhcPhysicalStaffCheckInfo info : staffCheckList) {
            if (!cn.smarthse.common.util.StringUtils.isNumeric((CharSequence)info.getOrgCode())) {
                info.setOrgName(info.getOrgCode());
            } else {
                info.setOrgName((String)map.get(info.getOrgCode()));
            }
            if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)info.getAnomalyItems())) continue;
            String[] split = info.getAnomalyItems().split(",");
            HashSet<CallSite> set = new HashSet<CallSite>();
            for (String itemId : split) {
                String value = (String)itemMap.get(itemId);
                if (!cn.smarthse.common.util.StringUtils.isNotEmpty((String)value)) continue;
                set.add((CallSite)((Object)(value + "\u5f02\u5e38")));
            }
            info.setAnomalyItems(String.join((CharSequence)",", set));
        }
        return new PageInfo(staffCheckList);
    }

    public List<PhcPhysicalStaffCheckInfo> getByCidIdCard(List<Long> cids, Set<String> idCardSet) {
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andIn("cid", cids).andIn("idcardCode", idCardSet).andIsNotNull("bodyCheckType").andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    public List<earliestCheckModel> getEarliestPhcDate(List<Long> cidList, List<String> idCardList) {
        List<String> idCardEncList = null;
        if (CollectionUtils.isEmpty(idCardList)) {
            return new ArrayList<earliestCheckModel>();
        }
        if (idCardList != null) {
            idCardEncList = idCardList.stream().map(SpringEncryptUtils::encrypt).toList();
        }
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).getEarliestPhcDate(cidList, idCardEncList);
    }

    public List<PhcPhysicalStaffCheckInfo> getNotConvertCfbYszybList(String unifiedSocialCc) {
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).getNotConvertCfbYszybList(unifiedSocialCc);
    }

    public PageInfo<PhcPhysicalStaffCheckInfo> getDelStaffListPage(JqGridParam gparam, String keyword, Long cid) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalStaffCheckInfo> list = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getDelStaffListPage(keyword, cid);
        return new PageInfo(list);
    }

    public List<PhcPhysicalStaffCheckInfo> getBySourceId(Long checkId) {
        Example e = new Example(PhcPhysicalStaffCheckInfo.class);
        e.createCriteria().andEqualTo("sourceId", (Object)checkId).andEqualTo("isValid", (Object)true);
        return this.getListByExample(e);
    }

    public void batchDelectStaffCheckInfoBySourceId(Long sourceId, Long loginUserId) {
        if (Objects.isNull(sourceId)) {
            return;
        }
        ((PhcPhysicalStaffCheckInfoMapper)this.dao).batchDelectStaffCheckInfoBySourceId(sourceId, loginUserId);
    }

    public String getHarmNames(String harmIds) {
        List ids = cn.smarthse.common.util.StringUtils.parseToLongList((String)harmIds);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return this.harmFactorService.getHarmNames(harmIds);
    }

    private String getBusinessName(PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo, Integer year, Map<String, String> jobMap, Map<String, String> bodyCheckTypeMap) {
        Object businessName = String.valueOf(year);
        String workName = "";
        workName = !"99-9999".equals(phcPhysicalStaffCheckInfo.getJobCode()) ? jobMap.get(phcPhysicalStaffCheckInfo.getJobCode()) : phcPhysicalStaffCheckInfo.getOtherJobName();
        businessName = cn.smarthse.common.util.StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop()) && cn.smarthse.common.util.StringUtils.isNotEmpty((String)workName) ? (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop() + "/" + workName : (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop()) ? (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop() : (String)businessName + "-" + workName);
        String conclusionStr = "";
        if ("3".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u7591\u4f3c\u804c\u4e1a\u75c5";
        } else if ("4".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u804c\u4e1a\u7981\u5fcc\u75c7";
        }
        businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getName() + "-" + bodyCheckTypeMap.get(phcPhysicalStaffCheckInfo.getBodyCheckType()) + "-" + conclusionStr;
        return businessName;
    }

    private Map<String, String> getWriteDatesFromWandaHealthCard(List<String> cardIds) {
        List<WandaHealthCard> results = ((PhcPhysicalStaffCheckInfoMapper)this.dao).getWriteDatesByCardIds(cardIds);
        HashMap<String, String> writeDateMap = new HashMap<String, String>();
        for (WandaHealthCard result : results) {
            String sourceId = result.getSourceId();
            String writeDate = result.getWriteDate();
            if (writeDate != null && writeDate.length() >= 10) {
                writeDate = writeDate.substring(0, 10);
            }
            writeDateMap.put(sourceId, writeDate);
        }
        return writeDateMap;
    }

    public Map<String, String> getCompanyNameDif(List<String> cardIds, Long cid) {
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andIn("cardId", cardIds).andIsNotNull("actualEmployerName").andIsNotNull("employerName").andEqualTo("isValid", (Object)true).andCondition("actual_employer_name != employer_name");
        example.selectProperties(new String[]{"cardId", "employerName"});
        example.setDistinct(true);
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).selectByExample(example).stream().filter(Objects::nonNull).collect(Collectors.toMap(PhcPhysicalStaffCheckInfo::getCardId, PhcPhysicalStaffCheckInfo::getEmployerName, (v1, v2) -> v1));
    }

    public List<PhcPhysicalStaffCheckInfo> getByCidAndSourceAndCardId(List<Long> tjCidList, List<Long> sourceIdList, List<String> cardIdList) {
        if (CollectionUtils.isEmpty(tjCidList) && CollectionUtils.isEmpty(sourceIdList) && CollectionUtils.isEmpty(cardIdList)) {
            return new ArrayList<PhcPhysicalStaffCheckInfo>();
        }
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        Example.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(tjCidList)) {
            criteria.andIn("cid", tjCidList);
        }
        if (CollectionUtils.isNotEmpty(sourceIdList)) {
            criteria.andIn("sourceId", sourceIdList);
        }
        if (CollectionUtils.isNotEmpty(cardIdList)) {
            criteria.andIn("cardId", cardIdList);
        }
        criteria.andEqualTo("isValid", (Object)true);
        example.selectProperties(new String[]{"sourceId", "checkTime", "cid", "name", "conclusion", "cardId", "employerName"});
        return ((PhcPhysicalStaffCheckInfoMapper)this.dao).selectByExample(example);
    }
}

