/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.checkV3221;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalCompanyInfoMapper;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCompanyInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalEmployerInfo;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCompanyInfoService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.model.org.AddResult;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class PhcPhysicalCompanyInfoServiceImpl
extends BaseServiceImpl<PhcPhysicalCompanyInfoMapper, PhcPhysicalCompanyInfo>
implements IPhcPhysicalCompanyInfoService {
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;

    public List<PhcPhysicalCompanyInfo> getCompanyInfoByCreditCode(List<String> unifiedSocialCcList) {
        List<PhcPhysicalCompanyInfo> companyInfoList = ((PhcPhysicalCompanyInfoMapper)this.dao).getCompanyInfoByCreditCode(unifiedSocialCcList);
        Map map = companyInfoList.stream().collect(Collectors.toMap(PhcPhysicalCompanyInfo::getCreditCode, Function.identity(), (c1, c2) -> c1.getCheckTime().compareTo(c2.getCheckTime()) > 0 ? c1 : c2));
        return new ArrayList<PhcPhysicalCompanyInfo>(map.values());
    }

    public PhcPhysicalCompanyInfo getOneComInfoByCreditCode(String unifiedSocialCc) {
        if (StringUtil.isEmpty((String)unifiedSocialCc)) {
            return new PhcPhysicalCompanyInfo();
        }
        Example example = new Example(PhcPhysicalCompanyInfo.class);
        example.createCriteria().andEqualTo("creditCode", (Object)unifiedSocialCc).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return (PhcPhysicalCompanyInfo)list.get(0);
        }
        return new PhcPhysicalCompanyInfo();
    }

    @Transactional(readOnly=false)
    public void batchUpdateOrInsertComInfo(List<PhcPhysicalCompanyInfo> companyList) {
        if (CollectionUtils.isEmpty(companyList)) {
            return;
        }
        List<String> creditCodeList = companyList.stream().map(PhcPhysicalCompanyInfo::getCreditCode).distinct().collect(Collectors.toList());
        Map<String, PhcPhysicalCompanyInfo> companyInfoMap = ((PhcPhysicalCompanyInfoMapper)this.dao).getCompanyInfoMapByCreditCode(creditCodeList);
        this.batchUpdateOrInsert(companyList, PhcPhysicalCompanyInfoMapper.class, (item, mapper) -> {
            PhcPhysicalCompanyInfo companyInfo = (PhcPhysicalCompanyInfo)companyInfoMap.get(item.getCreditCode());
            if (companyInfo != null) {
                BeanUtils.copyProperties((Object)item, (Object)companyInfo, (String[])new String[]{"id", "creditCode", "createDate", "createBy", "updateDate", "updateBy", "isValid"});
                companyInfo.setUpdateDate(new Date());
                return mapper.updateByPrimaryKey(companyInfo);
            }
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            return mapper.insert(item);
        });
    }

    public List<PhcPhysicalEmployerInfo> getEmployerInfoByCreditCode(List<String> unifiedSocialCcList) {
        List<PhcPhysicalEmployerInfo> employerInfoList = ((PhcPhysicalCompanyInfoMapper)this.dao).getEmployerInfoByCreditCode(unifiedSocialCcList);
        Map map = employerInfoList.stream().collect(Collectors.toMap(PhcPhysicalEmployerInfo::getCreditCodeEmployer, Function.identity(), (c1, c2) -> c1.getCheckTime().compareTo(c2.getCheckTime()) > 0 ? c1 : c2));
        return new ArrayList<PhcPhysicalEmployerInfo>(map.values());
    }

    @Transactional(readOnly=false)
    public void batchUpdateOrInsertEmpInfo(List<PhcPhysicalEmployerInfo> employerList) {
        if (CollectionUtils.isEmpty(employerList)) {
            return;
        }
        List<String> creditCodeList = employerList.stream().map(PhcPhysicalEmployerInfo::getCreditCodeEmployer).distinct().collect(Collectors.toList());
        Map<String, PhcPhysicalEmployerInfo> employerInfoMap = ((PhcPhysicalCompanyInfoMapper)this.dao).getEmployerInfoMapByCreditCode(creditCodeList);
        ArrayList<PhcPhysicalEmployerInfo> addList = new ArrayList<PhcPhysicalEmployerInfo>();
        ArrayList<PhcPhysicalEmployerInfo> updateList = new ArrayList<PhcPhysicalEmployerInfo>();
        for (PhcPhysicalEmployerInfo phcPhysicalEmployerInfo : employerList) {
            PhcPhysicalEmployerInfo employerInfo = employerInfoMap.get(phcPhysicalEmployerInfo.getCreditCodeEmployer());
            if (employerInfo != null) {
                BeanUtils.copyProperties((Object)phcPhysicalEmployerInfo, (Object)employerInfo, (String[])new String[]{"id", "creditCodeEmployer", "createDate", "createBy", "updateDate", "updateBy", "isValid"});
                employerInfo.setUpdateDate(new Date());
                updateList.add(employerInfo);
                continue;
            }
            phcPhysicalEmployerInfo.setId(Long.valueOf(this.idworker.nextId()));
            phcPhysicalEmployerInfo.setCreateDate(new Date());
            phcPhysicalEmployerInfo.setUpdateDate(new Date());
            phcPhysicalEmployerInfo.setIsValid(Boolean.valueOf(true));
            addList.add(phcPhysicalEmployerInfo);
        }
        int pageSize = 1000;
        if (CollectionUtils.isNotEmpty(updateList)) {
            for (PhcPhysicalEmployerInfo employerInfo : updateList) {
                if (employerInfo == null) continue;
                ((PhcPhysicalCompanyInfoMapper)this.dao).batchUpdateEmployerInfoById(employerInfo);
            }
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            int n = (int)Math.ceil((double)addList.size() * 1.0 / (double)pageSize);
            for (int i = 0; i < n; ++i) {
                List<PhcPhysicalEmployerInfo> subList = addList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
                ((PhcPhysicalCompanyInfoMapper)this.dao).batchInsertEmployerInfo(subList);
            }
        }
    }

    public List<ThirdOrganization> getOrganizationInfoByCreditCode(List<String> unifiedSocialCcList) {
        List<ThirdOrganization> thirdOrganizationList = ((PhcPhysicalCompanyInfoMapper)this.dao).getOrganizationInfoByCreditCode(unifiedSocialCcList);
        Map map = thirdOrganizationList.stream().collect(Collectors.toMap(ThirdOrganization::getCreditCode, Function.identity(), (c1, c2) -> c1.getCreateDate().compareTo(c2.getCreateDate()) > 0 ? c1 : c2));
        return new ArrayList<ThirdOrganization>(map.values());
    }

    @Transactional(readOnly=false)
    public void batchUpdateOrInsertOrganizationInfo(List<ThirdOrganization> thirdOrganizationList) {
        if (CollectionUtils.isEmpty(thirdOrganizationList)) {
            return;
        }
        Map map = thirdOrganizationList.stream().collect(Collectors.toMap(ThirdOrganization::getCreditCode, Function.identity()));
        List orgCodeList = thirdOrganizationList.stream().map(ThirdOrganization::getCreditCode).distinct().collect(Collectors.toList());
        List needCreateOrgCodeList = this.thirdOrganizationService.getNeedCreateOrgCode(orgCodeList);
        for (String orgCode : needCreateOrgCodeList) {
            ThirdOrganization organization;
            if (StringUtils.isEmpty((String)orgCode) || (organization = (ThirdOrganization)map.get(orgCode)) == null) continue;
            ThirdOrganization newOrg = new ThirdOrganization();
            newOrg.setId(Long.valueOf(this.idworker.nextId()));
            newOrg.setName(organization.getName());
            newOrg.setCreditCode(organization.getCreditCode());
            newOrg.setAreaId(organization.getAreaId());
            newOrg.setAddress(organization.getAddress());
            newOrg.setLegalPerson("");
            newOrg.setLegalPersonPhone("");
            newOrg.setOrgType(Integer.valueOf(2));
            newOrg.setOrgTypes("2");
            newOrg.setLevel(Integer.valueOf(0));
            newOrg.setRecordManageUnitDicId(Long.valueOf(0L));
            newOrg.setIsEnable(Boolean.valueOf(true));
            newOrg.setHidden(Boolean.valueOf(false));
            newOrg.setBusinessStatus(Byte.valueOf((byte)1));
            newOrg.setCreateBy(Long.valueOf(0L));
            newOrg.setCreateDate(new Date());
            newOrg.setUpdateBy(Long.valueOf(0L));
            newOrg.setUpdateDate(new Date());
            newOrg.setOrgSource(Byte.valueOf((byte)2));
            try {
                AddResult addResult = this.thirdOrganizationService.addAndGetResult(newOrg, new ArrayList(), Integer.valueOf(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

