/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.checkV3221;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalCheckV3221Mapper;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalStaffCheckInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.checkV3221.CheckNumInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCompanyInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalViewModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckConclusionEnum;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.fcyth.enums.FcythChangeTypeEnum;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientBasicInfoService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientSuspectedApplyService;
import cn.smarthse.modules.health.model.phyphcCheck.CidYear;
import cn.smarthse.modules.health.model.phyphcCheck.PhyPhcCheckCompanyInfo;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCompanyInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDetailInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckFileInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckListInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckTypeCount;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckListParam;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.services.wanda.api.service.IWandaHcItemsService;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckV3221ServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckV3221Mapper, PhcPhysicalCheckV3221>
implements IPhcPhysicalCheckV3221Service {
    @Autowired
    private IPhcPhysicalCompanyInfoService phcPhysicalCompanyInfoService;
    @Autowired
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private IFcythPatientBasicInfoService fcythPatientBasicInfoService;
    @DubboReference
    private IFcythPatientSuspectedApplyService fcythPatientSuspectedApplyService;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @DubboReference
    IWandaHcItemsService wandaHcItemsService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @DubboReference
    IWandaHealthCardService wandaHealthCardService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    PhcPhysicalStaffCheckInfoMapper phcPhysicalStaffCheckInfoMapper;

    public PageInfo<String> getPage(List<String> unifiedSocialCcList, Integer page, Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List<String> creditCodeList = ((PhcPhysicalCheckV3221Mapper)this.dao).getGroupByCreditCodeList(unifiedSocialCcList);
        return new PageInfo(creditCodeList);
    }

    @Transactional(readOnly=false)
    public List<String> convertedData(List<String> unifiedSocialCcList, Integer page, Integer pageSize) throws Exception {
        int i;
        if (ObjectUtil.isNotNull((Object)page) && ObjectUtil.isNotNull((Object)pageSize)) {
            PageHelper.startPage((int)page, (int)pageSize, (boolean)false);
        }
        List<PhcPhysicalCheckV3221> needConvertedCreditCode = ((PhcPhysicalCheckV3221Mapper)this.dao).getNeedConvertedCreditCode(unifiedSocialCcList);
        this.logger.error("\u8f6c\u6362\u7684\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801---\u300b{}", needConvertedCreditCode.stream().map(PhcPhysicalCheckV3221::getCreditCode).toList());
        Map<String, PhcPhysicalCheckV3221> creditCodeMap = needConvertedCreditCode.stream().collect(Collectors.toMap(PhcPhysicalCheckV3221::getCreditCode, Function.identity()));
        if (creditCodeMap == null || creditCodeMap.size() == 0) {
            this.logger.error("\u5206\u7ec4map\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        ArrayList<PhcPhysicalCheckV3221> insertList = new ArrayList<PhcPhysicalCheckV3221>();
        ArrayList<PhcPhysicalCheckV3221> updateList = new ArrayList<PhcPhysicalCheckV3221>();
        ArrayList<String> creditCodeList = new ArrayList<String>(creditCodeMap.keySet());
        List<PhcPhysicalCheckV3221> list = ((PhcPhysicalCheckV3221Mapper)this.dao).getPhcPhysicalCheckList(creditCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<PhcPhysicalCheckV3221> dbList = this.loadDbList(list, creditCodeMap);
        this.separateDiffData(insertList, updateList, list, dbList);
        if (CollectionUtils.isNotEmpty(insertList)) {
            i = this.batchUpdateOrInsert(insertList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setCreateDate(new Date());
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                PhcPhysicalCheckV3221 check = (PhcPhysicalCheckV3221)creditCodeMap.get(item.getCreditCode());
                if (check != null) {
                    item.setCid(check.getCid());
                }
                return mapper.insert(item);
            });
            this.logger.error("\u4f53\u68c0\u4e3b\u8868\u63d2\u5165{}\u6761\u6570\u636e", (Object)i);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            i = this.batchUpdateOrInsert(updateList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> {
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                return mapper.updateByPrimaryKeySelective(item);
            });
            this.logger.error("\u4f53\u68c0\u4e3b\u8868\u66f4\u65b0{}\u6761\u6570\u636e", (Object)i);
        }
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4f01\u4e1a\u4fe1\u606f\u548c\u7528\u5de5\u5355\u4f4d\u4fe1\u606f\u3001\u751f\u6210\u673a\u6784\u4fe1\u606f\u5f00\u59cb");
        this.convertedCompanyInfo(creditCodeList, creditCodeMap);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4f01\u4e1a\u4fe1\u606f\u548c\u7528\u5de5\u5355\u4f4d\u4fe1\u606f\u3001\u751f\u6210\u673a\u6784\u4fe1\u606f\u7ed3\u675f");
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb");
        Set<String> cardIds = this.convertedStaffInfo(creditCodeList, 1, true);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f");
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u5f00\u59cb");
        List bySourceIds = this.wandaHealthCardService.getBySourceIds(cardIds);
        List<String> repeatedList = bySourceIds.stream().filter(s -> s.getIsRepeated().equals((byte)1)).map(WandaHealthCard::getSourceId).distinct().collect(Collectors.toList());
        this.settingIsConvertedByCardIds(cardIds);
        if (CollectionUtils.isNotEmpty(repeatedList)) {
            ((PhcPhysicalCheckV3221Mapper)this.dao).settingIsRepeatedByCardIds(repeatedList);
        }
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u7ed3\u675f");
        return creditCodeList;
    }

    private void separateDiffData(List<PhcPhysicalCheckV3221> insertList, List<PhcPhysicalCheckV3221> updateList, List<PhcPhysicalCheckV3221> list, List<PhcPhysicalCheckV3221> dbList) {
        if (CollectionUtils.isEmpty(dbList)) {
            insertList.addAll(list);
            return;
        }
        Map<Long, List<PhcPhysicalCheckV3221>> listMap = list.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCid));
        Map<Long, List<PhcPhysicalCheckV3221>> dbMap = dbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCid));
        for (Long cid : listMap.keySet()) {
            if (!dbMap.containsKey(cid)) {
                insertList.addAll((Collection<PhcPhysicalCheckV3221>)listMap.get(cid));
                continue;
            }
            List<PhcPhysicalCheckV3221> sigleCompanyList = listMap.get(cid);
            List<PhcPhysicalCheckV3221> sigleCompanyDbList = dbMap.get(cid);
            Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckV3221>>>> map = sigleCompanyDbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getOrgCode, Collectors.groupingBy(PhcPhysicalCheckV3221::getCheckTime, Collectors.groupingBy(PhcPhysicalCheckV3221::getBodyCheckType))));
            for (PhcPhysicalCheckV3221 check : sigleCompanyList) {
                Map<Date, Map<Integer, List<PhcPhysicalCheckV3221>>> map_1 = map.get(check.getOrgCode());
                if (MapUtils.isEmpty(map_1)) {
                    insertList.add(check);
                    continue;
                }
                Map<Integer, List<PhcPhysicalCheckV3221>> map_2 = map_1.get(check.getCheckTime());
                if (MapUtils.isEmpty(map_2)) {
                    insertList.add(check);
                    continue;
                }
                List<PhcPhysicalCheckV3221> resultList = map_2.get(check.getBodyCheckType());
                if (CollectionUtils.isEmpty(resultList)) {
                    insertList.add(check);
                    continue;
                }
                PhcPhysicalCheckV3221 dbData = resultList.get(0);
                dbData.setNumberOfCheck(Integer.valueOf(dbData.getNumberOfCheck() + check.getNumberOfCheck()));
                dbData.setNumberOfXfc(Integer.valueOf(dbData.getNumberOfXfc() + check.getNumberOfXfc()));
                dbData.setNumberOfYsjjz(Integer.valueOf(dbData.getNumberOfYsjjz() + check.getNumberOfYsjjz()));
                dbData.setNumberOfYszyb(Integer.valueOf(dbData.getNumberOfYszyb() + check.getNumberOfYszyb()));
                dbData.setNumberOfMan(Integer.valueOf(dbData.getNumberOfMan() + check.getNumberOfMan()));
                dbData.setNumberOfWoman(Integer.valueOf(dbData.getNumberOfWoman() + check.getNumberOfWoman()));
                dbData.setNumberOfReexamination(Integer.valueOf(dbData.getNumberOfReexamination() + check.getNumberOfReexamination()));
                updateList.add(dbData);
            }
        }
    }

    private List<PhcPhysicalCheckV3221> loadDbList(List<PhcPhysicalCheckV3221> list, Map<String, PhcPhysicalCheckV3221> creditCodeMap) {
        List cidList = creditCodeMap.values().stream().map(PhcPhysicalCheckV3221::getCid).distinct().collect(Collectors.toList());
        List checkTimeList = list.stream().map(PhcPhysicalCheckV3221::getCheckTime).distinct().collect(Collectors.toList());
        List bodyCheckTypeList = list.stream().map(PhcPhysicalCheckV3221::getBodyCheckType).distinct().collect(Collectors.toList());
        List orgCodeList = list.stream().map(PhcPhysicalCheckV3221::getOrgCode).distinct().collect(Collectors.toList());
        Example example = new Example(PhcPhysicalCheckV3221.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cidList).andIn("checkTime", checkTimeList).andIn("bodyCheckType", bodyCheckTypeList).andIn("orgCode", orgCodeList);
        List<PhcPhysicalCheckV3221> dbList = this.getListByExample(example);
        return dbList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public void appendPhysicalCheckData(String unifiedSocialCcs) {
        int pageNum = 1;
        int pageSize = 10;
        Map creditCodeMap = this.companyService.getUnifiedSocialCcsAndCidMap(pageNum, pageSize, unifiedSocialCcs);
        while (MapUtils.isNotEmpty((Map)creditCodeMap)) {
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                this.commitOne(creditCodeMap);
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                this.logger.error("\u4f53\u68c0\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Throwable)e);
                this.transactionManager.rollback(status);
            }
            finally {
                creditCodeMap = this.companyService.getUnifiedSocialCcsAndCidMap(++pageNum, pageSize, unifiedSocialCcs);
            }
        }
    }

    public void appendEmpCreditCodeData(String unifiedSocialCcs) {
        int pageNum = 1;
        int pageSize = 1;
        List<Company> empCreditCodeList = this.getEmpCreditCodeList(pageNum, pageSize, unifiedSocialCcs);
        List split = ListUtil.split(empCreditCodeList, (int)pageSize);
        for (List list : split) {
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                HashMap<String, Company> creditCodeMap = new HashMap<String, Company>();
                for (Company company : list) {
                    creditCodeMap.put(company.getUnifiedSocialCc(), company);
                }
                this.commitEmpOne(creditCodeMap);
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                this.logger.error("\u4f53\u68c0\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                this.transactionManager.rollback(status);
            }
        }
    }

    public List<Company> getEmpCreditCodeList(int pageNum, int pageSize, String unifiedSocialCcs) {
        return ((PhcPhysicalCheckV3221Mapper)this.dao).getEmpCreditCodeList(pageNum, pageSize, unifiedSocialCcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public void correctData(String unifiedSocialCcs) {
        int pageNum = 1;
        int pageSize = 10;
        Map creditCodeMap = this.companyService.getUnifiedSocialCcsAndCidMap(pageNum, pageSize, unifiedSocialCcs);
        while (MapUtils.isNotEmpty((Map)creditCodeMap)) {
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                this.commitOneCorrect(creditCodeMap);
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                this.logger.error("\u4f53\u68c0\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Throwable)e);
                this.transactionManager.rollback(status);
            }
            finally {
                creditCodeMap = this.companyService.getUnifiedSocialCcsAndCidMap(++pageNum, pageSize, unifiedSocialCcs);
            }
        }
    }

    public void checkAndCorrect(Long cid) {
        List<PhcPhysicalCheckV3221> unequalList = ((PhcPhysicalCheckV3221Mapper)this.dao).unequalList(cid);
        if (CollectionUtils.isEmpty(unequalList)) {
            return;
        }
        for (PhcPhysicalCheckV3221 checkV3221 : unequalList) {
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                ((PhcPhysicalCheckV3221Mapper)this.dao).recoverIsConverted(checkV3221.getCreditCode(), checkV3221.getCheckYear());
                ((PhcPhysicalCheckV3221Mapper)this.dao).deleteByCid(checkV3221.getCid(), checkV3221.getCheckYear());
                List<String> sourceIds = ((PhcPhysicalCheckV3221Mapper)this.dao).getByCreditCode(checkV3221.getCreditCode(), checkV3221.getCheckYear());
                if (CollectionUtils.isEmpty(sourceIds)) {
                    this.transactionManager.rollback(status);
                    continue;
                }
                ((PhcPhysicalCheckV3221Mapper)this.dao).deleteChildByCardId(sourceIds);
                this.convertedDataWithoutStaffBaseInfo(checkV3221.getCreditCode());
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.transactionManager.rollback(status);
            }
        }
    }

    public void convertedDataWithoutStaffBaseInfo(String creditCode) throws Exception {
        PageHelper.startPage((int)1, (int)10);
        Map<String, PhcPhysicalCheckV3221> creditCodeMap = ((PhcPhysicalCheckV3221Mapper)this.dao).getGroupByCreditCodeMap(Arrays.asList(creditCode));
        if (creditCodeMap == null || creditCodeMap.size() == 0) {
            this.logger.error("\u5206\u7ec4map\u4e3a\u7a7a");
            return;
        }
        ArrayList<String> creditCodeList = new ArrayList<String>(creditCodeMap.keySet());
        List<PhcPhysicalCheckV3221> list = ((PhcPhysicalCheckV3221Mapper)this.dao).getPhcPhysicalCheckList(creditCodeList);
        this.logger.error("\u67e5\u8be2wanda_health_card \u4e3b\u8868\u4fe1\u606f");
        this.batchUpdateOrInsert(list, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            PhcPhysicalCheckV3221 check = (PhcPhysicalCheckV3221)creditCodeMap.get(item.getCreditCode());
            if (check != null) {
                item.setCid(check.getCid());
            }
            return mapper.insert(item);
        });
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4f01\u4e1a\u4fe1\u606f\u548c\u7528\u5de5\u5355\u4f4d\u4fe1\u606f\u3001\u751f\u6210\u673a\u6784\u4fe1\u606f\u5f00\u59cb");
        this.convertedCompanyInfo(creditCodeList, creditCodeMap);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4f01\u4e1a\u4fe1\u606f\u548c\u7528\u5de5\u5355\u4f4d\u4fe1\u606f\u3001\u751f\u6210\u673a\u6784\u4fe1\u606f\u7ed3\u675f");
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb");
        Set<String> cardIds = this.convertedStaffInfo(creditCodeList, 1, false);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f");
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u5f00\u59cb");
        this.settingIsConvertedByCardIds(cardIds);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u7ed3\u675f");
    }

    private void commitOneCorrect(Map<String, Company> creditCodeMap) throws Exception {
        ArrayList<String> unifiedSocialCcsList = new ArrayList<String>(creditCodeMap.keySet());
        List<PhcPhysicalCheckV3221> correctList = ((PhcPhysicalCheckV3221Mapper)this.dao).getCorrectPhcPhysicalCheckList(unifiedSocialCcsList);
        List<PhcPhysicalCheckV3221> dbDataList = this.getListByCids(unifiedSocialCcsList);
        if (CollectionUtils.isEmpty(correctList) || CollectionUtils.isEmpty(dbDataList)) {
            return;
        }
        ArrayList<PhcPhysicalCheckV3221> updateList = new ArrayList<PhcPhysicalCheckV3221>();
        for (PhcPhysicalCheckV3221 checkV3221 : correctList) {
            for (PhcPhysicalCheckV3221 dbData : dbDataList) {
                if (!dbData.getCheckTime().equals(checkV3221.getCheckTime()) || !dbData.getOrgCode().equalsIgnoreCase(checkV3221.getOrgCode()) || !dbData.getBodyCheckType().equals(checkV3221.getBodyCheckType()) || !dbData.getCreditCode().equalsIgnoreCase(checkV3221.getCreditCode()) || dbData.getNumberOfCheck().equals(checkV3221.getNumberOfCheck())) continue;
                dbData.setNumberOfCheck(checkV3221.getNumberOfCheck());
                dbData.setNumberOfXfc(checkV3221.getNumberOfXfc());
                dbData.setNumberOfReexamination(checkV3221.getNumberOfReexamination());
                dbData.setNumberOfYsjjz(checkV3221.getNumberOfYsjjz());
                dbData.setNumberOfYszyb(checkV3221.getNumberOfYszyb());
                dbData.setNumberOfMan(checkV3221.getNumberOfMan());
                dbData.setNumberOfWoman(checkV3221.getNumberOfWoman());
                dbData.setUpdateDate(new Date());
                updateList.add(dbData);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
        }
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb");
        this.updateCorrectStaffInfo(unifiedSocialCcsList);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f");
    }

    private void updateCorrectStaffInfo(List<String> unifiedSocialCcsList) {
        ArrayList<PhcPhysicalStaffCheckInfo> updateList = new ArrayList<PhcPhysicalStaffCheckInfo>();
        List<PhcPhysicalStaffCheckInfo> staffCheckInfoList = ((PhcPhysicalCheckV3221Mapper)this.dao).getCorrectStaffCheckInfoByCreditCode(unifiedSocialCcsList);
        List cardIds = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toList());
        List dbList = this.phcPhysicalStaffCheckInfoService.getLIstByCardIds(cardIds);
        block0: for (PhcPhysicalStaffCheckInfo dbData : dbList) {
            for (PhcPhysicalStaffCheckInfo newData : staffCheckInfoList) {
                if (!newData.getCardId().equalsIgnoreCase(dbData.getCardId())) continue;
                dbData.setContactHazardCode(newData.getContactHazardCode());
                dbData.setContactOtherHazardName(newData.getContactOtherHazardName());
                dbData.setHazardYear(newData.getHazardYear());
                dbData.setHazardMonth(newData.getHazardMonth());
                dbData.setSexCode(newData.getSexCode());
                updateList.add(dbData);
                continue block0;
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.phcPhysicalStaffCheckInfoService.batchUpdateOrInsert(updateList, PhcPhysicalStaffCheckInfoMapper.class, (item, mapper) -> {
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
        }
    }

    private void commitEmpOne(Map<String, Company> creditCodeMap) throws Exception {
        ArrayList<String> unifiedSocialCcsList = new ArrayList<String>(creditCodeMap.keySet());
        List<PhcPhysicalCheckV3221> needAppendList = ((PhcPhysicalCheckV3221Mapper)this.dao).getPhcPhysicalCheckListAppendEmp(unifiedSocialCcsList);
        if (CollectionUtils.isEmpty(needAppendList)) {
            return;
        }
        Map<String, List<PhcPhysicalCheckV3221>> appendMap = needAppendList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCreditCode));
        ArrayList<String> appendUnifiedSocialCcsList = new ArrayList<String>(appendMap.keySet());
        List<PhcPhysicalCheckV3221> dbList = this.getListByCids(appendUnifiedSocialCcsList);
        Map<String, List<PhcPhysicalCheckV3221>> dbMap = dbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCreditCode));
        ArrayList<PhcPhysicalCheckV3221> insertList = new ArrayList<PhcPhysicalCheckV3221>();
        ArrayList<PhcPhysicalCheckV3221> updateList = new ArrayList<PhcPhysicalCheckV3221>();
        this.assemblyData(appendMap, dbMap, insertList, updateList);
        if (CollectionUtils.isNotEmpty(insertList)) {
            Map<String, Company> finalCreditCodeMap = creditCodeMap;
            this.batchUpdateOrInsert(insertList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setCreateDate(new Date());
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                item.setCid(((Company)finalCreditCodeMap.get(item.getCreditCode())).getId());
                return mapper.insert(item);
            });
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
        }
        List ids = needAppendList.stream().map(PhcPhysicalCheckV3221::getCardId).collect(Collectors.toList());
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb");
        Set<String> cardIdSet = this.convertedStaffInfo(unifiedSocialCcsList, 3, true);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f");
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u5f00\u59cb");
        this.settingIsConvertedAppendEmp(cardIdSet);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u7ed3\u675f");
    }

    private void settingIsConvertedAppendEmp(Set<String> cardIdSet) {
        if (CollectionUtils.isEmpty(cardIdSet)) {
            return;
        }
        ((PhcPhysicalCheckV3221Mapper)this.dao).settingIsConvertedAppendEmp(cardIdSet);
    }

    private void commitOne(Map<String, Company> creditCodeMap) throws Exception {
        ArrayList<String> unifiedSocialCcsList = new ArrayList<String>(creditCodeMap.keySet());
        List<PhcPhysicalCheckV3221> needAppendList = ((PhcPhysicalCheckV3221Mapper)this.dao).getPhcPhysicalCheckListAppend(unifiedSocialCcsList);
        if (CollectionUtils.isEmpty(needAppendList)) {
            return;
        }
        Map<String, List<PhcPhysicalCheckV3221>> appendMap = needAppendList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCreditCode));
        ArrayList<String> appendUnifiedSocialCcsList = new ArrayList<String>(appendMap.keySet());
        List<PhcPhysicalCheckV3221> dbList = this.getListByCids(appendUnifiedSocialCcsList);
        Map<String, List<PhcPhysicalCheckV3221>> dbMap = dbList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCreditCode));
        ArrayList<PhcPhysicalCheckV3221> insertList = new ArrayList<PhcPhysicalCheckV3221>();
        ArrayList<PhcPhysicalCheckV3221> updateList = new ArrayList<PhcPhysicalCheckV3221>();
        this.assemblyData(appendMap, dbMap, insertList, updateList);
        if (CollectionUtils.isNotEmpty(insertList)) {
            Map<String, Company> finalCreditCodeMap = creditCodeMap;
            this.batchUpdateOrInsert(insertList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setCreateDate(new Date());
                item.setUpdateDate(new Date());
                item.setIsValid(Boolean.valueOf(true));
                item.setCid(((Company)finalCreditCodeMap.get(item.getCreditCode())).getId());
                return mapper.insert(item);
            });
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, PhcPhysicalCheckV3221Mapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
        }
        List ids = needAppendList.stream().map(PhcPhysicalCheckV3221::getCardId).collect(Collectors.toList());
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u5f00\u59cb");
        Set<String> cardIdSet = this.convertedStaffInfo(unifiedSocialCcsList, 2, true);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u4eba\u5458\u4fe1\u606f\u3001\u4eba\u5458\u4f53\u68c0\u4fe1\u606f\u548c\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f\u7ed3\u675f");
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u5f00\u59cb");
        this.settingIsConvertedAppend(cardIdSet);
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u6b64\u6279\u6570\u636e\u8f6c\u6362\u5b8c\u6bd5\u4fee\u6539\u4e3a\u2018\u5df2\u8f6c\u6362\u2019\u72b6\u6001\u7ed3\u675f");
    }

    private void assemblyData(Map<String, List<PhcPhysicalCheckV3221>> appendMap, Map<String, List<PhcPhysicalCheckV3221>> dbMap, List<PhcPhysicalCheckV3221> insertList, List<PhcPhysicalCheckV3221> updateList) {
        if (MapUtils.isEmpty(appendMap)) {
            return;
        }
        if (MapUtils.isEmpty(dbMap)) {
            for (String key : appendMap.keySet()) {
                insertList.addAll((Collection<PhcPhysicalCheckV3221>)appendMap.get(key));
            }
            return;
        }
        for (String unifiedSocialCcs : dbMap.keySet()) {
            List<PhcPhysicalCheckV3221> dbList = dbMap.get(unifiedSocialCcs);
            List<PhcPhysicalCheckV3221> appendList = appendMap.get(unifiedSocialCcs);
            if (CollectionUtils.isEmpty(appendList)) continue;
            insertList.addAll(appendList);
            for (PhcPhysicalCheckV3221 dbData : dbList) {
                for (PhcPhysicalCheckV3221 appendData : appendList) {
                    if (!dbData.getCheckTime().equals(appendData.getCheckTime()) || !dbData.getOrgCode().equalsIgnoreCase(appendData.getOrgCode()) || !dbData.getBodyCheckType().equals(appendData.getBodyCheckType())) continue;
                    dbData.setNumberOfCheck(Integer.valueOf(dbData.getNumberOfCheck() + appendData.getNumberOfCheck()));
                    dbData.setNumberOfXfc(Integer.valueOf(dbData.getNumberOfXfc() + appendData.getNumberOfXfc()));
                    dbData.setNumberOfYsjjz(Integer.valueOf(dbData.getNumberOfYsjjz() + appendData.getNumberOfYsjjz()));
                    dbData.setNumberOfYszyb(Integer.valueOf(dbData.getNumberOfYszyb() + appendData.getNumberOfYszyb()));
                    dbData.setNumberOfMan(Integer.valueOf(dbData.getNumberOfMan() + appendData.getNumberOfMan()));
                    dbData.setNumberOfWoman(Integer.valueOf(dbData.getNumberOfWoman() + appendData.getNumberOfWoman()));
                    dbData.setNumberOfReexamination(Integer.valueOf(dbData.getNumberOfReexamination() + appendData.getNumberOfReexamination()));
                    insertList.remove(appendData);
                    updateList.add(dbData);
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public List<PhcPhysicalCheckV3221> getListByCids(List<String> appendUnifiedSocialCcsList) {
        if (CollectionUtils.isEmpty(appendUnifiedSocialCcsList)) {
            return Collections.emptyList();
        }
        Example e = new Example(PhcPhysicalCheckV3221.class);
        e.createCriteria().andIn("creditCode", appendUnifiedSocialCcsList).andEqualTo("isValid", (Object)true);
        return this.getListByExample(e);
    }

    @Transactional(readOnly=false)
    public void settingIsConverted(List<String> creditCodeList) {
        if (CollectionUtils.isEmpty(creditCodeList)) {
            return;
        }
        ((PhcPhysicalCheckV3221Mapper)this.dao).settingIsConverted(creditCodeList);
    }

    @Transactional(readOnly=false)
    public void settingIsConvertedByCardIds(Set<String> cardIds) {
        if (CollectionUtils.isEmpty(cardIds)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(cardIds);
        ((PhcPhysicalCheckV3221Mapper)this.dao).settingIsConvertedByCardIds(list);
    }

    @Transactional(readOnly=false)
    public void settingIsConvertedAppend(Set<String> cardIdSet) {
        if (CollectionUtils.isEmpty(cardIdSet)) {
            return;
        }
        ((PhcPhysicalCheckV3221Mapper)this.dao).settingIsConvertedAppend(cardIdSet);
    }

    @Transactional(readOnly=false)
    public Set<String> convertedStaffInfo(List<String> unifiedSocialCcList, Integer type, Boolean flag) throws Exception {
        ArrayList<StaffInfo> staffInfoList = new ArrayList<StaffInfo>();
        ArrayList<PhcPhysicalCheck> phcPhysicalCheckList = new ArrayList<PhcPhysicalCheck>();
        ArrayList<PhcPhysicalCheckData> phcPhysicalCheckDataList = new ArrayList<PhcPhysicalCheckData>();
        ArrayList<PhcPhysicalCheckDataResult> phcPhysicalCheckDataResultList = new ArrayList<PhcPhysicalCheckDataResult>();
        ArrayList<ReformItemBasic> reformItemBasicList = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList = new ArrayList<ReformItemAcceptanceRecord>();
        List<Object> staffCheckInfoList = new ArrayList();
        if (type == 1) {
            staffCheckInfoList = ((PhcPhysicalCheckV3221Mapper)this.dao).getStaffCheckInfoByCreditCode(unifiedSocialCcList);
        }
        if (type == 2) {
            staffCheckInfoList = ((PhcPhysicalCheckV3221Mapper)this.dao).getAppendStaffCheckInfoByCreditCode(unifiedSocialCcList);
        }
        if (type == 3) {
            staffCheckInfoList = ((PhcPhysicalCheckV3221Mapper)this.dao).getAppendStaffCheckInfoByEmpCreditCode(unifiedSocialCcList);
        }
        staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toList());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Example example = new Example(PhcPhysicalCheckV3221.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("creditCode", unifiedSocialCcList);
        List checkList = this.getListByExample(example);
        Set<String> set = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).collect(Collectors.toSet());
        Map itemMap = new HashMap();
        if (CollectionUtils.isNotEmpty(set)) {
            try {
                itemMap = Optional.ofNullable(((PhcPhysicalCheckV3221Mapper)this.dao).getItemMap(set)).orElse(new HashMap());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Map<String, Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckV3221>>>>> map = checkList.stream().filter(item -> Objects.nonNull(item.getCreditCode()) && Objects.nonNull(item.getOrgCode()) && Objects.nonNull(item.getCheckTime()) && Objects.nonNull(item.getBodyCheckType())).collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCreditCode, Collectors.groupingBy(PhcPhysicalCheckV3221::getOrgCode, Collectors.groupingBy(PhcPhysicalCheckV3221::getCheckTime, Collectors.groupingBy(PhcPhysicalCheckV3221::getBodyCheckType)))));
        for (PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo : staffCheckInfoList) {
            String bodyCheckType;
            List<PhcPhysicalCheckV3221> subList;
            Date date;
            Map<Integer, List<PhcPhysicalCheckV3221>> subMap_3;
            String orgCode;
            Map<Date, Map<Integer, List<PhcPhysicalCheckV3221>>> subMap_2;
            String creditCode;
            Map<String, Map<Date, Map<Integer, List<PhcPhysicalCheckV3221>>>> subMap_1;
            PhcPhysicalStaffCheckInfo checkInfo;
            if (phcPhysicalStaffCheckInfo == null) continue;
            if (phcPhysicalStaffCheckInfo.getConclusion() == null) {
                phcPhysicalStaffCheckInfo.setConclusion("-1");
            }
            phcPhysicalStaffCheckInfo.setId(Long.valueOf(this.idworker.nextId()));
            phcPhysicalStaffCheckInfo.setCreateDate(new Date());
            phcPhysicalStaffCheckInfo.setUpdateDate(new Date());
            phcPhysicalStaffCheckInfo.setIsValid(Boolean.valueOf(true));
            if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getOtherDisease())) {
                phcPhysicalStaffCheckInfo.setOtherDisease(phcPhysicalStaffCheckInfo.getOtherDisease().replace("null;", ""));
            }
            if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getCheckResultCode())) {
                phcPhysicalStaffCheckInfo.setCheckResultCode(phcPhysicalStaffCheckInfo.getCheckResultCode().replace("......", "").replace("null;", ""));
            }
            if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getBirthday())) {
                try {
                    Date date2 = DateUtils.StringToDate((String)phcPhysicalStaffCheckInfo.getBirthday());
                    if (date2 != null) {
                        phcPhysicalStaffCheckInfo.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)((Date)format.parseObject(phcPhysicalStaffCheckInfo.getBirthday())), (Date)phcPhysicalStaffCheckInfo.getCheckTime())));
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u751f\u65e5\u8f6c\u6362\u51fa\u9519\uff1a{},id:{}", (Object)phcPhysicalStaffCheckInfo.getBirthday(), (Object)phcPhysicalStaffCheckInfo.getId());
                    e.printStackTrace();
                }
            }
            if (Objects.nonNull(checkInfo = (PhcPhysicalStaffCheckInfo)itemMap.get(phcPhysicalStaffCheckInfo.getCardId()))) {
                phcPhysicalStaffCheckInfo.setItemId(checkInfo.getItemId());
                phcPhysicalStaffCheckInfo.setItemGroupName(checkInfo.getItemGroupName());
                phcPhysicalStaffCheckInfo.setAnomalyItems(checkInfo.getAnomalyItems());
            }
            if ((subMap_1 = map.get(creditCode = phcPhysicalStaffCheckInfo.getCreditCode())) == null || (subMap_2 = subMap_1.get(orgCode = phcPhysicalStaffCheckInfo.getOrgCode())) == null || (subMap_3 = subMap_2.get(date = phcPhysicalStaffCheckInfo.getCheckTime())) == null || !CollectionUtils.isNotEmpty(subList = subMap_3.get(Integer.valueOf(bodyCheckType = phcPhysicalStaffCheckInfo.getBodyCheckType())))) continue;
            phcPhysicalStaffCheckInfo.setSourceId(subList.get(0).getId());
            phcPhysicalStaffCheckInfo.setCid(subList.get(0).getCid());
            phcPhysicalStaffCheckInfo.setEmployerName(subList.get(0).getEmployerName());
        }
        List orgCodeList = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getOrgCode).distinct().collect(Collectors.toList());
        Map map2 = this.thirdOrganizationService.getMapByCreditCode(orgCodeList);
        Map<String, StaffInfo> siMap = this.settingStaffInfo(staffInfoList, staffCheckInfoList, map2);
        this.settingPhcPhysicalCheck(reformItemBasicList, reformItemAcceptanceRecordList, phcPhysicalCheckList, phcPhysicalCheckDataList, phcPhysicalCheckDataResultList, staffCheckInfoList, map2, siMap);
        this.phcPhysicalStaffCheckInfoService.batchInsertStaffCheckInfo(staffCheckInfoList);
        if (flag.booleanValue() && CollectionUtils.isNotEmpty(siMap.keySet())) {
            this.phcPhysicalStaffCheckInfoService.batchInsertStaffInfo(staffInfoList, siMap.keySet(), phcPhysicalCheckDataList);
        }
        return set;
    }

    @Transactional(readOnly=false)
    public void convertedCompanyInfo(List<String> unifiedSocialCcList, Map<String, PhcPhysicalCheckV3221> creditCodeMap) {
        List companyList = this.phcPhysicalCompanyInfoService.getCompanyInfoByCreditCode(unifiedSocialCcList);
        for (PhcPhysicalCompanyInfo companyInfo : companyList) {
            PhcPhysicalCheckV3221 check = creditCodeMap.get(companyInfo.getCreditCode());
            if (check == null) continue;
            companyInfo.setCid(check.getCid());
        }
        this.phcPhysicalCompanyInfoService.batchUpdateOrInsertComInfo(companyList);
        List employerList = this.phcPhysicalCompanyInfoService.getEmployerInfoByCreditCode(unifiedSocialCcList);
        this.phcPhysicalCompanyInfoService.batchUpdateOrInsertEmpInfo(employerList);
    }

    private void settingPhcPhysicalCheck(List<ReformItemBasic> reformItemBasicList, List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList, List<PhcPhysicalCheck> phcPhysicalCheckList, List<PhcPhysicalCheckData> phcPhysicalCheckDataList, List<PhcPhysicalCheckDataResult> phcPhysicalCheckDataResultList, List<PhcPhysicalStaffCheckInfo> staffCheckInfoList, Map<String, ThirdOrganization> thirdOrganizationMap, Map<String, StaffInfo> siMap) {
        Map<String, Map<String, Map<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>>>> map = staffCheckInfoList.stream().collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCreditCode, Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getIdcardCode, Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCheckTime, Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getBodyCheckType, Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getConclusion))))));
        Map itemMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(10L));
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        Set<Map.Entry<String, Map<String, Map<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>>>>> entries = map.entrySet();
        for (Map.Entry<String, Map<String, Map<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>>>> creditCodeEntry : entries) {
            Set<Map.Entry<String, Map<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>>>> idCardCodeSet = creditCodeEntry.getValue().entrySet();
            for (Map.Entry<String, Map<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>>> idCardCodeEntry : idCardCodeSet) {
                Set<Map.Entry<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>>> checkTimeSet = idCardCodeEntry.getValue().entrySet();
                for (Map.Entry<Date, Map<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>> checkTimeEntry : checkTimeSet) {
                    Set<Map.Entry<String, Map<String, List<PhcPhysicalStaffCheckInfo>>>> bodyCheckTypeSet = checkTimeEntry.getValue().entrySet();
                    for (Map.Entry<String, Map<String, List<PhcPhysicalStaffCheckInfo>>> bodyCheckTypeEntry : bodyCheckTypeSet) {
                        Set<Map.Entry<String, List<PhcPhysicalStaffCheckInfo>>> conclusionSet = bodyCheckTypeEntry.getValue().entrySet();
                        for (Map.Entry<String, List<PhcPhysicalStaffCheckInfo>> conclusionEntry : conclusionSet) {
                            List<PhcPhysicalStaffCheckInfo> value = conclusionEntry.getValue();
                            if (!CollectionUtils.isNotEmpty(value)) continue;
                        }
                    }
                }
            }
        }
    }

    private String setBusinessName(PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo, Integer year, Map<String, String> jobMap, Map<String, String> bodyCheckTypeMap) {
        Object businessName = String.valueOf(year);
        String workName = "";
        workName = !"99-9999".equals(phcPhysicalStaffCheckInfo.getJobCode()) ? jobMap.get(phcPhysicalStaffCheckInfo.getJobCode()) : phcPhysicalStaffCheckInfo.getOtherJobName();
        if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop()) && StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop() + "/" + workName;
        } else if (StringUtils.isNotEmpty((String)phcPhysicalStaffCheckInfo.getWorkshop())) {
            businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getWorkshop();
        } else if (StringUtils.isNotEmpty((String)workName)) {
            businessName = (String)businessName + "-" + workName;
        }
        String conclusionStr = "";
        if ("3".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u7591\u4f3c\u804c\u4e1a\u75c5";
        } else if ("4".equals(phcPhysicalStaffCheckInfo.getConclusion())) {
            conclusionStr = "\u804c\u4e1a\u7981\u5fcc\u8bc1";
        }
        businessName = (String)businessName + "-" + phcPhysicalStaffCheckInfo.getName() + "-" + bodyCheckTypeMap.get(phcPhysicalStaffCheckInfo.getBodyCheckType()) + "-" + conclusionStr;
        return businessName;
    }

    private Map<String, StaffInfo> settingStaffInfo(List<StaffInfo> staffInfoList, List<PhcPhysicalStaffCheckInfo> staffCheckInfoList, Map<String, ThirdOrganization> thirdOrganizationMap) {
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map map = staffCheckInfoList.stream().peek(p -> p.setIdcardCode(p.getIdcardCode().toUpperCase())).collect(Collectors.toMap(PhcPhysicalStaffCheckInfo::getIdcardCode, Function.identity(), (c1, c2) -> c1.getCheckTime().compareTo(c2.getCheckTime()) > 0 ? c1 : c2));
        Map idCardMap = this.sysAreaService.getNativePlaceByIdCards(map.keySet());
        HashMap<String, StaffInfo> siMap = new HashMap<String, StaffInfo>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Set cidSet = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCid).collect(Collectors.toSet());
        Map companyOrganizationMap = this.companyOrganizationService.getAllCompanyOrganizationByCids(cidSet);
        Map workRoleInfoMap = this.workRoleInfoService.getAllWorkRoleInfoByCids(cidSet);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String idcardCode;
            String key = entry.getKey();
            PhcPhysicalStaffCheckInfo value = (PhcPhysicalStaffCheckInfo)entry.getValue();
            StaffBasicInfo sbi = new StaffBasicInfo();
            sbi.setId(Long.valueOf(this.idworker.nextId()));
            sbi.setRealName(value.getName());
            sbi.setGender(Byte.valueOf(value.getSexCode().equals("\u7537") ? (byte)1 : 0));
            sbi.setIdCard(value.getIdcardCode().toUpperCase());
            String maritalStatusCode = value.getMaritalStatusCode();
            boolean isMarried = true;
            if (maritalStatusCode != null) {
                if ("0".equals(maritalStatusCode)) {
                    maritalStatusCode = "1";
                    isMarried = false;
                } else if ("1".equals(maritalStatusCode)) {
                    maritalStatusCode = "0";
                }
                sbi.setMaritalStatus(Byte.valueOf(Byte.parseByte(maritalStatusCode)));
            }
            sbi.setIsMarried(Boolean.valueOf(isMarried));
            if (StringUtils.isNotEmpty((String)value.getBirthday())) {
                try {
                    Date date = DateUtils.StringToDate((String)value.getBirthday());
                    if (date != null) {
                        sbi.setBirthday(date);
                        sbi.setAge(Integer.valueOf(DateUtils.getAgeByDate((Date)sbi.getBirthday())));
                    }
                }
                catch (Exception e) {
                    this.logger.info("\u751f\u65e5\u8f6c\u6362\u51fa\u9519\uff1a{},id:{}", (Object)value.getBirthday(), (Object)value.getId());
                    e.printStackTrace();
                }
            }
            if (StringUtils.isNotEmpty((String)(idcardCode = value.getIdcardCode())) && IDCardUtil.isIDCard((String)idcardCode)) {
                String nativePlace = (String)idCardMap.get(value.getIdcardCode().substring(0, 6) + "000000");
                sbi.setNativePlace(nativePlace);
            } else {
                this.logger.info("\u8eab\u4efd\u8bc1\u683c\u5f0f\u6709\u8bef\uff1a{},id:{}", (Object)idcardCode, (Object)value.getId());
            }
            sbi.setIdcardType(value.getIdcardType());
            sbi.setMobile(value.getTelPhone());
            sbi.setCid(value.getCid());
            sbi.setCreateDate(new Date());
            sbi.setUpdateDate(new Date());
            sbi.setIsValid(Boolean.valueOf(true));
            sbi.setDataSource(Byte.valueOf((byte)1));
            String jobCode = value.getJobCode();
            String workName = "";
            workName = !"99-9999".equals(jobCode) ? (String)jobMap.get(jobCode) : value.getOtherJobName();
            sbi.setJobName(workName);
            StaffInfo sInfo = new StaffInfo();
            sInfo.setId(Long.valueOf(this.idworker.nextId()));
            sInfo.setStaffBasicId(sbi.getId());
            sInfo.setCid(value.getCid());
            if (StringUtils.isNotEmpty((String)value.getCreditCodeEmployer()) && StringUtils.isNotEmpty((String)value.getYrdwCreditCode()) && !value.getCreditCodeEmployer().equals(value.getYrdwCreditCode())) {
                sInfo.setIsThirdParty(Boolean.valueOf(true));
                sInfo.setOutsource(Byte.valueOf((byte)1));
                sInfo.setOtherCompany(value.getYrdwEmployerName());
            } else {
                sInfo.setIsThirdParty(Boolean.valueOf(false));
                sInfo.setOutsource(null);
                sInfo.setOtherCompany(null);
            }
            sInfo.setCheckStatus(Byte.valueOf((byte)2));
            sInfo.setAddFrom(Integer.valueOf(StaffAddFromEnum.wanda_physical_import.getValue().byteValue()));
            sInfo.setCreateDate(new Date());
            sInfo.setUpdateDate(new Date());
            sInfo.setIsValid(Boolean.valueOf(true));
            sInfo.setDataSource(Byte.valueOf((byte)1));
            CompanyOrganization companyOrganization = new CompanyOrganization();
            String comOrgKey = value.getCid() + "-" + value.getWorkshop();
            if (companyOrganizationMap.get(comOrgKey) == null) {
                if (StringUtils.isNotEmpty((String)value.getWorkshop())) {
                    companyOrganization.setId(Long.valueOf(this.idworker.nextId()));
                    companyOrganization.setCid(value.getCid());
                    companyOrganization.setOrganizationName(value.getWorkshop());
                    companyOrganization.setLevel(Byte.valueOf((byte)1));
                    companyOrganization.setNewAdd(Boolean.valueOf(true));
                    companyOrganization.setCreateDate(new Date());
                    companyOrganization.setUpdateDate(new Date());
                    companyOrganization.setIsValid(Boolean.valueOf(true));
                    companyOrganization.setDataSource(Byte.valueOf((byte)1));
                    companyOrganizationMap.put(comOrgKey, companyOrganization);
                }
            } else {
                companyOrganization = (CompanyOrganization)companyOrganizationMap.get(comOrgKey);
            }
            StaffBasicWork staffBasicWork = new StaffBasicWork();
            staffBasicWork.setId(Long.valueOf(this.idworker.nextId()));
            staffBasicWork.setCid(value.getCid());
            staffBasicWork.setStaffId(sInfo.getId());
            staffBasicWork.setWorkNo(value.getJobNumber());
            staffBasicWork.setOrgId(companyOrganization.getId());
            staffBasicWork.setCreateDate(new Date());
            staffBasicWork.setUpdateDate(new Date());
            staffBasicWork.setIsValid(Boolean.valueOf(true));
            staffBasicWork.setDataSource(Byte.valueOf((byte)1));
            WorkRoleInfo workRoleInfo = new WorkRoleInfo();
            String workRoleInfoKey = value.getCid() + "-" + companyOrganization.getId() + "-" + workName;
            if (workRoleInfoMap.get(workRoleInfoKey) == null) {
                if (StringUtils.isNotEmpty((String)workName)) {
                    workRoleInfo.setId(Long.valueOf(this.idworker.nextId()));
                    workRoleInfo.setCid(value.getCid());
                    workRoleInfo.setOrgId(companyOrganization.getId());
                    workRoleInfo.setNewAdd(Boolean.valueOf(true));
                    workRoleInfo.setWorkName(workName);
                    workRoleInfo.setHarmFanctorIds(value.getContactHazardCode());
                    workRoleInfo.setCreateDate(new Date());
                    workRoleInfo.setUpdateDate(new Date());
                    workRoleInfo.setIsValid(Boolean.valueOf(true));
                    workRoleInfo.setDataSource(Byte.valueOf((byte)1));
                    workRoleInfoMap.put(workRoleInfoKey, workRoleInfo);
                }
            } else {
                workRoleInfo = (WorkRoleInfo)workRoleInfoMap.get(workRoleInfoKey);
                if (StringUtils.isNotEmpty((String)workRoleInfo.getHarmFanctorIds())) {
                    List harmFanctorIdsList = Arrays.stream(workRoleInfo.getHarmFanctorIds().split(",")).distinct().collect(Collectors.toList());
                    if (!harmFanctorIdsList.contains(value.getContactHazardCode())) {
                        workRoleInfo.setHarmFanctorIds(workRoleInfo.getHarmFanctorIds() + "," + value.getContactHazardCode());
                    }
                } else {
                    workRoleInfo.setHarmFanctorIds(workRoleInfo.getHarmFanctorIds());
                }
            }
            StaffWorkRole staffWorkRole = new StaffWorkRole();
            staffWorkRole.setId(Long.valueOf(this.idworker.nextId()));
            staffWorkRole.setCid(value.getCid());
            staffWorkRole.setStaffId(sInfo.getId());
            staffWorkRole.setWorkProperty(Byte.valueOf((byte)1));
            staffWorkRole.setWorkRoleId(workRoleInfo.getId());
            staffWorkRole.setIsThirdParty(Boolean.valueOf(false));
            staffWorkRole.setIsHistory(Boolean.valueOf(false));
            staffWorkRole.setCreateDate(new Date());
            staffWorkRole.setUpdateDate(new Date());
            staffWorkRole.setIsValid(Boolean.valueOf(true));
            staffWorkRole.setDataSource(Byte.valueOf((byte)1));
            if (value.getBodyCheckType() != null && "3,4".contains(value.getBodyCheckType())) {
                staffWorkRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
            } else {
                staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
            }
            sInfo.setStaffBasicInfo(sbi);
            staffWorkRole.setWorkRoleInfo(workRoleInfo);
            staffWorkRole.setWandaHealthCardSourceId(value.getCardId());
            staffBasicWork.setCompanyOrganization(companyOrganization);
            staffBasicWork.setCurrentStaffWorkRole(staffWorkRole);
            sInfo.setStaffBasicWork(staffBasicWork);
            staffInfoList.add(sInfo);
            siMap.put(value.getIdcardCode(), sInfo);
        }
        return siMap;
    }

    public List<Integer> getYearList(PhcPhysicalCheckSearchVo searchVo) {
        List<Integer> yearList = new ArrayList<Integer>();
        if (searchVo.getCid() != null || !StringUtils.isEmpty((String)searchVo.getUnifiedSocialCc())) {
            yearList = ((PhcPhysicalCheckV3221Mapper)this.dao).getYearList(searchVo);
        }
        return yearList;
    }

    public Map<String, String> getBodyCheckTypeList(PhcPhysicalCheckSearchVo searchVo) {
        return this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
    }

    public PageInfo<PhcPhysicalCheckV3221> getPageInfoBySearchVo(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        if (searchVo.getCid() == null && StringUtils.isEmpty((String)searchVo.getUnifiedSocialCc())) {
            return new PageInfo();
        }
        List<PhcPhysicalCheckV3221> list = this.getListDataBySearchVo(param, searchVo, isSearchThirdMatch);
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        for (PhcPhysicalCheckV3221 phcPhysicalCheckV3221 : list) {
            String value = (String)bodyCheckTypeMap.get("" + phcPhysicalCheckV3221.getBodyCheckType());
            phcPhysicalCheckV3221.setBodyCheckTypeStr(value);
        }
        return new PageInfo(list);
    }

    public List<PhcPhysicalCheckV3221> getListDataBySearchVo(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        boolean noMatch;
        if (searchVo.getCid() == null && StringUtils.isEmpty((String)searchVo.getUnifiedSocialCc())) {
            return new ArrayList<PhcPhysicalCheckV3221>();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalCheckV3221> companyPhyList = ((PhcPhysicalCheckV3221Mapper)this.dao).getListDataBySearchVo(searchVo);
        List<PhcPhysicalCheckV3221> matchPhyList = Objects.equals(isSearchThirdMatch, 1) ? ((PhcPhysicalCheckV3221Mapper)this.dao).getListDataAssociationMatchBySearchVo(searchVo) : null;
        boolean bl = noMatch = matchPhyList == null || matchPhyList.isEmpty();
        if (noMatch) {
            return Optional.ofNullable(companyPhyList).orElse(Collections.emptyList());
        }
        List<PhcPhysicalCheckV3221> mergedMatchList = this.mergePhyList(matchPhyList);
        mergedMatchList.addAll(companyPhyList);
        return Optional.of(mergedMatchList).orElse(Collections.emptyList());
    }

    private List<PhcPhysicalCheckV3221> mergePhyList(List<PhcPhysicalCheckV3221> matchPhyList) {
        Map<String, List<PhcPhysicalCheckV3221>> listByIdTime = matchPhyList.stream().collect(Collectors.groupingBy(l -> l.getId() + "_" + l.getDataSource() + "_" + String.valueOf(l.getCheckTime())));
        ArrayList<PhcPhysicalCheckV3221> retList = new ArrayList<PhcPhysicalCheckV3221>();
        for (Map.Entry<String, List<PhcPhysicalCheckV3221>> oneList : listByIdTime.entrySet()) {
            String key = oneList.getKey();
            List<PhcPhysicalCheckV3221> value = oneList.getValue();
            PhcPhysicalCheckV3221 phy = new PhcPhysicalCheckV3221();
            BeanUtils.copyBeanProp((Object)phy, (Object)value.get(0));
            int checkNum = 0;
            int zybNum = 0;
            int jjzNum = 0;
            int reviewNum = 0;
            for (PhcPhysicalCheckV3221 v : value) {
                checkNum += v.getNumberOfCheck().intValue();
                zybNum += v.getNumberOfYszyb().intValue();
                jjzNum += v.getNumberOfYsjjz().intValue();
                reviewNum += v.getNumberOfXfc().intValue();
            }
            phy.setNumberOfCheck(Integer.valueOf(checkNum));
            phy.setNumberOfYszyb(Integer.valueOf(zybNum));
            phy.setNumberOfYsjjz(Integer.valueOf(jjzNum));
            phy.setNumberOfXfc(Integer.valueOf(reviewNum));
            retList.add(phy);
        }
        return retList;
    }

    public PhcPhysicalViewModel getViewById(PhcPhysicalCheckSearchVo searchVo) {
        PhcPhysicalViewModel model = new PhcPhysicalViewModel();
        if (searchVo.getId() == null) {
            return model;
        }
        int numberOfOther = 0;
        int numberOfFc = 0;
        int numberOfYszyb = 0;
        int numberOfYsjjz = 0;
        PhcPhysicalCheckV3221 check = (PhcPhysicalCheckV3221)this.getById(searchVo.getId());
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        check.setBodyCheckTypeStr((String)bodyCheckTypeMap.get("" + check.getBodyCheckType()));
        model.setCheck(check);
        List staffInfoList = this.phcPhysicalStaffCheckInfoService.getStaffCheckInfoListByCheckId(searchVo.getId());
        if (check.getDataSource() != null && check.getDataSource() == 2) {
            numberOfOther = this.getNumber4Conclusion(staffInfoList, Arrays.asList("1", "5", "6"));
            numberOfFc = this.getNumber4Conclusion(staffInfoList, Arrays.asList("2"));
            numberOfYszyb = this.getNumber4Conclusion(staffInfoList, Arrays.asList("3"));
            numberOfYsjjz = this.getNumber4Conclusion(staffInfoList, Arrays.asList("4"));
        } else {
            List<PhcPhysicalStaffCheckInfo> numberOfCheckList = ((PhcPhysicalCheckV3221Mapper)this.dao).getNumberOfCheck(searchVo.getId());
            numberOfOther = this.getNumber4Conclusion(numberOfCheckList, Arrays.asList("1", "5", "6"));
            numberOfFc = this.getNumber4Conclusion(numberOfCheckList, Arrays.asList("2"));
            numberOfYszyb = this.getNumber4Conclusion(numberOfCheckList, Arrays.asList("3"));
            numberOfYsjjz = this.getNumber4Conclusion(numberOfCheckList, Arrays.asList("4"));
        }
        PhcPhysicalCompanyInfo companyInfo = this.phcPhysicalCompanyInfoService.getOneComInfoByCreditCode(check.getCreditCode());
        if (Objects.isNull(companyInfo) || StringUtil.isEmpty((CharSequence)companyInfo.getEmployerName())) {
            Company company = (Company)this.companyService.getById(check.getCid());
            companyInfo.setEmployerName(company.getName());
            companyInfo.setAddress(company.getRegisterAddress());
        }
        model.setCompanyInfo(companyInfo);
        if (CollectionUtils.isEmpty((Collection)staffInfoList)) {
            return model;
        }
        Map itemMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(10L));
        HashSet<String> itemIdSet = new HashSet<String>();
        for (PhcPhysicalStaffCheckInfo checkInfo : staffInfoList) {
            String[] split;
            if (!StringUtils.isNotEmpty((String)checkInfo.getItemId())) continue;
            for (String itemId : split = checkInfo.getItemId().split(",")) {
                itemIdSet.add((String)itemMap.get(itemId));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)staffInfoList)) {
            List hazardCodes = staffInfoList.stream().map(PhcPhysicalStaffCheckInfo::getContactHazardCode).distinct().collect(Collectors.toList());
            String contactHazardCodeStr = check.getDataSource() == 1 ? this.dictionaryService.getContactHazardCodes(hazardCodes) : this.harmFactorService.getHarmNames(StringUtil.join(hazardCodes, (String)","));
            model.setHazardCodeStr(contactHazardCodeStr);
        }
        model.setItemNameStr(StringUtils.join((Object[])new Set[]{itemIdSet}));
        model.setNumberOfOther(Integer.valueOf(numberOfOther));
        model.getCheck().setNumberOfXfc(Integer.valueOf(numberOfFc));
        model.getCheck().setNumberOfYsjjz(Integer.valueOf(numberOfYsjjz));
        model.getCheck().setNumberOfYszyb(Integer.valueOf(numberOfYszyb));
        return model;
    }

    private int getNumber4Conclusion(List<PhcPhysicalStaffCheckInfo> checkInfoList, List<String> conclusionList) {
        return (int)checkInfoList.stream().filter(checkInfo -> conclusionList.contains(checkInfo.getConclusion())).map(item -> item.getIdcardCode() + item.getName()).distinct().count();
    }

    public PhcPhysicalViewModel getViewAssociativeMatchDataById(PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        PhcPhysicalCheckV3221 check;
        boolean noCom;
        PhcPhysicalViewModel model = new PhcPhysicalViewModel();
        if (searchVo.getId() == null) {
            return model;
        }
        Example example = new Example(PhcPhysicalCheckV3221.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("id", (Object)searchVo.getId()).andEqualTo("creditCode", (Object)searchVo.getUnifiedSocialCc());
        List companyPhyList = this.getListByExample(example);
        List staffInfoList = this.phcPhysicalStaffCheckInfoService.getStaffCheckInfoListByCheck(searchVo, isSearchThirdMatch);
        boolean bl = noCom = companyPhyList == null || companyPhyList.isEmpty();
        if (noCom) {
            check = new PhcPhysicalCheckV3221();
            PhcPhysicalCheckV3221 template = (PhcPhysicalCheckV3221)this.getById(searchVo.getId());
            int maleNum = 0;
            int femaleNum = 0;
            int zybNum = 0;
            int jjzNum = 0;
            int reviewNum = 0;
            for (PhcPhysicalStaffCheckInfo s : staffInfoList) {
                maleNum += "\u7537".equals(s.getSexCode()) ? 1 : 0;
                femaleNum += "\u5973".equals(s.getSexCode()) ? 1 : 0;
                zybNum += PhyPhcCheckConclusionEnum.YSZYB.getCode().toString().equals(s.getConclusion()) ? 1 : 0;
                jjzNum += PhyPhcCheckConclusionEnum.ZYJJZ.getCode().toString().equals(s.getConclusion()) ? 1 : 0;
                reviewNum += PhyPhcCheckConclusionEnum.REVIEW.getCode().toString().equals(s.getConclusion()) ? 1 : 0;
            }
            BeanUtils.copyBeanProp((Object)check, (Object)template);
            check.setNumberOfCheck(Integer.valueOf(staffInfoList.size()));
            check.setNumberOfMan(Integer.valueOf(maleNum));
            check.setNumberOfWoman(Integer.valueOf(femaleNum));
            check.setNumberOfYszyb(Integer.valueOf(zybNum));
            check.setNumberOfYsjjz(Integer.valueOf(jjzNum));
            check.setNumberOfXfc(Integer.valueOf(reviewNum));
        } else {
            check = (PhcPhysicalCheckV3221)this.getById(searchVo.getId());
        }
        Map bodyCheckTypeMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(13L));
        check.setBodyCheckTypeStr((String)bodyCheckTypeMap.get("" + check.getBodyCheckType()));
        model.setCheck(check);
        PhcPhysicalCompanyInfo companyInfo = this.phcPhysicalCompanyInfoService.getOneComInfoByCreditCode(check.getCreditCode());
        model.setCompanyInfo(companyInfo);
        if (CollectionUtils.isEmpty((Collection)staffInfoList)) {
            return model;
        }
        Map itemMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(10L));
        HashSet<String> itemIdSet = new HashSet<String>();
        Set numberOfOtherSet = staffInfoList.stream().filter(checkInfo -> "1".equals(checkInfo.getConclusion()) || "5".equals(checkInfo.getConclusion())).map(PhcPhysicalStaffCheckInfo::getIdcardCode).collect(Collectors.toSet());
        for (PhcPhysicalStaffCheckInfo checkInfo2 : staffInfoList) {
            String[] split;
            if (!StringUtils.isNotEmpty((String)checkInfo2.getItemId())) continue;
            for (String itemId : split = checkInfo2.getItemId().split(",")) {
                itemIdSet.add((String)itemMap.get(itemId));
            }
        }
        String contactHazardCodeStr = this.dictionaryService.getContactHazardCodes(staffInfoList.stream().map(PhcPhysicalStaffCheckInfo::getContactHazardCode).distinct().collect(Collectors.toList()));
        model.setHazardCodeStr(contactHazardCodeStr);
        model.setItemNameStr(StringUtils.join((Object[])new Set[]{itemIdSet}));
        model.setNumberOfOther(Integer.valueOf(numberOfOtherSet.size()));
        return model;
    }

    @Transactional
    public List<String> resetRepeatedData(List<String> unifiedSocialCcsList) throws Exception {
        List<PhcPhysicalStaffCheckInfo> delStaff;
        this.logger.error("\u91cd\u7f6e\u9519\u8bef\u4f53\u68c0\u6570\u636e\u5f00\u59cb");
        List<WandaHealthCard> wandaHealthCardList = ((PhcPhysicalCheckV3221Mapper)this.dao).selectWandaHealthCardList(unifiedSocialCcsList);
        if (CollectionUtils.isEmpty(wandaHealthCardList)) {
            return Collections.emptyList();
        }
        List<String> wandaSourceIdList = wandaHealthCardList.stream().map(WandaHealthCard::getSourceId).collect(Collectors.toList());
        List<Long> checkIdList = ((PhcPhysicalCheckV3221Mapper)this.dao).queryCheckIdByWandaSourceId(wandaSourceIdList);
        if (CollectionUtils.isEmpty(checkIdList)) {
            return Collections.emptyList();
        }
        List<PhcPhysicalStaffCheckInfo> staffCheckInfoList = ((PhcPhysicalCheckV3221Mapper)this.dao).queryStaffCheckInfoByCheckId(checkIdList);
        List<Long> staffCheckIdList = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getId).distinct().collect(Collectors.toList());
        List<String> allWandaSourceIdList = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).distinct().collect(Collectors.toList());
        HashMap<String, PhcPhysicalStaffCheckInfo> map = new HashMap<String, PhcPhysicalStaffCheckInfo>();
        for (PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo : staffCheckInfoList) {
            String key = phcPhysicalStaffCheckInfo.getCardId();
            if (map.containsKey(key) || !wandaSourceIdList.contains(key)) continue;
            phcPhysicalStaffCheckInfo.setCreateDate(new Date());
            map.put(key, phcPhysicalStaffCheckInfo);
        }
        ArrayList<PhcPhysicalStaffCheckInfo> delLog = new ArrayList<PhcPhysicalStaffCheckInfo>(map.values());
        this.logger.error("\u5220\u9664\u6570\u636e\u6253\u5370--->{}", delLog);
        if (CollectionUtils.isEmpty(delLog)) {
            return Collections.emptyList();
        }
        ((PhcPhysicalCheckV3221Mapper)this.dao).insertBatchLog(delLog);
        this.logger.error("\u91cd\u7f6e\u9519\u8bef\u4f53\u68c0\u6570\u636e\u6e90id--->{}", allWandaSourceIdList);
        ((PhcPhysicalCheckV3221Mapper)this.dao).resetWandaHealthCard(allWandaSourceIdList, (byte)0);
        ((PhcPhysicalCheckV3221Mapper)this.dao).delCheck(checkIdList);
        ((PhcPhysicalCheckV3221Mapper)this.dao).delStaffCheckInfo(staffCheckIdList);
        List idCardList = delLog.stream().map(PhcPhysicalStaffCheckInfo::getIdcardCode).distinct().collect(Collectors.toList());
        List<Long> cidList = delLog.stream().map(PhcPhysicalStaffCheckInfo::getCid).distinct().collect(Collectors.toList());
        List<String> creditCodeEmployerList = delLog.stream().map(PhcPhysicalStaffCheckInfo::getCreditCodeEmployer).distinct().collect(Collectors.toList());
        ArrayList<String> idCardEncs = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idCardList)) {
            for (String idCard : idCardList) {
                String encs = SpringEncryptUtils.encrypt((String)idCard);
                idCardEncs.add(encs);
            }
        }
        if (CollectionUtils.isNotEmpty(delStaff = ((PhcPhysicalCheckV3221Mapper)this.dao).queryNeedDelStaff(cidList, idCardEncs))) {
            List<Long> delStaffIdList = delStaff.stream().map(PhcPhysicalStaffCheckInfo::getId).distinct().collect(Collectors.toList());
            ((PhcPhysicalCheckV3221Mapper)this.dao).delStaffBasic(delStaffIdList);
            ((PhcPhysicalCheckV3221Mapper)this.dao).delStaffInfo(delStaffIdList);
        }
        ((PhcPhysicalCheckV3221Mapper)this.dao).delRisk(wandaSourceIdList, cidList);
        ((PhcPhysicalCheckV3221Mapper)this.dao).delRiskSource(wandaSourceIdList, cidList);
        this.logger.error("\u91cd\u7f6e\u9519\u8bef\u4f53\u68c0\u6570\u636e\u7ed3\u675f");
        if (CollectionUtils.isNotEmpty(creditCodeEmployerList)) {
            List<String> codeUpdateList = this.convertedData(creditCodeEmployerList, null, null);
            return codeUpdateList;
        }
        return Collections.emptyList();
    }

    @Transactional(readOnly=false)
    public void phcPhysicalCheckTask(String unifiedSocialCcs, Date endTime) {
        this.logger.error("\u8fdb\u5165service\u65b9\u6cd5");
        List<String> unifiedSocialCcList = null;
        if (StringUtils.isNotEmpty((String)unifiedSocialCcs)) {
            unifiedSocialCcList = Arrays.asList(unifiedSocialCcs.split(","));
        }
        Integer page = 1;
        Integer pageSize = 5;
        Integer currentPage = 1;
        int num = ((PhcPhysicalCheckV3221Mapper)this.dao).countNum(unifiedSocialCcList, page, pageSize);
        int pages = (int)Math.ceil((double)num * 1.0 / (double)pageSize.intValue());
        this.logger.error("\u5206\u9875\u67e5\u8be2\u7ed3\u679c\uff1a{}\u9875", (Object)pages);
        for (int i = 1; i <= pages; ++i) {
            this.logger.error("\u5f00\u59cb\u5faa\u73af\uff1a{}\u9875", (Object)i);
            TransactionStatus status = null;
            try {
                if (this.transactionManager != null) {
                    DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                    def.setPropagationBehavior(3);
                    status = this.transactionManager.getTransaction((TransactionDefinition)def);
                    this.logger.error("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                }
                this.logger.error("\u5f00\u59cb\u8f6c\u6362\u4e1a\u52a1");
                List<String> codeList = this.convertedData(unifiedSocialCcList, currentPage, pageSize);
                if (status != null) {
                    this.transactionManager.commit(status);
                    this.logger.error(i + "\u9875\u4e8b\u52a1\u63d0\u4ea4");
                }
                this.logger.error("\u8f6c\u6362\u5b8c\u6210");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                String join = StringUtils.join((Iterable)Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList()), (String)"\n");
                this.logger.error("\u4f53\u68c0\u8f6c\u6362\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)join);
                if (status != null) {
                    this.transactionManager.rollback(status);
                    this.logger.error(i + "\u9875\u4e8b\u52a1\u56de\u6eda");
                }
                currentPage = currentPage + 1;
            }
        }
    }

    public void phcPhysicalCheckResetTask(String unifiedSocialCcs, Date endTime) {
        String join;
        Object def;
        List codeList;
        TransactionStatus status;
        int i;
        List partition;
        List<String> unifiedSocialCcList = null;
        if (StringUtils.isNotEmpty((String)unifiedSocialCcs)) {
            unifiedSocialCcList = Arrays.asList(unifiedSocialCcs.split(","));
        }
        List<PhcPhysicalCheckV3221> resetRepeatedDataCreditCode = ((PhcPhysicalCheckV3221Mapper)this.dao).getResetRepeatedDataCreditCode(unifiedSocialCcList);
        List resetCodeList = resetRepeatedDataCreditCode.stream().filter(p -> ObjectUtil.isNotNull((Object)p.getCreditCode())).map(PhcPhysicalCheckV3221::getCreditCode).collect(Collectors.toList());
        ArrayList<String> resetCodeLists = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(resetCodeList)) {
            partition = Lists.partition(resetCodeList, (int)3);
            this.logger.error("\u91cd\u7f6e\u67e5\u8be2\u7ed3\u679c\uff1a{}\u9875", (Object)partition.size());
            for (i = 0; i < partition.size(); ++i) {
                status = null;
                codeList = (List)partition.get(i);
                try {
                    if (this.transactionManager != null) {
                        def = new DefaultTransactionDefinition();
                        def.setPropagationBehavior(3);
                        status = this.transactionManager.getTransaction((TransactionDefinition)def);
                        this.logger.error("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                    }
                    this.logger.error("\u5f00\u59cb\u6570\u636e\u91cd\u7f6e\u4e1a\u52a1");
                    List<String> list = this.resetRepeatedData(codeList);
                    if (CollectionUtils.isNotEmpty(list)) {
                        resetCodeLists.addAll(list);
                    }
                    if (status != null) {
                        this.transactionManager.commit(status);
                        this.logger.error(i + 1 + "\u9875\u6570\u636e\u91cd\u7f6e\u4e1a\u52a1\u4e8b\u52a1\u63d0\u4ea4");
                    }
                    this.logger.error("\u91cd\u7f6e\u5b8c\u6210");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    join = StringUtils.join((Iterable)Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList()), (String)"\n");
                    this.logger.error("\u91cd\u7f6e\u8f6c\u6362\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)join);
                    if (status == null) continue;
                    this.transactionManager.rollback(status);
                    this.logger.error(i + 1 + "\u9875\u91cd\u7f6e\u4e8b\u52a1\u56de\u6eda");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(resetCodeLists)) {
            partition = Lists.partition(resetCodeLists, (int)3);
            this.logger.error("\u5224\u65ad\u4f53\u68c0\u6570\u636e\u4e1a\u52a1\u4e8b\u52a1\uff1a{}\u9875", (Object)partition.size());
            for (i = 0; i < partition.size(); ++i) {
                status = null;
                codeList = (List)partition.get(i);
                try {
                    if (this.transactionManager != null) {
                        def = new DefaultTransactionDefinition();
                        def.setPropagationBehavior(3);
                        status = this.transactionManager.getTransaction((TransactionDefinition)def);
                        this.logger.error("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                    }
                    this.logger.error("\u5f00\u59cb\u5224\u65ad\u4f53\u68c0\u6570\u636e\u4e1a\u52a1\u4e8b\u52a1");
                    for (String code : codeList) {
                        this.fcythPatientBasicInfoService.convertData(code, Boolean.valueOf(true));
                    }
                    List companyList = this.companyService.getListByUnifiedSocialCc(codeList);
                    if (CollectionUtils.isNotEmpty((Collection)companyList)) {
                        List cidList = companyList.stream().map(Company::getId).distinct().collect(Collectors.toList());
                        this.reformItemBasicNewService.divideBatchGenKeyReform(cidList, ReformGenerationSourceEnum.TJ.getValue(), Integer.valueOf(2025), ReformDataSourceEnum.KEYFACTORY.getValue());
                        this.fcythPatientSuspectedApplyService.againJudgeFCCompany(cidList, Long.valueOf(1L), FcythChangeTypeEnum.EXIT_AFTER_UPDATE.getKey());
                    }
                    if (status != null) {
                        this.transactionManager.commit(status);
                        this.logger.error(i + 1 + "\u9875\u5224\u65ad\u4f53\u68c0\u6570\u636e\u4e1a\u52a1\u4e8b\u52a1\u63d0\u4ea4");
                    }
                    this.logger.error("\u5224\u65ad\u4f53\u68c0\u6570\u636e\u4e1a\u52a1\u4e8b\u52a1\u5b8c\u6210");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    join = StringUtils.join((Iterable)Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList()), (String)"\n");
                    this.logger.error("\u5224\u65ad\u4f53\u68c0\u6570\u636e\u4e1a\u52a1\u4e8b\u52a1\u8f6c\u6362\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)join);
                    if (status == null) continue;
                    this.transactionManager.rollback(status);
                    this.logger.error(i + 1 + "\u9875\u5224\u65ad\u4f53\u68c0\u6570\u636e\u4e1a\u52a1\u4e8b\u52a1\u56de\u6eda");
                }
            }
        }
    }

    public PhcPhysicalStatisticsModel getStatisticsModel(PhcPhysicalCheckSearchVo searchVo) {
        PhcPhysicalStatisticsModel statisticsModel;
        if (searchVo.getCid() == null && StringUtils.isEmpty((String)searchVo.getUnifiedSocialCc())) {
            return new PhcPhysicalStatisticsModel();
        }
        if (searchVo.getYear() == null) {
            searchVo.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
        }
        if (searchVo.getYear() == 0) {
            searchVo.setYear(null);
        }
        if ((statisticsModel = ((PhcPhysicalCheckV3221Mapper)this.dao).getStatisticsModel(searchVo)) == null) {
            return new PhcPhysicalStatisticsModel();
        }
        return statisticsModel;
    }

    public Map<Long, PhcPhysicalCheckV3221> getCheckMapByCid(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new HashMap<Long, PhcPhysicalCheckV3221>();
        }
        return ((PhcPhysicalCheckV3221Mapper)this.dao).getCheckMapByCid(cidList);
    }

    public int getHcCheckNumByByAreaAndYear(Long areaId, Byte areaLevel, Integer year, Byte finalOwnLevel) {
        Date today = new Date();
        Date nextDate = DateUtil.getNextDate((Date)today, (int)-365);
        return ((PhcPhysicalCheckV3221Mapper)this.dao).getHcCheckNumByByAreaAndYear(areaId, areaLevel, year, finalOwnLevel, DateUtil.format((Date)nextDate, (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.format((Date)today, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public Map<Long, PhyPhcCheckCompanyInfo> getPhyPhcCompanyInfo(Long cid) {
        HashMap<Long, PhyPhcCheckCompanyInfo> resultMap = new HashMap<Long, PhyPhcCheckCompanyInfo>();
        List<CidYear> cidYears = ((PhcPhysicalCheckV3221Mapper)this.dao).getMaxCheckYear(cid);
        if (CollectionUtils.isEmpty(cidYears)) {
            return new HashMap<Long, PhyPhcCheckCompanyInfo>();
        }
        HashMap<Long, Integer> cidYearMap = new HashMap<Long, Integer>();
        for (CidYear cidYear : cidYears) {
            cidYearMap.put(cidYear.getCid(), cidYear.getYear());
        }
        List<PhcPhysicalCheckV3221> list = ((PhcPhysicalCheckV3221Mapper)this.dao).getCheckTimeByCids(cidYearMap.keySet());
        Map<Long, List<PhcPhysicalCheckV3221>> CheckTimeMap = list.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCid));
        for (Long cidKey : CheckTimeMap.keySet()) {
            PhyPhcCheckCompanyInfo info = new PhyPhcCheckCompanyInfo();
            List<PhcPhysicalCheckV3221> itemList = CheckTimeMap.get(cidKey);
            if (CollectionUtils.isEmpty(itemList)) continue;
            Date date = itemList.stream().max(Comparator.comparing(PhcPhysicalCheckV3221::getCheckTime)).get().getCheckTime();
            Date beginTime = itemList.stream().min(Comparator.comparing(PhcPhysicalCheckV3221::getCheckTime)).get().getCheckTime();
            info.setBeginTime(beginTime);
            info.setEndTime(date);
            resultMap.put(cidKey, info);
        }
        ArrayList<Long> cidList = new ArrayList<Long>(cidYearMap.keySet());
        ArrayList<PhcPhysicalStaffCheckInfo> staffInfoList = new ArrayList<PhcPhysicalStaffCheckInfo>();
        List<List<Long>> lists = this.subList(cidList);
        for (List list2 : lists) {
            staffInfoList.addAll(this.phcPhysicalStaffCheckInfoMapper.getStaffInfoByCids(list2));
        }
        if (CollectionUtils.isEmpty(staffInfoList)) {
            return resultMap;
        }
        Map<Long, List<PhcPhysicalStaffCheckInfo>> staffMap = staffInfoList.stream().collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCid));
        for (Long cidKey : resultMap.keySet()) {
            List<PhcPhysicalStaffCheckInfo> phcPhysicalStaffCheckInfos = staffMap.get(cidKey);
            int num = 0;
            if (CollectionUtils.isNotEmpty(phcPhysicalStaffCheckInfos)) {
                Integer year = (Integer)cidYearMap.get(cidKey);
                num = phcPhysicalStaffCheckInfos.stream().filter(item -> DateUtils.getYear((Date)item.getCheckTime()) == year).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PhcPhysicalStaffCheckInfo>(Comparator.comparing(PhcPhysicalStaffCheckInfo::getIdcardCode))), ArrayList::new)).size();
            }
            PhyPhcCheckCompanyInfo info = (PhyPhcCheckCompanyInfo)resultMap.get(cidKey);
            info.setNum(num);
            resultMap.put(cidKey, info);
        }
        return resultMap;
    }

    @Transactional(readOnly=false)
    public CheckDetailInfo saveInfo(CheckDetailInfo checkDetail) {
        PhcPhysicalCheckV3221 checkV3221 = this.oldCheck2CheckV3221(checkDetail);
        checkV3221 = this.saveOrUpdate(checkV3221);
        return this.v3221Check2OldCheck(checkV3221);
    }

    @Transactional(readOnly=false)
    public void saveResult(CheckDataResultInfo resultInfo) {
        PhcPhysicalStaffCheckInfo staffCheckInfo = new PhcPhysicalStaffCheckInfo();
        if (resultInfo.getDataId() != null) {
            staffCheckInfo = this.phcPhysicalStaffCheckInfoService.getByCardIdWhereSource2(resultInfo.getDataId());
        }
        PhcPhysicalCheckV3221 checkV3221 = this.getBySourceId(resultInfo.getCheckId());
        staffCheckInfo.setCheckTime(checkV3221.getCheckTime());
        staffCheckInfo.setSourceId(checkV3221.getId());
        staffCheckInfo.setCardId("" + resultInfo.getDataId());
        Company company = this.phcPhysicalStaffCheckInfoMapper.selectCompanyInfoByCid(checkV3221.getCid());
        if (company != null) {
            String ucc = company.getUnifiedSocialCc();
            staffCheckInfo.setCreditCode(ucc);
        }
        this.convert2V3221(resultInfo, staffCheckInfo, checkV3221);
        if (staffCheckInfo.getId() != null) {
            this.phcPhysicalStaffCheckInfoService.update((Object)staffCheckInfo);
        } else {
            this.phcPhysicalStaffCheckInfoService.add((Object)staffCheckInfo);
        }
    }

    public PageInfo<CheckListInfo> thirdOrgPage(JqGridParam jparam, PageCheckListParam param) {
        if (jparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<CheckListInfo> infoList = ((PhcPhysicalCheckV3221Mapper)this.dao).thirdOrgPage(param);
        for (CheckListInfo checkListInfo : infoList) {
            if (!StringUtils.isNotEmpty((String)checkListInfo.getEmployerIds())) continue;
            List<CompanySuperviseModel> companys = this.getCompanys(checkListInfo.getEmployerIds());
            checkListInfo.setEmployers(companys);
        }
        return new PageInfo(infoList);
    }

    private PhcPhysicalCheckV3221 saveOrUpdate(PhcPhysicalCheckV3221 checkV3221) {
        if (checkV3221.getId() == null) {
            return this.add(checkV3221);
        }
        this.update(checkV3221);
        return checkV3221;
    }

    private CheckDetailInfo v3221Check2OldCheck(PhcPhysicalCheckV3221 checkV3221) {
        String[] split;
        CheckDetailInfo checkDetailInfo = new CheckDetailInfo();
        checkDetailInfo.setId(checkV3221.getId());
        String employerId = checkV3221.getEmployerId();
        checkDetailInfo.setEmployers(this.getCompanys(employerId));
        checkDetailInfo.setCompanyType(Byte.valueOf((byte)2));
        checkDetailInfo.setHospital(Long.valueOf(Long.parseLong(checkV3221.getOrgCode())));
        ThirdOrganization org = (ThirdOrganization)this.thirdOrganizationService.getById(Long.valueOf(Long.parseLong(checkV3221.getOrgCode())));
        checkDetailInfo.setHospitalName(org == null ? null : org.getName());
        checkDetailInfo.setCid(checkV3221.getCid());
        checkDetailInfo.setCompanyName(checkV3221.getEmployerName());
        checkDetailInfo.setIsRecheck(checkV3221.getIsRecheck());
        checkDetailInfo.setCheckBeginTime(checkV3221.getCheckTime());
        checkDetailInfo.setCheckEndTime(checkV3221.getEndTime());
        checkDetailInfo.setCheckAddress(checkV3221.getCheckAddress());
        checkDetailInfo.setCreateBy(checkV3221.getCreateBy());
        CheckTypeCount checkTypeCount = new CheckTypeCount();
        checkTypeCount.setNeedChecks(checkV3221.getNumberOfShouldCheck());
        checkTypeCount.setCheckType(checkV3221.getBodyCheckType().toString());
        checkTypeCount.setCheckProjects(checkV3221.getCheckName());
        String reportFileId = checkV3221.getReportFileId();
        if (StringUtil.isNotEmpty((CharSequence)reportFileId) && (split = reportFileId.split(",")).length > 0) {
            checkTypeCount.setReportIds(split);
            List fileList = this.sysFileService.getListByIds(checkV3221.getReportFileId());
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                List checkFileInfoList = fileList.stream().map(file -> {
                    CheckFileInfo checkFile = new CheckFileInfo();
                    checkFile.setCid(checkV3221.getCid());
                    checkFile.setFileName(file.getFileName());
                    checkFile.setFileUrl(file.getOssUrl());
                    checkFile.setOssUrl(file.getOssUrl());
                    return checkFile;
                }).collect(Collectors.toList());
                checkTypeCount.setReportFiles(checkFileInfoList);
            }
        }
        checkDetailInfo.setCheckTypeCount(checkTypeCount);
        ArrayList<CheckTypeCount> checkTypeCounts = new ArrayList<CheckTypeCount>();
        checkTypeCounts.add(checkTypeCount);
        checkDetailInfo.setCheckTypeCounts(checkTypeCounts);
        return checkDetailInfo;
    }

    private List<CompanySuperviseModel> getCompanys(String idStr) {
        List ids = cn.smarthse.common.util.StringUtils.parseToLongList((String)idStr);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Collections.emptyList();
        }
        List companys = this.companyProvideBySuperviseService.getOnlyCompanyByCid(ids);
        return companys.stream().map(c -> {
            CompanySuperviseModel model = new CompanySuperviseModel();
            BeanUtils.copyBeanProp((Object)model, (Object)c);
            return model;
        }).collect(Collectors.toList());
    }

    private PhcPhysicalCheckV3221 oldCheck2CheckV3221(CheckDetailInfo checkDetail) {
        PhcPhysicalCheckV3221 checkV3221 = new PhcPhysicalCheckV3221();
        if (checkDetail.getId() != null) {
            checkV3221 = this.getBySourceId(checkDetail.getId());
            if (Objects.nonNull(checkV3221)) {
                List items = this.phcPhysicalStaffCheckInfoService.getListByCardId("" + checkV3221.getId());
                Set idset = items.stream().map(PhcPhysicalStaffCheckInfo::getActualEmployerId).collect(Collectors.toSet());
                String join = org.apache.commons.lang3.StringUtils.join(idset, (String)",");
                checkV3221.setEmployerId(join);
            } else {
                checkV3221 = new PhcPhysicalCheckV3221();
            }
        }
        checkV3221.setStatus(Byte.valueOf((byte)0));
        checkV3221.setCreditCode(checkDetail.getUnifiedSocialCc());
        checkV3221.setSourceId(checkDetail.getId());
        checkV3221.setCid(checkDetail.getCid());
        checkV3221.setEmployerName(checkDetail.getCompanyName());
        checkV3221.setDataSource(PhyPhcCheckDataSourceEnum.ORG.getCode());
        checkV3221.setOrgCode(checkDetail.getHospital().toString());
        ThirdOrganization org = (ThirdOrganization)this.thirdOrganizationService.getById(checkDetail.getHospital());
        checkDetail.setHospitalName(org == null ? null : org.getName());
        checkV3221.setOrgName(checkDetail.getHospitalName());
        checkV3221.setIsRecheck(checkDetail.getIsRecheck());
        checkV3221.setCheckTime(checkDetail.getCheckBeginTime());
        checkV3221.setEndTime(checkDetail.getCheckEndTime());
        checkV3221.setCheckYear(Integer.valueOf(DateUtils.getYear((Date)checkDetail.getCheckBeginTime())));
        checkV3221.setCheckAddress(checkDetail.getCheckAddress());
        checkV3221.setCheckName(checkDetail.getCheckTypeCount().getCheckProjects());
        checkV3221.setNumberOfShouldCheck(checkDetail.getCheckTypeCount().getNeedChecks());
        checkV3221.setBodyCheckType(Integer.valueOf(Integer.parseInt(checkDetail.getCheckTypeCount().getCheckType())));
        String fileIds = StringUtils.join((Object[])checkDetail.getCheckTypeCount().getReportIds(), (String)",");
        checkV3221.setReportFileId(fileIds);
        checkV3221.setCreateBy(checkDetail.getCreateBy());
        if (checkDetail.getReportSate() == 1 && checkDetail.getStatus() == 1) {
            this.logger.error("\u8fdb\u5165\u4e0a\u62a5");
            checkV3221.setStatus(Byte.valueOf((byte)1));
            List checkTypeCounts = checkDetail.getCheckTypeCounts();
            Integer numberOfYszyb = 0;
            Integer numberOfYsjjz = 0;
            Integer numberOfReexamination = 0;
            Integer numberOfMan = 0;
            Integer numberOfWoman = 0;
            Integer numberOfCheck = 0;
            for (CheckTypeCount count : checkTypeCounts) {
                numberOfWoman = numberOfWoman + count.getWomen();
                numberOfMan = numberOfMan + count.getMen();
                numberOfYsjjz = numberOfYsjjz + count.getOc();
                numberOfYszyb = numberOfYszyb + count.getSd();
                numberOfReexamination = numberOfReexamination + count.getRecheck();
                numberOfCheck = numberOfCheck + count.getChecks();
            }
            checkV3221.setNumberOfWoman(numberOfWoman);
            checkV3221.setNumberOfMan(numberOfMan);
            checkV3221.setNumberOfYszyb(numberOfYszyb);
            checkV3221.setNumberOfYsjjz(numberOfYsjjz);
            checkV3221.setNumberOfXfc(numberOfReexamination);
            checkV3221.setNumberOfCheck(numberOfCheck);
            checkV3221.setLoadTime(new Date());
        }
        return checkV3221;
    }

    private PhcPhysicalCheckV3221 getBySourceId(Long id) {
        Example example = new Example(PhcPhysicalCheckV3221.class);
        example.createCriteria().andEqualTo("sourceId", (Object)id).andEqualTo("isValid", (Object)true);
        return (PhcPhysicalCheckV3221)this.getOneByExample(example);
    }

    public CheckDetailInfo getCheckDetailById(Long id) {
        PhcPhysicalCheckV3221 byId = (PhcPhysicalCheckV3221)this.getById(id);
        return this.v3221Check2OldCheck(byId);
    }

    private List<List<Long>> subList(List<Long> cidList) {
        int length = 1000;
        int size = cidList.size();
        int temp = size / length + 1;
        boolean result = size % length == 0;
        ArrayList<List<Long>> subList = new ArrayList<List<Long>>();
        for (int i = 0; i < temp; ++i) {
            if (i == temp - 1) {
                if (result) break;
                subList.add(cidList.subList(length * i, size));
                continue;
            }
            subList.add(cidList.subList(length * i, length * (i + 1)));
        }
        return subList;
    }

    public List<PhcPhysicalCheckV3221> lastUpdatePhcCheck(Date updateDate) {
        if (updateDate == null) {
            updateDate = DateUtils.getStartTime((Date)DateUtils.addDay((Date)new Date(), (int)-1));
        }
        return ((PhcPhysicalCheckV3221Mapper)this.dao).lastUpdatePhcCheck(updateDate);
    }

    @Transactional(readOnly=false)
    public void deleteByCardIds(String sourceIds) {
        List idArray = cn.smarthse.common.util.StringUtils.parseToStringList((String)sourceIds, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        ArrayList<String> idCardEncs = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty((Collection)idArray)) {
            for (String idCard : idArray) {
                String encs = SpringEncryptUtils.encrypt((String)idCard);
                idCardEncs.add(encs);
            }
        }
        ((PhcPhysicalCheckV3221Mapper)this.dao).deleteByCardIds(idCardEncs);
    }

    @Transactional(readOnly=false)
    public void insertCheckDataBatch(List<CheckDataResultInfo> checkDataBatch) {
        List collect = checkDataBatch.stream().map(resultInfo -> {
            PhcPhysicalStaffCheckInfo newCheck = this.getPhcPhysicalStaffCheckInfo((CheckDataResultInfo)resultInfo);
            newCheck.setId(Long.valueOf(this.idworker.nextId()));
            newCheck.setCreateDate(new Date());
            newCheck.setUpdateDate(new Date());
            newCheck.setIsValid(Boolean.valueOf(true));
            return newCheck;
        }).collect(Collectors.toList());
        this.phcPhysicalStaffCheckInfoService.batchUpdateOrInsert(collect, PhcPhysicalStaffCheckInfoMapper.class, (item, mapper) -> mapper.insert(item));
    }

    public List<PhcPhysicalStaffCheckInfo> getPhcPhysicaStaffCheckInfoV3221(Long id) {
        Example example = new Example(PhcPhysicalStaffCheckInfo.class);
        example.createCriteria().andEqualTo("sourceId", (Object)id).andIn("conclusion", Arrays.asList("3", "4")).andEqualTo("isValid", (Object)true);
        return this.phcPhysicalStaffCheckInfoMapper.selectByExample(example);
    }

    public Long getCountBySearchVo(PhcPhysicalCheckSearchVo searchVo) {
        if (searchVo.getCid() == null && StringUtils.isEmpty((String)searchVo.getUnifiedSocialCc())) {
            return null;
        }
        Long count = ((PhcPhysicalCheckV3221Mapper)this.dao).getCountBySearchVo(searchVo);
        return Optional.of(count).orElse(null);
    }

    public Integer[] checkStaffNum(Long cid) {
        CheckNumInfo info = ((PhcPhysicalCheckV3221Mapper)this.dao).getCheckNumGorupByBodyType(cid);
        if (Objects.isNull(info)) {
            info = new CheckNumInfo();
        }
        Integer[] arr = new Integer[]{info.getBeforeWorkNum(), info.getOnWorkNum(), info.getLeaveWorkNum()};
        return arr;
    }

    public List<PhcPhysicalCheckV3221> getOnWorkListByCid(Long cid) {
        return ((PhcPhysicalCheckV3221Mapper)this.dao).getOnWorkListByCid(cid);
    }

    public Map<Long, String> getLastCheckOrgName(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyMap();
        }
        List<PhcPhysicalStaffCheckInfo> list = ((PhcPhysicalCheckV3221Mapper)this.dao).getLastCheckOrgName(cids);
        return list.stream().collect(Collectors.toMap(PhcPhysicalStaffCheckInfo::getCid, PhcPhysicalStaffCheckInfo::getOrgName));
    }

    public List<PhcPhysicalStatisticsModel> queryCompliancePhysical5Data(List<Long> cids, Integer year) {
        return ((PhcPhysicalCheckV3221Mapper)this.dao).queryCompliancePhysical5Data(cids, year);
    }

    @Transactional
    public void staticsCompanyAppendInfo() {
        ((PhcPhysicalCheckV3221Mapper)this.dao).deleteCompanyAppendInfo();
        ((PhcPhysicalCheckV3221Mapper)this.dao).insertBatchCompanyAppendInfo();
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void resetConverted(Integer batchSize) {
        List<Long> toUpdateIds = ((PhcPhysicalCheckV3221Mapper)this.dao).selectAllConvertedCards();
        if (toUpdateIds.isEmpty()) {
            XxlJobHelper.log((String)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e", (Object[])new Object[0]);
            return;
        }
        int total = 0;
        for (int i = 0; i < toUpdateIds.size(); i += batchSize.intValue()) {
            List<Long> batch = toUpdateIds.subList(i, Math.min(i + batchSize, toUpdateIds.size()));
            try {
                this.updateBatch(batch);
                total += batch.size();
                this.logger.debug("\u7b2c {} \u6279\u6210\u529f\u66f4\u65b0 {} \u6761", (Object)(i / batchSize + 1), (Object)batch.size());
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u7b2c {} \u6279\u66f4\u65b0\u5931\u8d25\uff1a{}", new Object[]{i / batchSize + 1, e.getMessage(), e});
            }
        }
        XxlJobHelper.log((String)"\u4efb\u52a1\u5b8c\u6210\uff0c\u603b\u8ba1\u66f4\u65b0 {} \u6761\u8bb0\u5f55", (Object[])new Object[]{total});
    }

    public void updateCheckNum(Long cid, Integer year, Integer size) {
        List<Long> checkIdList;
        if (size == null || size <= 0) {
            size = 1000;
        }
        long total = 0L;
        int batchNo = 0;
        do {
            PageHelper.startPage((int)(++batchNo), (int)size, (boolean)false);
            checkIdList = ((PhcPhysicalCheckV3221Mapper)this.dao).needUpdateCheckId(cid, year, size);
            this.logger.error("\u672c\u6b21\u66f4\u65b0\u7684checkId: {}", checkIdList);
            if (checkIdList == null || checkIdList.isEmpty()) {
                XxlJobHelper.log((String)"\u672a\u67e5\u8be2\u5230\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\uff0c\u9000\u51fa\u5faa\u73af", (Object[])new Object[0]);
                break;
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
            try {
                int updateNum = ((PhcPhysicalCheckV3221Mapper)this.dao).updateCheckNum(checkIdList);
                this.transactionManager.commit(status);
                XxlJobHelper.log((String)"\u7b2c {} \u6279\u63d0\u4ea4\u6210\u529f\uff0c\u672c\u6279\u66f4\u65b0 {} \u6761\uff0c\u603b\u8ba1 {} \u6761", (Object[])new Object[]{batchNo, updateNum, total += (long)updateNum});
            }
            catch (Exception e) {
                e.printStackTrace();
                XxlJobHelper.log((String)"\u7b2c {} \u6279\u63d0\u4ea4\u5931\u8d25\uff0c\u6570\u91cf\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", (Object[])new Object[]{batchNo, checkIdList.size(), e.getMessage()});
                this.transactionManager.rollback(status);
            }
        } while (checkIdList.size() == size.intValue());
        XxlJobHelper.log((String)"\u4efb\u52a1\u5b8c\u6210\uff0c\u603b\u8ba1\u66f4\u65b0 {} \u6761\u8bb0\u5f55\uff0c\u5171\u5904\u7406 {} \u6279", (Object[])new Object[]{total, batchNo});
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void updateBatch(List<Long> batch) {
        ((PhcPhysicalCheckV3221Mapper)this.dao).updateIsConvertedBatch(batch);
    }

    private PhcPhysicalStaffCheckInfo getPhcPhysicalStaffCheckInfo(CheckDataResultInfo resultInfo) {
        PhcPhysicalStaffCheckInfo staffCheckInfo = new PhcPhysicalStaffCheckInfo();
        if (resultInfo.getDataId() != null) {
            staffCheckInfo = this.phcPhysicalStaffCheckInfoService.getByCardIdWhereSource2(resultInfo.getDataId());
        }
        PhcPhysicalCheckV3221 checkV3221 = this.getBySourceId(resultInfo.getCheckId());
        staffCheckInfo.setCheckTime(checkV3221.getCheckTime());
        staffCheckInfo.setSourceId(checkV3221.getId());
        staffCheckInfo.setCardId("" + resultInfo.getDataId());
        Company company = this.phcPhysicalStaffCheckInfoMapper.selectCompanyInfoByCid(checkV3221.getCid());
        if (company != null) {
            String ucc = company.getUnifiedSocialCc();
            staffCheckInfo.setCreditCode(ucc);
        }
        this.convert2V3221(resultInfo, staffCheckInfo, checkV3221);
        return staffCheckInfo;
    }

    private void convert2V3221(CheckDataResultInfo resultInfo, PhcPhysicalStaffCheckInfo staffCheckInfo, PhcPhysicalCheckV3221 checkV3221) {
        staffCheckInfo.setCid(resultInfo.getCid());
        staffCheckInfo.setCreditCodeEmployer(resultInfo.getUnifiedSocialCc());
        staffCheckInfo.setName(resultInfo.getStaffName());
        staffCheckInfo.setHazardYear(resultInfo.getHarmYear().replace("\u5e74", ""));
        staffCheckInfo.setHazardMonth(resultInfo.getHarmMonth().replace("\u6708", ""));
        staffCheckInfo.setIdcardCode(resultInfo.getIdCard());
        staffCheckInfo.setContactHazardCode(resultInfo.getHarmIds());
        staffCheckInfo.setCheckResultCode(ExamResultEnum.getName((String)resultInfo.getRessult()));
        staffCheckInfo.setActualEmployerId(resultInfo.getCid());
        staffCheckInfo.setActualEmployerName(resultInfo.getCompanyName());
        staffCheckInfo.setAdvice(resultInfo.getMedicalAdvice());
        staffCheckInfo.setHandlingOpinions(resultInfo.getCheckAdvice());
        staffCheckInfo.setAnomalyItems(resultInfo.getAbnormal());
        staffCheckInfo.setConclusion(resultInfo.getRessult());
        staffCheckInfo.setOtherJobName(resultInfo.getWorkName());
        staffCheckInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)resultInfo.getIdCard())));
        staffCheckInfo.setSexCode("" + (IDCardUtil.getGender((String)resultInfo.getIdCard()) == 1 ? 1 : 2));
        staffCheckInfo.setCheckTime(checkV3221.getCheckTime());
        staffCheckInfo.setBodyCheckType(checkV3221.getBodyCheckType().toString());
        staffCheckInfo.setSuggest(resultInfo.getMedicalAdvice());
        if (staffCheckInfo.getConclusion().equalsIgnoreCase(PhyPhcCheckConclusionEnum.YSZYB.getCode().toString())) {
            staffCheckInfo.setSptId(String.valueOf(resultInfo.getHarmDescId()));
        }
        if (staffCheckInfo.getConclusion().equalsIgnoreCase(PhyPhcCheckConclusionEnum.ZYJJZ.getCode().toString())) {
            staffCheckInfo.setCotId(resultInfo.getOccHarmIds());
        }
    }

    public List<PhcPhysicalCheckV3221> getAllPhcCheckInfoByCids(ReformSearchVo reformSearchVo) {
        if (CollectionUtils.isEmpty((Collection)reformSearchVo.getCidList())) {
            return Collections.emptyList();
        }
        return ((PhcPhysicalCheckV3221Mapper)this.dao).selectAllPhcCheckInfoByCids(reformSearchVo);
    }

    public List<PhcPhysicalStaffCheckInfo> getLatestCheckData(List<Long> cidList, int year) {
        return ((PhcPhysicalCheckV3221Mapper)this.dao).getLatestCheckData(cidList, year);
    }
}

