/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check.checkV3221;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.checkV3221.PhcPhysicalCheckV3221OrgMapper;
import cn.smarthse.modules.health.entity.base.disease.Disease;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckProjectVo;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckConclusionEnum;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.model.phyphcCheck.AddCheckStaffModel;
import cn.smarthse.modules.health.model.phyphcCheck.CheckDetailModel;
import cn.smarthse.modules.health.model.phyphcCheck.CheckProjectModel;
import cn.smarthse.modules.health.model.phyphcCheck.CheckSubmitModel;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221OrgService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class PhcPhysicalCheckV3221OrgServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckV3221OrgMapper, PhcPhysicalCheckV3221>
implements IPhcPhysicalCheckV3221OrgService {
    private final IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideService;
    private final IStaffInfoService staffInfoService;
    private final IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IDiseaseThirdService diseaseThirdService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    private static Map<Long, String> factorMap;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;

    public Map<Long, String> getFactorMap() {
        if (MapUtils.isEmpty(factorMap)) {
            HarmFactor harm = new HarmFactor();
            List harmFactorList = this.harmFactorService.getByHarm(harm);
            factorMap = harmFactorList.stream().collect(Collectors.toMap(HarmFactor::getId, HarmFactor::getNameCh, (o1, o2) -> o1));
        }
        return factorMap;
    }

    @Transactional
    public CheckDetailModel submit(CheckSubmitModel model, Long operatorId) {
        PhcPhysicalCheckV3221 checkV3221 = new PhcPhysicalCheckV3221();
        checkV3221.setId(model.getCheckId());
        checkV3221.setCheckYear(Integer.valueOf(DateUtils.getYear((Date)model.getCheckDateBegin())));
        checkV3221.setCheckTime(model.getCheckDateBegin());
        checkV3221.setEndTime(model.getCheckDateEnd());
        checkV3221.setBodyCheckType(model.getBodyCheckType());
        checkV3221.setOrgCode(model.getOrgId().toString());
        checkV3221.setOrgName(model.getOrgName());
        checkV3221.setNumberOfShouldCheck(model.getNumberOfShouldCheck());
        checkV3221.setCreditCode(model.getActualEmployerCreditCode());
        checkV3221.setCid(model.getActualEmployerId());
        checkV3221.setIsRecheck(model.getIsRecheck());
        checkV3221.setDataSource(Byte.valueOf((byte)2));
        checkV3221.setCheckName(model.getCheckWorkName());
        checkV3221.setCheckAddress(model.getCheckAddress());
        if (model.getCheckReportFileId() != null) {
            checkV3221.setReportFileId(model.getCheckReportFileId().toString());
        }
        checkV3221.setEntrustEmployerId(model.getEntrustEmployerId());
        checkV3221.setCheckItems(model.getCheckItems());
        checkV3221.setUpdateDate(new Date());
        checkV3221.setUpdateBy(operatorId);
        if (model.getCheckId() != null) {
            List staffList = this.phcPhysicalStaffCheckInfoService.getBySourceId(model.getCheckId());
            if (CollectionUtils.isNotEmpty((Collection)staffList)) {
                int numberOfYszyb = (int)staffList.stream().filter(checkInfo -> "3".equalsIgnoreCase(checkInfo.getConclusion())).map(item -> item.getIdcardCode() + item.getName()).count();
                int numberOfYsjjz = (int)staffList.stream().filter(checkInfo -> "4".equalsIgnoreCase(checkInfo.getConclusion())).map(item -> item.getIdcardCode() + item.getName()).count();
                int numberOfFc = (int)staffList.stream().filter(checkInfo -> "2".equalsIgnoreCase(checkInfo.getConclusion())).map(item -> item.getIdcardCode() + item.getName()).count();
                int numberOfMan = (int)staffList.stream().filter(checkInfo -> "\u7537".equals(checkInfo.getSexCode())).map(item -> item.getIdcardCode() + item.getName()).count();
                int numberOfWoman = (int)staffList.stream().filter(checkInfo -> "\u5973".equals(checkInfo.getSexCode())).map(item -> item.getIdcardCode() + item.getName()).count();
                int numberOfCheck = (int)staffList.stream().map(PhcPhysicalStaffCheckInfo::getIdcardCode).distinct().count();
                checkV3221.setNumberOfYszyb(Integer.valueOf(numberOfYszyb));
                checkV3221.setNumberOfYsjjz(Integer.valueOf(numberOfYsjjz));
                checkV3221.setNumberOfXfc(Integer.valueOf(numberOfFc));
                checkV3221.setNumberOfMan(Integer.valueOf(numberOfMan));
                checkV3221.setNumberOfWoman(Integer.valueOf(numberOfWoman));
                checkV3221.setNumberOfCheck(Integer.valueOf(numberOfCheck));
            }
        } else {
            checkV3221.setCreateDate(new Date());
            checkV3221.setCreateBy(operatorId);
            checkV3221.setId(Long.valueOf(this.idworker.nextId()));
        }
        byte status = 0;
        ArrayList<String> idCardList = new ArrayList<String>();
        if (model.getIsSubmit().booleanValue()) {
            status = 1;
            checkV3221.setLoadTime(new Date());
            List<AddCheckStaffModel> modelList = this.checkStaffList(model.getCheckId(), null, null);
            List idcardList = modelList.stream().map(AddCheckStaffModel::getIdCardCode).distinct().collect(Collectors.toList());
            List staffInfoList = this.staffInfoService.getByIdcardList(checkV3221.getCid(), idcardList);
            Map dbStaffMap = staffInfoList.stream().peek(m -> m.setIdCard(m.getIdCard().toUpperCase())).collect(Collectors.toMap(StaffInfo::getIdCard, Function.identity(), (m1, m2) -> m1));
            idCardList.addAll(dbStaffMap.keySet());
            List<AddCheckStaffModel> addCheckStaffModelList = modelList.stream().filter(m -> !dbStaffMap.containsKey(m.getIdCardCode().toUpperCase())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(addCheckStaffModelList)) {
                List<StaffInfo> insertList = this.computedInsertStaffList(addCheckStaffModelList, checkV3221.getCid(), checkV3221.getBodyCheckType());
                this.staffInfoService.addOrgCheckStaffInfo(insertList, operatorId);
            }
        }
        checkV3221.setStatus(Byte.valueOf(status));
        ((PhcPhysicalCheckV3221OrgMapper)this.dao).saveCheckV3221OrUpdate(checkV3221);
        ((PhcPhysicalCheckV3221OrgMapper)this.dao).updateCheckStaffBaseInfoBySourceId(checkV3221);
        if (model.getIsSubmit().booleanValue() && CollectionUtils.isNotEmpty(idCardList)) {
            Long cid = checkV3221.getCid();
            ArrayList<StaffFieldChangeLog> staffFieldChangeLogList = new ArrayList<StaffFieldChangeLog>();
            List staffShowInfos = this.staffInfoService.getStaffInfoByCardIdList(cid, idCardList, model.getCheckId());
            ArrayList<StaffWorkRole> staffWorkRoleList = new ArrayList<StaffWorkRole>();
            if (CollectionUtils.isNotEmpty((Collection)staffShowInfos)) {
                for (StaffShowInfo showInfo : staffShowInfos) {
                    Long sourceId = showInfo.getContractInformId();
                    Date earliestCheckTime = showInfo.getEarliestCheckTime();
                    Byte workStatus = showInfo.getWorkStatus();
                    String bodyCheckType = showInfo.getRadiationTypeName();
                    Date currentWorkBeginTime = showInfo.getCurrentWorkBeginTime();
                    Date currentWorkLeaveTime = showInfo.getCurrentWorkLeaveTime();
                    if (!ObjectUtil.isNotNull((Object)sourceId) || !StringUtils.isNotEmpty((String)bodyCheckType) || !ObjectUtil.isNotNull((Object)earliestCheckTime) || !ObjectUtil.isNotNull((Object)model.getCheckId()) || !sourceId.equals(model.getCheckId()) || !ObjectUtil.isNotNull((Object)workStatus)) continue;
                    StaffWorkRole staffWorkRole = new StaffWorkRole();
                    StaffFieldChangeLog log = new StaffFieldChangeLog();
                    log.setStaffId(showInfo.getId());
                    log.setCid(cid);
                    log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
                    if (workStatus == 1 && "3".contains(bodyCheckType) && (ObjectUtil.isNull((Object)currentWorkBeginTime) || currentWorkBeginTime.before(earliestCheckTime))) {
                        staffWorkRole.setId(showInfo.getWorkRoleId());
                        staffWorkRole.setStatus(Byte.valueOf((byte)2));
                        staffWorkRole.setLeaveTime(earliestCheckTime);
                        staffWorkRole.setUpdateBy(operatorId);
                        staffWorkRoleList.add(staffWorkRole);
                        log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)1));
                        log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)2));
                        log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                        staffFieldChangeLogList.add(log);
                        continue;
                    }
                    if (workStatus != 2 || !"1,2".contains(bodyCheckType) || !ObjectUtil.isNull((Object)currentWorkLeaveTime) && !currentWorkLeaveTime.before(earliestCheckTime)) continue;
                    staffWorkRole.setId(showInfo.getWorkRoleId());
                    staffWorkRole.setStatus(Byte.valueOf((byte)1));
                    staffWorkRole.setUpdateBy(operatorId);
                    staffWorkRoleList.add(staffWorkRole);
                    log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)2));
                    log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)1));
                    log.setChangeReason("\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
                    staffFieldChangeLogList.add(log);
                }
            }
            if (CollectionUtils.isNotEmpty(staffFieldChangeLogList)) {
                this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, operatorId);
            }
            if (CollectionUtils.isNotEmpty(staffWorkRoleList)) {
                this.staffWorkRoleService.updateStaffWorkRoleStatus(staffWorkRoleList);
            }
        }
        return this.info(checkV3221.getId());
    }

    private List<StaffInfo> computedInsertStaffList(List<AddCheckStaffModel> addCheckStaffModelList, Long cid, Integer bodyCheckType) {
        HashMap<String, StaffInfo> map = new HashMap<String, StaffInfo>();
        for (AddCheckStaffModel m : addCheckStaffModelList) {
            if (map.containsKey(m.getIdCardCode())) continue;
            Long staffId = this.idworker.nextId();
            Long staffBasicId = this.idworker.nextId();
            Long sbwId = this.idworker.nextId();
            Long swrId = this.idworker.nextId();
            StaffInfo staffInfo = new StaffInfo();
            StaffBasicInfo sbi = new StaffBasicInfo();
            StaffBasicWork sbw = new StaffBasicWork();
            StaffWorkRole swr = new StaffWorkRole();
            sbi.setId(staffBasicId);
            sbi.setCid(cid);
            staffInfo.setId(staffId);
            staffInfo.setCid(cid);
            staffInfo.setStaffBasicId(staffBasicId);
            sbw.setId(sbwId);
            sbw.setCid(cid);
            sbw.setStaffId(staffId);
            swr.setId(swrId);
            swr.setStaffId(staffId);
            swr.setCid(cid);
            sbw.setIsRadiation(Global.FALSE);
            List<Integer> list = Arrays.asList(1, 2, 5);
            if (list.contains(bodyCheckType)) {
                swr.setStatus(Byte.valueOf((byte)1));
            } else {
                swr.setStatus(Byte.valueOf((byte)2));
            }
            swr.setWorkProperty(Byte.valueOf((byte)1));
            swr.setIsHistory(Boolean.valueOf(false));
            swr.setIsThirdParty(Boolean.valueOf(false));
            sbi.setIdCard(m.getIdCardCode());
            sbi.setIdcardType(m.getIdCardType());
            sbi.setRealName(m.getName());
            sbi.setJobName(m.getOtherJobName());
            Integer value = StaffGenderEnum.getValue((String)m.getSexCode());
            if (value != null) {
                sbi.setGender(Byte.valueOf(value.byteValue()));
            }
            if (m.getIdCardType().equalsIgnoreCase("1")) {
                Date birthday = IDCardUtil.getBirthday((String)m.getIdCardCode());
                sbi.setBirthday(birthday);
            }
            sbi.setAge(m.getAge());
            staffInfo.setStaffBasicInfo(sbi);
            sbw.setCurrentStaffWorkRole(swr);
            staffInfo.setStaffBasicWork(sbw);
            staffInfo.setIsThirdParty(Boolean.valueOf(false));
            staffInfo.setAddFrom(Integer.valueOf(StaffAddFromEnum.third_org_check_add.getValue().intValue()));
            map.put(m.getIdCardCode(), staffInfo);
        }
        return new ArrayList<StaffInfo>(map.values());
    }

    public CheckDetailModel info(Long checkId) {
        CheckDetailModel detail = ((PhcPhysicalCheckV3221OrgMapper)this.dao).queryDataById(checkId);
        if (detail.getCheckReportFileId() != null) {
            SysFileModel fileModel = this.sysFileProvideService.getFileById(detail.getCheckReportFileId());
            detail.setCheckReportFile(fileModel);
        }
        return detail;
    }

    @Transactional
    public void addOrUpdateCheckStaff(List<AddCheckStaffModel> modelList, Long operatorId) {
        if (CollectionUtils.isEmpty(modelList)) {
            throw new RuntimeException("\u4f53\u68c0\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long checkId = modelList.get(0).getCheckId();
        ArrayList<PhcPhysicalStaffCheckInfo> staffList = new ArrayList<PhcPhysicalStaffCheckInfo>();
        PhcPhysicalCheckV3221 checkV3221 = (PhcPhysicalCheckV3221)this.getById(checkId);
        if (checkV3221 == null) {
            throw new RuntimeException("\u4f53\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CompanySuperviseModel company = this.companyProvideService.getCompanyInfoById(checkV3221.getCid());
        if (company == null) {
            throw new RuntimeException("\u8bf7\u5148\u9009\u62e9\u7528\u5de5\u5355\u4f4d");
        }
        for (AddCheckStaffModel model : modelList) {
            String idCardCode = model.getIdCardCode();
            if (StringUtils.isNotEmpty((String)idCardCode)) {
                model.setIdCardCode(idCardCode.toUpperCase());
            }
            PhcPhysicalStaffCheckInfo staffCheckInfo = new PhcPhysicalStaffCheckInfo();
            BeanUtils.copyProperties((Object)model, (Object)staffCheckInfo);
            staffCheckInfo.setIsValid(Boolean.valueOf(true));
            staffCheckInfo.setSourceId(model.getCheckId());
            staffCheckInfo.setCheckTime(checkV3221.getCheckTime());
            staffCheckInfo.setCid(checkV3221.getCid());
            staffCheckInfo.setCreditCode(checkV3221.getCreditCode());
            staffCheckInfo.setCreditCodeEmployer(company.getUnifiedSocialCc());
            staffCheckInfo.setOrgCode(checkV3221.getOrgCode());
            staffCheckInfo.setIdcardCode(model.getIdCardCode());
            staffCheckInfo.setIdcardType(model.getIdCardType());
            staffCheckInfo.setConclusion(model.getConclusion());
            if (checkV3221.getBodyCheckType() != null) {
                staffCheckInfo.setBodyCheckType(checkV3221.getBodyCheckType().toString());
            }
            staffCheckInfo.setUpdateBy(operatorId);
            staffCheckInfo.setUpdateDate(new Date());
            staffCheckInfo.setCheckResultCode(model.getCheckResultCode());
            staffCheckInfo.setSuggest(model.getSuggest());
            staffCheckInfo.setHandlingOpinions(model.getHandlingOpinions());
            staffCheckInfo.setOtherJobName(model.getOtherJobName());
            staffCheckInfo.setAnomalyItems(model.getAnomalyItems());
            staffCheckInfo.setContactHazardCode(model.getContactHazardCode());
            staffCheckInfo.setContactHazardName(model.getContactHazardName());
            if (model.getCheckStaffId() != null) {
                staffCheckInfo.setId(model.getCheckStaffId());
                staffCheckInfo.setCardId(model.getCheckStaffId().toString());
            } else {
                Long id = this.idworker.nextId();
                staffCheckInfo.setId(id);
                staffCheckInfo.setCardId(id.toString());
                staffCheckInfo.setCreateBy(operatorId);
                staffCheckInfo.setCreateDate(new Date());
                staffCheckInfo.setIsValid(Boolean.valueOf(true));
            }
            if (PhyPhcCheckConclusionEnum.ZYJJZ.getCode().toString().equals(staffCheckInfo.getConclusion())) {
                staffCheckInfo.setCotId(model.getAbnormalHazardCode());
            }
            if (PhyPhcCheckConclusionEnum.YSZYB.getCode().toString().equals(staffCheckInfo.getConclusion())) {
                staffCheckInfo.setSptId(model.getAbnormalHazardCode());
            }
            if (PhyPhcCheckConclusionEnum.REVIEW.getCode().toString().equals(staffCheckInfo.getConclusion())) {
                staffCheckInfo.setFcItem(model.getFcItem());
            }
            staffList.add(staffCheckInfo);
        }
        ((PhcPhysicalCheckV3221OrgMapper)this.dao).saveCheckStaffV3221OrUpdate(staffList);
    }

    public List<AddCheckStaffModel> checkStaffList(Long checkId, String conclusion, String keyword) {
        List<AddCheckStaffModel> modelList = ((PhcPhysicalCheckV3221OrgMapper)this.dao).queryCheckStaffList(checkId, conclusion, keyword);
        if (CollectionUtils.isEmpty(modelList)) {
            return Collections.emptyList();
        }
        List<Integer> sptIds = modelList.stream().map(AddCheckStaffModel::getSptId).filter(StringUtils::isNotEmpty).map(Integer::parseInt).collect(Collectors.toList());
        Map<Integer, Disease> diseaseMap = this.queryAbnormalName(sptIds);
        Map<Long, String> harmMap = this.getFactorMap();
        modelList.forEach(m -> {
            String abnormalName;
            if (StringUtils.isNotEmpty((String)m.getContactHazardCode())) {
                String contactHazardName = Arrays.stream(StringUtils.split((String)m.getContactHazardCode(), (String)",")).map(f -> (String)harmMap.get(Long.parseLong(f))).filter(Objects::nonNull).distinct().collect(Collectors.joining(";"));
                m.setContactHazardName(contactHazardName);
            }
            if (StringUtils.isNotEmpty((String)m.getSptId())) {
                abnormalName = Arrays.stream(StringUtils.split((String)m.getSptId(), (String)",")).map(f -> ((Disease)diseaseMap.get(Integer.parseInt(f))).getDiseaseName()).filter(Objects::nonNull).distinct().collect(Collectors.joining(";"));
                m.setAbnormalName(abnormalName);
                m.setAbnormalHazardCode(m.getSptId());
                m.setSptId(abnormalName);
            }
            if (StringUtils.isNotEmpty((String)m.getCotId())) {
                abnormalName = Arrays.stream(StringUtils.split((String)m.getCotId(), (String)",")).map(f -> (String)harmMap.get(Long.parseLong(f))).filter(Objects::nonNull).distinct().collect(Collectors.joining(";"));
                m.setAbnormalName(abnormalName);
                m.setAbnormalHazardCode(m.getCotId());
                m.setCotId("/");
            }
        });
        return modelList;
    }

    public AddCheckStaffModel getCheckStaff(Long id) {
        return ((PhcPhysicalCheckV3221OrgMapper)this.dao).queryCheckStaff(id);
    }

    public PageInfo<AddCheckStaffModel> checkStaffListPage(JqGridParam pageParam, Long checkId, String conclusion, String keyword) {
        PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        return new PageInfo(this.checkStaffList(checkId, conclusion, keyword));
    }

    public Map<String, Map<String, String>> checkStaffInfo(Long checkId, List<AddCheckStaffModel> modelList) {
        List<AddCheckStaffModel> dbCheckList;
        HashMap<String, String> tempMap;
        List<AddCheckStaffModel> staffInfoList;
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        PhcPhysicalCheckV3221 checkV3221 = (PhcPhysicalCheckV3221)this.getById(checkId);
        if (Objects.isNull(checkV3221)) {
            throw new RuntimeException("\u4f53\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Map<String, List<AddCheckStaffModel>> idcardMap = modelList.stream().peek(m -> m.setIdCardCode(m.getIdCardCode().toUpperCase())).collect(Collectors.groupingBy(AddCheckStaffModel::getIdCardCode));
        for (String idCard : idcardMap.keySet()) {
            List<AddCheckStaffModel> tempList = idcardMap.get(idCard);
            if (tempList.size() <= 1) continue;
            String firstName = tempList.get(0).getName();
            HashMap tempMap2 = new HashMap();
            for (AddCheckStaffModel person : tempList) {
                if (person.getName().equals(firstName)) continue;
                tempMap2.put("\u4e0a\u62a5\u7684\u540d\u5b57", person.getName());
            }
            if (tempMap2.size() <= 0) continue;
            tempMap2.put("\u4e0a\u62a5\u7684\u540d\u5b57", firstName);
            resultMap.put(idCard, tempMap2);
        }
        List idCardList = modelList.stream().map(AddCheckStaffModel::getIdCardCode).distinct().collect(Collectors.toList());
        Map<String, String> importMap = modelList.stream().collect(Collectors.toMap(k -> k.getIdCardCode().toUpperCase(), AddCheckStaffModel::getName, (o1, o2) -> o1));
        Long cid = checkV3221.getCid();
        ArrayList<String> idCardEncs = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idCardList)) {
            for (Object idCard : idCardList) {
                String encs = SpringEncryptUtils.encrypt((String)idCard);
                idCardEncs.add(encs);
            }
        }
        if (CollectionUtils.isNotEmpty(staffInfoList = ((PhcPhysicalCheckV3221OrgMapper)this.dao).queryCheckStaffListByCidIdCard(cid, idCardEncs))) {
            for (String idCard : importMap.keySet()) {
                for (AddCheckStaffModel staffCheckInfo : staffInfoList) {
                    if (!idCard.equalsIgnoreCase(staffCheckInfo.getIdCardCode()) || Objects.equals(staffCheckInfo.getName(), importMap.get(idCard))) continue;
                    tempMap = new HashMap();
                    tempMap.put("\u7cfb\u7edf\u5185\u540d\u5b57", staffCheckInfo.getName());
                    tempMap.put("\u4e0a\u62a5\u7684\u540d\u5b57", importMap.get(idCard));
                    resultMap.put(idCard, tempMap);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(dbCheckList = ((PhcPhysicalCheckV3221OrgMapper)this.dao).queryCheckStaffList(checkId, null, null))) {
            modelList.addAll(dbCheckList);
        }
        Map<String, List<AddCheckStaffModel>> map = modelList.stream().collect(Collectors.groupingBy(k -> k.getConclusion() + "-" + k.getIdCardCode()));
        for (String key : map.keySet()) {
            tempMap = new HashMap<String, String>();
            if (map.get(key).size() > 1) {
                tempMap.put("\u4eba\u5458\u91cd\u590d", key);
            }
            if (tempMap.size() <= 0) continue;
            resultMap.put(map.get(key).get(0).getName(), tempMap);
        }
        return resultMap;
    }

    @Transactional
    public void delCheckStaff(List<Long> checkStaffIdList) {
        if (CollectionUtils.isNotEmpty(checkStaffIdList)) {
            ((PhcPhysicalCheckV3221OrgMapper)this.dao).delCheckStaff(checkStaffIdList);
        }
    }

    public Map<Integer, Disease> queryAbnormalName(List<Integer> abnormalCodeList) {
        if (CollectionUtils.isEmpty(abnormalCodeList)) {
            return Collections.emptyMap();
        }
        List diseaseList = this.diseaseThirdService.listDiseases(abnormalCodeList);
        return diseaseList.stream().collect(Collectors.toMap(Disease::getId, Function.identity()));
    }

    public PageInfo<PhcPhysicalCheckProjectVo> getCheckProjectList(CheckProjectModel model, JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalCheckProjectVo> checkProjectList = ((PhcPhysicalCheckV3221OrgMapper)this.dao).selectCheckProjectList(model);
        return new PageInfo(checkProjectList);
    }

    @Transactional
    public void delCheckProject(CheckProjectModel model) {
        if (ObjectUtil.isNull((Object)model.getCheckId())) {
            throw new HealthException("\u5220\u9664\u7684\u4f53\u68c0\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(PhcPhysicalCheckV3221.class);
        example.createCriteria().andEqualTo("id", (Object)model.getCheckId()).andEqualTo("status", (Object)0).andEqualTo("isValid", (Object)true);
        PhcPhysicalCheckV3221 phcPhysicalCheckV3221 = (PhcPhysicalCheckV3221)((PhcPhysicalCheckV3221OrgMapper)this.dao).selectOneByExample(example);
        if (ObjectUtil.isNull((Object)phcPhysicalCheckV3221)) {
            throw new HealthException("\u4f53\u68c0\u9879\u76ee\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        phcPhysicalCheckV3221.setUpdateDate(new Date());
        phcPhysicalCheckV3221.setUpdateBy(model.getLoginUserId());
        phcPhysicalCheckV3221.setIsValid(Boolean.valueOf(false));
        this.phcPhysicalStaffCheckInfoService.batchDelectStaffCheckInfoBySourceId(model.getCheckId(), model.getLoginUserId());
        ((PhcPhysicalCheckV3221OrgMapper)this.dao).updateByPrimaryKey(phcPhysicalCheckV3221);
    }

    @Generated
    public PhcPhysicalCheckV3221OrgServiceImpl(IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService, IStaffInfoService staffInfoService, IReformItemBasicNewService reformItemBasicNewService) {
        this.phcPhysicalStaffCheckInfoService = phcPhysicalStaffCheckInfoService;
        this.staffInfoService = staffInfoService;
        this.reformItemBasicNewService = reformItemBasicNewService;
    }
}

