/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.check.PhcWorkUnexchangeMapper;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhcWorkUnexchange;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcWorkUnexchangeInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcWorkUnexchangeParam;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcWorkUnexchangeLastCheckResultService;
import cn.smarthse.modules.health.service.work.check.IPhcWorkUnexchangeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcWorkUnexchangeServiceImpl
extends BaseServiceImpl<PhcWorkUnexchangeMapper, PhcWorkUnexchange>
implements IPhcWorkUnexchangeService {
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IPhcWorkUnexchangeLastCheckResultService childService;
    @Autowired
    IStaffInfoService staffInfoService;

    @Transactional(readOnly=false)
    public void addByResult(PhcPhysicalCheckDataResult result) {
        PhcPhysicalCheckResultDeal resultDealInfo = this.resultService.getResultDealInfo(result);
        if (resultDealInfo == null) {
            return;
        }
        PhcWorkUnexchange data = this.getByDealInfo(resultDealInfo);
        if (data == null) {
            data = this.convertResult(resultDealInfo);
            data.setId(Long.valueOf(this.idworker.nextId()));
            ((PhcWorkUnexchangeMapper)this.dao).insert(data);
        }
        this.childService.addChild(resultDealInfo, data);
    }

    private PhcWorkUnexchange getByDealInfo(PhcPhysicalCheckResultDeal resultDealInfo) {
        PhcWorkUnexchange result = null;
        try {
            Example example = new Example(PhcWorkUnexchange.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("cid", (Object)resultDealInfo.getCid());
            criteria.andEqualTo("staffId", (Object)resultDealInfo.getStaffId());
            criteria.andEqualTo("isFinish", (Object)false);
            example.setOrderByClause("update_date desc");
            List list = ((PhcWorkUnexchangeMapper)this.dao).selectByExample(example);
            if (list != null && list.size() > 0) {
                result = (PhcWorkUnexchange)list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    private PhcWorkUnexchange convertResult(PhcPhysicalCheckResultDeal resultDealInfo) {
        PhcWorkUnexchange data = new PhcWorkUnexchange();
        data.setCid(resultDealInfo.getCid());
        data.setCreateBy(resultDealInfo.getUpdateBy());
        data.setCreateDate(new Date());
        data.setIsFinish(Boolean.valueOf(false));
        data.setIsValid(Boolean.valueOf(true));
        data.setStaffId(resultDealInfo.getStaffId());
        data.setUpdateBy(resultDealInfo.getUpdateBy());
        data.setUpdateDate(new Date());
        data.setOrgId(resultDealInfo.getOrgId());
        return data;
    }

    @Transactional(readOnly=false)
    public void setIsFinishByIds(String ids, boolean b, Long updateBy) {
        List idList = StringUtils.parseToLongList((String)ids, (String)",");
        for (Long id : idList) {
            this.setIsFinishById(id, b, updateBy);
        }
    }

    @Transactional(readOnly=false)
    public void setIsFinishById(Long id, Boolean isFinish, Long updateBy) {
        PhcWorkUnexchange record = new PhcWorkUnexchange();
        record.setIsFinish(isFinish);
        record.setId(id);
        this.update(record, updateBy);
    }

    public PageInfo<PhcWorkUnexchangeInfo> getUnexchangePage(JqGridParam gparam, PhcWorkUnexchangeParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("healthCheck", "phc_work_unexchange");
        return new PageInfo(this.listDetails(param));
    }

    public List<PhcWorkUnexchangeInfo> listDetails(PhcWorkUnexchangeParam data) {
        return ((PhcWorkUnexchangeMapper)this.dao).getListByQuery(data);
    }

    public PhcWorkUnexchange getDetailById(Long id) {
        if (id == null) {
            return null;
        }
        return ((PhcWorkUnexchangeMapper)this.dao).getDetailById(id);
    }

    @Transactional(readOnly=false)
    public void updateChangeInfo(PhcWorkUnexchange data, Long updateBy) {
        data.setUpdateBy(updateBy);
        data.setUpdateDate(new Date());
        ((PhcWorkUnexchangeMapper)this.dao).updateChangeInfo(data);
        if (data.getIsFinish() == null || !data.getIsFinish().booleanValue()) {
            return;
        }
        this.staffInfoService.staffCurrentWorkInfoChangeInform(data.getStaffId(), data.getChangeWorkId(), data.getLeaveTime(), data.getWorkTime(), StaffWorkStatusEnum.TRANSFER, updateBy, data.getCid());
    }
}

