/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.check.PhcUnrecheckMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.PhcUnrecheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckDataVO;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckRecheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.IPhcUnrecheckLastCheckResultService;
import cn.smarthse.modules.health.service.work.check.IPhcUnrecheckService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcUnrecheckServiceImpl
extends BaseServiceImpl<PhcUnrecheckMapper, PhcUnrecheck>
implements IPhcUnrecheckService {
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IPhcUnrecheckLastCheckResultService childService;
    @Autowired
    IPhcPhysicalCheckService checkService;
    @Autowired
    IPhcPhysicalCheckDataService checkDataService;
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired
    IStaffInfoService staffService;

    @Transactional(readOnly=false)
    public void addByResult(PhcPhysicalCheckDataResult result) {
        PhcPhysicalCheckResultDeal resultDealInfo = this.resultService.getResultDealInfo(result);
        if (resultDealInfo == null) {
            return;
        }
        PhcUnrecheck data = this.convertResult(resultDealInfo);
        if (result.getDealType() == 8) {
            data.setType(Integer.valueOf(1));
        }
        data.setId(Long.valueOf(this.idworker.nextId()));
        ((PhcUnrecheckMapper)this.dao).insert(data);
        this.childService.addChild(resultDealInfo, data);
    }

    public PhcUnrecheck getByDealInfo(PhcPhysicalCheckResultDeal resultDealInfo) {
        PhcUnrecheck result = null;
        try {
            Example example = new Example(PhcUnrecheck.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("cid", (Object)resultDealInfo.getCid());
            criteria.andEqualTo("staffId", (Object)resultDealInfo.getStaffId());
            criteria.andEqualTo("isFinish", (Object)false);
            example.setOrderByClause("update_date desc");
            List list = ((PhcUnrecheckMapper)this.dao).selectByExample(example);
            if (list != null && list.size() > 0) {
                result = (PhcUnrecheck)list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    private PhcUnrecheck convertResult(PhcPhysicalCheckResultDeal resultDealInfo) {
        PhcUnrecheck data = new PhcUnrecheck();
        data.setCid(resultDealInfo.getCid());
        data.setCreateBy(resultDealInfo.getUpdateBy());
        data.setCreateDate(new Date());
        data.setIsFinish(Boolean.valueOf(false));
        data.setIsValid(Boolean.valueOf(true));
        data.setStaffId(resultDealInfo.getStaffId());
        data.setUpdateBy(resultDealInfo.getUpdateBy());
        data.setUpdateDate(new Date());
        data.setOrgId(resultDealInfo.getOrgId());
        return data;
    }

    public PageInfo<PhcPhysicalCheckRecheckInfo> getUnrecheckPage(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("healthCheck", "phc_unrecheck");
        return new PageInfo(this.listDetails(param));
    }

    public List<PhcPhysicalCheckRecheckInfo> listDetails(PhcPhysicalCheckAbnormalParam data) {
        return ((PhcUnrecheckMapper)this.dao).getListByQuery(data);
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheck addRecheckInfo(Long checkId, String unRecheckIds, Long cid, Long staffId, Integer reCheckType) {
        if (StringUtils.isEmpty((CharSequence)unRecheckIds)) {
            return null;
        }
        List unRecheckIdList = StringUtils.parseToLongList((String)unRecheckIds, (String)",");
        PhcPhysicalCheck check = null;
        if (checkId == null) {
            check = this.getCheckInfo(cid, reCheckType);
            this.checkService.insertOrUpdate(check, cid, staffId);
        } else {
            check = new PhcPhysicalCheck();
            check.setId(checkId);
            check.setCid(cid);
            check.setCreateBy(staffId);
            check.setCreateDate(new Date());
        }
        PhcPhysicalCheckAbnormalParam query = new PhcPhysicalCheckAbnormalParam();
        query.setUnRecheckIdList(unRecheckIdList);
        query.setReCheckType(reCheckType);
        List<PhcPhysicalCheckRecheckInfo> unrechecks = ((PhcUnrecheckMapper)this.dao).getListByQuery(query);
        this.addDataByUnrecheck(unrechecks, check);
        this.setIsFinishByIds(unRecheckIds, true, check.getId());
        return check;
    }

    @Transactional(readOnly=false)
    private void addDataByUnrecheck(List<PhcPhysicalCheckRecheckInfo> unrechecks, PhcPhysicalCheck check) {
        if (check == null || unrechecks == null) {
            return;
        }
        List<Long> alreadyAddStaffId = this.getAlreadyExistStaffIdsByCheckId(check.getId());
        for (PhcPhysicalCheckRecheckInfo u : unrechecks) {
            Long staffId = u.getStaffId();
            if (alreadyAddStaffId.contains(staffId)) continue;
            StaffInfo staff = this.staffService.getStaffInfoWithStaffBasicWorkById(staffId);
            PhcPhysicalCheckData data = new PhcPhysicalCheckData();
            if (staff == null || staff.getStaffBasicInfo() == null) continue;
            data.setCheckId(check.getId());
            data.setStaffId(staffId);
            StaffBasicInfo basicInfo = staff.getStaffBasicInfo();
            data.setStaffName(basicInfo.getRealName());
            StaffBasicWork basicWork = staff.getStaffBasicWork() == null ? new StaffBasicWork() : staff.getStaffBasicWork();
            data.setStaffWorkNo(basicWork.getWorkNo());
            data.setStaffDeptId(basicWork.getOrgId());
            data.setStaffDeptName(basicWork.getCompanyOrganization() == null ? "" : basicWork.getCompanyOrganization().getOrganizationName());
            StaffWorkRole staffWorkRole = staff.getStaffWorkRole() == null ? new StaffWorkRole() : staff.getStaffWorkRole();
            WorkRoleInfo work = staffWorkRole.getWorkRoleInfo() == null ? new WorkRoleInfo() : staffWorkRole.getWorkRoleInfo();
            data.setStaffWorkId(work.getId());
            data.setStaffWorkName(work.getWorkName());
            data.setCheckType(Byte.valueOf(Byte.parseByte(CheckTypeEnum.recheck.getCode())));
            this.checkDataService.add((Object)data, check.getCreateBy(), check.getCid());
            alreadyAddStaffId.add(staffId);
        }
    }

    private List<Long> getAlreadyExistStaffIdsByCheckId(Long checkId) {
        ArrayList<Long> alreadyAddStaffId = new ArrayList<Long>();
        if (checkId == null) {
            return alreadyAddStaffId;
        }
        PhcPhysicalCheckQuery query = new PhcPhysicalCheckQuery();
        query.setCheckId(checkId);
        List datas = this.checkDataService.listDatas(query);
        if (datas == null) {
            return alreadyAddStaffId;
        }
        for (PhcPhysicalCheckDataVO data : datas) {
            Long staffId = Long.parseLong(data.getStaffId());
            if (alreadyAddStaffId.contains(staffId)) continue;
            alreadyAddStaffId.add(staffId);
        }
        return alreadyAddStaffId;
    }

    private PhcPhysicalCheck getCheckInfo(Long cid, Integer reCheckType) {
        PhcPhysicalCheck check = new PhcPhysicalCheck();
        ArrayList<PhcPhysicalCheckType> checkTypes = new ArrayList<PhcPhysicalCheckType>();
        PhcPhysicalCheckType checkType = new PhcPhysicalCheckType();
        checkType.setCheckType(Byte.valueOf(Byte.parseByte(CheckTypeEnum.recheck.getCode())));
        checkTypes.add(checkType);
        check.setCheckTypes(checkTypes);
        check.setNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HEALTHCHECK.getCode()));
        if (reCheckType != null && reCheckType == 1) {
            check.setIsReplenish(Boolean.valueOf(true));
        } else {
            check.setIsRecheck(Boolean.valueOf(true));
        }
        check.setStatus(Byte.valueOf((byte)0));
        return check;
    }

    public List<PhcUnrecheck> listByIds(String ids) {
        List list = ((PhcUnrecheckMapper)this.dao).selectByIds(ids);
        return list;
    }

    @Transactional(readOnly=false)
    public void setIsFinishById(Long id, Boolean isFinish, Long checkId) {
        PhcUnrecheck record = new PhcUnrecheck();
        record.setIsFinish(isFinish);
        record.setId(id);
        record.setRecheckId(checkId);
        ((PhcUnrecheckMapper)this.dao).updateByPrimaryKeySelective(record);
    }

    @Transactional(readOnly=false)
    public void setIsFinishByIds(String unRecheckIds, Boolean isFinish, Long checkId) {
        List ids = StringUtils.parseToLongList((String)unRecheckIds, (String)",");
        for (Long id : ids) {
            this.setIsFinishById(id, isFinish, checkId);
        }
    }

    @Transactional(readOnly=false)
    public void setIsFinishByInfo(PhcUnrecheck recheck, Long updateBy) {
        if (recheck == null) {
            return;
        }
        boolean flag = false;
        this.checkDataService.deleteById(recheck.getDataId());
        Example example = new Example(PhcUnrecheck.class);
        Example.Criteria criteria = example.createCriteria();
        if (recheck.getStaffId() != null) {
            criteria.andEqualTo("staffId", (Object)recheck.getStaffId());
            flag = true;
        }
        if (recheck.getRecheckId() != null) {
            criteria.andEqualTo("recheckId", (Object)recheck.getRecheckId());
            flag = true;
        }
        if (!flag) {
            return;
        }
        PhcUnrecheck data = new PhcUnrecheck();
        data.setIsFinish(Boolean.valueOf(false));
        data.setUpdateBy(updateBy);
        data.setUpdateDate(new Date());
        ((PhcUnrecheckMapper)this.dao).updateByExampleSelective(data, example);
    }
}

