/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckTypeMapper;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.enums.check.CheckSourceEnum;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTypeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class PhcPhysicalCheckTypeServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckTypeMapper, PhcPhysicalCheckType>
implements IPhcPhysicalCheckTypeService {
    @Autowired
    IPhcPhysicalCheckDataService phcPhysicalCheckDataService;

    @Transactional(readOnly=false)
    public void updateTypesByParent(PhcPhysicalCheck data) {
        if (data == null) {
            return;
        }
        this.deleteByPid(data.getId());
        List checkTypes = data.getCheckTypes();
        if (data.getId() == null || checkTypes == null) {
            return;
        }
        for (PhcPhysicalCheckType checkType : checkTypes) {
            if (checkType.getCheckType() == null) continue;
            this.setParentInfos(data, checkType);
            checkType.setId(Long.valueOf(this.idworker.nextId()));
            if (data.getSource() == null || data.getSource() == CheckSourceEnum.smarthse.getCode()) {
                checkType.setCheckReportFileIds(StringUtils.convertArrayToString((String[])checkType.getCheckReportFileArray(), (String)","));
            }
            ((PhcPhysicalCheckTypeMapper)this.dao).insert(checkType);
        }
    }

    private void deleteByPid(Long checkId) {
        if (checkId == null) {
            return;
        }
        Example example = new Example(PhcPhysicalCheckType.class);
        example.createCriteria().andEqualTo("checkId", (Object)checkId);
        ((PhcPhysicalCheckTypeMapper)this.dao).deleteByExample(example);
    }

    private void setParentInfos(PhcPhysicalCheck data, PhcPhysicalCheckType type) {
        type.setCheckId(data.getId());
        type.setCid(data.getCid());
        type.setCreateBy(data.getUpdateBy());
        type.setCreateDate(data.getUpdateDate());
        type.setUpdateBy(data.getUpdateBy());
        type.setUpdateDate(data.getUpdateDate());
    }
}

