/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoQuery;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserReportQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcWorkUnexchangeParam;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.RecommendCheckEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.check.IPhcDiagnoseDiseaseProcessService;
import cn.smarthse.modules.health.service.work.check.IPhcDiseaserReportService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTipService;
import cn.smarthse.modules.health.service.work.check.IPhcUnrecheckService;
import cn.smarthse.modules.health.service.work.check.IPhcWorkUnexchangeService;
import cn.smarthse.modules.health.vo.work.check.CheckTipQuery;
import cn.smarthse.modules.health.vo.work.check.CheckTipVO;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckTipServiceImpl
implements IPhcPhysicalCheckTipService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IPhcPhysicalCheckService checkService;
    @Autowired
    IPhcWorkUnexchangeService phcWorkUnexchangeService;
    @Autowired
    IPhcDiseaserReportService reportService;
    @Autowired
    IPhcDiagnoseDiseaseProcessService processService;
    @Autowired
    IPhcUnrecheckService recheckService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysService;

    public int unfinishCheckCount(Long cid) {
        PhcPhysicalCheckParam query = new PhcPhysicalCheckParam();
        query.setCid(cid);
        query.setStatus(Byte.valueOf((byte)0));
        List list = this.checkService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public int finishCheckCount(Long cid) {
        PhcPhysicalCheckParam query = new PhcPhysicalCheckParam();
        query.setCid(cid);
        query.setStatus(Byte.valueOf((byte)1));
        List list = this.checkService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public int undealAbnormalCount(Long cid) {
        PhcPhysicalCheckAbnormalParam query = new PhcPhysicalCheckAbnormalParam();
        query.setCid(cid);
        query.setDealStatus(Byte.valueOf((byte)0));
        List list = this.resultService.getAbnormalList(query);
        return list == null ? 0 : list.size();
    }

    public int unexchangeCount(Long cid) {
        PhcWorkUnexchangeParam query = new PhcWorkUnexchangeParam();
        query.setCid(cid);
        List list = this.phcWorkUnexchangeService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public int unreportCount(Long cid) {
        PhcDiseaserReportQuery query = new PhcDiseaserReportQuery();
        query.setCid(cid);
        query.setStatus(Byte.valueOf((byte)0));
        List list = this.reportService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public int unrecheckCount(Long cid) {
        PhcPhysicalCheckAbnormalParam query = new PhcPhysicalCheckAbnormalParam();
        query.setCid(cid);
        List list = this.recheckService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public int unReplenishcheckCount(Long cid) {
        PhcPhysicalCheckAbnormalParam query = new PhcPhysicalCheckAbnormalParam();
        query.setCid(cid);
        query.setReCheckType(Integer.valueOf(1));
        List list = this.recheckService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public int undiagnoseCount(Long cid) {
        PhcDiseaserUnProcessParam query = new PhcDiseaserUnProcessParam();
        query.setCid(cid);
        query.setIsFinish(Boolean.valueOf(false));
        query.setDealStatus(Byte.valueOf((byte)1));
        List list = this.processService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    public boolean hasThisYearChecked(Long cid, int thisYear) {
        CheckTipQuery query = new CheckTipQuery();
        query.setCid(cid);
        query.setYear(Integer.valueOf(thisYear));
        query.setCheckType(CheckTypeEnum.on.getCode());
        boolean hasThisYearCheced = this.checkService.hasThisYearChecked(query);
        return hasThisYearCheced;
    }

    @Transactional
    public CheckTipVO getCheckTips(Long cid) {
        List thirdTimes;
        List acctions;
        CheckTipVO vo = new CheckTipVO();
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        DataScope dataScope = DataScopeHelper.getDataScope();
        int unfinishCheckCount = this.unfinishCheckCount(cid);
        DataScopeHelper.setDataScope(dataScope);
        int finishCheckCount = this.finishCheckCount(cid);
        vo.setCheckCount(Integer.valueOf(unfinishCheckCount + finishCheckCount));
        DataScopeHelper.setDataScope(dataScope);
        int undealAbnormalCount = this.undealAbnormalCount(cid);
        dataScope.setMainTableName("phc_work_unexchange");
        DataScopeHelper.setDataScope(dataScope);
        int unexchangeCount = this.unexchangeCount(cid);
        dataScope.setMainTableName("phc_diseaser_report");
        DataScopeHelper.setDataScope(dataScope);
        int unreportCount = this.unreportCount(cid);
        dataScope.setMainTableName("phc_unrecheck");
        DataScopeHelper.setDataScope(dataScope);
        int unrecheckCount = this.unrecheckCount(cid);
        dataScope.setMainTableName("phc_unrecheck");
        DataScopeHelper.setDataScope(dataScope);
        int unReplenishcheckCount = this.unReplenishcheckCount(cid);
        dataScope.setMainTableName("phc_diagnose_disease_process");
        DataScopeHelper.setDataScope(dataScope);
        int undiagnoseCount = this.undiagnoseCount(cid);
        int thisYear = DateUtils.getThisYear();
        boolean hasThisYearIgnored = this.sysService.hasThisYearIgnoreData(TodlistInfoTypeEnum.healthCheck_thisYear, cid, thisYear);
        Boolean hasThisYearChecked = hasThisYearIgnored ? false : this.hasThisYearChecked(cid, thisYear);
        vo.setHasThisYearChecked(hasThisYearChecked);
        int total = 0;
        if (unfinishCheckCount > 0) {
            vo.setUnfinishCheckCount(Integer.valueOf(unfinishCheckCount));
        }
        if (undealAbnormalCount > 0) {
            ++total;
            vo.setUndealAbnormalCount(Integer.valueOf(undealAbnormalCount));
        }
        if (unexchangeCount > 0) {
            ++total;
            vo.setUnexchangeCount(Integer.valueOf(unexchangeCount));
        }
        if (unreportCount > 0) {
            ++total;
            vo.setUnreportCount(Integer.valueOf(unreportCount));
        }
        if (unrecheckCount > 0) {
            ++total;
            vo.setUnrecheckCount(Integer.valueOf(unrecheckCount));
        }
        if (unReplenishcheckCount > 0) {
            ++total;
            vo.setUnReplenishcheckCount(Integer.valueOf(unReplenishcheckCount));
        }
        if (undiagnoseCount > 0) {
            ++total;
            vo.setUndiagnoseCount(Integer.valueOf(undiagnoseCount));
        }
        if (hasThisYearChecked != null && !hasThisYearChecked.booleanValue()) {
            ++total;
        }
        if ((acctions = this.sysService.getListToRemind(CoreWorkEnum.accidentManement, CoreWorkEnum.healthCheck, cid)) != null && acctions.size() > 0) {
            vo.setAcctions(acctions);
            ++total;
        }
        if ((thirdTimes = this.sysService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.healthCheck, cid)) != null) {
            vo.setThirdTimes(thirdTimes);
            total += thirdTimes.size();
        }
        vo.setTotal(Integer.valueOf(total));
        List thirdOrgUploads = this.sysService.getListToRemind(CoreWorkEnum.healthCheck, CoreWorkEnum.healthCheck, cid);
        if (thirdOrgUploads != null) {
            vo.setThirdOrgUploads(thirdOrgUploads);
        }
        this.logger.info("\u83b7\u53d6\u5c97\u524d\uff0c\u79bb\u5c97\u4f53\u68c0\u4eba\u5458\u7edf\u8ba1");
        HealthCheckStaffInfoQuery query = new HealthCheckStaffInfoQuery();
        query.setCid(cid);
        query.setChoose(RecommendCheckEnum.leaveChoose.getCode());
        query.setMust(RecommendCheckEnum.leaveMust.getCode());
        JqGridParam gparam = new JqGridParam();
        gparam.setCid(cid);
        gparam.setPage(1);
        gparam.setRows(1);
        PageInfo pageInfo = this.checkService.getLeaveRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        if (pageInfo == null) {
            vo.setLeaveNoCheckNum(Integer.valueOf(0));
        } else {
            vo.setLeaveNoCheckNum(Integer.valueOf((int)pageInfo.getTotal()));
        }
        query.setCid(cid);
        query.setChoose(RecommendCheckEnum.beforeChoose.getCode());
        query.setMust(RecommendCheckEnum.beforeMust.getCode());
        PageInfo pInfo = this.checkService.getBeforeRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        if (pInfo == null) {
            vo.setBeforeNoCheckNum(Integer.valueOf(0));
        } else {
            vo.setBeforeNoCheckNum(Integer.valueOf((int)pInfo.getTotal()));
        }
        return vo;
    }

    @Transactional
    public CheckTipVO getLiteCheckTips(Long cid, boolean isZhouShanCompany) {
        List diseasers;
        List thirdTimes;
        List<SysCoreWorkModuleCorrelation> thirdOrgUploads;
        CheckTipVO vo = new CheckTipVO();
        int total = 0;
        int thisYear = DateUtils.getThisYear();
        boolean hasThisYearIgnored = this.sysService.hasThisYearIgnoreData(TodlistInfoTypeEnum.healthCheck_thisYear, cid, thisYear);
        if (hasThisYearIgnored) {
            vo.setHasThisYearChecked(Boolean.valueOf(true));
        } else {
            boolean thisYearChecked = this.hasThisYearChecked(cid, thisYear);
            vo.setHasThisYearChecked(Boolean.valueOf(thisYearChecked));
            if (!thisYearChecked) {
                ++total;
            }
        }
        if (isZhouShanCompany) {
            int undealAbnormalCount = this.undealLiteAbnormalCount(cid);
            if (undealAbnormalCount > 0) {
                ++total;
            }
            vo.setUndealAbnormalCount(Integer.valueOf(undealAbnormalCount));
        }
        if (!CollectionUtils.isEmpty(thirdOrgUploads = this.getThirdOrgCheckList(cid, isZhouShanCompany))) {
            vo.setThirdOrgUploads(thirdOrgUploads);
            total += thirdOrgUploads.size();
        }
        if ((thirdTimes = this.sysService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.healthCheck, cid)) != null) {
            vo.setThirdTimes(thirdTimes);
            total += thirdTimes.size();
        }
        if ((diseasers = this.sysService.getListToRemind(CoreWorkEnum.diseaser, CoreWorkEnum.diseaser, cid)) != null) {
            vo.setDiseasers(diseasers);
            total += diseasers.size();
        }
        vo.setTotal(Integer.valueOf(total));
        return vo;
    }

    public int undealLiteAbnormalCount(Long cid) {
        PhcPhysicalCheckAbnormalParam query = new PhcPhysicalCheckAbnormalParam();
        query.setCid(cid);
        query.setSuperviseDealStatus(Byte.valueOf((byte)0));
        List list = this.resultService.getAbnormalList(query);
        return list == null ? 0 : list.size();
    }

    private List<SysCoreWorkModuleCorrelation> getThirdOrgCheckList(Long cid, boolean isZhouShanCompany) {
        ArrayList<SysCoreWorkModuleCorrelation> resultList = new ArrayList<SysCoreWorkModuleCorrelation>();
        List thirdOrgUploads = this.sysService.getListToRemind(CoreWorkEnum.healthCheck, CoreWorkEnum.healthCheck, cid);
        for (SysCoreWorkModuleCorrelation thirdOrgUpload : thirdOrgUploads) {
            Long surceBusinessId = thirdOrgUpload.getSurceBusinessId();
            int sdNum = this.resultService.countSDieasers(surceBusinessId);
            if (sdNum <= 0) continue;
            thirdOrgUpload.setStageSource(Byte.valueOf((byte)89));
        }
        if (CollectionUtils.isEmpty((Collection)thirdOrgUploads) || isZhouShanCompany) {
            return thirdOrgUploads;
        }
        thirdOrgUploads.forEach(t -> {
            if (t.getBusinessState() == null || t.getBusinessState() != -1) {
                resultList.add((SysCoreWorkModuleCorrelation)t);
            }
        });
        return resultList;
    }
}

