/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.standard.L081OccupationalRiskFactorsList;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckRecommendIgnored;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.HHealthCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.HHealthCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserReportInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckLastCheckTime;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcYearCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.StaffCheckCountParam;
import cn.smarthse.modules.health.entity.work.check.vo.StaffCheckCountResult;
import cn.smarthse.modules.health.entity.work.check.vo.count.CheckTypeCount;
import cn.smarthse.modules.health.entity.work.check.vo.count.CheckTypeInfo;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.enums.check.CheckSourceEnum;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.DealTypeEnum;
import cn.smarthse.modules.health.enums.check.DiagnosedTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.model.HHealthCheckConclusionModel;
import cn.smarthse.modules.health.model.HHealthCheckModel;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveFileVo;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveStaffGroup;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveStaffInfo;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.standard.IL081occupationalRiskFactorsListService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.check.IPhcDiseaserReportService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckFileService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckRecommendIgnoredService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckThirdInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTypeService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgQualificationService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.work.check.CheckTipQuery;
import cn.smarthse.modules.health.vo.work.check.CheckWorkIdVO;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.util.common.JsonUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckMapper, PhcPhysicalCheck>
implements IPhcPhysicalCheckService {
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired
    IPhcPhysicalCheckTypeService checkTypeService;
    @Autowired
    IPhcPhysicalCheckFileService fileService;
    @Autowired
    IPhcDiseaserReportService reportService;
    @Autowired
    IPhcOccupationalDiseaserService diseaserService;
    @Autowired
    IPhcPhysicalCheckDataService dataService;
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IStaffInfoService staffService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysService;
    @Autowired
    IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    IPhcPhysicalCheckRecommendIgnoredService ignoredService;
    @Autowired
    IPhcPhysicalCheckThirdInfoService thirdInfoService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    IThirdOrgQualificationService thirdOrgQualificationService;
    @Autowired
    private IL081occupationalRiskFactorsListService l081occupationalRiskFactorsListService;
    @DubboReference
    private IWandaDeclareService wandaDeclareService;

    public PageInfo<PhcPhysicalCheck> getListByQuery(int pageIndex, PhcPhysicalCheckParam check) {
        PageHelper.startPage((int)pageIndex, (int)10);
        List<PhcPhysicalCheck> list = this.listDetails(check);
        return new PageInfo(list);
    }

    public PhcPhysicalCheck getDetailById(Long id) {
        if (id == null) {
            return new PhcPhysicalCheck();
        }
        PhcPhysicalCheck data = ((PhcPhysicalCheckMapper)this.dao).getDetailById(id);
        if (data != null) {
            data.setManagerName(SpringEncryptUtils.decrypt((String)data.getManagerName()));
            if (data.getManager() != null) {
                data.setManagerName(this.staffService.getStaffNameIncludeDelStatusByStaffId(data.getManager()));
            }
            if (data.getHospital() != null) {
                // empty if block
            }
            if (data.getSource() != null && data.getSource() == CheckSourceEnum.third.getCode()) {
                data.setThirdInfo(this.thirdInfoService.getByCheckId(data.getId()));
            }
        }
        this.setFiles(data);
        data.setCheckTypeCounts(this.getCheckTypeCounts(id));
        return data;
    }

    private List<CheckTypeCount> getCheckTypeCounts(Long checkId) {
        ArrayList<CheckTypeCount> counts = new ArrayList<CheckTypeCount>();
        List<CheckTypeInfo> infos = ((PhcPhysicalCheckMapper)this.dao).listCheckTypeInfoByCheckId(checkId);
        if (CollectionUtils.isEmpty(infos)) {
            return counts;
        }
        HashMap<String, CheckTypeCount> countMap = new HashMap<String, CheckTypeCount>();
        for (CheckTypeInfo checkTypeInfo : infos) {
            Integer gender;
            if (checkTypeInfo == null || checkTypeInfo.getCheckType() == null) continue;
            String checkType = checkTypeInfo.getCheckType();
            CheckTypeCount count = (CheckTypeCount)countMap.get(checkType);
            if (count == null) {
                count = new CheckTypeCount();
                count.setCheckType(checkType);
                count.setCheckProjects(checkTypeInfo.getCheckProjects());
                count.setCheckReportFileIds(checkTypeInfo.getCheckReportFileIds());
                count.setOtherFileIds(checkTypeInfo.getOtherFileIds());
                count.setNeedChecks(checkTypeInfo.getNeedChecks());
                count.setCheckTypeName(CheckTypeEnum.getThirdOrgName((String)checkType));
            }
            count.setHarmIds((count.getHarmIds() == null ? "" : count.getHarmIds()) + (String)(checkTypeInfo.getHarmFactor() == null ? "" : "," + checkTypeInfo.getHarmFactor()));
            Long staffId = checkTypeInfo.getStaffId();
            String examResult = checkTypeInfo.getExamResult();
            if (staffId != null) {
                count.getCheckStaffIds().add(staffId);
            }
            if ((gender = checkTypeInfo.getGender()) != null && gender == StaffGenderEnum.FEMALE.getValue()) {
                count.getWomenStaffIds().add(staffId);
            } else if (gender != null && gender == StaffGenderEnum.MALE.getValue()) {
                count.getManStaffIds().add(staffId);
            }
            if (ExamResultEnum.so.getCode().equals(examResult)) {
                count.getSdStaffIds().add(staffId);
            } else if (ExamResultEnum.oc.getCode().equals(examResult)) {
                count.getOcStaffIds().add(staffId);
            } else if (ExamResultEnum.recheck.getCode().equals(examResult)) {
                count.getRecheckStaffIds().add(staffId);
            } else if (ExamResultEnum.mis.getCode().equals(examResult)) {
                count.getMissingStaffIds().add(staffId);
            }
            countMap.put(checkType, count);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            CheckTypeCount count = (CheckTypeCount)entry.getValue();
            count.setHarmNames(this.harmFactorService.getHarmNames(count.getHarmIds()));
            counts.add(count);
        }
        return counts;
    }

    private void setFiles(PhcPhysicalCheck data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List allFiles = this.fileService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (PhcPhysicalCheckFile file : allFiles) {
            switch (file.getFileType()) {
                case 1: {
                    data.getReportFiles().add(file);
                    break;
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheck insertOrUpdate(PhcPhysicalCheck data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        data.setCid(cid);
        data.setUpdateBy(staffId);
        data.setUpdateDate(new Date());
        if (data.getId() == null) {
            data.setCreateBy(staffId);
            data.setCreateDate(new Date());
            data.setIsValid(Boolean.valueOf(true));
            data = this.add(data, staffId, cid);
        } else {
            ((PhcPhysicalCheckMapper)this.dao).updateById(data);
        }
        this.checkTypeService.updateTypesByParent(data);
        this.fileService.updateFilesByParent(data);
        this.reportService.addReportByCheck(data);
        this.dataService.deleteByCheck(data);
        this.addSuspectedDiseasers(data);
        this.updateTip(data, cid, staffId);
        return data;
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheck finishedInfo(PhcPhysicalCheck data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        data.setCid(cid);
        data.setUpdateBy(staffId);
        data.setUpdateDate(new Date());
        if (data.getId() == null) {
            data.setCreateBy(staffId);
            data.setCreateDate(new Date());
            data.setIsValid(Boolean.valueOf(true));
            data = this.add(data, staffId, cid);
        } else {
            ((PhcPhysicalCheckMapper)this.dao).updateById(data);
        }
        this.fileService.updateFilesByParent(data);
        return data;
    }

    private void addSuspectedDiseasers(PhcPhysicalCheck data) {
        if (data.getStatus() == null) {
            return;
        }
        if (data.getStatus() == 1) {
            this.resultService.addSuspectedDiseasersByCheckId(data.getId());
        }
    }

    private void updateTip(PhcPhysicalCheck data, Long cid, Long staffId) {
        if (data.getStatus() == null) {
            return;
        }
        if (data.getFromType() == null) {
            return;
        }
        CoreWorkEnum desCoreWork = CoreWorkEnum.healthCheck;
        CoreWorkEnum sourceCoreWork = CoreWorkEnum.getCoreWorkEnum((Byte)data.getFromType());
        if (data.getStatus() == 0) {
            this.sysService.businessStart(desCoreWork, sourceCoreWork, data.getId(), staffId, cid, new Long[]{data.getFromId()});
        } else if (data.getStatus() == 1) {
            this.sysService.businessComplete(desCoreWork, sourceCoreWork, data.getId(), staffId, cid, new Long[]{data.getFromId()});
        }
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long updateBy, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(PhcPhysicalCheck.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        PhcPhysicalCheck data = new PhcPhysicalCheck();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(updateBy);
        ((PhcPhysicalCheckMapper)this.dao).updateByExampleSelective(data, example);
        for (Long id : idArray) {
            this.sysService.businessDelete(CoreWorkEnum.healthCheck, id, updateBy, cid);
        }
    }

    private List<PhcPhysicalCheck> listReportData(PhcPhysicalCheckParam data) {
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        data.setKeywordEncrypt(data.getKeyword());
        List<PhcPhysicalCheck> list = ((PhcPhysicalCheckMapper)this.dao).listReportData(data);
        if (list != null) {
            for (PhcPhysicalCheck check : list) {
                check.setManagerName(SpringEncryptUtils.decrypt((String)check.getManagerName()));
                List<PhcPhysicalCheckResultCount> confirmation = ((PhcPhysicalCheckMapper)this.dao).getConfirmationByCheckId(check.getId());
                if (confirmation == null) continue;
                for (PhcPhysicalCheckResultCount con : confirmation) {
                    if (con.getCheckType() == null) continue;
                    if (con.getCheckType().intValue() == 0) {
                        check.setNotViewNum(con.getTotal());
                        continue;
                    }
                    if (con.getCheckType().intValue() == 1) {
                        check.setUnconfirmedNum(con.getTotal());
                        continue;
                    }
                    if (con.getCheckType().intValue() != 2) continue;
                    check.setSignedNum(con.getTotal());
                }
            }
        }
        return list;
    }

    public List<PhcPhysicalCheck> listDetails(PhcPhysicalCheckParam data) {
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        data.setKeywordEncrypt(data.getKeyword());
        List<PhcPhysicalCheck> list = ((PhcPhysicalCheckMapper)this.dao).getListByQuery(data);
        if (list == null || list.isEmpty()) {
            return list;
        }
        for (PhcPhysicalCheck l : list) {
            l.setManagerName(SpringEncryptUtils.decrypt((String)l.getManagerName()));
            if (l.getManager() == null) continue;
            l.setManagerName(this.staffService.getStaffNameIncludeDelStatusByStaffId(l.getManager()));
        }
        return list;
    }

    public PageInfo<PhcPhysicalCheck> getList(JqGridParam gparam, PhcPhysicalCheckParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        this.setOrder(gparam, param);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    public PageInfo<PhcPhysicalCheck> getReportPage(JqGridParam gparam, PhcPhysicalCheckParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        this.setOrder(gparam, param);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listReportData(param));
    }

    public Integer getReportNum(PhcPhysicalCheckParam param) {
        if (param == null || param.getCid() == null) {
            return 0;
        }
        return ((PhcPhysicalCheckMapper)this.dao).getReportNum(param);
    }

    public Map<Integer, Map<String, Integer>> getCheckTypeNum(PhcPhysicalCheckParam param) {
        HashMap<Integer, Map<String, Integer>> map = new HashMap<Integer, Map<String, Integer>>();
        if (param == null || param.getCid() == null) {
            return map;
        }
        List<CheckTypeInfo> list = ((PhcPhysicalCheckMapper)this.dao).getCheckTypeNum(param);
        if (list != null) {
            for (CheckTypeInfo info : list) {
                HashMap<String, Integer> yearMap = (HashMap<String, Integer>)map.get(info.getCheckYear());
                if (yearMap == null) {
                    yearMap = new HashMap<String, Integer>();
                }
                yearMap.put(info.getCheckType(), info.getNeedChecks());
                String year = info.getCheckYear().toString();
                Integer total = (Integer)yearMap.get(year);
                total = total == null ? info.getNeedChecks() : Integer.valueOf(total + info.getNeedChecks());
                yearMap.put(year, total);
                map.put(info.getCheckYear(), yearMap);
            }
        }
        return map;
    }

    private void setOrder(JqGridParam gparam, PhcPhysicalCheckParam param) {
        if ("checkDate".equals(gparam.getSidx())) {
            param.setOrder("c.begin_time " + gparam.getSord());
        } else if ("workName".equals(gparam.getSidx())) {
            param.setOrder("c.work_name " + gparam.getSord());
        } else if ("managerName".equals(gparam.getSidx())) {
            param.setOrder("b.real_name " + gparam.getSord());
        } else if ("updateDate".equals(gparam.getSidx())) {
            param.setOrder("c.update_date " + gparam.getSord());
        }
    }

    public PhcYearCheckInfo countYearCheckInfo(PhcYearCheckInfo params) {
        if (params == null || params.getYear() == null || params.getCid() == null) {
            return params;
        }
        DataScopeHelper.startDataScope("healthCheck", "phc_occupational_diseaser");
        DataScope dataScope = DataScopeHelper.getDataScope();
        params.setDiseasers(this.diseaserService.countYearDiseasers(params));
        dataScope.setMainTableName("phc_occupational_diseaser");
        DataScopeHelper.setDataScope(dataScope);
        params.setDiagnosedType(DiagnosedTypeEnum.diagnosed.getCode());
        params.setDiagnoseDiseasers(this.diseaserService.countYearDiseasers(params));
        dataScope.setMainTableName("phc_physical_check");
        DataScopeHelper.setDataScope(dataScope);
        List<PhcDieaserReportInfo> results = ((PhcPhysicalCheckMapper)this.dao).countYearCheckInfo(params);
        if (results == null || results.size() == 0) {
            return params;
        }
        HashSet<Long> checkIds = new HashSet<Long>();
        HashMap resultMap = new HashMap();
        HashSet<CallSite> staffChecks = new HashSet<CallSite>();
        HashSet<Long> staffs = new HashSet<Long>();
        HashSet<Long> sos = new HashSet<Long>();
        HashSet<Long> diagnoseDiseaser = new HashSet<Long>();
        int resultCount = 0;
        for (PhcDieaserReportInfo phcDieaserReportInfo : results) {
            Long checkId = phcDieaserReportInfo.getCheckId();
            checkIds.add(checkId);
            Byte checkType = phcDieaserReportInfo.getCheckType();
            Long staffId = phcDieaserReportInfo.getStaffId();
            if (staffId == null) continue;
            String examResult = String.valueOf(phcDieaserReportInfo.getExamResult());
            String staffCheck = checkId + "_" + checkType + "_" + staffId;
            staffs.add(staffId);
            staffChecks.add((CallSite)((Object)staffCheck));
            Set<CallSite> examResultSet = resultMap.get(examResult) == null ? new HashSet() : (Set)resultMap.get(examResult);
            examResultSet.add((CallSite)((Object)staffCheck));
            resultMap.put(examResult, examResultSet);
            if (!ExamResultEnum.so.getCode().equals(examResult)) continue;
            Date beginTime = phcDieaserReportInfo.getBeginTime();
            if (beginTime != null && DateUtils.getYear((Date)beginTime) == DateUtils.getThisYear() && ExamResultEnum.so.getCode().equals(examResult)) {
                sos.add(staffId);
            }
            if (phcDieaserReportInfo.getIsFinish() == null || !phcDieaserReportInfo.getIsFinish().booleanValue() || phcDieaserReportInfo.getIsDisease() == null || !phcDieaserReportInfo.getIsDisease().booleanValue()) continue;
            diagnoseDiseaser.add(staffId);
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            Set value = (Set)entry.getValue();
            String key = (String)entry.getKey();
            int valueCount = value == null ? 0 : value.size();
            resultCount += valueCount;
            if (ExamResultEnum.noraml.getCode().equals(key)) {
                params.setNormal(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.recheck.getCode().equals(key)) {
                params.setRecheck(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.so.getCode().equals(key)) {
                params.setSd(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.oc.getCode().equals(key)) {
                params.setOc(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.other.getCode().equals(key)) {
                params.setOther(Integer.valueOf(valueCount));
                continue;
            }
            if (!ExamResultEnum.mis.getCode().equals(key)) continue;
            params.setMissing(Integer.valueOf(valueCount));
        }
        params.setNewSd(Integer.valueOf(sos.size()));
        params.setCheckCount(Integer.valueOf(staffs.size()));
        params.setCheckStaffs(Integer.valueOf(staffChecks.size()));
        params.setResultCount(Integer.valueOf(resultCount));
        params.setCheckTimes(Integer.valueOf(checkIds.size()));
        return params;
    }

    @Transactional(readOnly=false)
    public List<String> importCheckResult(List<List<String>> contents, PhcPhysicalCheckQuery param, Long cid, Long createBy) {
        ArrayList<String> checkResults = new ArrayList<String>();
        if (contents == null || contents.size() == 0) {
            checkResults.add("excel\u4e2d\u6ca1\u6709\u6570\u636e\u5bfc\u5165");
            return checkResults;
        }
        if (param == null || param.getCheckId() == null || param.getCheckType() == null) {
            checkResults.add("\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
            return checkResults;
        }
        Map<String, List<PhcPhysicalCheckData>> checkDatas = this.getCheckDataByCheck(param);
        List<Long> normalStaffIds = this.getNormalStaffIdsByCheckId(param);
        HashMap<Long, Set<Byte>> staffIdAndResults = new HashMap<Long, Set<Byte>>();
        HashMap<String, PhcPhysicalCheckData> importData = new HashMap<String, PhcPhysicalCheckData>();
        for (List<String> content : contents) {
            String importResult = this.setResult(checkDatas, content, normalStaffIds, staffIdAndResults, param, createBy, cid, importData);
            if (!StringUtils.isNotEmpty((String)importResult)) continue;
            checkResults.add(importResult);
        }
        if (checkResults.size() == 0) {
            checkResults.add("\u5bfc\u5165\u6210\u529f");
        }
        return checkResults;
    }

    private PhcPhysicalCheckData getCheckData(Map<String, List<PhcPhysicalCheckData>> dataMap, String name, String idCard, PhcPhysicalCheckQuery param, Long cid, String workName, String harmIds) {
        List<PhcPhysicalCheckData> datas = dataMap.get(name);
        PhcPhysicalCheckData data = null;
        if (datas != null && datas.size() == 1) {
            data = datas.get(0);
        } else if (datas != null && datas.size() > 1) {
            for (PhcPhysicalCheckData d : datas) {
                if (!idCard.equals(d.getIdCard())) continue;
                data = d;
                break;
            }
        }
        if (data == null) {
            StaffBasicVo staffBasicVo = this.staffService.getOrAddStaffInfoByQuery(cid, name, idCard, workName, harmIds, null);
            if (staffBasicVo == null) {
                return null;
            }
            data = new PhcPhysicalCheckData();
            data.setStaffId(staffBasicVo.getStaffId());
            data.setStaffName(staffBasicVo.getStaffName());
            data.setStaffWorkNo(staffBasicVo.getWorkNo());
            data.setStaffDeptId(staffBasicVo.getDeptId());
            data.setStaffDeptName(staffBasicVo.getDeptName());
            data.setStaffWorkId(staffBasicVo.getWorkId());
            data.setStaffWorkName(staffBasicVo.getWorkName());
            data.setCheckId(param.getCheckId());
            data.setCheckType(param.getCheckType());
            data.setIsJoin(Boolean.valueOf(true));
            data.setIsValid(Boolean.valueOf(true));
        }
        return data;
    }

    private String setResult(Map<String, List<PhcPhysicalCheckData>> dataMap, List<String> content, List<Long> normalStaffIds, Map<Long, Set<Byte>> staffIdAndResults, PhcPhysicalCheckQuery param, Long createBy, Long cid, Map<String, PhcPhysicalCheckData> importData) {
        String importResult = null;
        if (content == null || content.size() < 2) {
            return importResult;
        }
        PhcPhysicalCheckDataResult resultInfo = new PhcPhysicalCheckDataResult();
        String resultTypeName = StringUtils.isNotEmpty((String)content.get(content.size() - 1)) ? content.get(content.size() - 1).trim() : "";
        String name = StringUtils.isNotEmpty((String)content.get(0)) ? content.get(0).trim() : "";
        String idCard = StringUtils.isNotEmpty((String)content.get(1)) ? content.get(1).trim() : "";
        String workName = content.size() >= 4 && StringUtils.isNotEmpty((String)content.get(3)) ? content.get(3).trim() : "";
        String harmNames = content.size() >= 5 && StringUtils.isNotEmpty((String)content.get(4)) ? content.get(3).trim() : "";
        String importDataKey = name + "_" + idCard;
        PhcPhysicalCheckData data = importData.get(importDataKey);
        String harmIds = null;
        if (!harmNames.isEmpty()) {
            harmIds = this.harmFactorService.getHarmIdsByNames(harmNames);
        }
        if (data == null) {
            data = this.getCheckData(dataMap, name, idCard, param, cid, workName, harmIds);
        }
        if (data == null) {
            return resultTypeName + "\u4e2d\u59d3\u540d\u4e3a:" + name + "\u7684\u5458\u5de5\u4e0d\u5b58\u5728\u672c\u4f01\u4e1a\u4e2d\u6216\u8be5\u5458\u5de5\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5339\u914d";
        }
        if (data.getId() == null) {
            this.dataService.add((Object)data, createBy, cid);
        }
        importData.put(importDataKey, data);
        Byte examResult = null;
        if (ExamResultEnum.noraml.getName().equals(resultTypeName)) {
            examResult = Byte.parseByte(ExamResultEnum.noraml.getCode());
        } else if (ExamResultEnum.recheck.getName().equals(resultTypeName)) {
            examResult = Byte.parseByte(ExamResultEnum.recheck.getCode());
            if (content.size() >= 5) {
                resultInfo.setAbnormal(content.get(2));
                resultInfo.setCheckAdvice(content.get(3));
            }
        } else if (ExamResultEnum.so.getName().equals(resultTypeName)) {
            examResult = Byte.parseByte(ExamResultEnum.so.getCode());
            if (content.size() >= 7) {
                resultInfo.setHarmYear(content.get(2));
                resultInfo.setAbnormal(content.get(3));
                resultInfo.setHarmDesc(content.get(4));
                resultInfo.setCheckAdvice(content.get(5));
            }
        } else if (ExamResultEnum.oc.getName().equals(resultTypeName)) {
            examResult = Byte.parseByte(ExamResultEnum.oc.getCode());
            if (content.size() >= 6) {
                resultInfo.setAbnormal(content.get(2));
                resultInfo.setHarmDesc(content.get(3));
                resultInfo.setCheckAdvice(content.get(4));
            }
        } else if (ExamResultEnum.other.getName().equals(resultTypeName)) {
            examResult = Byte.parseByte(ExamResultEnum.other.getCode());
        } else if (ExamResultEnum.mis.getName().equals(resultTypeName)) {
            examResult = Byte.parseByte(ExamResultEnum.mis.getCode());
            if (content.size() >= 7) {
                resultInfo.setMissingItems(content.get(2));
                resultInfo.setAbnormal(content.get(3));
                resultInfo.setCheckAdvice(content.get(4));
                resultInfo.setMedicalAdvice(content.get(5));
            }
        }
        HashSet<Byte> alreadyImprotResults = staffIdAndResults.get(data.getStaffId()) == null ? new HashSet<Byte>() : staffIdAndResults.get(data.getStaffId());
        resultInfo.setDataId(data.getId());
        data.setExamResult(examResult);
        resultInfo.setExamResult(examResult);
        if (ExamResultEnum.noraml.getCode().equals(String.valueOf(examResult))) {
            if (alreadyImprotResults.size() > 0 && !alreadyImprotResults.contains((byte)1)) {
                alreadyImprotResults.add(resultInfo.getExamResult());
                staffIdAndResults.put(data.getStaffId(), alreadyImprotResults);
                return resultTypeName + "\u4e2d\u59d3\u540d\u4e3a:" + name + "\u7684\u5458\u5de5\u5df2\u5bfc\u5165\u5f02\u5e38\u6570\u636e";
            }
            this.resultService.deleteByDataId(String.valueOf(data.getId()));
        } else {
            if (alreadyImprotResults.contains((byte)1)) {
                alreadyImprotResults.add(resultInfo.getExamResult());
                staffIdAndResults.put(data.getStaffId(), alreadyImprotResults);
                return resultTypeName + "\u4e2d\u59d3\u540d\u4e3a:" + name + "\u7684\u5458\u5de5\u5df2\u5f55\u5165\u672a\u89c1\u5f02\u5e38";
            }
            if (normalStaffIds.contains(data.getStaffId())) {
                PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
                result.setDataId(resultInfo.getDataId());
                result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.noraml.getCode())));
                this.resultService.deleteByInfo(result);
                this.deleteByDataIdAndResult(resultInfo.getDataId(), Byte.parseByte(ExamResultEnum.noraml.getCode()));
            }
            if (ExamResultEnum.other.getCode().equals(String.valueOf(examResult))) {
                this.deleteByDataIdAndResult(resultInfo.getDataId(), Byte.parseByte(ExamResultEnum.other.getCode()));
            }
        }
        resultInfo = (PhcPhysicalCheckDataResult)this.resultService.add((Object)resultInfo, createBy, cid);
        if (resultInfo.getId() == null) {
            importResult = resultTypeName + "\u4e2d\u59d3\u540d\u4e3a:" + name + "\u7684\u5458\u5de5\u4f53\u68c0\u7ed3\u679c\u5f55\u5165\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        } else {
            alreadyImprotResults.add(resultInfo.getExamResult());
            staffIdAndResults.put(data.getStaffId(), alreadyImprotResults);
        }
        return importResult;
    }

    private void deleteByDataIdAndResult(Long dataId, Byte examResult) {
        PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
        result.setDataId(dataId);
        result.setExamResult(examResult);
        this.resultService.deleteByInfo(result);
    }

    private Map<String, List<PhcPhysicalCheckData>> getCheckDataByCheck(PhcPhysicalCheckQuery param) {
        HashMap<String, List<PhcPhysicalCheckData>> datas = new HashMap<String, List<PhcPhysicalCheckData>>();
        List checkDatas = this.dataService.getByCheckInfo(param);
        if (checkDatas == null || checkDatas.size() == 0) {
            return datas;
        }
        for (PhcPhysicalCheckData data : checkDatas) {
            String key = data.getStaffName();
            List<PhcPhysicalCheckData> listDatas = datas.get(key) == null ? new ArrayList() : (List)datas.get(key);
            listDatas.add(data);
            datas.put(key, listDatas);
        }
        return datas;
    }

    private List<Long> getNormalStaffIdsByCheckId(PhcPhysicalCheckQuery param) {
        List datas = this.resultService.getNormalStaffIdsByCheck(param);
        return datas;
    }

    public List<PhcPhysicalCheck> unreportList(PhcPhysicalCheckParam data) {
        data.setKeywordEncrypt(data.getKeyword());
        List<PhcPhysicalCheck> phcPhysicalChecks = ((PhcPhysicalCheckMapper)this.dao).unreportList(data);
        if (CollectionUtil.isNotEmpty(phcPhysicalChecks)) {
            phcPhysicalChecks.forEach(p -> p.setManagerName(SpringEncryptUtils.decrypt((String)p.getManagerName())));
        }
        return phcPhysicalChecks;
    }

    public Boolean hasThisYearChecked(CheckTipQuery query) {
        int count = ((PhcPhysicalCheckMapper)this.dao).countThisYearChecks(query);
        return count > 0;
    }

    public Integer countConfired(PhcPhysicalCheckParam data) {
        return ((PhcPhysicalCheckMapper)this.dao).countConfired(data);
    }

    public Integer getStaffCheckCount(PhcPhysicalCheckParam param) {
        if (param == null || param.getCid() == null) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        return ((PhcPhysicalCheckMapper)this.dao).getStaffCheckCount(param);
    }

    @Transactional(readOnly=false)
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        if (detail == null) {
            return null;
        }
        PhcPhysicalCheck data = new PhcPhysicalCheck();
        data.setWorkName(detail.getBusinessName());
        data.setNo(this.businessNoService.getBusinessNo(detail.getCid(), BusinessNoTypeEnum.HEALTHCHECK.getCode()));
        data.setBeginTime(detail.getBusinessPlantime());
        data.setEndTime(detail.getBusinessPlantime());
        data.setManager(detail.getManagerId());
        data.setStatus(Byte.valueOf((byte)0));
        data.setIsValid(Boolean.valueOf(true));
        this.add(data, detail.getCreatorBy(), detail.getCid());
        this.setCheckTypeByPlanYear(detail, data);
        this.checkTypeService.updateTypesByParent(data);
        return data.getId();
    }

    private void setCheckTypeByPlanYear(PlanYearSyncSO detail, PhcPhysicalCheck data) {
        if (StringUtils.isEmpty((CharSequence)detail.getWorkSubtype())) {
            return;
        }
        ArrayList<PhcPhysicalCheckType> checkTypes = new ArrayList<PhcPhysicalCheckType>();
        PhcPhysicalCheckType checkType = new PhcPhysicalCheckType();
        checkType.setCheckType(Byte.valueOf(Byte.parseByte(detail.getWorkSubtype())));
        checkTypes.add(checkType);
        data.setCheckTypes(checkTypes);
    }

    public Date getLastYearCheckDate(CheckTipQuery query) {
        if (query == null || query.getCid() == null) {
            return null;
        }
        return ((PhcPhysicalCheckMapper)this.dao).getLastYearCheckDate(query);
    }

    public List<HHealthCheckModel> getHealthCheckList(PageParamModel paramModel) {
        if (paramModel == null) {
            return null;
        }
        List<Long> staffIds = this.getStaffIdsByIdCardAndCid(paramModel.getIdCard(), paramModel.getCid());
        if (staffIds == null || staffIds.size() == 0) {
            return null;
        }
        HHealthCheckParam param = new HHealthCheckParam();
        param.setBeginTime(paramModel.getStartDate());
        param.setCheckStaffs(staffIds);
        List<HHealthCheckInfo> checkInfos = ((PhcPhysicalCheckMapper)this.dao).getHealthCheckList(param);
        List<HHealthCheckModel> checks = this.convertCheckInfos(checkInfos, false);
        return checks;
    }

    public PageInfo<HHealthCheckModel> getHealthCheckPage(PageParamModel paramModel) {
        if (paramModel == null) {
            return null;
        }
        List<Long> staffIds = this.getStaffIdsByIdCardAndCid(paramModel.getIdCard(), paramModel.getCid());
        if (staffIds.size() == 0) {
            return null;
        }
        HHealthCheckParam param = new HHealthCheckParam();
        param.setBeginTime(paramModel.getStartDate());
        param.setCheckStaffs(staffIds);
        if (paramModel.getPageInfo() != null) {
            PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
        }
        List<HHealthCheckInfo> checkInfos = ((PhcPhysicalCheckMapper)this.dao).getHealthCheckList(param);
        PageInfo pageInfo = new PageInfo(checkInfos);
        List<HHealthCheckModel> checks = this.convertCheckInfos(checkInfos, true);
        PageInfo p = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)p);
        p.setList(checks);
        return p;
    }

    private List<HHealthCheckModel> convertCheckInfos(List<HHealthCheckInfo> checkInfos, boolean includeNormal) {
        ArrayList<HHealthCheckModel> results = new ArrayList<HHealthCheckModel>();
        TreeMap<CallSite, HHealthCheckModel> resultMap = new TreeMap<CallSite, HHealthCheckModel>();
        if (checkInfos == null || checkInfos.size() == 0) {
            return null;
        }
        for (HHealthCheckInfo hHealthCheckInfo : checkInfos) {
            String key = hHealthCheckInfo.getId() + "_" + hHealthCheckInfo.getStaffId() + "_" + hHealthCheckInfo.getCheckType();
            HHealthCheckModel model = resultMap.get(key) == null ? this.createNewModel(hHealthCheckInfo) : (HHealthCheckModel)resultMap.get(key);
            HHealthCheckConclusionModel detailModel = null;
            detailModel = includeNormal ? this.createDetailModelIncludeNormal(hHealthCheckInfo) : this.createDetailModel(hHealthCheckInfo);
            if (detailModel == null) continue;
            model.getConclusionList().add(detailModel);
            resultMap.put((CallSite)((Object)key), model);
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            results.add((HHealthCheckModel)entry.getValue());
        }
        Collections.sort(results, new Comparator<HHealthCheckModel>(){

            @Override
            public int compare(HHealthCheckModel o1, HHealthCheckModel o2) {
                return o2.getStartDate().compareTo(o1.getStartDate());
            }
        });
        return results;
    }

    private HHealthCheckConclusionModel createDetailModel(HHealthCheckInfo check) {
        if (StringUtils.isEmpty((CharSequence)check.getExamResult()) || ExamResultEnum.noraml.getCode().equals(check.getExamResult())) {
            return null;
        }
        return this.toHHealthCheckConclusionModel(check);
    }

    private HHealthCheckConclusionModel createDetailModelIncludeNormal(HHealthCheckInfo check) {
        return this.toHHealthCheckConclusionModel(check);
    }

    private HHealthCheckConclusionModel toHHealthCheckConclusionModel(HHealthCheckInfo check) {
        HHealthCheckConclusionModel detailModel = new HHealthCheckConclusionModel();
        detailModel.setCheckadvice(check.getCheckAdvice());
        detailModel.setDealinfo(check.getDealDesc());
        detailModel.setDealTypeName(DealTypeEnum.getName((String)check.getDealType()));
        detailModel.setExamresults(ExamResultEnum.getName((String)check.getExamResult()));
        detailModel.setInfodesc(check.getInfoDesc());
        detailModel.setNameCh(check.getNameCH());
        if (check.getHarmDesc() != null) {
            detailModel.setHarmDesc("\u7591\u4f3c" + check.getHarmDesc());
        }
        return detailModel;
    }

    private HHealthCheckModel createNewModel(HHealthCheckInfo check) {
        HHealthCheckModel model = new HHealthCheckModel();
        model.setCheckType(check.getCheckType());
        model.setChecktypeName(CheckTypeEnum.getName((String)check.getCheckType()));
        model.setEndDate(check.getEndTime());
        model.setHealthCheckId(check.getId());
        model.setStaffId(check.getStaffId());
        model.setStartDate(check.getBeginTime());
        model.setReadState(check.getConfirmation());
        ArrayList conclusionList = new ArrayList();
        model.setConclusionList(conclusionList);
        return model;
    }

    private List<Long> getStaffIdsByIdCardAndCid(String idCard, Long cid) {
        ArrayList<Long> staffIds = new ArrayList<Long>();
        List staffInfos = this.staffService.getStaffInfoByCardId(idCard, cid);
        if (staffInfos == null || staffInfos.size() == 0) {
            return staffIds;
        }
        for (StaffInfo staffInfo : staffInfos) {
            staffIds.add(staffInfo.getId());
        }
        return staffIds;
    }

    public HHealthCheckModel getHealthCheckList(HHealthCheckParam param) {
        if (param == null) {
            return null;
        }
        List<HHealthCheckInfo> checkInfos = ((PhcPhysicalCheckMapper)this.dao).getHealthCheckList(param);
        List<HHealthCheckModel> checks = this.convertCheckInfos(checkInfos, false);
        return checks == null || checks.size() == 0 ? null : checks.get(0);
    }

    public PageInfo<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfosPageBySearch(JqGridParam gparam, HealthCheckStaffInfoQuery query) {
        if (gparam == null || query == null || query.getCid() == null) {
            return null;
        }
        List<Long> staffIds = this.setStaffIds(query);
        if (staffIds == null || staffIds.isEmpty()) {
            return null;
        }
        query.setIncludeStaffIds(staffIds);
        PageInfo pages = this.staffService.getRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        if (pages == null || pages.getList() == null) {
            return pages;
        }
        this.setStaffOtherInfos(pages.getList(), query);
        return pages;
    }

    private void setStaffOtherInfos(List<HealthCheckStaffInfoVo> list, HealthCheckStaffInfoQuery query) {
        if (list.size() == 0) {
            return;
        }
        String splitor = ",";
        Long cid = query.getCid();
        for (HealthCheckStaffInfoVo l : list) {
            Long workId = l.getWorkId();
            this.setStaffLastCheckTime(cid, l);
            HealthCheckStaffInfoVo recommendCheks = this.harmfactorWorkService.getRecommedCheckInfo(cid, workId, query.getMust(), query.getChoose(), splitor);
            l.setChooseChecks(recommendCheks.getChooseChecks());
            l.setMustChecks(recommendCheks.getMustChecks());
            List<Long> allWorkIds = this.getAllWorkIds(l);
            l.setHarms(this.harmfactorWorkService.getHarmNamesByWorks(cid, allWorkIds, "\u3001"));
        }
    }

    private List<Long> getAllWorkIds(HealthCheckStaffInfoVo l) {
        ArrayList<Long> all = new ArrayList<Long>();
        if (l.getWorkId() != null) {
            all.add(l.getWorkId());
        }
        return all;
    }

    private void setStaffLastCheckTime(Long cid, HealthCheckStaffInfoVo l) {
        PhcPhysicalCheckQuery query = new PhcPhysicalCheckQuery();
        query.setCid(cid);
        query.setStaffId(l.getStaffId());
        List<PhcPhysicalCheckLastCheckTime> timeInfos = ((PhcPhysicalCheckMapper)this.dao).saffLastCheckedTime(query);
        if (timeInfos == null || timeInfos.size() == 0) {
            return;
        }
        PhcPhysicalCheckLastCheckTime timeInfo = timeInfos.get(0);
        l.setLastCheckId(timeInfo.getCheckId());
        Object lastCheckTime = "";
        lastCheckTime = DateUtils.formatCheckTime((Date)timeInfo.getLastCheckBeginTime(), (Date)timeInfo.getLastCheckEndTime(), (String)" \u81f3 ");
        if (StringUtils.isNotEmpty((String)timeInfo.getLastCheckType())) {
            lastCheckTime = (String)lastCheckTime + "(" + CheckTypeEnum.getShortName((String)timeInfo.getLastCheckType()) + ")";
        }
        l.setLastCheckTime((String)lastCheckTime);
    }

    private List<Long> getHarmAndUncheckStaffs(Long cid, Byte checkType, Integer year, StaffWorkStatusEnum staffWorkStatus) {
        List<Long> includeStaffIds = this.getHarmStaffs(cid, checkType, year, staffWorkStatus);
        if (includeStaffIds == null || includeStaffIds.isEmpty()) {
            return null;
        }
        return includeStaffIds;
    }

    private List<Long> setStaffIds(HealthCheckStaffInfoQuery query) {
        Byte checkType = Byte.parseByte(CheckTypeEnum.on.getCode());
        Integer year = DateUtils.getThisYear();
        List<Long> includeStaffIds = this.getHarmStaffs(query.getCid(), checkType, year, StaffWorkStatusEnum.ONWORKING);
        if (includeStaffIds == null || includeStaffIds.isEmpty()) {
            return null;
        }
        if (query.getLastCheckBeginTime() != null || query.getLastCheckEndTime() != null) {
            return this.getLastCheckTimeStaffIds(query.getCid(), checkType, year, query.getLastCheckBeginTime(), query.getLastCheckEndTime(), includeStaffIds);
        }
        return includeStaffIds;
    }

    private List<Long> getLastCheckTimeStaffIds(Long cid, Byte checkType, Integer year, Date lastCheckBeginTime, Date lastCheckEndTime, List<Long> includeStaffIds) {
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCheckType(checkType);
        param.setCid(cid);
        param.setCheckYear(year);
        param.setBeginTime(lastCheckBeginTime);
        param.setEndTime(lastCheckEndTime);
        param.setIncludeStaffs(includeStaffIds);
        List<Long> checkStaffIds = ((PhcPhysicalCheckMapper)this.dao).lastCheckedStaffs(param);
        return checkStaffIds;
    }

    private List<Long> getHarmStaffs(Long cid, Byte checkType, Integer year, StaffWorkStatusEnum staffWorkStatus) {
        ArrayList<Long> harmStaffIds = new ArrayList<Long>();
        List harmStaffs = this.staffService.getHarmStaffIdsByCidAndStatus(cid, staffWorkStatus);
        if (harmStaffs == null || harmStaffs.size() == 0) {
            return harmStaffIds;
        }
        List ignoredStaffs = this.ignoredService.getIgnoredStaffIds(cid, checkType, year);
        for (StaffInfo staff : harmStaffs) {
            Long workId;
            Long staffId;
            StaffWorkRole staffWorkRole = staff.getStaffWorkRole();
            if (staffWorkRole == null || staffWorkRole.getWorkRoleId() == null || this.isIgnored(staffId = staff.getId(), workId = staffWorkRole.getWorkRoleId(), ignoredStaffs) || this.isChecked(staffId, workId, checkType, cid, year)) continue;
            harmStaffIds.add(staffId);
        }
        return harmStaffIds;
    }

    private boolean isChecked(Long staffId, Long workId, Byte checkType, Long cid, Integer year) {
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCheckType(checkType);
        param.setCid(cid);
        param.setCheckYear(year);
        param.setStaffId(staffId);
        param.setWorkId(workId);
        List<Long> excludeStaffs = ((PhcPhysicalCheckMapper)this.dao).checkedStaffs(param);
        return excludeStaffs != null && !excludeStaffs.isEmpty();
    }

    private boolean isIgnored(Long staffId, Long workId, List<PhcPhysicalCheckRecommendIgnored> ignoredStaffs) {
        if (ignoredStaffs == null || ignoredStaffs.isEmpty()) {
            return false;
        }
        for (PhcPhysicalCheckRecommendIgnored i : ignoredStaffs) {
            Long ignoredStaffId = i.getStaffId();
            Long ignoredStaffWorkId = i.getWorkId();
            if (ignoredStaffId == null || ignoredStaffWorkId == null || staffId.longValue() != ignoredStaffId.longValue() || workId.longValue() != ignoredStaffWorkId.longValue()) continue;
            return true;
        }
        return false;
    }

    public List<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfos(HealthCheckStaffInfoQuery query) {
        if (query == null || query.getCid() == null) {
            return null;
        }
        List<Long> staffIds = this.setStaffIds(query);
        if (staffIds == null || staffIds.isEmpty()) {
            return null;
        }
        query.setIncludeStaffIds(staffIds);
        List list = this.staffService.getRecommendHealthCheckStaffInfosBySearch(query);
        if (list == null || list.isEmpty()) {
            return list;
        }
        this.setStaffOtherInfos(list, query);
        return list;
    }

    @Transactional(readOnly=false)
    public void cancelByIds(String ids, Long staffId, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(PhcPhysicalCheck.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        PhcPhysicalCheck data = new PhcPhysicalCheck();
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        data.setStatus(Byte.valueOf((byte)2));
        ((PhcPhysicalCheckMapper)this.dao).updateByExampleSelective(data, example);
        this.reportService.deleteByCheckIds(idArray);
        this.resultService.deleteDieasersByCheckIds(idArray);
    }

    public Date getLastPhcCheckDateJobing(Long cid) {
        if (cid == null) {
            return null;
        }
        return ((PhcPhysicalCheckMapper)this.dao).getLastPhcCheckDateByCidAndCheckType(cid, CheckTypeEnum.on.getCode());
    }

    public Date getFirstPhcCheckDateByCidAndCheckTypeAndYear(Long cid, Integer year) {
        if (cid == null) {
            return null;
        }
        return ((PhcPhysicalCheckMapper)this.dao).getFirstPhcCheckDateByCidAndCheckTypeAndYear(cid, CheckTypeEnum.on.getCode(), year);
    }

    public int getPhcCheckNumJobing(Long cid) {
        if (cid == null) {
            return 0;
        }
        return ((PhcPhysicalCheckMapper)this.dao).getPhcCheckNumByCidAndCheckType(cid, CheckTypeEnum.on.getCode());
    }

    public PhcCheckInfo getPhcCheckInfo(Long cid) {
        PhcCheckInfo checkInfo = new PhcCheckInfo();
        checkInfo.setPhcCheckNumPreJob(((PhcPhysicalCheckMapper)this.dao).getPhcCheckNumByCidAndCheckType(cid, CheckTypeEnum.before.getCode()));
        checkInfo.setLastPhcCheckDatePreJob(((PhcPhysicalCheckMapper)this.dao).getLastPhcCheckDateByCidAndCheckType(cid, CheckTypeEnum.before.getCode()));
        checkInfo.setPhcCheckNumLeftJob(((PhcPhysicalCheckMapper)this.dao).getPhcCheckNumByCidAndCheckType(cid, CheckTypeEnum.leave.getCode()));
        checkInfo.setLastPhcCheckDateLeftJob(((PhcPhysicalCheckMapper)this.dao).getLastPhcCheckDateByCidAndCheckType(cid, CheckTypeEnum.leave.getCode()));
        return checkInfo;
    }

    public PageInfo<StaffCheckCountResult> getStaffCheckPage(JqGridParam gparam, StaffCheckCountParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (StringUtils.isNotBlank((CharSequence)gparam.getSidx())) {
            param.setOrder("CONVERT( " + gparam.getSidx() + " USING gbk) " + gparam.getSord());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        return new PageInfo(this.listStaffChecks(param));
    }

    public List<Long> getHealthCheckStaffIds(Long cid, Integer year) {
        return ((PhcPhysicalCheckMapper)this.dao).getHasPhysicalInfoStaffid(cid, year);
    }

    private List<StaffCheckCountResult> listStaffChecks(StaffCheckCountParam param) {
        if (param == null || param.getCid() == null) {
            return null;
        }
        List<StaffCheckCountResult> list = ((PhcPhysicalCheckMapper)this.dao).staffCheckCount(param);
        if (list == null || list.isEmpty()) {
            return list;
        }
        for (StaffCheckCountResult r : list) {
            r.setCheckTypeName(CheckTypeEnum.getName((String)r.getCheckType()));
            r.setExamResultName(ExamResultEnum.getName((String)r.getExamResult()));
            r.setDealTypeName(DealTypeEnum.getName((String)r.getDealType()));
            r.setHarmFactorNames(StringUtils.isNotEmpty((String)r.getHarmFactor()) ? this.harmFactorService.getHarmNames(r.getHarmFactor()) : null);
            this.clearUnDealInfo(r);
        }
        return list;
    }

    private void clearUnDealInfo(StaffCheckCountResult r) {
        if (!"1".equals(r.getDealStatus())) {
            r.setDealType("");
            r.setInfoDesc("");
            r.setDealDesc("");
        }
    }

    public List<StaffCheckCountResult> getStaffCheckList(StaffCheckCountParam param) {
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        return this.listStaffChecks(param);
    }

    public PageInfo<HealthCheckStaffInfoVo> getBeforeRecommendHealthCheckStaffInfosPageBySearch(JqGridParam gparam, HealthCheckStaffInfoQuery query) {
        if (gparam == null || query == null || query.getCid() == null) {
            return null;
        }
        List<Long> includeStaffIds = this.getHarmAndUncheckStaffs(query.getCid(), Byte.parseByte(CheckTypeEnum.before.getCode()), DateUtils.getThisYear(), StaffWorkStatusEnum.ONWORKING);
        if (includeStaffIds == null || includeStaffIds.isEmpty()) {
            return null;
        }
        query.setIncludeStaffIds(includeStaffIds);
        PageInfo pages = this.staffService.getBeforeWorkRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        if (pages == null || pages.getList() == null) {
            return pages;
        }
        this.setStaffOtherInfos(pages.getList(), query);
        return pages;
    }

    public List<HealthCheckStaffInfoVo> getBeforeRecommendHealthCheckStaffInfos(HealthCheckStaffInfoQuery query) {
        if (query == null || query.getCid() == null) {
            return null;
        }
        List<Long> includeStaffIds = this.getHarmAndUncheckStaffs(query.getCid(), Byte.parseByte(CheckTypeEnum.before.getCode()), DateUtils.getThisYear(), StaffWorkStatusEnum.ONWORKING);
        if (includeStaffIds == null || includeStaffIds.isEmpty()) {
            return null;
        }
        query.setIncludeStaffIds(includeStaffIds);
        List pages = this.staffService.getBeforeWorkRecommendHealthCheckStaffInfosBySearch(query);
        if (pages == null || pages.isEmpty()) {
            return pages;
        }
        this.setStaffOtherInfos(pages, query);
        return pages;
    }

    private void removeIgnoredStaffs(List<Long> includeStaffIds) {
    }

    public PageInfo<HealthCheckStaffInfoVo> getLeaveRecommendHealthCheckStaffInfosPageBySearch(JqGridParam gparam, HealthCheckStaffInfoQuery query) {
        if (gparam == null || query == null || query.getCid() == null) {
            return null;
        }
        List<Long> includeStaffIds = this.getLeaveRecommendIncludeStaffIds(query);
        if (includeStaffIds == null || includeStaffIds.isEmpty()) {
            return null;
        }
        query.setIncludeStaffIds(includeStaffIds);
        PageInfo pages = this.staffService.getAfterWorkWorkRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        if (pages == null || pages.getList() == null) {
            return pages;
        }
        this.setStaffOtherInfos(pages.getList(), query);
        return pages;
    }

    public List<HealthCheckStaffInfoVo> getLeaveRecommendHealthCheckStaffInfos(HealthCheckStaffInfoQuery query) {
        if (query == null || query.getCid() == null) {
            return null;
        }
        StaffWorkStatusEnum staffWorkStatus = StaffWorkStatusEnum.NOWORKED;
        List<Long> includeStaffIds = this.getLeaveRecommendIncludeStaffIds(query);
        if (includeStaffIds == null || includeStaffIds.isEmpty()) {
            return null;
        }
        query.setIncludeStaffIds(includeStaffIds);
        List pages = this.staffService.getAfterWorkRecommendHealthCheckStaffInfosBySearch(query);
        if (pages == null || pages.isEmpty()) {
            return pages;
        }
        this.setStaffOtherInfos(pages, query);
        return pages;
    }

    private List<Long> getLeaveRecommendIncludeStaffIds(HealthCheckStaffInfoQuery query) {
        ArrayList<Long> includeStaffIds = new ArrayList<Long>(128);
        JqGridParam g = new JqGridParam();
        g.setPage(1);
        g.setRows(Integer.MAX_VALUE);
        g.setCid(query.getCid());
        g.setPostDatas(new ArrayList());
        ParamSeachFieldVO vo = new ParamSeachFieldVO();
        vo.setSearchField("swrStatus");
        vo.setSearchValue("2");
        g.getPostDatas().add(vo);
        PageInfo harmWorkStaffInfoVoPageInfo = this.harmfactorWorkService.listHarmfactorStaffInfo(g, true);
        List<Object> staffIds1 = new ArrayList();
        if (harmWorkStaffInfoVoPageInfo != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)harmWorkStaffInfoVoPageInfo.getList())) {
            staffIds1 = harmWorkStaffInfoVoPageInfo.getList().stream().filter(v -> v.getStaffId() != null).map(HarmWorkStaffInfoVo::getStaffId).collect(Collectors.toList());
        }
        List staffIds2 = this.staffService.getStaffIdLeaveAndNoCheck(query.getCid(), 90);
        List ignoredStaffs = this.ignoredService.getIgnoredStaffIds(query.getCid(), Byte.valueOf(Byte.parseByte(CheckTypeEnum.leave.getCode())), Integer.valueOf(DateUtils.getThisYear()));
        List ingnoreStaffIds = ignoredStaffs.stream().map(PhcPhysicalCheckRecommendIgnored::getStaffId).collect(Collectors.toList());
        this.logger.info("\u63a5\u5bb3\u5c97\u4f4d\u4eba\u5458:{}", (Object)JsonUtils.toJsonStringNoPretty(staffIds1));
        this.logger.info("90\u5929\u5185\u6ca1\u6709\u4f53\u68c0\u8bb0\u5f55\u7684:{}", (Object)JsonUtils.toJsonStringNoPretty((Object)staffIds2));
        includeStaffIds.addAll(staffIds1.stream().filter(i -> staffIds2.contains(i) && !ingnoreStaffIds.contains(i)).collect(Collectors.toList()));
        return includeStaffIds;
    }

    @Transactional(readOnly=false)
    public void ignoreStaff(PhcPhysicalCheckRecommendIgnored data, Long loginStaffId, Long cid) {
        data.setIgnoreDate(new Date());
        this.ignoredService.ignored(data, loginStaffId, cid);
    }

    public List<CheckWorkIdVO> getCheckWorks(Long cid, int year) {
        if (cid == null) {
            return null;
        }
        return ((PhcPhysicalCheckMapper)this.dao).getCheckWorks(cid, year);
    }

    public Map<String, List<PhcPhysicalCheckData>> getHuadongCheckDataByCheck(PhcPhysicalCheckQuery param) {
        HashMap<String, List<PhcPhysicalCheckData>> datas = new HashMap<String, List<PhcPhysicalCheckData>>();
        List checkDatas = this.dataService.getHuadongByCheckInfo(param);
        if (checkDatas == null || checkDatas.size() == 0) {
            return datas;
        }
        for (PhcPhysicalCheckData data : checkDatas) {
            String key = data.getStaffName();
            List<PhcPhysicalCheckData> listDatas = datas.get(key) == null ? new ArrayList() : (List)datas.get(key);
            listDatas.add(data);
            datas.put(key, listDatas);
        }
        return datas;
    }

    public List<HudongSysStaffInfoVo> getAllStaffInfoListByCid(Long cid) {
        return ((PhcPhysicalCheckMapper)this.dao).getAllStaffInfoListByCid(cid);
    }

    public List<Long> queryHospital(Long cid, Long year) {
        return ((PhcPhysicalCheckMapper)this.dao).queryHospital(cid, year);
    }

    public List<Long> getInstitutionalQualificationFileIdsByCidAndYear(Long cid, Long year) {
        List<Long> ids = this.queryHospital(cid, year);
        String fileIds = this.thirdOrgQualificationService.getHealthCheckQualificationFileIds(ids);
        if (fileIds == null || fileIds.equals("")) {
            return null;
        }
        String[] split = fileIds.split(",");
        ArrayList<Long> list = new ArrayList<Long>();
        for (String s : split) {
            list.add(Long.parseLong(s));
        }
        return list;
    }

    public List<HealthCheckArchiveFileVo> queryHealthArchiveVo(Long cid, Integer year) {
        List<HealthCheckArchiveFileVo> rList = this.queryHealthCheck(cid, year);
        LinkedList<Long> orgIds = new LinkedList<Long>();
        for (HealthCheckArchiveFileVo vo : rList) {
            orgIds.add(vo.getHospital());
        }
        this.setOrgName(rList, orgIds);
        for (HealthCheckArchiveFileVo vo : rList) {
            PhcPhysicalCheck detail = this.getDetailById(vo.getId());
            List checkTypeCounts = detail.getCheckTypeCounts();
            if (checkTypeCounts == null || checkTypeCounts.isEmpty()) continue;
            vo.setNeedCheckNum(((CheckTypeCount)checkTypeCounts.get(0)).getNeedChecks());
            vo.setCheckNum(((CheckTypeCount)checkTypeCounts.get(0)).getChecks());
            this.setResultNum(vo);
        }
        return rList;
    }

    public List<HealthCheckArchiveStaffInfo> queryHealthCheckArchiveStaffInfo(Long cid) {
        List<PhcPhysicalCheck> list = this.queryCheckList(cid, null);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Long> checkIds = new LinkedList<Long>();
        for (PhcPhysicalCheck check : list) {
            checkIds.add(check.getId());
        }
        List<HealthCheckArchiveStaffInfo> rList = ((PhcPhysicalCheckMapper)this.dao).queryHealthCheckArchiveStaffInfo(checkIds);
        this.setFactorNames(rList);
        this.setDiseaseNames(rList);
        return rList;
    }

    public List<HealthCheckArchiveStaffGroup> queryHealthCheckArchiveStaffInfoGroup(Long cid) {
        List<HealthCheckArchiveStaffInfo> list = this.queryHealthCheckArchiveStaffInfo(cid);
        HashMap<CallSite, HealthCheckArchiveStaffGroup> map = new HashMap<CallSite, HealthCheckArchiveStaffGroup>();
        for (HealthCheckArchiveStaffInfo info : list) {
            if (info.getCheckType() == null || info.getCheckDate() == null) continue;
            String key = info.getStaffDeptName() + "-" + info.getCheckType() + "-" + DateUtils.format((Date)info.getCheckDate(), (String)"yyyy-MM-dd");
            HealthCheckArchiveStaffGroup group = (HealthCheckArchiveStaffGroup)map.get(key);
            if (group == null) {
                group = new HealthCheckArchiveStaffGroup();
                group.setCheckDate(info.getCheckDate());
                group.setCheckType(info.getCheckType());
                group.setStaffDeptName(info.getStaffDeptName());
                map.put((CallSite)((Object)key), group);
            }
            group.getList().add(info);
        }
        return new LinkedList<HealthCheckArchiveStaffGroup>(map.values());
    }

    public Integer[] checkStaffNum(Long cid) {
        Integer[] nums = new Integer[]{0, 0, 0};
        JqGridParam gparam = new JqGridParam();
        gparam.setPage(1);
        gparam.setRows(Integer.MAX_VALUE);
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCid(cid);
        PageInfo<PhcPhysicalCheck> page = this.getReportPage(gparam, param);
        List checkIds = page.getList().stream().map(PhcPhysicalCheck::getId).collect(Collectors.toList());
        for (Long checkId : checkIds) {
            List<CheckTypeCount> checkTypeCounts = this.getCheckTypeCounts(checkId);
            for (CheckTypeCount checkTypeCount : checkTypeCounts) {
                switch (checkTypeCount.getCheckType()) {
                    case "1": {
                        Integer[] integerArray = nums;
                        Integer.valueOf(integerArray[0] + checkTypeCount.getChecks());
                        break;
                    }
                    case "2": {
                        Integer[] integerArray = nums;
                        Integer.valueOf(integerArray[1] + checkTypeCount.getChecks());
                        break;
                    }
                    case "3": {
                        Integer[] integerArray = nums;
                        Integer.valueOf(integerArray[2] + checkTypeCount.getChecks());
                        break;
                    }
                }
            }
        }
        return nums;
    }

    public Integer getCheckNumByCid(Long cid, Integer year) {
        if (cid == null) {
            return 0;
        }
        PhcYearCheckInfo params = new PhcYearCheckInfo();
        params.setCid(cid);
        params.setYear(year);
        List<PhcDieaserReportInfo> results = ((PhcPhysicalCheckMapper)this.dao).countYearCheckInfo(params);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(results)) {
            return results.stream().map(PhcDieaserReportInfo::getCheckId).collect(Collectors.toSet()).size();
        }
        return 0;
    }

    public List<Long> getThirdOrgIdByYear(Long cid, int year) {
        return ((PhcPhysicalCheckMapper)this.dao).getThirdOrgIdByYear(cid, year);
    }

    public WandaDeclare getLastOneWandaDeclareByCid(Long cid) {
        return this.wandaDeclareService.getLastOneWandaDeclareByCid(cid);
    }

    private void setDiseaseNames(List<HealthCheckArchiveStaffInfo> rList) {
        StringBuilder sb = new StringBuilder();
        for (HealthCheckArchiveStaffInfo info : rList) {
            String harmFactor = info.getHarmFactor();
            if (harmFactor == null || harmFactor.isEmpty()) continue;
            sb.append(harmFactor);
            sb.append(",");
        }
        if (sb.length() == 0) {
            return;
        }
        List list = this.l081occupationalRiskFactorsListService.getListByIds(sb.substring(0, sb.length()));
        for (HealthCheckArchiveStaffInfo info : rList) {
            for (L081OccupationalRiskFactorsList l081 : list) {
                if (info.getHarmFactor() == null || !info.getHarmFactor().contains("" + l081.getIdList()) || l081.getOccupationalDisease() == null || l081.getOccupationalDisease().equals("/")) continue;
                info.setPerhapsDiseaseNames(info.getPerhapsDiseaseNames() + l081.getOccupationalDisease() + ",");
            }
            if (info.getPerhapsDiseaseNames() == null || info.getPerhapsDiseaseNames().isEmpty()) continue;
            info.setPerhapsDiseaseNames(info.getPerhapsDiseaseNames().substring(0, info.getPerhapsDiseaseNames().length() - 1));
        }
    }

    private void setFactorNames(List<HealthCheckArchiveStaffInfo> rList) {
        Map factorIdToNameMap = this.harmFactorService.getAllIdAndNameMap();
        for (HealthCheckArchiveStaffInfo info : rList) {
            String harmFactor = info.getHarmFactor();
            if (harmFactor == null || harmFactor.isEmpty()) continue;
            StringBuilder factorNames = new StringBuilder();
            for (String s : harmFactor.split(",")) {
                String factorName = (String)factorIdToNameMap.get(s);
                if (factorName == null) continue;
                factorNames.append(factorName);
                factorNames.append(",");
            }
            if (factorNames.length() <= 0) continue;
            info.setFactorNames(factorNames.substring(0, factorNames.length() - 1));
        }
    }

    private List<PhcPhysicalCheck> queryCheckList(Long cid, Integer year) {
        JqGridParam gparam = new JqGridParam();
        gparam.setPage(1);
        gparam.setRows(Integer.MAX_VALUE);
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCid(cid);
        return this.getReportPage(gparam, param).getList();
    }

    private List<HealthCheckArchiveFileVo> queryHealthCheck(Long cid, Integer year) {
        List<PhcPhysicalCheck> list = this.queryCheckList(cid, year);
        return list.stream().map(item -> {
            HealthCheckArchiveFileVo vo = new HealthCheckArchiveFileVo();
            vo.setId(item.getId());
            vo.setHospital(item.getHospital());
            vo.setCheckTypeName(item.getCheckTypeNames());
            vo.setCheckDate(item.getCheckDate());
            return vo;
        }).collect(Collectors.toList());
    }

    private void setResultNum(HealthCheckArchiveFileVo vo) {
        List results = this.resultService.queryByCheckId(vo.getId());
        for (PhcPhysicalCheckDataResult result : results) {
            if (Objects.isNull(result.getExamResult())) continue;
            if (result.getExamResult().equals((byte)1)) {
                vo.setResult1Num(Integer.valueOf(vo.getResult1Num() + 1));
                continue;
            }
            if (result.getExamResult().equals((byte)2)) {
                vo.setResult2Num(Integer.valueOf(vo.getResult2Num() + 1));
                continue;
            }
            if (result.getExamResult().equals((byte)3)) {
                vo.setResult3Num(Integer.valueOf(vo.getResult3Num() + 1));
                continue;
            }
            if (result.getExamResult().equals((byte)4)) {
                vo.setResult4Num(Integer.valueOf(vo.getResult4Num() + 1));
                continue;
            }
            if (!result.getExamResult().equals((byte)5)) continue;
            vo.setResult5Num(Integer.valueOf(vo.getResult5Num() + 1));
        }
    }

    private void setOrgName(List<HealthCheckArchiveFileVo> rList, List<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return;
        }
        List orgs = this.thirdOrganizationService.getAllByIds(orgIds);
        HashMap<Long, String> idToNameMap = new HashMap<Long, String>();
        for (ThirdOrganization org : orgs) {
            idToNameMap.put(org.getId(), org.getName());
        }
        for (HealthCheckArchiveFileVo vo : rList) {
            if (vo.getHospital() == null) continue;
            vo.setHospitalName((String)idToNameMap.get(vo.getHospital()));
        }
    }
}

