/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckRecommendQueryMapper;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckRecommendQuery;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckRecommendQueryService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckRecommendQueryServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckRecommendQueryMapper, PhcPhysicalCheckRecommendQuery>
implements IPhcPhysicalCheckRecommendQueryService {
    @Autowired
    IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    IWorkRoleInfoService workService;

    public PhcPhysicalCheckRecommendQuery query(PhcPhysicalCheckRecommendQuery query) {
        Byte workState = query.getWorkState();
        if (workState == null) {
            return query;
        }
        String mustCheckFlag = workState + "8";
        String chooseCheckFlag = workState + "9";
        String[] harmIds = query.getHarmIds();
        String[] specialWorkIds = query.getSpecialWorkIds();
        String splitor = "\u3001";
        HealthCheckStaffInfoVo recommends = this.harmfactorWorkService.getRecommendChecks(harmIds, specialWorkIds, mustCheckFlag, chooseCheckFlag, splitor);
        query.setChooseChecks(recommends.getChooseChecks());
        query.setMustChecks(recommends.getMustChecks());
        return query;
    }

    public PageInfo<PhcPhysicalCheckRecommendQuery> page(JqGridParam param, Long cid) {
        if (param == null || cid == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalCheckRecommendQuery> list = this.getList(cid);
        return new PageInfo(list);
    }

    private List<PhcPhysicalCheckRecommendQuery> getList(Long cid) {
        if (cid == null) {
            return null;
        }
        Example example = this.getUnExportExample(cid);
        List list = ((PhcPhysicalCheckRecommendQueryMapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return list;
        }
        for (PhcPhysicalCheckRecommendQuery l : list) {
            this.setQueryInfo(l);
        }
        return list;
    }

    private Example getUnExportExample(Long cid) {
        Example example = new Example(PhcPhysicalCheckRecommendQuery.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("exportState", (Object)0);
        return example;
    }

    public Integer unExportCount(Long cid) {
        List<PhcPhysicalCheckRecommendQuery> list = this.getList(cid);
        return list == null ? 0 : list.size();
    }

    @Transactional(readOnly=false)
    public List<PhcPhysicalCheckRecommendQuery> exportAll(Long cid) {
        List<PhcPhysicalCheckRecommendQuery> list = this.getList(cid);
        this.updateState(cid, (byte)1);
        return list;
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheckRecommendQuery insertOrUpdate(PhcPhysicalCheckRecommendQuery query, Long staffId, Long cid) {
        if (query.getId() != null) {
            this.updateStateById(query.getId(), query.getExportState(), staffId);
        } else {
            PhcPhysicalCheckRecommendQuery lastQuery = this.lastResult(query, cid);
            if (lastQuery != null) {
                return lastQuery;
            }
            this.add(query, staffId, cid);
        }
        return query;
    }

    private PhcPhysicalCheckRecommendQuery lastResult(PhcPhysicalCheckRecommendQuery query, Long cid) {
        Example example = new Example(PhcPhysicalCheckRecommendQuery.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid);
        criteria.andEqualTo("workState", (Object)query.getWorkState());
        criteria.andEqualTo("workId", (Object)query.getWorkId());
        criteria.andEqualTo("specialWorks", (Object)query.getSpecialWorks());
        criteria.andEqualTo("harms", (Object)query.getHarms());
        criteria.andEqualTo("isValid", (Object)Global.TRUE);
        criteria.andEqualTo("exportState", (Object)0);
        example.setOrderByClause("update_date desc");
        List list = ((PhcPhysicalCheckRecommendQueryMapper)this.dao).selectByExample(example);
        if (list != null && !list.isEmpty()) {
            return (PhcPhysicalCheckRecommendQuery)list.get(0);
        }
        return null;
    }

    private void updateStateById(Long id, Byte state, Long staffId) {
        PhcPhysicalCheckRecommendQuery query = new PhcPhysicalCheckRecommendQuery();
        query.setId(id);
        query.setExportState(state);
        this.setUpdateInfo(query, staffId);
        ((PhcPhysicalCheckRecommendQueryMapper)this.dao).updateByPrimaryKeySelective(query);
    }

    private void updateState(Long cid, Byte state) {
        Example example = this.getUnExportExample(cid);
        PhcPhysicalCheckRecommendQuery data = new PhcPhysicalCheckRecommendQuery();
        data.setExportState(state);
        ((PhcPhysicalCheckRecommendQueryMapper)this.dao).updateByExampleSelective(data, example);
    }

    @Override
    public PhcPhysicalCheckRecommendQuery getById(Long id) {
        PhcPhysicalCheckRecommendQuery query = this.getById(id);
        this.setQueryInfo(query);
        return query;
    }

    private void setQueryInfo(PhcPhysicalCheckRecommendQuery query) {
        if (query == null) {
            return;
        }
        Long workId = query.getWorkId();
        if (workId != null) {
            query.setWorkName(this.workService.getWorkNameIncludeOrgName(workId));
        }
    }
}

