/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckHarmDeclareService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.vo.work.check.CheckHarmDeclareVO;
import cn.smarthse.modules.health.vo.work.check.CheckTipQuery;
import cn.smarthse.modules.health.vo.work.check.CheckWorkIdVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckHarmDeclareServiceImpl
implements IPhcPhysicalCheckHarmDeclareService {
    @Autowired
    IPhcPhysicalCheckService checkService;
    private List<String> keys = Arrays.asList("\u7c89\u5c18", "\u5316\u5b66\u56e0\u7d20", "\u7269\u7406\u56e0\u7d20", "\u653e\u5c04\u56e0\u7d20", "\u94c5", "\u566a\u58f0", "\u82ef");

    public CheckHarmDeclareVO harmDeclareCheck(Long cid, int year) {
        CheckHarmDeclareVO vo = new CheckHarmDeclareVO();
        List checkWorkIds = this.checkService.getCheckWorks(cid, year);
        if (CollectionUtils.isEmpty((Collection)checkWorkIds)) {
            return vo;
        }
        HashMap<String, Set<Long>> harmWorkMap = new HashMap<String, Set<Long>>();
        for (CheckWorkIdVO checkWorkIdVO : checkWorkIds) {
            if (checkWorkIdVO == null || checkWorkIdVO.getWorkId() == null || checkWorkIdVO.getHarmId() == null) continue;
            Long workId = checkWorkIdVO.getWorkId();
            if (this.keys.contains(checkWorkIdVO.getHarmName())) {
                this.setMapValue(checkWorkIdVO.getHarmName(), harmWorkMap, workId);
            }
            if (!this.keys.contains(checkWorkIdVO.getHarmType())) continue;
            this.setMapValue(checkWorkIdVO.getHarmType(), harmWorkMap, workId);
        }
        if (CollectionUtils.isEmpty(harmWorkMap)) {
            return vo;
        }
        vo.setIsChecked(Boolean.valueOf(true));
        for (Map.Entry entry : harmWorkMap.entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)value)) continue;
            vo.setNums(key, value.size());
        }
        return vo;
    }

    private void setMapValue(String key, Map<String, Set<Long>> harmWorkMap, Long workId) {
        Set<Long> value = harmWorkMap.get(key);
        if (value == null) {
            value = new HashSet<Long>();
        }
        value.add(workId);
        harmWorkMap.put(key, value);
    }

    private boolean hasThisYearChecked(Long cid, int year) {
        CheckTipQuery query = new CheckTipQuery();
        query.setCid(cid);
        query.setYear(Integer.valueOf(year));
        boolean hasThisYearCheced = this.checkService.hasThisYearChecked(query);
        return hasThisYearCheced;
    }
}

