/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckFileMapper;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckFileService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class PhcPhysicalCheckFileServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckFileMapper, PhcPhysicalCheckFile>
implements IPhcPhysicalCheckFileService {
    @DubboReference
    ISysFileProvideService sysFileService;

    @Transactional(readOnly=true)
    public void updateFilesByParent(PhcPhysicalCheck data) {
        if (data == null) {
            return;
        }
        this.deleteFilesByPid(data.getId());
        this.addFilesByType(data.getReportFiles(), data, (byte)1);
    }

    private void deleteFilesByPid(Long pid) {
        if (pid == null) {
            return;
        }
        Example example = new Example(PhcPhysicalCheckFile.class);
        example.createCriteria().andEqualTo("checkId", (Object)pid);
        ((PhcPhysicalCheckFileMapper)this.dao).deleteByExample(example);
    }

    private void addFilesByType(List<PhcPhysicalCheckFile> files, PhcPhysicalCheck data, Byte fileType) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (PhcPhysicalCheckFile file : files) {
            if (file.getFileId() == null) continue;
            this.setParentInfos(data, file);
            file.setFileType(fileType);
            file.setId(Long.valueOf(this.idworker.nextId()));
            ((PhcPhysicalCheckFileMapper)this.dao).insert(file);
        }
    }

    private void setParentInfos(PhcPhysicalCheck data, PhcPhysicalCheckFile file) {
        file.setCheckId(data.getId());
        file.setCid(data.getCid());
    }

    public List<PhcPhysicalCheckFile> getFilesByPid(Long checkId) {
        if (checkId == null) {
            return null;
        }
        Example example = new Example(PhcPhysicalCheckFile.class);
        example.createCriteria().andEqualTo("checkId", (Object)checkId);
        return ((PhcPhysicalCheckFileMapper)this.dao).selectByExample(example);
    }

    public List<PhcPhysicalCheckFile> getFilesByPidAndType(Long checkId, Byte fileType) {
        if (checkId == null) {
            return null;
        }
        Example example = new Example(PhcPhysicalCheckFile.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkId", (Object)checkId);
        if (fileType != null) {
            criteria.andEqualTo("fileType", (Object)fileType);
        }
        return ((PhcPhysicalCheckFileMapper)this.dao).selectByExample(example);
    }

    public List<PhcPhysicalCheckFile> getFilesDetailByPidAndType(Long id, Byte fileType) {
        List<PhcPhysicalCheckFile> list = this.getFilesByPidAndType(id, fileType);
        if (list == null) {
            return list;
        }
        for (PhcPhysicalCheckFile l : list) {
            SysFileModel file;
            Long fileId = l.getFileId();
            if (fileId == null || (file = this.sysFileService.getFileById(fileId)) == null) continue;
            l.setFileName(file.getFileName());
            l.setFileUrl(file.getOssUrl());
        }
        return list;
    }
}

