/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelContent;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckDataMapper;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckDataVO;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckTypeInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.check.vo.StaffCheckCountResult;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.pojo.CheckTypeUserCount;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckDataServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckDataMapper, PhcPhysicalCheckData>
implements IPhcPhysicalCheckDataService {
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IStaffInfoService staffService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private IPhcPhysicalCheckService phcPhysicalCheckService;

    public Integer getAllCheckResultStaffCountByByQuery(PhcPhysicalCheckQuery query) {
        return ((PhcPhysicalCheckDataMapper)this.dao).getAllCheckResultStaffCountByByQuery(query);
    }

    public List<PhcPhysicalCheckDataVO> listDatas(PhcPhysicalCheckQuery query) {
        return ((PhcPhysicalCheckDataMapper)this.dao).listDatas(query);
    }

    public PageInfo<PhcPhysicalCheckDataVO> getList(JqGridParam gparam, PhcPhysicalCheckQuery param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param == null || param.getCheckId() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalCheckDataVO> list = this.listDatas(param);
        for (PhcPhysicalCheckDataVO vo : list) {
            if (StringUtils.isEmpty((CharSequence)vo.getReportFiles())) {
                vo.setReportFiles("");
            }
            for (PhcPhysicalCheckDataVO vo2 : list) {
                if (StringUtils.isEmpty((CharSequence)vo2.getReportFiles())) {
                    vo2.setReportFiles("");
                }
                if (!vo.getDataId().equals(vo2.getDataId()) || vo2.getReportFiles().isEmpty()) continue;
                for (String s : vo2.getReportFiles().split(",")) {
                    if (vo.getReportFiles().contains(s)) continue;
                    vo.setReportFiles(vo.getReportFiles() + "," + s);
                }
            }
        }
        this.setFileModel(list);
        return new PageInfo(list);
    }

    private void setFileModel(List<PhcPhysicalCheckDataVO> list) {
        StringBuilder sb = new StringBuilder();
        list.forEach(item -> {
            if (item.getReportFiles() == null || item.getReportFiles().isEmpty()) {
                return;
            }
            sb.append(item.getReportFiles());
            if (sb.indexOf(",") != sb.length() - 1) {
                sb.append(",");
            }
        });
        if (sb.length() == 0) {
            return;
        }
        List files = this.sysFileProvideService.getListByIds(sb.toString());
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (SysFileModel file : files) {
                for (PhcPhysicalCheckDataVO detailVo : list) {
                    if (detailVo.getReportFiles() == null || detailVo.getReportFiles().isEmpty() || !detailVo.getReportFiles().contains("" + file.getId())) continue;
                    detailVo.getReportFileList().add(file);
                }
            }
        }
    }

    public PhcPhysicalCheckData getDataDetailById(PhcPhysicalCheckData query) {
        PhcPhysicalCheckData data = null;
        if (query == null || query.getId() == null) {
            return data;
        }
        data = ((PhcPhysicalCheckDataMapper)this.dao).getDataById(query.getId());
        data.setResults(this.resultService.listResults(query));
        return data;
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheckData insertOrUpdate(PhcPhysicalCheckData data, Long staffId, Long cid) {
        if (data == null) {
            return data;
        }
        this.deleteByInfo(data);
        PhcPhysicalCheckData existData = this.getDataByQuery(data);
        if (existData != null && existData.getId() != null) {
            data.setId(existData.getId());
        } else {
            data.setId(null);
        }
        if (data.getId() != null) {
            data.setCid(cid);
            data.setUpdateBy(staffId);
            data.setUpdateDate(new Date());
            ((PhcPhysicalCheckDataMapper)this.dao).updateData(data);
        } else {
            this.add(data, staffId, cid);
        }
        this.resultService.updateResultsByData(data);
        return data;
    }

    private Example getExampleByQuery(PhcPhysicalCheckData query) {
        Example example = new Example(PhcPhysicalCheckData.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("staffId", (Object)query.getStaffId());
        criteria.andEqualTo("checkType", (Object)query.getCheckType());
        criteria.andEqualTo("checkId", (Object)query.getCheckId());
        if (query.getId() != null) {
            criteria.andNotEqualTo("id", (Object)query.getId());
        }
        return example;
    }

    private PhcPhysicalCheckData getDataByQuery(PhcPhysicalCheckData query) {
        PhcPhysicalCheckData data = new PhcPhysicalCheckData();
        if (query == null || query.getCheckId() == null || query.getCheckType() == null) {
            return data;
        }
        Example example = this.getExampleByQuery(query);
        List datas = ((PhcPhysicalCheckDataMapper)this.dao).selectByExample(example);
        if (datas != null && datas.size() > 0) {
            return (PhcPhysicalCheckData)datas.get(0);
        }
        return data;
    }

    public PhcPhysicalCheckData getDataDetailByQuery(PhcPhysicalCheckData query) {
        PhcPhysicalCheckData data = this.getDataByQuery(query);
        if (data.getId() == null) {
            return data;
        }
        data.setExamResult(query.getExamResult());
        List allResults = this.resultService.listResults(data);
        data.setResults(allResults);
        return data;
    }

    public Boolean hasDataExist(PhcPhysicalCheckData query) {
        if (query == null || query.getCheckId() == null || query.getCheckType() == null || query.getExamResult() == null) {
            return false;
        }
        Example example = this.getExampleByQuery(query);
        List datas = ((PhcPhysicalCheckDataMapper)this.dao).selectByExample(example);
        if (datas == null || datas.size() == 0) {
            return false;
        }
        PhcPhysicalCheckData data = (PhcPhysicalCheckData)datas.get(0);
        data.setExamResult(query.getExamResult());
        List results = this.resultService.listResults(data);
        return results != null && results.size() > 0;
    }

    public PageInfo<PhcPhysicalCheckDataVO> getRecheckPage(JqGridParam gparam, PhcPhysicalCheckQuery param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param == null || param.getCheckId() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalCheckDataVO> list = ((PhcPhysicalCheckDataMapper)this.dao).listDatas(param);
        return new PageInfo(list);
    }

    public List<PhcPhysicalCheckData> getByCheckInfo(PhcPhysicalCheckQuery param) {
        List<PhcPhysicalCheckData> byCheckInfo = ((PhcPhysicalCheckDataMapper)this.dao).getByCheckInfo(param);
        if (CollectionUtils.isNotEmpty(byCheckInfo)) {
            byCheckInfo.forEach(b -> b.setIdCard(SpringEncryptUtils.decrypt((String)b.getIdCard())));
        }
        return byCheckInfo;
    }

    public List<PhcPhysicalCheckData> getHuadongByCheckInfo(PhcPhysicalCheckQuery param) {
        List<PhcPhysicalCheckData> huadongByCheckInfo = ((PhcPhysicalCheckDataMapper)this.dao).getHuadongByCheckInfo(param);
        if (CollectionUtils.isNotEmpty(huadongByCheckInfo)) {
            huadongByCheckInfo.forEach(h -> h.setIdCard(SpringEncryptUtils.decrypt((String)h.getIdCard())));
        }
        return huadongByCheckInfo;
    }

    @Transactional(readOnly=false)
    public void deleteByInfo(PhcPhysicalCheckData data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List otherResults = this.resultService.listOtherResults(data);
        if (otherResults == null || otherResults.size() == 0) {
            ((PhcPhysicalCheckDataMapper)this.dao).deleteByPrimaryKey(data.getId());
        }
        this.resultService.deleteByData(data);
    }

    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        ((PhcPhysicalCheckDataMapper)this.dao).deleteByPrimaryKey(id);
    }

    @Transactional(readOnly=false)
    public PhcPhysicalCheckData addStaffs(PhcPhysicalCheckData data, String staffIds, Long staffId, Long cid) {
        if (StringUtils.isEmpty((CharSequence)staffIds)) {
            return data;
        }
        List staffIdArray = StringUtils.parseToLongList((String)staffIds, (String)",");
        for (Long id : staffIdArray) {
            StaffBasicVo staffBasicVo = this.staffService.getStaffBasicInfoById(id);
            if (staffBasicVo == null) continue;
            PhcPhysicalCheckData addData = this.setDataInfo(data, staffBasicVo);
            this.insertOrUpdate(addData, staffId, cid);
        }
        return data;
    }

    private PhcPhysicalCheckData setDataInfo(PhcPhysicalCheckData commonData, StaffBasicVo staffBasicVo) {
        PhcPhysicalCheckData data = new PhcPhysicalCheckData();
        data.setCheckId(commonData.getCheckId());
        data.setCheckType(commonData.getCheckType());
        data.setExamResult(commonData.getExamResult());
        data.setStaffId(staffBasicVo.getStaffId());
        data.setStaffName(staffBasicVo.getStaffName());
        data.setStaffWorkNo(staffBasicVo.getWorkNo());
        data.setStaffDeptId(staffBasicVo.getDeptId());
        data.setStaffDeptName(staffBasicVo.getDeptName());
        data.setStaffWorkId(staffBasicVo.getWorkId());
        data.setStaffWorkName(staffBasicVo.getWorkName());
        ArrayList<PhcPhysicalCheckDataResult> results = new ArrayList<PhcPhysicalCheckDataResult>();
        PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
        result.setIsValid(Boolean.valueOf(true));
        results.add(result);
        data.setResults(results);
        return data;
    }

    public List<PhcPhysicalCheckTypeInfo> checkTypesInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataMapper)this.dao).checkTypesInfo(query);
    }

    public void deleteByCheck(PhcPhysicalCheck check) {
        if (check == null || check.getId() == null) {
            return;
        }
        List checkTypes = check.getCheckTypes();
        ArrayList<Byte> types = new ArrayList<Byte>();
        if (checkTypes != null && checkTypes.size() > 0) {
            for (PhcPhysicalCheckType checkType : checkTypes) {
                if (checkType.getCheckType() == null) continue;
                types.add(checkType.getCheckType());
            }
        }
        Example example = new Example(PhcPhysicalCheckData.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkId", (Object)check.getId());
        if (types.size() > 0) {
            criteria.andNotIn("checkType", types);
        }
        ((PhcPhysicalCheckDataMapper)this.dao).deleteByExample(example);
    }

    public Date getStaffFirstCheckBeginTime(Long staffId) {
        if (staffId == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataMapper)this.dao).getStaffFirstCheckBeginTime(staffId);
    }

    public List<PhcPhysicalCheckDataVO> selectStaff(PhcPhysicalCheckQuery param) {
        List<PhcPhysicalCheckDataVO> phcPhysicalCheckDataVOS = ((PhcPhysicalCheckDataMapper)this.dao).selectStaff(param);
        if (CollectionUtils.isNotEmpty(phcPhysicalCheckDataVOS)) {
            phcPhysicalCheckDataVOS.forEach(p -> p.setName(SpringEncryptUtils.decrypt((String)p.getName())));
        }
        return phcPhysicalCheckDataVOS;
    }

    public Integer selectCountByCheckIdAndType(PhcPhysicalYearCountQuery query) {
        return ((PhcPhysicalCheckDataMapper)this.dao).selectCountByCheckIdAndType(query);
    }

    public PageInfo<StaffCheckCountResult> getConfirmationStaffList(JqGridParam gparam, Long checkId, Byte confirmationType) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<StaffCheckCountResult> list = ((PhcPhysicalCheckDataMapper)this.dao).getConfirmationStaffList(checkId, confirmationType);
        return new PageInfo(list);
    }

    public PhcPhysicalCheckData getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(Long cid, Long checkId, Long staffId, Byte checkType) {
        Example example = new Example(PhcPhysicalCheckData.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkId", (Object)checkId).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("staffId", (Object)staffId).andEqualTo("checkType", (Object)checkType);
        return (PhcPhysicalCheckData)((PhcPhysicalCheckDataMapper)this.dao).selectOneByExample(example);
    }

    @Transactional(readOnly=false)
    public void addExistCheckResults(Map<Long, List<ArrayList<ExcelContent>>> existedStaffInfosMap, Long checkId, Byte checkType, Long loginStaffId, Long cid) {
        List allSysStaffs = this.phcPhysicalCheckService.getAllStaffInfoListByCid(cid);
        HashMap nameMap = new HashMap();
        HashMap<Long, HudongSysStaffInfoVo> staffIdMap = new HashMap<Long, HudongSysStaffInfoVo>();
        for (HudongSysStaffInfoVo hssiv : allSysStaffs) {
            staffIdMap.put(hssiv.getStaffId(), hssiv);
            if (nameMap.get(hssiv.getRealName()) == null) {
                nameMap.put(hssiv.getRealName(), new ArrayList());
            }
            ((List)nameMap.get(hssiv.getRealName())).add(hssiv);
        }
        for (Long staffId : existedStaffInfosMap.keySet()) {
            PhcPhysicalCheckData ppcd = this.getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(cid, checkId, staffId, checkType);
            List<ArrayList<ExcelContent>> checkResultsExcel = existedStaffInfosMap.get(staffId);
            if (ppcd == null) {
                ppcd = new PhcPhysicalCheckData();
                ppcd.setCheckId(checkId);
                ppcd.setCheckType(checkType);
                ppcd.setStaffId(staffId);
                HudongSysStaffInfoVo sysStaffInfoVo = (HudongSysStaffInfoVo)staffIdMap.get(staffId);
                if (sysStaffInfoVo != null) {
                    ppcd.setStaffName(sysStaffInfoVo.getRealName());
                    ppcd.setStaffWorkNo(sysStaffInfoVo.getWorkNo());
                    ppcd.setStaffDeptName(sysStaffInfoVo.getOrgName());
                    ppcd.setStaffDeptId(sysStaffInfoVo.getOrgId());
                    ppcd.setStaffWorkId(sysStaffInfoVo.getCurrentWorkId());
                    ppcd.setStaffWorkName(sysStaffInfoVo.getCurrentWorkName());
                }
                ppcd = this.add(ppcd, loginStaffId, cid);
            }
            for (ArrayList<ExcelContent> excelContents : checkResultsExcel) {
                PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
                result.setDataId(ppcd.getId());
                if (ExamResultEnum.noraml.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.noraml.getCode())));
                } else if (ExamResultEnum.recheck.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.recheck.getCode())));
                    result.setAbnormal(excelContents.get(3).getContent());
                    result.setCheckAdvice(excelContents.get(4).getContent());
                } else if (ExamResultEnum.so.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.so.getCode())));
                    result.setHarmYear(excelContents.get(3).getContent());
                    result.setAbnormal(excelContents.get(4).getContent());
                    result.setHarmDesc(excelContents.get(5).getContent());
                    result.setCheckAdvice(excelContents.get(6).getContent());
                } else if (ExamResultEnum.oc.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.oc.getCode())));
                    result.setAbnormal(excelContents.get(3).getContent());
                    result.setHarmDesc(excelContents.get(4).getContent());
                    result.setCheckAdvice(excelContents.get(5).getContent());
                } else if (ExamResultEnum.other.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.other.getCode())));
                } else if (ExamResultEnum.mis.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.mis.getCode())));
                    result.setMissingItems(excelContents.get(3).getContent());
                    result.setAbnormal(excelContents.get(4).getContent());
                    result.setCheckAdvice(excelContents.get(5).getContent());
                    result.setMedicalAdvice(excelContents.get(6).getContent());
                }
                if (result.getExamResult() == null) continue;
                this.resultService.add((Object)result, loginStaffId, cid);
            }
        }
    }

    @Transactional(readOnly=false)
    public void addNeedAddStaffInfosCheckResults(List<ArrayList<ExcelContent>> needAddStaffInfos, Long checkId, Byte checkType, Long loginStaffId, Long cid) {
        HashMap<CallSite, Long> map = new HashMap<CallSite, Long>();
        HashMap needAddStaffInfosMap = new HashMap();
        for (ArrayList<ExcelContent> colsContents : needAddStaffInfos) {
            String key = colsContents.get(0).getContent().trim() + (StringUtils.isNotEmpty((String)colsContents.get(1).getContent()) ? colsContents.get(1).getContent().trim() : "") + (StringUtils.isNotEmpty((String)colsContents.get(2).getContent()) ? colsContents.get(2).getContent().trim() : "");
            Long staffId = (Long)map.get(key);
            HudongSysStaffInfoVo vo = null;
            if (staffId == null) {
                vo = this.staffService.addHuadongStaffInfo(colsContents.get(0).getContent().trim(), colsContents.get(1).getContent(), colsContents.get(2).getContent(), loginStaffId, cid);
                map.put((CallSite)((Object)key), vo.getStaffId());
            }
            if (needAddStaffInfosMap.get(map.get(key)) == null) {
                needAddStaffInfosMap.put((Long)map.get(key), new ArrayList());
            }
            ((List)needAddStaffInfosMap.get(map.get(key))).add(colsContents);
        }
        List allSysStaffs = this.phcPhysicalCheckService.getAllStaffInfoListByCid(cid);
        HashMap<Long, HudongSysStaffInfoVo> staffIdMap = new HashMap<Long, HudongSysStaffInfoVo>();
        for (HudongSysStaffInfoVo hssiv : allSysStaffs) {
            staffIdMap.put(hssiv.getStaffId(), hssiv);
        }
        for (Long staffId : needAddStaffInfosMap.keySet()) {
            PhcPhysicalCheckData ppcd = this.getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(cid, checkId, staffId, checkType);
            List checkResultsExcel = (List)needAddStaffInfosMap.get(staffId);
            if (ppcd == null) {
                ppcd = new PhcPhysicalCheckData();
                ppcd.setCheckId(checkId);
                ppcd.setCheckType(checkType);
                ppcd.setStaffId(staffId);
                HudongSysStaffInfoVo sysStaffInfoVo = (HudongSysStaffInfoVo)staffIdMap.get(staffId);
                if (sysStaffInfoVo != null) {
                    ppcd.setStaffName(sysStaffInfoVo.getRealName());
                    ppcd.setStaffWorkNo(sysStaffInfoVo.getWorkNo());
                    ppcd.setStaffDeptName(sysStaffInfoVo.getOrgName());
                    ppcd.setStaffDeptId(sysStaffInfoVo.getOrgId());
                    ppcd.setStaffWorkId(sysStaffInfoVo.getCurrentWorkId());
                    ppcd.setStaffWorkName(sysStaffInfoVo.getCurrentWorkName());
                }
                ppcd = this.add(ppcd, loginStaffId, cid);
            }
            for (ArrayList excelContents : checkResultsExcel) {
                PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
                result.setDataId(ppcd.getId());
                if (ExamResultEnum.noraml.equals((Object)ExamResultEnum.getThisEnumByName((String)((ExcelContent)excelContents.get(0)).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.noraml.getCode())));
                } else if (ExamResultEnum.recheck.equals((Object)ExamResultEnum.getThisEnumByName((String)((ExcelContent)excelContents.get(0)).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.recheck.getCode())));
                    result.setAbnormal(((ExcelContent)excelContents.get(3)).getContent());
                    result.setCheckAdvice(((ExcelContent)excelContents.get(4)).getContent());
                } else if (ExamResultEnum.so.equals((Object)ExamResultEnum.getThisEnumByName((String)((ExcelContent)excelContents.get(0)).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.so.getCode())));
                    result.setHarmYear(((ExcelContent)excelContents.get(3)).getContent());
                    result.setAbnormal(((ExcelContent)excelContents.get(4)).getContent());
                    result.setHarmDesc(((ExcelContent)excelContents.get(5)).getContent());
                    result.setCheckAdvice(((ExcelContent)excelContents.get(6)).getContent());
                } else if (ExamResultEnum.oc.equals((Object)ExamResultEnum.getThisEnumByName((String)((ExcelContent)excelContents.get(0)).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.oc.getCode())));
                    result.setAbnormal(((ExcelContent)excelContents.get(3)).getContent());
                    result.setHarmDesc(((ExcelContent)excelContents.get(4)).getContent());
                    result.setCheckAdvice(((ExcelContent)excelContents.get(5)).getContent());
                } else if (ExamResultEnum.other.equals((Object)ExamResultEnum.getThisEnumByName((String)((ExcelContent)excelContents.get(0)).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.other.getCode())));
                } else if (ExamResultEnum.mis.equals((Object)ExamResultEnum.getThisEnumByName((String)((ExcelContent)excelContents.get(0)).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.mis.getCode())));
                    result.setMissingItems(((ExcelContent)excelContents.get(3)).getContent());
                    result.setAbnormal(((ExcelContent)excelContents.get(4)).getContent());
                    result.setCheckAdvice(((ExcelContent)excelContents.get(5)).getContent());
                    result.setMedicalAdvice(((ExcelContent)excelContents.get(6)).getContent());
                }
                if (result.getExamResult() == null) continue;
                this.resultService.add((Object)result, loginStaffId, cid);
            }
        }
    }

    @Transactional(readOnly=false)
    public void addNeedUpdateStaffInfosCheckResults(Map<Long, List<ArrayList<ExcelContent>>> needUpdateStaffInfosMap, Long checkId, Byte checkType, Long loginStaffId, Long cid) {
        List allSysStaffs = this.phcPhysicalCheckService.getAllStaffInfoListByCid(cid);
        HashMap<Long, HudongSysStaffInfoVo> staffIdMap = new HashMap<Long, HudongSysStaffInfoVo>();
        for (HudongSysStaffInfoVo hssiv : allSysStaffs) {
            staffIdMap.put(hssiv.getStaffId(), hssiv);
        }
        for (Long staffId : needUpdateStaffInfosMap.keySet()) {
            PhcPhysicalCheckData ppcd = this.getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(cid, checkId, staffId, checkType);
            List<ArrayList<ExcelContent>> checkResultsExcel = needUpdateStaffInfosMap.get(staffId);
            if (ppcd == null) {
                ppcd = new PhcPhysicalCheckData();
                ppcd.setCheckId(checkId);
                ppcd.setCheckType(checkType);
                ppcd.setStaffId(staffId);
                HudongSysStaffInfoVo sysStaffInfoVo = (HudongSysStaffInfoVo)staffIdMap.get(staffId);
                if (sysStaffInfoVo != null) {
                    ppcd.setStaffName(sysStaffInfoVo.getRealName());
                    ppcd.setStaffWorkNo(checkResultsExcel.get(0).get(1).getContent());
                    ppcd.setStaffDeptName(sysStaffInfoVo.getOrgName());
                    ppcd.setStaffDeptId(sysStaffInfoVo.getOrgId());
                    ppcd.setStaffWorkId(sysStaffInfoVo.getCurrentWorkId());
                    ppcd.setStaffWorkName(sysStaffInfoVo.getCurrentWorkName());
                }
                ppcd = this.add(ppcd, loginStaffId, cid);
            }
            HudongSysStaffInfoVo vo = new HudongSysStaffInfoVo();
            vo.setStaffId(staffId);
            vo.setIdCard(checkResultsExcel.get(0).get(2).getContent());
            vo.setWorkNo(checkResultsExcel.get(0).get(1).getContent());
            this.staffService.updateHuadongStaffInfo(staffId, vo.getWorkNo(), vo.getIdCard(), loginStaffId, cid);
            for (ArrayList<ExcelContent> excelContents : checkResultsExcel) {
                PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
                result.setDataId(ppcd.getId());
                if (ExamResultEnum.noraml.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.noraml.getCode())));
                } else if (ExamResultEnum.recheck.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.recheck.getCode())));
                    result.setAbnormal(excelContents.get(3).getContent());
                    result.setCheckAdvice(excelContents.get(4).getContent());
                } else if (ExamResultEnum.so.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.so.getCode())));
                    result.setHarmYear(excelContents.get(3).getContent());
                    result.setAbnormal(excelContents.get(4).getContent());
                    result.setHarmDesc(excelContents.get(5).getContent());
                    result.setCheckAdvice(excelContents.get(6).getContent());
                } else if (ExamResultEnum.oc.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.oc.getCode())));
                    result.setAbnormal(excelContents.get(3).getContent());
                    result.setHarmDesc(excelContents.get(4).getContent());
                    result.setCheckAdvice(excelContents.get(5).getContent());
                } else if (ExamResultEnum.other.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.other.getCode())));
                } else if (ExamResultEnum.mis.equals((Object)ExamResultEnum.getThisEnumByName((String)excelContents.get(0).getSheetName()))) {
                    result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.mis.getCode())));
                    result.setMissingItems(excelContents.get(3).getContent());
                    result.setAbnormal(excelContents.get(4).getContent());
                    result.setCheckAdvice(excelContents.get(5).getContent());
                    result.setMedicalAdvice(excelContents.get(6).getContent());
                }
                if (result.getExamResult() == null) continue;
                this.resultService.add((Object)result, loginStaffId, cid);
            }
        }
    }

    public Integer[] checkTypeUserCount(Long cid, Integer checkYear) {
        List<CheckTypeUserCount> typeUserCounts = ((PhcPhysicalCheckDataMapper)this.dao).checkTypeUserCount(cid, checkYear);
        Integer[] counts = new Integer[]{0, 0, 0, 0, 0, 0};
        for (CheckTypeUserCount typeUserCount : typeUserCounts) {
            Integer checkType = typeUserCount.getCheckType();
            if (checkType == null || checkType < 1 || checkType > 6) continue;
            Integer count = typeUserCount.getCount();
            if (count == null) {
                count = 0;
            }
            counts[checkType.intValue() - 1] = count;
        }
        return counts;
    }
}

