/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckDataResultMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhyCheckDataResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserUnprocessInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserUnprocessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckConfiredInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckRechckDataVO;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalPersonCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalPersonInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheckInfoResult;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcSDInfo;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table3;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table4_1;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.DealTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcDiagnoseDiseaseProcessService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckFileService;
import cn.smarthse.modules.health.service.work.check.IPhcUnrecheckLastCheckResultService;
import cn.smarthse.modules.health.service.work.check.IPhcUnrecheckService;
import cn.smarthse.modules.health.service.work.check.IPhcWorkUnexchangeLastCheckResultService;
import cn.smarthse.modules.health.service.work.check.IPhcWorkUnexchangeService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.operate.ICompanyWorkOperateLogService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckDataResultServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckDataResultMapper, PhcPhysicalCheckDataResult>
implements IPhcPhysicalCheckDataResultService {
    @Autowired
    IPhcUnrecheckService phcUnrecheckService;
    @Autowired
    IPhcWorkUnexchangeService phcWorkUnexchangeService;
    @Autowired
    IPhcDiagnoseDiseaseProcessService phcDiagnoseDiseaseProcessService;
    @Autowired
    IPhcPhysicalCheckFileService checkFileService;
    @Autowired
    IPhcUnrecheckLastCheckResultService unrecheckLastCheckResultService;
    @Autowired
    IPhcWorkUnexchangeLastCheckResultService workUnexchangeLastCheckResultService;
    @Autowired
    IPhcOccupationalDiseaserDetailService diseaserDetailService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    IHarmfactorWorkService harmService;
    @Autowired
    ICompanyWorkOperateLogService companyWorkOperateLogService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private IReformItemBasicService reformItemBasicService;

    @Transactional(readOnly=false)
    public void updateResultsByData(PhcPhysicalCheckData data) {
        if (data == null || data.getId() == null || data.getResults() == null) {
            return;
        }
        this.deleteByParent(data);
        List results = data.getResults();
        for (PhcPhysicalCheckDataResult result : results) {
            if (result.getIsValid() == null || !result.getIsValid().booleanValue()) continue;
            result.setDealStatus(Byte.valueOf((byte)0));
            result.setExamResult(data.getExamResult());
            this.setParentInfos(data, result);
            result.setId(Long.valueOf(this.idworker.nextId()));
            ((PhcPhysicalCheckDataResultMapper)this.dao).insert(result);
        }
    }

    @Transactional(readOnly=false)
    public void deleteByParent(PhcPhysicalCheckData data) {
        if (data == null || data.getId() == null) {
            return;
        }
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dataId", (Object)data.getId());
        if (data.getExamResult() == null) {
            ((PhcPhysicalCheckDataResultMapper)this.dao).deleteByExample(example);
            return;
        }
        if (!ExamResultEnum.noraml.getCode().equals(String.valueOf(data.getExamResult()))) {
            ArrayList<Byte> exams = new ArrayList<Byte>();
            exams.add(data.getExamResult());
            exams.add(Byte.parseByte(ExamResultEnum.noraml.getCode()));
            criteria.andIn("examResult", exams);
        }
        ((PhcPhysicalCheckDataResultMapper)this.dao).deleteByExample(example);
    }

    private void setParentInfos(PhcPhysicalCheckData parent, PhcPhysicalCheckDataResult child) {
        child.setDataId(parent.getId());
        child.setCid(parent.getCid());
        child.setCreateBy(parent.getUpdateBy());
        child.setCreateDate(parent.getUpdateDate());
        child.setUpdateBy(parent.getUpdateBy());
        child.setUpdateDate(parent.getUpdateDate());
    }

    public List<PhcPhysicalCheckDataResult> listResults(PhcPhysicalCheckData query) {
        List list = null;
        if (query == null) {
            return list;
        }
        boolean flag = false;
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        if (query.getId() != null) {
            criteria.andEqualTo("dataId", (Object)query.getId());
            flag = true;
        }
        if (query.getExamResult() != null) {
            criteria.andEqualTo("examResult", (Object)query.getExamResult());
            flag = true;
        }
        if (flag) {
            list = ((PhcPhysicalCheckDataResultMapper)this.dao).selectByExample(example);
        }
        return list;
    }

    public List<PhcPhysicalCheckDataResult> listOtherResults(PhcPhysicalCheckData query) {
        List list = null;
        if (query == null) {
            return list;
        }
        boolean flag = false;
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        if (query.getId() != null) {
            criteria.andEqualTo("dataId", (Object)query.getId());
            flag = true;
        }
        if (query.getExamResult() != null) {
            criteria.andNotEqualTo("examResult", (Object)query.getExamResult());
            flag = true;
        }
        if (flag) {
            list = ((PhcPhysicalCheckDataResultMapper)this.dao).selectByExample(example);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void deleteByDataId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dataId", (Object)id);
        ((PhcPhysicalCheckDataResultMapper)this.dao).deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public void deleteByData(PhcPhysicalCheckData data) {
        if (data == null || data.getId() == null) {
            return;
        }
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dataId", (Object)data.getId());
        if (data.getExamResult() != null) {
            criteria.andEqualTo("examResult", (Object)data.getExamResult());
        }
        ((PhcPhysicalCheckDataResultMapper)this.dao).deleteByExample(example);
    }

    public List<PhcPhysicalCheckAbnormal> getAbnormalList(PhcPhysicalCheckAbnormalParam param) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getAbnormalList(param);
    }

    public List<PhcPhysicalCheckAbnormal> getAbnormalListV3_1(PhcPhysicalCheckAbnormalParam param) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getAbnormalListV3_1(param);
    }

    public PageInfo<PhcPhysicalCheckAbnormal> getAbnormalPage(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (StringUtils.isEmpty((CharSequence)gparam.getSidx())) {
            param.setOrderBy(" c.update_date ");
        } else if ("staffName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_name " + gparam.getSord());
        } else if ("staffWorkNo".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_work_no " + gparam.getSord());
        } else if ("deptName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_dept_name " + gparam.getSord());
        } else if ("workName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_work_name " + gparam.getSord());
        } else if ("checkDate".equals(gparam.getSidx())) {
            param.setOrderBy(" c.begin_time " + gparam.getSord());
        } else if ("checkTypeName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.check_type " + gparam.getSord());
        } else if ("examResultName".equals(gparam.getSidx())) {
            param.setOrderBy(" r.exam_result " + gparam.getSord());
        } else if ("state".equals(gparam.getSidx())) {
            param.setOrderBy(" r.deal_status+r.supervise_deal_status " + gparam.getSord() + ",r.deal_status " + gparam.getSord() + ",r.supervise_deal_status " + gparam.getSord());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        List<PhcPhysicalCheckAbnormal> list = this.getAbnormalList(param);
        return new PageInfo(list);
    }

    public PageInfo<PhcPhysicalCheckAbnormal> getAbnormalPageV3_1(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (StringUtils.isEmpty((CharSequence)gparam.getSidx())) {
            param.setOrderBy(" c.update_date ");
        } else if ("staffName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_name " + gparam.getSord());
        } else if ("staffWorkNo".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_work_no " + gparam.getSord());
        } else if ("deptName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_dept_name " + gparam.getSord());
        } else if ("workName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.staff_work_name " + gparam.getSord());
        } else if ("checkDate".equals(gparam.getSidx())) {
            param.setOrderBy(" c.begin_time " + gparam.getSord());
        } else if ("checkTypeName".equals(gparam.getSidx())) {
            param.setOrderBy(" d.check_type " + gparam.getSord());
        } else if ("examResultName".equals(gparam.getSidx())) {
            param.setOrderBy(" r.exam_result " + gparam.getSord());
        } else if ("state".equals(gparam.getSidx())) {
            param.setOrderBy(" r.deal_status+r.supervise_deal_status " + gparam.getSord() + ",r.deal_status " + gparam.getSord() + ",r.supervise_deal_status " + gparam.getSord());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        List<PhcPhysicalCheckAbnormal> list = this.getAbnormalListV3_1(param);
        return new PageInfo(list);
    }

    public int getAbnormalCount(PhcPhysicalCheckAbnormalParam param) {
        List<PhcPhysicalCheckAbnormal> list = ((PhcPhysicalCheckDataResultMapper)this.dao).getAbnormalList(param);
        return list == null ? 0 : list.size();
    }

    @Transactional(readOnly=false)
    public void updateDealInfo(PhcPhysicalCheckDataResult result, Long staffId, Long cid) {
        if (result == null || result.getId() == null) {
            return;
        }
        result.setUpdateBy(staffId);
        result.setUpdateDate(new Date());
        ((PhcPhysicalCheckDataResultMapper)this.dao).updateDealInfo(result);
        this.copyByDealType(result, cid);
    }

    @Transactional(readOnly=false)
    public void rechckBatchPost(PhcPhysicalCheckDataResult data, Long staffId, Long cid) {
        List resustIds = StringUtils.parseToLongList((String)data.getRecheckBatchIds());
        if (resustIds.isEmpty()) {
            return;
        }
        resustIds.forEach(r -> {
            data.setId(r);
            this.updateDealInfo(data, staffId, cid);
        });
    }

    public PhyCheckDataResultInfo getCheckResultInfo(Long id) {
        PhyCheckDataResultInfo resultInfo = ((PhcPhysicalCheckDataResultMapper)this.dao).getCheckResultInfo(id);
        if (resultInfo != null) {
            resultInfo.setAge(resultInfo.getBirthday() == null ? null : Integer.valueOf(DateUtils.getAgeByYear((Date)resultInfo.getBirthday())));
            resultInfo.setGenderName(StaffGenderEnum.getName((Integer)resultInfo.getGender()));
            resultInfo.setHarmNames(this.getHarmNames(resultInfo.getHarmIds()));
            resultInfo.setRessultName(ExamResultEnum.getName((String)resultInfo.getRessult()));
            resultInfo.setHarms(this.harmFactorService.getHarmByIds(resultInfo.getHarmIds()));
            resultInfo.setOccHarms(this.harmFactorService.getHarmByIds(resultInfo.getOccHarmIds()));
            resultInfo.setOccHarmNames(this.getHarmNames(resultInfo.getOccHarmIds()));
            resultInfo.setCompanyFullAreaName(this.sysAreaService.getFullName(resultInfo.getCompanyAreaId(), ""));
        }
        return resultInfo;
    }

    public List<PhcPhysicalCheckDataResult> queryByCheckId(Long checkId) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).queryByCheckId(checkId);
    }

    @Transactional(readOnly=false)
    public void updateSuperviseStatus(Long resultId, Integer superviseStatus) {
        ((PhcPhysicalCheckDataResultMapper)this.dao).updateSuperviseStatus(resultId, superviseStatus);
    }

    public PhcPhysicalCheckDataResult getDataResultByStaffId(Long staffId, String workName) {
        List<PhcPhysicalCheckDataResult> list = ((PhcPhysicalCheckDataResultMapper)this.dao).getDataResultByStaffId(staffId, workName);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private String getHarmNames(String harmIds) {
        List ids = StringUtils.parseToLongList((String)harmIds);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getHarmNames(ids);
    }

    private void copyByDealType(PhcPhysicalCheckDataResult result, Long cid) {
        Byte dealStatus = result.getDealStatus();
        if (dealStatus == null || dealStatus == 0) {
            return;
        }
        String companyName = this.companyProvideByHSEService.getCompanyNameById(cid);
        this.companyWorkOperateLogService.report(result.getId(), WorkOperateLogEnum.phc.getTypeVal(), result.getUpdateBy(), result.getUpdator(), companyName);
        String dealType = String.valueOf(result.getDealType());
        if (dealType == null) {
            return;
        }
        if (DealTypeEnum.recheck.getCode().equals(dealType) || DealTypeEnum.replenishCheck.getCode().equals(dealType)) {
            this.phcUnrecheckService.addByResult(result);
        } else if (DealTypeEnum.change.getCode().equals(dealType)) {
            this.phcWorkUnexchangeService.addByResult(result);
        }
        PhcPhysicalCheckDataResult checkResult = ((PhcPhysicalCheckDataResultMapper)this.dao).getResultInfoById(result.getId());
        if (!DealTypeEnum.diagnose.getCode().equals(dealType) && ExamResultEnum.so.getCode().equals(String.valueOf(checkResult.getExamResult()))) {
            this.phcDiagnoseDiseaseProcessService.updateByResult(result);
        }
    }

    public PhcPhysicalCheckDataResult getResultInfoById(Long id) {
        if (id == null) {
            return null;
        }
        PhcPhysicalCheckDataResult data = ((PhcPhysicalCheckDataResultMapper)this.dao).getResultInfoById(id);
        if (data == null) {
            return data;
        }
        data.setIdCard(SpringEncryptUtils.decrypt((String)data.getIdCard()));
        if (StringUtils.isNotEmpty((String)data.getHarmFactor())) {
            data.setHarmNames(this.harmFactorService.getHarmNames(data.getHarmFactor()));
        }
        if (StringUtils.isNotEmpty((String)data.getOccId())) {
            String occHarmName = this.harmFactorService.getHarmNames(data.getOccId());
            List harmNameList = StringUtils.parseToStringList((String)occHarmName, (String)",");
            StringBuilder occName = null;
            for (String harm : harmNameList) {
                if (occName == null) {
                    occName = new StringBuilder(harm + "\u804c\u4e1a\u7981\u5fcc");
                    continue;
                }
                occName.append(",").append(harm).append("\u804c\u4e1a\u7981\u5fcc");
            }
            assert (occName != null);
            data.setOccHarmNames(occName.toString());
        }
        return data;
    }

    public PhcPhysicalCheckResultDeal getResultDealInfo(PhcPhysicalCheckDataResult result) {
        if (result == null || result.getId() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getResultDealInfo(result);
    }

    @Transactional(readOnly=false)
    public void rechckInfoPost(PhcPhysicalCheckRechckDataVO recheckData, Long staffId, Long cid) {
        List results;
        if (recheckData == null || recheckData.getDataId() == null) {
            return;
        }
        Long dataId = recheckData.getDataId();
        this.deleteByDataId(String.valueOf(dataId));
        if (recheckData.getExamResults() == null || recheckData.getExamResults().size() == 0) {
            return;
        }
        List exams = recheckData.getExamResults();
        if (exams.contains(ExamResultEnum.noraml.getCode()) || exams.contains(ExamResultEnum.other.getCode())) {
            PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
            result.setIsValid(Boolean.valueOf(true));
            result.setDealStatus(Byte.valueOf((byte)0));
            result.setDataId(dataId);
            if (exams.contains(ExamResultEnum.noraml.getCode())) {
                result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.noraml.getCode())));
                this.add(result, staffId, cid);
                return;
            }
            result.setExamResult(Byte.valueOf(Byte.parseByte(ExamResultEnum.other.getCode())));
            this.add(result, staffId, cid);
        }
        if ((results = recheckData.getResults()) == null) {
            return;
        }
        for (PhcPhysicalCheckDataResult result : results) {
            Byte examResult = result.getExamResult();
            if (examResult == null || !exams.contains(String.valueOf(examResult))) continue;
            result.setIsValid(Boolean.valueOf(true));
            result.setDealStatus(Byte.valueOf((byte)0));
            result.setDataId(dataId);
            this.add(result, staffId, cid);
        }
    }

    public int countSDieasers(Long checkId) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).countSDieasers(checkId);
    }

    public List<Long> getNormalStaffIdsByCheck(PhcPhysicalCheckQuery param) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getNormalStaffIdsByCheck(param);
    }

    @Transactional(readOnly=false)
    public void deleteByInfo(PhcPhysicalCheckDataResult result) {
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        boolean haveCondition = false;
        if (result.getDataId() != null) {
            criteria.andEqualTo("dataId", (Object)result.getDataId());
            haveCondition = true;
        }
        if (result.getExamResult() != null) {
            criteria.andEqualTo("examResult", (Object)result.getExamResult());
            haveCondition = true;
        }
        if (haveCondition) {
            ((PhcPhysicalCheckDataResultMapper)this.dao).deleteByExample(example);
        }
    }

    public PageInfo<PhcPhysicalPersonInfo> getPersonCheckInfo(JqGridParam gparam, Long staffId) {
        if (gparam == null || staffId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalPersonCheckInfo> checkInfos = ((PhcPhysicalCheckDataResultMapper)this.dao).getPersonCheckInfo(staffId);
        List<PhcPhysicalPersonInfo> list = this.getPersonList(checkInfos, staffId);
        this.setFileModel(list);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<PhcPhysicalPersonCheckInfo> getPersonCheckInfoList(Long staffId) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getPersonCheckInfo(staffId);
    }

    private void setFileModel(List<PhcPhysicalPersonInfo> list) {
        StringBuilder sb = new StringBuilder();
        list.forEach(item -> {
            if (item.getReportFiles() == null || item.getReportFiles().isEmpty()) {
                return;
            }
            sb.append(item.getReportFiles());
            if (sb.indexOf(",") != sb.length() - 1) {
                sb.append(",");
            }
        });
        if (sb.length() == 0) {
            return;
        }
        List files = this.sysFileProvideService.getListByIds(sb.toString());
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (SysFileModel file : files) {
                for (PhcPhysicalPersonInfo detailVo : list) {
                    if (detailVo.getReportFiles() == null || detailVo.getReportFiles().isEmpty() || !detailVo.getReportFiles().contains("" + file.getId())) continue;
                    detailVo.getReportFileList().add(file);
                }
            }
        }
    }

    private List<PhcPhysicalPersonInfo> getPersonList(List<PhcPhysicalPersonCheckInfo> list, Long staffId) {
        ArrayList<PhcPhysicalPersonInfo> results = new ArrayList<PhcPhysicalPersonInfo>();
        if (list == null || list.size() == 0) {
            return results;
        }
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        StaffBasicInfo basic = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
        for (PhcPhysicalPersonCheckInfo l : list) {
            String from;
            PhcPhysicalPersonInfo r = new PhcPhysicalPersonInfo();
            r.setDetailId(l.getId());
            if (basic != null) {
                r.setStaffName(basic.getRealName());
            }
            if (work != null) {
                r.setWorkNo(work.getWorkNo());
            }
            if ("p".equals(from = l.getFrom())) {
                r.setCheckDate(l.getDiagnosedTime());
                r.setCheckType("\u804c\u4e1a\u75c5\u8bca\u65ad");
                r.setDealTypInfo(this.getDealInfo(l.getDealTypeInfo(), l.getPdInfoDesc()));
                r.setInfoDesc(StringUtils.isNotEmpty((String)l.getPdInfoDesc()) ? l.getPdInfoDesc() : "-");
                r.setDealDesc(StringUtils.isNotEmpty((String)l.getPdDealDesc()) ? l.getPdDealDesc() : "-");
                Boolean isSure = l.getIsSure();
                if (isSure == null) {
                    r.setIsSure("-");
                } else if (isSure.booleanValue()) {
                    r.setIsSure("\u662f");
                } else {
                    r.setIsSure("\u5426");
                }
                r.setCheckResult("\u975e\u804c\u4e1a\u75c5");
                r.setDetailUrl("/work/check/disease/process/view?id=" + l.getId());
            } else if ("o".equals(from)) {
                r.setCheckDate(l.getDiagnosedTime());
                r.setCheckType("\u804c\u4e1a\u75c5\u8bca\u65ad");
                r.setCheckResult(l.getDiseaseName());
                r.setDealTypInfo(this.getDealInfo(l.getDealTypeInfo(), l.getPdInfoDesc()));
                r.setInfoDesc(StringUtils.isNotEmpty((String)l.getPdInfoDesc()) ? l.getPdInfoDesc() : "-");
                r.setDealDesc(StringUtils.isNotEmpty((String)l.getPdDealDesc()) ? l.getPdDealDesc() : "-");
                if (l.getIsSure() == null) {
                    r.setIsSure("-");
                } else if (l.getIsSure().booleanValue()) {
                    r.setIsSure("\u662f");
                } else {
                    r.setIsSure("\u5426");
                }
                r.setDetailUrl("/work/check/diseaser/view/" + l.getId());
            } else {
                r.setCheckDate(l.getCheckDate());
                r.setCheckResult(ExamResultEnum.getName((String)l.getCheckResult()));
                r.setCheckType(CheckTypeEnum.getName((String)l.getCheckType()));
                r.setDealTypInfo(this.getDealInfo(DealTypeEnum.getName((String)l.getDealType()), l.getInfoDesc()));
                r.setInfoDesc(StringUtils.isNotEmpty((String)l.getInfoDesc()) ? l.getInfoDesc() : "-");
                r.setDealDesc(StringUtils.isNotEmpty((String)l.getDealDesc()) ? l.getDealDesc() : "-");
                if (StringUtils.isEmpty((CharSequence)l.getCheckResult())) {
                    r.setIsSure("-");
                } else if (ExamResultEnum.noraml.getCode().equals(l.getCheckResult()) || ExamResultEnum.other.getCode().equals(l.getCheckResult())) {
                    r.setIsSure("-");
                } else if (DealTypeEnum.recheck.getCode().equals(l.getDealType()) && String.valueOf(1).equals(l.getRecheckStatus())) {
                    r.setIsSure("\u662f");
                } else if (DealTypeEnum.change.getCode().equals(l.getDealType()) && l.getIsExchange() != null && l.getIsExchange().booleanValue()) {
                    r.setIsSure("\u662f");
                } else if (DealTypeEnum.diagnose.getCode().equals(l.getDealType()) && l.getIsDiagnosed() != null && l.getIsDiagnosed().booleanValue()) {
                    r.setIsSure("\u662f");
                } else {
                    r.setIsSure("\u5426");
                }
                r.setDetailUrl("/work/check/view?id=" + l.getId());
            }
            String examResult = l.getCheckResult();
            if (l.getResultId() != null && !ExamResultEnum.noraml.getCode().equals(examResult) && !ExamResultEnum.other.getCode().equals(examResult)) {
                r.setResultUrl("/work/check/data/result/deal/info?id=" + l.getResultId());
            }
            r.setHospitalName(l.getHospitalName());
            r.setDeptName(l.getDeptName());
            r.setWorkName(l.getWorkName());
            r.setCompanyName(l.getCompanyName());
            r.setAbnormal(l.getAbnormal());
            r.setCheckAdvise(l.getCheckAdvice());
            r.setHospital(l.getHospital());
            r.setConfirmation(l.getConfirmation());
            r.setResultId(l.getResultId());
            r.setReportFiles(l.getReportFiles());
            results.add(r);
        }
        return results;
    }

    public List<PhcPhysicalCheckResultInfo> countResultInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).countResultInfo(query);
    }

    public List<PhcPhysicalResultInfo> getResultInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getResultInfo(query);
    }

    public List<PhcPhysicalResultInfo> getYearResultInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getYearResultInfo(query);
    }

    public List<PhcPhysicalResultInfo> getDeptOrWorkYearResultInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getDeptOrWorkYearResultInfo(query);
    }

    public List<PhcPhysicalQueryCheckInfo> queryCheck(PhcPhysicalQueryCheck query) {
        if (query == null) {
            return null;
        }
        List<PhcPhysicalQueryCheckInfo> infos = ((PhcPhysicalCheckDataResultMapper)this.dao).queryCheck(query);
        this.countCheck(infos);
        return infos;
    }

    private void groupInfoResult(Map<String, Set<Long>> checkTypeStaffsMap, Map<String, Set<Long>> checkTypeResultStaffsMap, List<PhcPhysicalQueryCheckInfoResult> infoResults) {
        if (infoResults == null || infoResults.size() == 0) {
            return;
        }
        for (PhcPhysicalQueryCheckInfoResult result : infoResults) {
            Long checkId = result.getCheckId();
            Byte checkType = result.getCheckType();
            String checkTypeStaffsMapKey = checkId + "_" + checkType;
            String checkTypeResultStaffsMapKey = checkId + "_" + checkType + "_" + result.getExamResult();
            Set<Object> checkTypeStaffs = checkTypeStaffsMap.get(checkTypeStaffsMapKey) == null ? new HashSet() : checkTypeStaffsMap.get(checkTypeStaffsMapKey);
            checkTypeStaffs.add(result.getStaffId());
            checkTypeStaffsMap.put(checkTypeStaffsMapKey, checkTypeStaffs);
            Set<Object> checkTypeResultStaffs = checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey) == null ? new HashSet() : checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey);
            checkTypeResultStaffs.add(result.getStaffId());
            checkTypeResultStaffsMap.put(checkTypeResultStaffsMapKey, checkTypeResultStaffs);
        }
    }

    private void countInfoResult(Map<String, Set<Long>> checkTypeStaffsMap, Map<String, Set<Long>> checkTypeResultStaffsMap, PhcPhysicalQueryCheckInfo info) {
        Byte checkType;
        Long checkId = info.getCheckId();
        String checkTypeStaffsMapKey = checkId + "_" + (checkType = info.getCheckType());
        Set<Long> checkTypeStaffs = checkTypeStaffsMap.get(checkTypeStaffsMapKey);
        info.setTotal(Integer.valueOf(checkTypeStaffs == null ? 0 : checkTypeStaffs.size()));
        for (ExamResultEnum examResult : ExamResultEnum.values()) {
            Set<Object> checkTypeResultStaffs;
            String exam = examResult.getCode();
            String checkTypeResultStaffsMapKey = checkId + "_" + checkType + "_" + exam;
            Set<Object> set = checkTypeResultStaffs = checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey) == null ? new HashSet() : checkTypeResultStaffsMap.get(checkTypeResultStaffsMapKey);
            if (ExamResultEnum.noraml.getCode().equals(exam)) {
                info.setNormal(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.recheck.getCode().equals(exam)) {
                info.setRecheck(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.so.getCode().equals(exam)) {
                info.setSd(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (ExamResultEnum.oc.getCode().equals(exam)) {
                info.setOc(Integer.valueOf(checkTypeResultStaffs.size()));
                continue;
            }
            if (!ExamResultEnum.other.getCode().equals(exam)) continue;
            info.setOther(Integer.valueOf(checkTypeResultStaffs.size()));
        }
    }

    public List<PhcPhysicalCheckAbnormalInfo> queryCheckAbnormalResult(PhcPhysicalCheckParam param) {
        List<PhcPhysicalCheckAbnormalInfo> infos = ((PhcPhysicalCheckDataResultMapper)this.dao).queryCheckAbnormalResult(param);
        if (infos == null || infos.size() == 0) {
            return infos;
        }
        for (PhcPhysicalCheckAbnormalInfo info : infos) {
            String dealType = String.valueOf(info.getDealType());
            info.setCheckTypeName(CheckTypeEnum.getName((String)String.valueOf(info.getCheckType())));
            info.setCheckResultName(ExamResultEnum.getName((String)String.valueOf(info.getCheckResult())));
            info.setDealTypeName(DealTypeEnum.getName((String)dealType));
            if (info.getCheckResult() == null) {
                info.setIsSureName("-");
                continue;
            }
            if (DealTypeEnum.recheck.getCode().equals(dealType) && String.valueOf(1).equals(String.valueOf(info.getRecheckStatus()))) {
                info.setIsSureName("\u662f");
                continue;
            }
            if (DealTypeEnum.change.getCode().equals(dealType) && info.getIsExchange() != null && info.getIsExchange().booleanValue()) {
                info.setIsSureName("\u662f");
                continue;
            }
            if (DealTypeEnum.diagnose.getCode().equals(dealType) && info.getIsDiagnose() != null && info.getIsDiagnose().booleanValue()) {
                info.setIsSureName("\u662f");
                continue;
            }
            info.setIsSureName("\u5426");
        }
        return infos;
    }

    public PageInfo<PhcPhysicalCheckConfiredInfo> getConfirmedCheck(JqGridParam gparam, PhcPhysicalCheckParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        List<Long> listCheckId = this.getConfirmedCheckIdList(param);
        if (listCheckId == null || listCheckId.isEmpty()) {
            return new PageInfo();
        }
        param.setCheckIds(listCheckId);
        return this.getConfirmedCheckPage(gparam, param);
    }

    private PageInfo<PhcPhysicalCheckConfiredInfo> getConfirmedCheckPage(JqGridParam gparam, PhcPhysicalCheckParam param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcPhysicalCheckConfiredInfo> list = ((PhcPhysicalCheckDataResultMapper)this.dao).getConfirmedByCheckIds(param);
        if (list != null) {
            for (PhcPhysicalCheckConfiredInfo l : list) {
                l.setManagerName(SpringEncryptUtils.decrypt((String)l.getManagerName()));
                l.setFiles(this.checkFileService.getFilesDetailByPidAndType(l.getCheckId(), Byte.valueOf((byte)1)));
                this.setManagerHistoryNameByCheckDate(l);
            }
        }
        PageInfo page = new PageInfo(list);
        return page;
    }

    private List<Long> getConfirmedCheckIdList(PhcPhysicalCheckParam param) {
        ArrayList<Long> checkIds = new ArrayList<Long>();
        List<PhcPhysicalCheckConfiredInfo> list = ((PhcPhysicalCheckDataResultMapper)this.dao).getConfirmedCheckId(param);
        for (PhcPhysicalCheckConfiredInfo l : list) {
            Long checkId = l.getCheckId();
            if (checkId == null || checkIds.contains(checkId)) continue;
            checkIds.add(checkId);
        }
        return checkIds;
    }

    public List<PhcPhysicalCheckConfiredInfo> getConfirmedCheckList(Long cid, Integer year) {
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCid(cid);
        if (year != null) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            param.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            param.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        List<PhcPhysicalCheckConfiredInfo> list = this.getConfirmedCheckList(param);
        return list;
    }

    public List<PhcPhysicalCheckConfiredInfo> getConfirmedCheckList(PhcPhysicalCheckParam param) {
        DataScopeHelper.startDataScope("healthCheck", "phc_physical_check");
        List<Long> listCheckId = this.getConfirmedCheckIdList(param);
        if (listCheckId == null || listCheckId.isEmpty()) {
            return Collections.emptyList();
        }
        param.setCheckIds(listCheckId);
        if (param == null || param.getCid() == null) {
            return null;
        }
        List<PhcPhysicalCheckConfiredInfo> list = ((PhcPhysicalCheckDataResultMapper)this.dao).getConfirmedByCheckIds(param);
        if (list != null) {
            for (PhcPhysicalCheckConfiredInfo l : list) {
                l.setManagerName(SpringEncryptUtils.decrypt((String)l.getManagerName()));
                l.setFiles(this.checkFileService.getFilesDetailByPidAndType(l.getCheckId(), Byte.valueOf((byte)1)));
                this.setManagerHistoryNameByCheckDate(l);
            }
        }
        return list;
    }

    private void setManagerHistoryNameByCheckDate(PhcPhysicalCheckConfiredInfo l) {
        Date checkBeginTime;
        Long managerId = l.getManagerId();
        String managerHistoryName = this.staffInfoService.getHistroyRealNameByIdAndYear(managerId, checkBeginTime = l.getCheckBeginTime());
        if (StringUtils.isNotBlank((CharSequence)managerHistoryName)) {
            l.setManagerName(managerHistoryName);
        }
    }

    public void countCheck(List<PhcPhysicalQueryCheckInfo> infos) {
        if (infos == null || infos.size() == 0) {
            return;
        }
        ArrayList<Long> checkIds = new ArrayList<Long>();
        ArrayList<Byte> checkTypes = new ArrayList<Byte>();
        for (PhcPhysicalQueryCheckInfo info : infos) {
            if (!checkIds.contains(info.getCheckId())) {
                checkIds.add(info.getCheckId());
            }
            if (!checkTypes.contains(info.getCheckType())) {
                checkTypes.add(info.getCheckType());
            }
            this.setHistoryInfos(info);
        }
        PhcPhysicalQueryCheck resultQuery = new PhcPhysicalQueryCheck();
        resultQuery.setCheckIds(checkIds);
        resultQuery.setCheckTypes(checkTypes);
        List<PhcPhysicalQueryCheckInfoResult> infoResults = ((PhcPhysicalCheckDataResultMapper)this.dao).queryCheckResult(resultQuery);
        HashMap<String, Set<Long>> checkTypeStaffsMap = new HashMap<String, Set<Long>>();
        HashMap<String, Set<Long>> checkTypeResultStaffsMap = new HashMap<String, Set<Long>>();
        this.groupInfoResult(checkTypeStaffsMap, checkTypeResultStaffsMap, infoResults);
        for (PhcPhysicalQueryCheckInfo info : infos) {
            this.countInfoResult(checkTypeStaffsMap, checkTypeResultStaffsMap, info);
        }
    }

    private void setHistoryInfos(PhcPhysicalQueryCheckInfo info) {
        Date beginTime = info.getBeginTime();
        if (beginTime == null) {
            return;
        }
        if (info.getHospital() != null) {
            // empty if block
        }
    }

    public List<PhcPhysicalCheckResultDeal> getCheckResultAndDealInfo(PhcPhysicalCheckParam param) {
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getCheckResultAndDealInfo(param);
    }

    public List<Doc6Table3> doc6Table3(Long staffId) {
        ArrayList<Doc6Table3> results = new ArrayList<Doc6Table3>();
        if (staffId == null) {
            return results;
        }
        List<PhcPhysicalPersonCheckInfo> infos = ((PhcPhysicalCheckDataResultMapper)this.dao).doc6Table3(staffId);
        Doc6Table3 result1 = new Doc6Table3();
        if (infos == null || infos.size() == 0) {
            return results;
        }
        for (PhcPhysicalPersonCheckInfo info : infos) {
            Doc6Table3 result = new Doc6Table3();
            String dealType = info.getDealType();
            result.setReportFiles(info.getReportFiles());
            result.setCheckDate(info.getCheckDate());
            result.setCheckHospital(info.getHospitalName());
            result.setDealInfo(this.getDealInfo(DealTypeEnum.getName((String)dealType), info.getInfoDesc()));
            result.setDealDesc(info.getDealDesc());
            result.setCheckType(CheckTypeEnum.getName((String)String.valueOf(info.getCheckType())));
            result.setCheckResult(ExamResultEnum.getName((String)String.valueOf(info.getCheckResult())));
            result.setCheckWork(info.getWorkName());
            String from = info.getFrom();
            if ("p".equals(from)) {
                result.setCheckDate(info.getDiagnosedTime());
                result.setCheckType("\u804c\u4e1a\u75c5\u8bca\u65ad");
                result.setCheckHospital(info.getDiagnosedName());
                result.setDealInfo(this.getDealInfo(info.getDealTypeInfo(), info.getPdInfoDesc()));
                result.setDealDesc(info.getPdDealDesc());
                result.setCheckWork(info.getPWorkName());
                isSure = info.getIsSure();
                if (isSure == null) {
                    result.setSure("");
                } else if (isSure.booleanValue()) {
                    result.setSure("\u662f");
                } else {
                    result.setSure("\u5426");
                }
                result.setCheckResult("\u975e\u804c\u4e1a\u75c5");
            } else if ("o".equals(from)) {
                result.setCheckDate(info.getDiagnosedTime());
                result.setCheckType("\u804c\u4e1a\u75c5\u8bca\u65ad");
                result.setCheckHospital(info.getDiagnosedName());
                result.setDealInfo(this.getDealInfo(info.getDealTypeInfo(), info.getPdInfoDesc()));
                result.setDealDesc(info.getPdDealDesc());
                result.setCheckWork(info.getPWorkName());
                isSure = info.getIsSure();
                if (isSure == null) {
                    result.setSure("");
                } else if (isSure.booleanValue()) {
                    result.setSure("\u662f");
                } else {
                    result.setSure("\u5426");
                }
                result.setCheckResult(info.getDiseaseName());
            } else if (info.getCheckResult() == null || ExamResultEnum.noraml.getCode().equals(info.getCheckResult()) || ExamResultEnum.other.getCode().equals(info.getCheckResult())) {
                result.setSure("");
            } else if (DealTypeEnum.recheck.getCode().equals(dealType) && String.valueOf(1).equals(info.getRecheckStatus())) {
                result.setSure("\u662f");
            } else if (DealTypeEnum.change.getCode().equals(dealType) && info.getIsExchange() != null && info.getIsExchange().booleanValue()) {
                result.setSure("\u662f");
            } else if (DealTypeEnum.diagnose.getCode().equals(dealType) && info.getIsDiagnosed() != null && info.getIsDiagnosed().booleanValue()) {
                result.setSure("\u662f");
            } else {
                result.setSure("\u5426");
            }
            results.add(result);
        }
        return results;
    }

    private String getDealInfo(String dealType, String infoDesc) {
        Object result = "-";
        if (StringUtils.isNotEmpty((String)dealType) && StringUtils.isNotEmpty((String)infoDesc)) {
            result = dealType + "\uff1b" + infoDesc;
        } else if (StringUtils.isNotEmpty((String)dealType)) {
            result = dealType;
        } else if (StringUtils.isNotEmpty((String)infoDesc)) {
            result = infoDesc;
        }
        return result;
    }

    public List<Doc6Table4_1> doc6Table4_1(Long staffId) {
        ArrayList<Doc6Table4_1> results = new ArrayList<Doc6Table4_1>();
        if (staffId == null) {
            return results;
        }
        List<PhcPhysicalPersonCheckInfo> infos = ((PhcPhysicalCheckDataResultMapper)this.dao).doc6Table4_1(staffId);
        if (infos == null || infos.size() == 0) {
            return results;
        }
        for (PhcPhysicalPersonCheckInfo info : infos) {
            Doc6Table4_1 result = new Doc6Table4_1();
            result.setCheckData(info.getCheckDate());
            if (StringUtils.isNotEmpty((String)info.getDiagnosedTime())) {
                result.setCheckData(info.getDiagnosedTime());
            }
            result.setCheckType(CheckTypeEnum.getName((String)info.getCheckType()));
            result.setReportLocation(info.getReportLocation());
            results.add(result);
        }
        return results;
    }

    public List<PhcPhysicalCheckAbnormal> getSuspectDiseaseList(PhcPhysicalCheckAbnormalParam param) {
        if (param == null || param.getStaffId() == null || param.getCheckId() == null) {
            return null;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getSuspectDiseaseList(param);
    }

    @Transactional(readOnly=true)
    public void addSuspectedDiseasersByCheckId(Long checkId) {
        if (checkId == null) {
            return;
        }
        List<PhcPhysicalCheckDataResult> list = ((PhcPhysicalCheckDataResultMapper)this.dao).getSuspectedDiseasers(checkId);
        if (list == null || list.size() == 0) {
            return;
        }
        for (PhcPhysicalCheckDataResult l : list) {
            this.phcDiagnoseDiseaseProcessService.addByResult(l);
        }
    }

    @Transactional(readOnly=true)
    public void deleteDieasersByCheckIds(List<Long> idArray) {
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        for (Long checkId : idArray) {
            this.phcDiagnoseDiseaseProcessService.deleteByCheckId(checkId);
            List<Long> resultIds = ((PhcPhysicalCheckDataResultMapper)this.dao).getResultIdByCheckId(checkId);
            if (resultIds == null || resultIds.size() == 0) continue;
            this.unrecheckLastCheckResultService.deleteByResultIds(resultIds);
            this.workUnexchangeLastCheckResultService.deleteByResultIds(resultIds);
            this.diseaserDetailService.deleteByResultIds(resultIds);
        }
    }

    public void deleteByDataIdAndExamResult(Long dataId, Byte examResult) {
        if (dataId == null || examResult == null) {
            return;
        }
        Example example = new Example(PhcPhysicalCheckDataResult.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dataId", (Object)dataId).andEqualTo("examResult", (Object)examResult);
        ((PhcPhysicalCheckDataResultMapper)this.dao).deleteByExample(example);
    }

    public PageInfo<PhcDieaserUnprocessInfo> getSDPage(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcDieaserUnprocessInfo> sdList = ((PhcPhysicalCheckDataResultMapper)this.dao).getSDList(param);
        this.setReformResult(sdList);
        return new PageInfo(sdList);
    }

    public Integer getSDNum(PhcPhysicalCheckAbnormalParam param) {
        if (param.getCid() == null) {
            return 0;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getSDNum(param);
    }

    public PageInfo<PhcDieaserUnprocessParam> getPatientData(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcDieaserUnprocessParam> sdList = ((PhcPhysicalCheckDataResultMapper)this.dao).getPatientList(param);
        this.setReformResultPatient(sdList);
        return new PageInfo(sdList);
    }

    public List<PhcDieaserUnprocessParam> getPatientDataByCid(Long cid) {
        PhcPhysicalCheckAbnormalParam param = new PhcPhysicalCheckAbnormalParam();
        param.setCid(cid);
        List<PhcDieaserUnprocessParam> sdList = ((PhcPhysicalCheckDataResultMapper)this.dao).getPatientList(param);
        this.setReformResultPatient(sdList);
        return sdList;
    }

    public PageInfo<PhcDieaserUnprocessInfo> listRecheckData(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcDieaserUnprocessInfo> recheckList = ((PhcPhysicalCheckDataResultMapper)this.dao).getRecheckList(param);
        this.setReformResult(recheckList);
        return new PageInfo(recheckList);
    }

    public Integer getRecheckNum(PhcPhysicalCheckAbnormalParam param) {
        if (param.getCid() == null) {
            return 0;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getRecheckNum(param);
    }

    private void setReformResultPatient(List<PhcDieaserUnprocessParam> list) {
        LinkedList<Long> resultIds = new LinkedList<Long>();
        for (PhcDieaserUnprocessParam info : list) {
            resultIds.add(info.getResultId());
        }
        Map resultMap = this.reformItemBasicService.getResult(resultIds);
        for (PhcDieaserUnprocessParam info : list) {
            info.setReformResult((Byte)resultMap.get(info.getResultId()));
        }
    }

    private void setReformResult(List<PhcDieaserUnprocessInfo> list) {
        LinkedList<Long> resultIds = new LinkedList<Long>();
        for (PhcDieaserUnprocessInfo info : list) {
            resultIds.add(info.getResultId());
        }
        Map resultMap = this.reformItemBasicService.getResult(resultIds);
        for (PhcDieaserUnprocessInfo info : list) {
            info.setReformResult((Byte)resultMap.get(info.getResultId()));
        }
    }

    public PageInfo<PhcDieaserUnprocessInfo> listOCData(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcDieaserUnprocessInfo> ocList = ((PhcPhysicalCheckDataResultMapper)this.dao).getOcList(param);
        if (!ocList.isEmpty()) {
            for (PhcDieaserUnprocessInfo info : ocList) {
                String occIds = info.getOccIds();
                info.setOccNames(this.harmFactorService.getHarmNames(occIds));
            }
        }
        this.setReformResult(ocList);
        return new PageInfo(ocList);
    }

    public Integer getOCNum(PhcPhysicalCheckAbnormalParam param) {
        if (param.getCid() == null) {
            return 0;
        }
        return ((PhcPhysicalCheckDataResultMapper)this.dao).getOCNum(param);
    }

    public PhcSDInfo getSDById(Long resultId) {
        PhcSDInfo info = ((PhcPhysicalCheckDataResultMapper)this.dao).getSDById(resultId);
        if (info != null) {
            info.setWorkHarms(this.harmService.getHarmNamesByWork(info.getCid(), info.getStaffWorkId(), " "));
        }
        return info;
    }
}

