/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedDetail;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedStaff;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCountInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultGroupCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultTypeGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckTypeInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcYearCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table4_2;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcDiagnoseDiseaseProcessService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.PhcPhysicalCheckSummaryVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCheckCountServiceImpl
implements IPhcPhysicalCheckCountService {
    @Autowired
    IPhcPhysicalCheckDataService dataService;
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IPhcOccupationalDiseaserService diseaserService;
    @Autowired
    IPhcDiagnoseDiseaseProcessService suspectedDiseaserService;
    @Autowired
    IPhcPhysicalCheckService checkService;
    @DubboReference
    ISysFileProvideService sysFileService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    ICompanyOrganizationService orgService;
    @Autowired
    IWorkRoleInfoService workRoleService;

    public List<PhcPhysicalCheckTypeInfo> checkTypesInfo(PhcPhysicalYearCountQuery query) {
        return this.dataService.checkTypesInfo(query);
    }

    public PhcPhysicalCheckResultCount countResult(PhcPhysicalYearCountQuery query) {
        List resultInfo = this.resultService.countResultInfo(query);
        int total = 0;
        PhcPhysicalCheckResultCount count = new PhcPhysicalCheckResultCount();
        PhcYearCheckInfo params = new PhcYearCheckInfo();
        params.setCid(query.getCid());
        params.setBeginYear(query.getBeginYear());
        params.setEndYear(query.getEndYear());
        Integer diseasers = this.diseaserService.countYearDiseasers(params);
        count.setDiseasers(diseasers);
        count.setTotal(Integer.valueOf(total += diseasers.intValue()));
        if (resultInfo == null || resultInfo.size() == 0) {
            return count;
        }
        HashMap resultMap = new HashMap();
        for (PhcPhysicalCheckResultInfo phcPhysicalCheckResultInfo : resultInfo) {
            Byte resultKey = phcPhysicalCheckResultInfo.getExamResult();
            String value = phcPhysicalCheckResultInfo.getCheckId() + "_" + phcPhysicalCheckResultInfo.getCheckType() + "_" + phcPhysicalCheckResultInfo.getStaffId();
            Set<CallSite> checkResultStaffs = resultMap.get(resultKey) == null ? new HashSet() : (Set)resultMap.get(resultKey);
            checkResultStaffs.add((CallSite)((Object)value));
            resultMap.put(resultKey, checkResultStaffs);
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            Set value = (Set)entry.getValue();
            String key = String.valueOf(entry.getKey());
            int valueCount = value == null ? 0 : value.size();
            total += valueCount;
            if (ExamResultEnum.noraml.getCode().equals(key)) {
                count.setNormal(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.recheck.getCode().equals(key)) {
                count.setRecheck(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.so.getCode().equals(key)) {
                count.setSd(Integer.valueOf(valueCount));
                continue;
            }
            if (ExamResultEnum.oc.getCode().equals(key)) {
                count.setOc(Integer.valueOf(valueCount));
                continue;
            }
            if (!ExamResultEnum.other.getCode().equals(key)) continue;
            count.setOther(Integer.valueOf(valueCount));
        }
        count.setTotal(Integer.valueOf(total));
        return count;
    }

    public List<PhcPhysicalCheckResultCount> countCheckTypeResult(PhcPhysicalYearCountQuery query) {
        ArrayList<PhcPhysicalCheckResultCount> checkTypes = new ArrayList<PhcPhysicalCheckResultCount>();
        List resultInfo = this.resultService.countResultInfo(query);
        if (resultInfo == null || resultInfo.size() == 0) {
            return checkTypes;
        }
        HashMap checkTypeMap = new HashMap();
        HashMap checkTypeStaffMap = new HashMap();
        for (PhcPhysicalCheckResultInfo phcPhysicalCheckResultInfo : resultInfo) {
            Byte checkTypeKey = phcPhysicalCheckResultInfo.getCheckType();
            Map resultMap = checkTypeMap.get(checkTypeKey) == null ? new HashMap() : (Map)checkTypeMap.get(checkTypeKey);
            Byte resultKey = phcPhysicalCheckResultInfo.getExamResult();
            String value = phcPhysicalCheckResultInfo.getCheckId() + "_" + phcPhysicalCheckResultInfo.getCheckType() + "_" + phcPhysicalCheckResultInfo.getStaffId();
            Set<CallSite> checkResultStaffs = resultMap.get(resultKey) == null ? new HashSet() : (Set)resultMap.get(resultKey);
            checkResultStaffs.add((CallSite)((Object)value));
            resultMap.put(resultKey, checkResultStaffs);
            checkTypeMap.put(checkTypeKey, resultMap);
            Set<Long> checkTypeStaffSet = checkTypeStaffMap.get(checkTypeKey) == null ? new HashSet() : (Set)checkTypeStaffMap.get(checkTypeKey);
            checkTypeStaffSet.add(phcPhysicalCheckResultInfo.getStaffId());
            checkTypeStaffMap.put(checkTypeKey, checkTypeStaffSet);
        }
        for (Map.Entry entry : checkTypeMap.entrySet()) {
            Map resultMap = (Map)entry.getValue();
            Byte checkTypeKey = (Byte)entry.getKey();
            int checkTypeTotal = 0;
            PhcPhysicalCheckResultCount checkTypeCount = new PhcPhysicalCheckResultCount();
            checkTypeCount.setCheckType(checkTypeKey);
            for (Map.Entry result : resultMap.entrySet()) {
                Set value = (Set)result.getValue();
                String key = String.valueOf(result.getKey());
                int valueCount = value == null ? 0 : value.size();
                checkTypeTotal += valueCount;
                if (ExamResultEnum.noraml.getCode().equals(key)) {
                    checkTypeCount.setNormal(Integer.valueOf(valueCount));
                    continue;
                }
                if (ExamResultEnum.recheck.getCode().equals(key)) {
                    checkTypeCount.setRecheck(Integer.valueOf(valueCount));
                    continue;
                }
                if (ExamResultEnum.so.getCode().equals(key)) {
                    checkTypeCount.setSd(Integer.valueOf(valueCount));
                    continue;
                }
                if (ExamResultEnum.oc.getCode().equals(key)) {
                    checkTypeCount.setOc(Integer.valueOf(valueCount));
                    continue;
                }
                if (!ExamResultEnum.other.getCode().equals(key)) continue;
                checkTypeCount.setOther(Integer.valueOf(valueCount));
            }
            checkTypeCount.setTotal(Integer.valueOf(checkTypeTotal));
            checkTypeCount.setCheckTypeStaffTotal(Integer.valueOf(checkTypeStaffMap.get(checkTypeKey) == null ? 0 : ((Set)checkTypeStaffMap.get(checkTypeKey)).size()));
            checkTypes.add(checkTypeCount);
        }
        return checkTypes;
    }

    private List<PhcPhysicalCheckResultGroup> countResultInfo(List<PhcPhysicalResultInfo> infos, String deptOrWork) {
        ArrayList<PhcPhysicalCheckResultGroup> counts = new ArrayList<PhcPhysicalCheckResultGroup>();
        HashMap<String, PhcPhysicalCheckResultGroup> countMap = new HashMap<String, PhcPhysicalCheckResultGroup>();
        if (infos == null || infos.size() == 0) {
            return counts;
        }
        for (PhcPhysicalResultInfo phcPhysicalResultInfo : infos) {
            String countMapKey = null;
            String deptOrWorkName = null;
            Long deptOrWorkId = null;
            if ("dept".equals(deptOrWork)) {
                countMapKey = String.valueOf(phcPhysicalResultInfo.getDeptId());
                deptOrWorkId = phcPhysicalResultInfo.getDeptId();
                deptOrWorkName = phcPhysicalResultInfo.getDeptName();
            } else {
                deptOrWorkId = phcPhysicalResultInfo.getWorkId();
                countMapKey = String.valueOf(phcPhysicalResultInfo.getWorkId());
                deptOrWorkName = phcPhysicalResultInfo.getWorkName();
            }
            if (deptOrWorkId == null || deptOrWorkName == null) continue;
            PhcPhysicalCheckResultGroup group = (PhcPhysicalCheckResultGroup)countMap.get(countMapKey);
            if (group == null) {
                group = new PhcPhysicalCheckResultGroup();
                group.setDeptOrWorkId(deptOrWorkId);
                group.setDeptOrWorkName(deptOrWorkName);
            }
            String examResult = String.valueOf(phcPhysicalResultInfo.getExamResult());
            if (ExamResultEnum.noraml.getCode().equals(examResult)) {
                group.setNormal(Integer.valueOf(group.getNormal() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.recheck.getCode().equals(examResult)) {
                group.setRecheck(Integer.valueOf(group.getRecheck() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.so.getCode().equals(examResult)) {
                group.setSd(Integer.valueOf(group.getSd() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.oc.getCode().equals(examResult)) {
                group.setOc(Integer.valueOf(group.getOc() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.other.getCode().equals(examResult)) {
                group.setOther(Integer.valueOf(group.getOther() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if ("6".equals(examResult)) {
                group.setDiseasers(Integer.valueOf(group.getDiseasers() + phcPhysicalResultInfo.getExamResultTotal()));
            }
            countMap.put(countMapKey, group);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            counts.add((PhcPhysicalCheckResultGroup)entry.getValue());
        }
        return counts;
    }

    private List<PhcPhysicalCheckResultTypeGroup> countTypeResultInfo(List<PhcPhysicalResultInfo> infos, String deptOrWork) {
        ArrayList<PhcPhysicalCheckResultTypeGroup> counts = new ArrayList<PhcPhysicalCheckResultTypeGroup>();
        HashMap<Byte, PhcPhysicalCheckResultTypeGroup> countMap = new HashMap<Byte, PhcPhysicalCheckResultTypeGroup>();
        if (infos == null || infos.size() == 0) {
            return counts;
        }
        for (PhcPhysicalResultInfo phcPhysicalResultInfo : infos) {
            Byte checkType = phcPhysicalResultInfo.getCheckType();
            PhcPhysicalCheckResultTypeGroup typeGroup = (PhcPhysicalCheckResultTypeGroup)countMap.get(checkType);
            if (typeGroup == null) {
                typeGroup = new PhcPhysicalCheckResultTypeGroup();
                typeGroup.setCheckType(checkType);
            }
            Long deptOrWorkId = null;
            String deptOrWorkName = null;
            if ("dept".equals(deptOrWork)) {
                deptOrWorkId = phcPhysicalResultInfo.getDeptId();
                deptOrWorkName = phcPhysicalResultInfo.getDeptName();
            } else {
                deptOrWorkId = phcPhysicalResultInfo.getWorkId();
                deptOrWorkName = phcPhysicalResultInfo.getWorkName();
            }
            PhcPhysicalCheckResultGroup typeResultGroup = (PhcPhysicalCheckResultGroup)typeGroup.getResultGroup().get(deptOrWorkId);
            if (typeResultGroup == null) {
                typeResultGroup = new PhcPhysicalCheckResultGroup();
                typeResultGroup.setDeptOrWorkId(deptOrWorkId);
                typeResultGroup.setDeptOrWorkName(deptOrWorkName);
            }
            String examResult = String.valueOf(phcPhysicalResultInfo.getExamResult());
            if (ExamResultEnum.noraml.getCode().equals(examResult)) {
                typeResultGroup.setNormal(Integer.valueOf(typeResultGroup.getNormal() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.recheck.getCode().equals(examResult)) {
                typeResultGroup.setRecheck(Integer.valueOf(typeResultGroup.getRecheck() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.so.getCode().equals(examResult)) {
                typeResultGroup.setSd(Integer.valueOf(typeResultGroup.getSd() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.oc.getCode().equals(examResult)) {
                typeResultGroup.setOc(Integer.valueOf(typeResultGroup.getOc() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.other.getCode().equals(examResult)) {
                typeResultGroup.setOther(Integer.valueOf(typeResultGroup.getOther() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if ("6".equals(examResult)) {
                typeResultGroup.setDiseasers(Integer.valueOf(typeResultGroup.getDiseasers() + phcPhysicalResultInfo.getExamResultTotal()));
            }
            typeGroup.getResultGroup().put(deptOrWorkId, typeResultGroup);
            countMap.put(checkType, typeGroup);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            counts.add((PhcPhysicalCheckResultTypeGroup)entry.getValue());
        }
        return counts;
    }

    public PhcPhysicalCheckResultGroupCount countWorkResultInfo(PhcPhysicalYearCountQuery query) {
        List resultInfos = this.resultService.getResultInfo(query);
        List diseaserInfos = this.diseaserService.getResultInfo(query);
        ArrayList<PhcPhysicalResultInfo> allInfos = new ArrayList<PhcPhysicalResultInfo>();
        if (resultInfos != null && resultInfos.size() > 0) {
            allInfos.addAll(resultInfos);
        }
        if (diseaserInfos != null && diseaserInfos.size() > 0) {
            allInfos.addAll(diseaserInfos);
        }
        List<PhcPhysicalCheckResultGroup> deptOrWorkGroups = this.countResultInfo(allInfos, query.getDeptOrWork());
        List<PhcPhysicalCheckResultTypeGroup> deptOrWorkTypeGroups = this.countTypeResultInfo(allInfos, query.getDeptOrWork());
        PhcPhysicalCheckResultGroupCount count = new PhcPhysicalCheckResultGroupCount();
        count.setDeptOrWorkGroups(deptOrWorkGroups);
        count.setDeptOrWorkTypeGroups(deptOrWorkTypeGroups);
        return count;
    }

    public List<PhcPhysicalCheckResultGroup> countYearResultInfo(PhcPhysicalYearCountQuery query) {
        List resultInfos = this.resultService.getYearResultInfo(query);
        List diseaserInfos = this.diseaserService.getDeptOrWorkYearResultInfo(query);
        ArrayList<PhcPhysicalResultInfo> allInfos = new ArrayList<PhcPhysicalResultInfo>();
        if (resultInfos != null && resultInfos.size() > 0) {
            allInfos.addAll(resultInfos);
        }
        if (diseaserInfos != null && diseaserInfos.size() > 0) {
            allInfos.addAll(diseaserInfos);
        }
        return this.countResultGroup(allInfos);
    }

    private List<PhcPhysicalCheckResultGroup> countResultGroup(List<PhcPhysicalResultInfo> resultInfos) {
        ArrayList<PhcPhysicalCheckResultGroup> counts = new ArrayList<PhcPhysicalCheckResultGroup>();
        if (resultInfos == null || resultInfos.size() == 0) {
            return counts;
        }
        HashMap<Integer, PhcPhysicalCheckResultGroup> countMap = new HashMap<Integer, PhcPhysicalCheckResultGroup>();
        for (PhcPhysicalResultInfo phcPhysicalResultInfo : resultInfos) {
            Integer key = phcPhysicalResultInfo.getCheckYear();
            String exam = String.valueOf(phcPhysicalResultInfo.getExamResult());
            PhcPhysicalCheckResultGroup group = (PhcPhysicalCheckResultGroup)countMap.get(key);
            if (group == null) {
                group = new PhcPhysicalCheckResultGroup();
                group.setCheckYear(key);
            }
            if (ExamResultEnum.noraml.getCode().equals(exam)) {
                group.setNormal(Integer.valueOf(group.getNormal() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.recheck.getCode().equals(exam)) {
                group.setRecheck(Integer.valueOf(group.getRecheck() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.so.getCode().equals(exam)) {
                group.setSd(Integer.valueOf(group.getSd() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.oc.getCode().equals(exam)) {
                group.setOc(Integer.valueOf(group.getOc() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.other.getCode().equals(exam)) {
                group.setOther(Integer.valueOf(group.getOther() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if ("6".equals(exam)) {
                group.setDiseasers(Integer.valueOf(group.getDiseasers() + phcPhysicalResultInfo.getExamResultTotal()));
            }
            group.setTotal(Integer.valueOf(group.getTotal() + phcPhysicalResultInfo.getExamResultTotal()));
            countMap.put(key, group);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            counts.add((PhcPhysicalCheckResultGroup)entry.getValue());
        }
        return counts;
    }

    public List<PhcPhysicalCheckResultCountInfo> countDeptOrWorkYearResultInfo(PhcPhysicalYearCountQuery query) {
        ArrayList<PhcPhysicalCheckResultCountInfo> counts = new ArrayList<PhcPhysicalCheckResultCountInfo>();
        List resultInfos = this.resultService.getDeptOrWorkYearResultInfo(query);
        List diseaserInfos = this.diseaserService.getDeptOrWorkYearResultInfo(query);
        ArrayList allInfos = new ArrayList();
        if (resultInfos != null && resultInfos.size() > 0) {
            allInfos.addAll(resultInfos);
        }
        if (diseaserInfos != null && diseaserInfos.size() > 0) {
            allInfos.addAll(diseaserInfos);
        }
        if (allInfos.size() == 0) {
            return counts;
        }
        HashMap<String, PhcPhysicalCheckResultCountInfo> countMap = new HashMap<String, PhcPhysicalCheckResultCountInfo>();
        for (PhcPhysicalResultInfo phcPhysicalResultInfo : allInfos) {
            String deptOrWorkId = phcPhysicalResultInfo.getDeptOrWorkId();
            String deptOrWorkName = phcPhysicalResultInfo.getDeptOrWorkName();
            PhcPhysicalCheckResultCountInfo count = (PhcPhysicalCheckResultCountInfo)countMap.get(deptOrWorkId);
            if (count == null) {
                count = new PhcPhysicalCheckResultCountInfo();
                count.setGroupId(deptOrWorkId);
                count.setGroupName(deptOrWorkName);
                count.setDetails(new ArrayList());
            }
            List details = count.getDetails();
            Integer year = phcPhysicalResultInfo.getCheckYear();
            String exam = String.valueOf(phcPhysicalResultInfo.getExamResult());
            PhcPhysicalCheckResultGroup yearGroup = null;
            for (PhcPhysicalCheckResultGroup group : details) {
                if (year.intValue() != group.getCheckYear().intValue()) continue;
                yearGroup = group;
                break;
            }
            if (yearGroup == null) {
                yearGroup = new PhcPhysicalCheckResultGroup();
                yearGroup.setCheckYear(year);
                details.add(yearGroup);
            }
            if (ExamResultEnum.noraml.getCode().equals(exam)) {
                yearGroup.setNormal(Integer.valueOf(yearGroup.getNormal() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.recheck.getCode().equals(exam)) {
                yearGroup.setRecheck(Integer.valueOf(yearGroup.getRecheck() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.so.getCode().equals(exam)) {
                yearGroup.setSd(Integer.valueOf(yearGroup.getSd() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.oc.getCode().equals(exam)) {
                yearGroup.setOc(Integer.valueOf(yearGroup.getOc() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if (ExamResultEnum.other.getCode().equals(exam)) {
                yearGroup.setOther(Integer.valueOf(yearGroup.getOther() + phcPhysicalResultInfo.getExamResultTotal()));
            } else if ("6".equals(exam)) {
                yearGroup.setDiseasers(Integer.valueOf(yearGroup.getDiseasers() + phcPhysicalResultInfo.getExamResultTotal()));
            }
            yearGroup.setTotal(Integer.valueOf(yearGroup.getTotal() + phcPhysicalResultInfo.getExamResultTotal()));
            count.setDetails(details);
            countMap.put(deptOrWorkId, count);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            counts.add((PhcPhysicalCheckResultCountInfo)entry.getValue());
        }
        return counts;
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryCheckList(JqGridParam gparam, PhcPhysicalQueryCheck query) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List infoList = this.resultService.queryCheck(query);
        for (PhcPhysicalQueryCheckInfo info : infoList) {
            String str = "<a href='../work/check/view?id=" + info.getCheckId() + "'  target='_blank'>" + info.getCheckNo() + "</a>";
            info.setCheckNo(str);
        }
        return new PageInfo(infoList);
    }

    public PhcPhysicalQueryCheckInfo queryCheckInfo(Long checkId, Byte checkType) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        ArrayList<Long> checkIds = new ArrayList<Long>();
        checkIds.add(checkId);
        query.setCheckIds(checkIds);
        if (checkType != null) {
            ArrayList<Byte> checkTypes = new ArrayList<Byte>();
            checkTypes.add(checkType);
            query.setCheckTypes(checkTypes);
        }
        List infos = this.resultService.queryCheck(query);
        return this.countCheckInfo(infos);
    }

    private PhcPhysicalQueryCheckInfo countCheckInfo(List<PhcPhysicalQueryCheckInfo> infos) {
        if (infos == null || infos.size() == 0) {
            return new PhcPhysicalQueryCheckInfo();
        }
        if (infos.size() == 1) {
            return infos.get(0);
        }
        PhcPhysicalQueryCheckInfo count = infos.get(0);
        for (int i = 1; i < infos.size(); ++i) {
            PhcPhysicalQueryCheckInfo info = infos.get(i);
            count.setTotal(Integer.valueOf((count.getTotal() == null ? 0 : count.getTotal()) + (info.getTotal() == null ? 0 : info.getTotal())));
            count.setNormal(Integer.valueOf((count.getNormal() == null ? 0 : count.getNormal()) + (info.getNormal() == null ? 0 : info.getNormal())));
            count.setRecheck(Integer.valueOf((count.getRecheck() == null ? 0 : count.getRecheck()) + (info.getRecheck() == null ? 0 : info.getRecheck())));
            count.setSd(Integer.valueOf((count.getSd() == null ? 0 : count.getSd()) + (info.getSd() == null ? 0 : info.getSd())));
            count.setOc(Integer.valueOf((count.getOc() == null ? 0 : count.getOc()) + (info.getOc() == null ? 0 : info.getOc())));
            count.setOther(Integer.valueOf((count.getOther() == null ? 0 : count.getOther()) + (info.getOther() == null ? 0 : info.getOther())));
        }
        return count;
    }

    public List<PhcPhysicalCheckAbnormalInfo> queryCheckAbnormalResult(Long checkId, Byte checkType, String keyword) {
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCheckId(checkId);
        param.setCheckType(checkType);
        param.setKeyword(keyword);
        return this.resultService.queryCheckAbnormalResult(param);
    }

    public PageInfo<PhcPhysicalCheckAbnormalInfo> queryCheckAbnormalResult(JqGridParam gparam, PhcPhysicalCheckParam query) {
        if (gparam == null || query == null || query.getCheckId() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.resultService.queryCheckAbnormalResult(query));
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        PhcPhysicalCheckSummaryVO vo = new PhcPhysicalCheckSummaryVO();
        Integer unfinishChecks = this.unfinishCheckCount(cid, year);
        vo.setUnfinishChecks(unfinishChecks);
        Integer finishChecks = this.finishCheckCount(cid, year);
        vo.setFinishChecks(finishChecks);
        this.setCheckResultInfo(cid, year, vo);
        return vo;
    }

    public Integer checkConfiredTimes(Long cid, String year) {
        PhcPhysicalCheckParam query = this.getParam(cid, year, (byte)1);
        return this.checkService.countConfired(query);
    }

    private PhcPhysicalCheckParam getParam(Long cid, String year, Byte status) {
        PhcPhysicalCheckParam query = new PhcPhysicalCheckParam();
        query.setCid(cid);
        query.setStatus(status);
        if (StringUtils.isNotEmpty((String)year)) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            query.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            query.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        return query;
    }

    private int unfinishCheckCount(Long cid, String year) {
        PhcPhysicalCheckParam query = this.getParam(cid, year, (byte)0);
        List list = this.checkService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    private int finishCheckCount(Long cid, String year) {
        PhcPhysicalCheckParam query = this.getParam(cid, year, (byte)1);
        List list = this.checkService.listDetails(query);
        return list == null ? 0 : list.size();
    }

    private void setCheckResultInfo(Long cid, String year, PhcPhysicalCheckSummaryVO vo) {
        PhcPhysicalCheckParam param = this.getParam(cid, year, (byte)1);
        List results = this.resultService.getCheckResultAndDealInfo(param);
        if (results == null || results.size() == 0) {
            return;
        }
        HashSet<CallSite> checkStaffs = new HashSet<CallSite>();
        HashMap abnormalStaffMap = new HashMap();
        HashMap abnormalDealedStaffMap = new HashMap();
        for (PhcPhysicalCheckResultDeal phcPhysicalCheckResultDeal : results) {
            String key = phcPhysicalCheckResultDeal.getCheckId() + "_" + phcPhysicalCheckResultDeal.getCheckType() + "_" + phcPhysicalCheckResultDeal.getStaffId();
            checkStaffs.add((CallSite)((Object)key));
            String examResult = phcPhysicalCheckResultDeal.getExamResult();
            if (ExamResultEnum.noraml.getCode().equals(examResult) || ExamResultEnum.other.getCode().equals(examResult)) continue;
            Set<CallSite> abnormalStaffSet = abnormalStaffMap.get(examResult) == null ? new HashSet() : (Set)abnormalStaffMap.get(examResult);
            abnormalStaffSet.add((CallSite)((Object)key));
            abnormalStaffMap.put(examResult, abnormalStaffSet);
            Byte dealStatus = phcPhysicalCheckResultDeal.getDealStatus();
            if (dealStatus == null || dealStatus == 0) continue;
            Set<CallSite> abnormalStaffDealedSet = abnormalDealedStaffMap.get(examResult) == null ? new HashSet() : (Set)abnormalDealedStaffMap.get(examResult);
            abnormalStaffDealedSet.add((CallSite)((Object)key));
            abnormalDealedStaffMap.put(examResult, abnormalStaffDealedSet);
        }
        vo.setFinishCheckStaffs(Integer.valueOf(checkStaffs.size()));
        for (Map.Entry entry : abnormalStaffMap.entrySet()) {
            int abnormalStaffSize;
            String examResult = (String)entry.getKey();
            int n = abnormalStaffSize = entry.getValue() == null ? 0 : ((Set)entry.getValue()).size();
            if (ExamResultEnum.recheck.getCode().equals(examResult)) {
                vo.setRecheks(Integer.valueOf(abnormalStaffSize));
                continue;
            }
            if (ExamResultEnum.so.getCode().equals(examResult)) {
                vo.setSos(Integer.valueOf(abnormalStaffSize));
                continue;
            }
            if (!ExamResultEnum.oc.getCode().equals(examResult)) continue;
            vo.setOcs(Integer.valueOf(abnormalStaffSize));
        }
        int abnormalDealedTotal = 0;
        for (Map.Entry entry : abnormalDealedStaffMap.entrySet()) {
            String examResult = (String)entry.getKey();
            int abnormalDealedStaffSize = entry.getValue() == null ? 0 : ((Set)entry.getValue()).size();
            abnormalDealedTotal += abnormalDealedStaffSize;
            if (ExamResultEnum.recheck.getCode().equals(examResult)) {
                vo.setRecheckDealeds(Integer.valueOf(abnormalDealedStaffSize));
                continue;
            }
            if (ExamResultEnum.so.getCode().equals(examResult)) {
                vo.setSoDealeds(Integer.valueOf(abnormalDealedStaffSize));
                continue;
            }
            if (!ExamResultEnum.oc.getCode().equals(examResult)) continue;
            vo.setOcDealeds(Integer.valueOf(abnormalDealedStaffSize));
        }
        vo.setFinishDealStaffs(Integer.valueOf(abnormalDealedTotal));
    }

    public List<PhcDiseaserConfirmedStaff> getConfirmedListByQuery(Long cid, Integer year) {
        PhcDiseaserUnProcessParam query = new PhcDiseaserUnProcessParam();
        query.setCid(cid);
        if (year != null) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            query.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            query.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        return this.getConfirmedList(query);
    }

    public PageInfo<PhcDiseaserConfirmedDetail> getConfirmedPageByQuery(JqGridParam gparam, PhcDiseaserUnProcessParam query) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List list = this.diseaserService.getConfirmedListFromViewByQuery(query);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        for (PhcDiseaserConfirmedDetail l : list) {
            if (l.getStaffId() != null) {
                l.setStaffName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(l.getStaffId()));
            }
            if (l.getStaffDeptId() != null) {
                l.setStaffDeptName(this.orgService.getOrgNameById(l.getStaffDeptId()));
            }
            if (l.getStaffWorkId() == null) continue;
            l.setStaffWorkName(this.workRoleService.getWorkNameIncludeOrgName(l.getStaffWorkId()));
        }
        return new PageInfo(list);
    }

    public List<PhcDiseaserConfirmedDetail> getConfirmedListByQuery(PhcDiseaserUnProcessParam query) {
        List list = this.diseaserService.getConfirmedListByQuery(query);
        return list;
    }

    private List<PhcDiseaserConfirmedStaff> getConfirmedList(PhcDiseaserUnProcessParam query) {
        ArrayList<PhcDiseaserConfirmedStaff> staffs = new ArrayList<PhcDiseaserConfirmedStaff>();
        if (query.getCid() == null) {
            return staffs;
        }
        List all = this.diseaserService.getConfirmedListByQuery(query);
        if (all == null || all.size() == 0) {
            return staffs;
        }
        HashMap<Long, PhcDiseaserConfirmedStaff> staffMap = new HashMap<Long, PhcDiseaserConfirmedStaff>();
        for (PhcDiseaserConfirmedDetail a : all) {
            a.setCredenceFiles(this.getFiles(a.getCredenceUrl()));
            Long key = a.getStaffId();
            PhcDiseaserConfirmedStaff staff = (PhcDiseaserConfirmedStaff)staffMap.get(key);
            if (staff == null) {
                staff = this.createStaff(a);
            }
            staff.getDetails().add(a);
            staffMap.put(key, staff);
        }
        for (PhcDiseaserConfirmedStaff value : staffMap.values()) {
            staffs.add(value);
        }
        return staffs;
    }

    private List<SysFileModel> getFiles(String ids) {
        ArrayList<SysFileModel> files = new ArrayList<SysFileModel>();
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return files;
        }
        List fileIds = StringUtils.parseToLongList((String)ids, (String)",");
        for (Long fileId : fileIds) {
            SysFileModel file = this.sysFileService.getFileById(fileId);
            files.add(file);
        }
        return files;
    }

    private PhcDiseaserConfirmedStaff createStaff(PhcDiseaserConfirmedDetail detail) {
        PhcDiseaserConfirmedStaff staff = new PhcDiseaserConfirmedStaff();
        staff.setStaffId(detail.getStaffId());
        staff.setStaffName(detail.getStaffName());
        staff.setGender(this.getGender(detail.getGender()));
        staff.setBirthday(detail.getBirthday());
        staff.setStaffWorkNo(detail.getStaffWorkNo());
        return staff;
    }

    private String getGender(String gender) {
        if ("0".equals(gender)) {
            return "\u5973";
        }
        if ("1".equals(gender)) {
            return "\u7537";
        }
        return "";
    }

    public List<PhcDiseaserConfirmedDetail> getDiseaserListByQuery(Long staffId, Integer year) {
        if (staffId == null) {
            return null;
        }
        PhcDiseaserUnProcessParam query = new PhcDiseaserUnProcessParam();
        query.setStaffId(staffId);
        if (year != null) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            query.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            query.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        List diseasers = this.diseaserService.getDiseaserInfosByQuery(query);
        return diseasers;
    }

    public List<Doc6Table4_2> doc6Table4_2(Long staffId) {
        ArrayList<Doc6Table4_2> results = new ArrayList<Doc6Table4_2>();
        if (staffId == null) {
            return results;
        }
        PhcDiseaserUnProcessParam query = new PhcDiseaserUnProcessParam();
        query.setStaffId(staffId);
        List all = this.diseaserService.getConfirmedListByQuery(query);
        for (PhcDiseaserConfirmedDetail a : all) {
            Doc6Table4_2 result = new Doc6Table4_2();
            result.setDiagnosedTime(a.getDiagnosedTime());
            result.setDiseaseName(a.getDiseaseName());
            Boolean isDisease = a.getIsDisease();
            result.setIsDisease(isDisease);
            if (isDisease == null || !isDisease.booleanValue()) {
                result.setDiseaseName("\u2014");
            }
            List<SysFileModel> certs = this.getFiles(a.getCertUrl());
            result.setCerts(certs);
            results.add(result);
        }
        return results;
    }

    public Date getStaffFirstCheckBeginTime(Long staffId) {
        return this.dataService.getStaffFirstCheckBeginTime(staffId);
    }

    public Integer getConfirmedCountByYear(Long cid, String year) {
        List list;
        PhcDiseaserUnProcessParam param = new PhcDiseaserUnProcessParam();
        param.setCid(cid);
        if (StringUtils.isNotEmpty((String)year)) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            param.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            param.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        return (list = this.diseaserService.getConfirmedListByQuery(param)) == null ? 0 : list.size();
    }
}

