/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckCountMapper;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckCount;
import cn.smarthse.modules.health.entity.work.check.vo.count.CompanyCountInfo;
import cn.smarthse.modules.health.entity.work.check.vo.count.PhysicalExaminationCountInfo;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountDataService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class PhcPhysicalCheckCountDataServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckCountMapper, PhcPhysicalCheckCount>
implements IPhcPhysicalCheckCountDataService {
    @Autowired
    ICompanyService companyService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    private DataSourceTransactionManager txManager;

    private void clearAll() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            Example example = new Example(PhcPhysicalCheckCount.class);
            ((PhcPhysicalCheckCountMapper)this.dao).deleteByExample(example);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1\u6e05\u9664\u65e7\u6570\u636e\u51fa\u9519\u3011", (Throwable)e);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
    }

    @Transactional
    public void createSuperviseCountInfo() {
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u5f00\u59cb\u3011");
        this.clearAll();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
        Integer checkCount = ((PhcPhysicalCheckCountMapper)this.dao).countPhysicalCheckData();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u603b\u68c0\u6d4b\u6570\u636e\u5b8c\u6210\u3011");
        if (checkCount == null || checkCount == 0) {
            return;
        }
        int pages = (int)Math.ceil((double)checkCount.intValue() / 1000.0);
        Map<String, Integer> totalCount = this.getTotalCheckCount();
        Map<String, Integer> suspectedCount = this.getSuspectedCount();
        Map<String, Integer> ocCount = this.getOcCount();
        HashMap<String, Integer> dustCount = new HashMap<String, Integer>();
        HashMap<String, Set<String>> dustCountstaffs = new HashMap<String, Set<String>>();
        HashMap<String, Integer> chemistryCount = new HashMap<String, Integer>();
        HashMap<String, Set<String>> chemistryCountstaffs = new HashMap<String, Set<String>>();
        HashMap<String, Integer> physicalCount = new HashMap<String, Integer>();
        HashMap<String, Set<String>> physicalCountstaffs = new HashMap<String, Set<String>>();
        HashMap<String, Integer> radiationCount = new HashMap<String, Integer>();
        HashMap<String, Set<String>> radiationCountstaffs = new HashMap<String, Set<String>>();
        List<PhysicalExaminationCountInfo> companyphysicalCount = ((PhcPhysicalCheckCountMapper)this.dao).companyphysicalCount();
        Map allharms = this.harmFactorService.doGetAllIdAndTypeMap();
        if (companyphysicalCount != null && companyphysicalCount.size() != 0) {
            companyphysicalCount.forEach(item -> {
                item.setIdCard(SpringEncryptUtils.decrypt((String)item.getIdCard()));
                if (StringUtils.isNotEmpty((String)item.getHarmFactor())) {
                    for (String s : item.getHarmFactor().split(",")) {
                        String type = (String)allharms.get(Long.valueOf(s));
                        if ("\u7c89\u5c18".equals(type)) {
                            this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<String, Set<String>>)dustCountstaffs);
                        }
                        if ("\u5316\u5b66\u56e0\u7d20".equals(type)) {
                            this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<String, Set<String>>)chemistryCountstaffs);
                        }
                        if ("\u7269\u7406\u56e0\u7d20".equals(type)) {
                            this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<String, Set<String>>)physicalCountstaffs);
                        }
                        if (!"\u653e\u5c04\u56e0\u7d20".equals(type)) continue;
                        this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<String, Set<String>>)radiationCountstaffs);
                    }
                }
            });
        }
        this.mapPutOnInt(dustCountstaffs, dustCount);
        this.mapPutOnInt(chemistryCountstaffs, chemistryCount);
        this.mapPutOnInt(physicalCountstaffs, physicalCount);
        this.mapPutOnInt(radiationCountstaffs, radiationCount);
        for (int i = 1; i <= pages; ++i) {
            this.commitOneBatch(i, 1000, totalCount, suspectedCount, ocCount, dustCount, chemistryCount, physicalCount, radiationCount);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u4f53\u68c0\u4f01\u4e1a\u6570\u636e\u5b8c\u6210\u3011");
    }

    private void commitOneBatch(int page, int pageSize, Map<String, Integer> totalCount, Map<String, Integer> suspectedCount, Map<String, Integer> ocCount, Map<String, Integer> dustCount, Map<String, Integer> chemistryCount, Map<String, Integer> physicalCount, Map<String, Integer> radiationCount) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            Date now = new Date();
            int pageStart = (page - 1) * pageSize;
            List<PhcPhysicalCheckCount> countInfo = ((PhcPhysicalCheckCountMapper)this.dao).getCompanyCheckInfo(pageStart, pageSize);
            for (PhcPhysicalCheckCount info : countInfo) {
                info.setId(Long.valueOf(this.idworker.nextId()));
                String key = info.getCid() + "-" + info.getCheckId();
                info.setChecked(Integer.valueOf(1));
                info.setCheckTotal(totalCount.get(key));
                info.setSuspected(suspectedCount.get(key));
                info.setOc(ocCount.get(key));
                info.setDust(dustCount.get(key));
                info.setChemistry(chemistryCount.get(key));
                info.setPhysical(physicalCount.get(key));
                info.setRadiation(radiationCount.get(key));
            }
            ((PhcPhysicalCheckCountMapper)this.dao).insertBatch(countInfo);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1\u5f02\u5e38\u3011", (Throwable)e);
        }
    }

    private void mapPutOnSet(PhysicalExaminationCountInfo info, Map<String, Set<String>> map) {
        String key = info.getCid() + "-" + info.getCheckId();
        Set<String> set = map.get(key);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(String.valueOf(info.getIdCard()));
        map.put(key, set);
    }

    private void mapPutOnInt(Map<String, Set<String>> staffs, Map<String, Integer> cout) {
        for (Map.Entry<String, Set<String>> m : staffs.entrySet()) {
            cout.put(m.getKey(), m.getValue().size());
        }
    }

    private Map<Long, Integer> companyHarmCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCountMapper)this.dao).companyHarmCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> convertList(List<CompanyCountInfo> list) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (CompanyCountInfo l : list) {
            if (l.getTotal() == 0) continue;
            result.put(l.getCid(), l.getTotal());
        }
        return result;
    }

    private Map<String, Integer> convertListToMap(List<CompanyCountInfo> list) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (CompanyCountInfo l : list) {
            if (l.getTotal() == 0) continue;
            result.put(l.getCid() + "-" + l.getCheckId(), l.getTotal());
        }
        return result;
    }

    private Map<String, Integer> getTotalCheckCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCountMapper)this.dao).checkTotalCount();
        Map<String, Integer> result = this.convertListToMap(count);
        return result;
    }

    private Map<String, Integer> getOcCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCountMapper)this.dao).checkResultCount(4);
        Map<String, Integer> result = this.convertListToMap(count);
        return result;
    }

    private Map<String, Integer> getSuspectedCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCountMapper)this.dao).checkResultCount(3);
        Map<String, Integer> result = this.convertListToMap(count);
        return result;
    }
}

