/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCheckCompanyCountMapper;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckCompanyCount;
import cn.smarthse.modules.health.entity.work.check.vo.count.CompanyCountInfo;
import cn.smarthse.modules.health.entity.work.check.vo.count.DeclareRiskfactorInfo;
import cn.smarthse.modules.health.entity.work.check.vo.count.PhysicalExaminationCountInfo;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCompanyCountService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class PhcPhysicalCheckCompanyCountServiceImpl
extends BaseServiceImpl<PhcPhysicalCheckCompanyCountMapper, PhcPhysicalCheckCompanyCount>
implements IPhcPhysicalCheckCompanyCountService {
    @Autowired
    ICompanyService companyService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @Autowired
    private DataSourceTransactionManager txManager;

    private void clearAll() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            Example example = new Example(PhcPhysicalCheckCompanyCount.class);
            ((PhcPhysicalCheckCompanyCountMapper)this.dao).deleteByExample(example);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1\u6e05\u9664\u65e7\u6570\u636e\u51fa\u9519\u3011", (Throwable)e);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
    }

    @Transactional
    public void createSuperviseCountInfo() {
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u5f00\u59cb\u3011");
        this.clearAll();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
        Integer companyCount = this.companyService.countSuperviseCompanyData();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u4f01\u4e1a\u5b8c\u6210\u3011");
        if (companyCount == null || companyCount == 0) {
            return;
        }
        int pages = (int)Math.ceil((double)companyCount.intValue() / 1000.0);
        Map<Long, Integer> harmCount = this.companyHarmCount();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u63a5\u5bb3\u4eba\u6570\u5b8c\u6210\u3011");
        HashMap<Long, Integer> suspectCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> suspectCountstaffs = new HashMap<Long, Set<String>>();
        Map<Long, Integer> sureCount = this.companySureCount();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u804c\u4e1a\u75c5\u4eba\u6570\u5b8c\u6210\u3011");
        HashMap<Long, Integer> ocCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> ocCountstaffs = new HashMap<Long, Set<String>>();
        List checkCount = this.checkPlanService.getCidLatestYear();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u68c0\u6d4b\u4f01\u4e1a\u5b8c\u6210\u3011");
        Map<Long, Integer> declareCount = this.companyDeclareCount();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u7533\u62a5\u4f01\u4e1a\u5b8c\u6210\u3011");
        HashSet<Long> companyPhcCount = new HashSet<Long>();
        HashMap<Long, Integer> dustCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> dustCountstaffs = new HashMap<Long, Set<String>>();
        HashMap<Long, Integer> chemistryCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> chemistryCountstaffs = new HashMap<Long, Set<String>>();
        HashMap<Long, Integer> physicalCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> physicalCountstaffs = new HashMap<Long, Set<String>>();
        HashMap<Long, Integer> radiationCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> radiationCountstaffs = new HashMap<Long, Set<String>>();
        HashMap<Long, Integer> allHarmCount = new HashMap<Long, Integer>();
        HashMap<Long, Set<String>> allHarmCountstaffs = new HashMap<Long, Set<String>>();
        List<PhysicalExaminationCountInfo> companyphysicalCount = ((PhcPhysicalCheckCompanyCountMapper)this.dao).companyphysicalCount();
        if (CollectionUtil.isNotEmpty(companyphysicalCount)) {
            companyphysicalCount.forEach(c -> c.setIdCard(SpringEncryptUtils.decrypt((String)c.getIdCard())));
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u4f53\u68c0\u4f01\u4e1a\u6570\u636e\u5b8c\u6210\u3011");
        Map allharms = this.harmFactorService.doGetAllIdAndTypeMap();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u83b7\u53d6\u6240\u6709\u5371\u5bb3\u56e0\u7d20id\u53ca\u7c7b\u578b\u5b8c\u6210\u3011");
        if (companyphysicalCount != null && companyphysicalCount.size() != 0) {
            companyphysicalCount.forEach(item -> {
                if (item.getExamResult() == 3) {
                    this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)suspectCountstaffs);
                }
                if (item.getExamResult() == 4) {
                    this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)ocCountstaffs);
                }
                companyPhcCount.add(item.getCid());
                if (StringUtils.isNotEmpty((String)item.getHarmFactor())) {
                    this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)allHarmCountstaffs);
                    for (String s : item.getHarmFactor().split(",")) {
                        String type = (String)allharms.get(Long.valueOf(s));
                        if ("\u7c89\u5c18".equals(type)) {
                            this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)dustCountstaffs);
                        }
                        if ("\u5316\u5b66\u56e0\u7d20".equals(type)) {
                            this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)chemistryCountstaffs);
                        }
                        if ("\u7269\u7406\u56e0\u7d20".equals(type)) {
                            this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)physicalCountstaffs);
                        }
                        if (!"\u653e\u5c04\u56e0\u7d20".equals(type)) continue;
                        this.mapPutOnSet((PhysicalExaminationCountInfo)item, (Map<Long, Set<String>>)radiationCountstaffs);
                    }
                }
            });
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u5371\u5bb3\u56e0\u7d20\u5b8c\u6210\u3011");
        this.mapPutOnInt(suspectCountstaffs, suspectCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u7591\u4f3c\u804c\u4e1a\u75c5\u5b8c\u6210\u3011");
        this.mapPutOnInt(ocCountstaffs, ocCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u804c\u4e1a\u7981\u5fcc\u75c7\u5b8c\u6210\u3011");
        this.mapPutOnInt(allHarmCountstaffs, allHarmCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u6240\u6709\u5b8c\u6210\u3011");
        this.mapPutOnInt(dustCountstaffs, dustCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u7c89\u5c18\u5b8c\u6210\u3011");
        this.mapPutOnInt(chemistryCountstaffs, chemistryCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u5316\u5b66\u5b8c\u6210\u3011");
        this.mapPutOnInt(physicalCountstaffs, physicalCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u7269\u7406\u5b8c\u6210\u3011");
        this.mapPutOnInt(radiationCountstaffs, radiationCount);
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7edf\u8ba1\u653e\u5c04\u5b8c\u6210\u3011");
        List<DeclareRiskfactorInfo> declareRiskfactorInfos = ((PhcPhysicalCheckCompanyCountMapper)this.dao).declareRiskFactorCount();
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7533\u62a5\u6570\u636e\u4e2d\u672c\u5e74\u5ea6\u4f01\u4e1a\u5371\u5bb3\u56e0\u7d20\u4eba\u6570\u4fe1\u606f\u83b7\u53d6\u5b8c\u6210\u3011");
        if (declareRiskfactorInfos != null && declareRiskfactorInfos.size() != 0) {
            declareRiskfactorInfos.forEach(item -> {
                if (companyPhcCount.add(item.getCid())) {
                    dustCount.put(item.getCid(), item.getDustPeoples());
                    chemistryCount.put(item.getCid(), item.getChemistryPeoples());
                    physicalCount.put(item.getCid(), item.getPhysicsPeoples());
                    radiationCount.put(item.getCid(), item.getRadioactivityPeoples());
                    allHarmCount.put(item.getCid(), item.getTotalPeoples());
                }
            });
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u7533\u62a5\u6570\u636e\u5206\u7ec4\u5b8c\u6210\u3011");
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1-\u83b7\u53d6\u4f01\u4e1a\u7edf\u8ba1\u4fe1\u606f\u5b8c\u6210\u3011");
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u5f00\u59cb" + companyCount + "\u6761\u3011");
        for (int i = 1; i <= pages; ++i) {
            this.commitOneBatch(i, 1000, harmCount, suspectCount, sureCount, checkCount, declareCount, ocCount, companyPhcCount, dustCount, chemistryCount, physicalCount, radiationCount, allHarmCount);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1---\u5b8c\u6210\u3011");
    }

    private void commitOneBatch(int page, int pageSize, Map<Long, Integer> harmCount, Map<Long, Integer> suspectCount, Map<Long, Integer> sureCount, List<Long> checkCount, Map<Long, Integer> declareCount, Map<Long, Integer> ocCount, Set<Long> companyPhcCount, Map<Long, Integer> dustCount, Map<Long, Integer> chemistryCount, Map<Long, Integer> physicalCount, Map<Long, Integer> radiationCount, Map<Long, Integer> allHarmCount) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            Date now = new Date();
            List compaines = this.companyService.listSuperviseCompanyData(page, pageSize);
            if (compaines != null && compaines.size() > 0) {
                ArrayList<PhcPhysicalCheckCompanyCount> counts = new ArrayList<PhcPhysicalCheckCompanyCount>();
                for (CompanySuperviseModel c : compaines) {
                    Long cid = c.getId();
                    Integer allTotal = 0;
                    PhcPhysicalCheckCompanyCount count = new PhcPhysicalCheckCompanyCount();
                    count.setId(Long.valueOf(this.idworker.nextId()));
                    count.setName(c.getName());
                    count.setAreaId(c.getAreaId());
                    count.setIndustryCategory(c.getIndustryCategory());
                    count.setOccupationalRiskClassify(c.getOccupationalRiskClassify() == null ? null : Byte.valueOf(Byte.parseByte("" + c.getOccupationalRiskClassify())));
                    count.setRegisterType(c.getRegisterType());
                    count.setScale(c.getScale());
                    count.setHarm(harmCount.get(cid));
                    allTotal = allTotal + (harmCount.containsKey(cid) ? count.getHarm() : 0);
                    count.setSuspected(suspectCount.get(cid));
                    allTotal = allTotal + (suspectCount.containsKey(cid) ? count.getSuspected() : 0);
                    count.setOc(ocCount.get(cid));
                    allTotal = allTotal + (ocCount.containsKey(cid) ? count.getOc() : 0);
                    count.setSure(sureCount.get(cid));
                    allTotal = allTotal + (sureCount.containsKey(cid) ? count.getSure() : 0);
                    count.setChecked(Integer.valueOf(checkCount.contains(cid) ? 1 : 0));
                    count.setDeclared(declareCount.get(cid));
                    count.setCreateDate(now);
                    count.setUpdateDate(now);
                    count.setCid(cid);
                    count.setExamedCompany(Integer.valueOf(companyPhcCount.contains(cid) ? 1 : 0));
                    count.setDust(dustCount.get(cid));
                    count.setChemistry(chemistryCount.get(cid));
                    count.setPhysical(physicalCount.get(cid));
                    count.setRadiation(radiationCount.get(cid));
                    count.setRiskTotal(allHarmCount.get(cid));
                    allTotal = allTotal + (allHarmCount.containsKey(cid) ? count.getRiskTotal() : 0);
                    count.setAllTotal(allTotal);
                    counts.add(count);
                }
                ((PhcPhysicalCheckCompanyCountMapper)this.dao).insertBatch(counts);
            }
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7edf\u8ba1\u5f02\u5e38\u3011", (Throwable)e);
        }
    }

    private void mapPutOnSet(PhysicalExaminationCountInfo info, Map<Long, Set<String>> map) {
        Set<String> set = map.get(info.getCid());
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(String.valueOf(info.getIdCard()));
        map.put(info.getCid(), set);
    }

    private void mapPutOnInt(Map<Long, Set<String>> staffs, Map<Long, Integer> cout) {
        for (Map.Entry<Long, Set<String>> m : staffs.entrySet()) {
            cout.put(m.getKey(), m.getValue().size());
        }
    }

    private Map<Long, Integer> companyHarmCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCompanyCountMapper)this.dao).companyHarmCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companySuspectCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCompanyCountMapper)this.dao).companyCheckExamCount(ExamResultEnum.so.getCode());
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companyOcCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCompanyCountMapper)this.dao).companyCheckExamCount(ExamResultEnum.oc.getCode());
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companySureCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCompanyCountMapper)this.dao).companySureCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> companyDeclareCount() {
        List<CompanyCountInfo> count = ((PhcPhysicalCheckCompanyCountMapper)this.dao).companyDeclareCount();
        Map<Long, Integer> countMap = this.convertList(count);
        return countMap;
    }

    private Map<Long, Integer> convertList(List<CompanyCountInfo> list) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (CompanyCountInfo l : list) {
            if (l.getTotal() == 0) continue;
            result.put(l.getCid(), l.getTotal());
        }
        return result;
    }
}

