/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.work.check.PhcOccupationalDiseaserMapper;
import cn.smarthse.modules.health.entity.work.check.PhcCheckResultDetail;
import cn.smarthse.modules.health.entity.work.check.PhcDiagnoseDiseaseProcess;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaser;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaserDetail;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedDetail;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcSuperviseOccupationalDiseaserVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcYearCheckInfo;
import cn.smarthse.modules.health.pojo.CidDiseaserCount;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcOccupationalDiseaserServiceImpl
extends BaseServiceImpl<PhcOccupationalDiseaserMapper, PhcOccupationalDiseaser>
implements IPhcOccupationalDiseaserService {
    @Autowired
    IPhcOccupationalDiseaserDetailService detailService;
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @DubboReference
    ISysFileProvideService sysFileService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    ICompanyOrganizationService orgService;
    @Autowired
    IWorkRoleInfoService workRoleService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;

    public PageInfo<PhcOccupationalDiseaserVo> getList(JqGridParam gparam, PhcOccupationalDiseaserParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    public PageInfo<PhcSuperviseOccupationalDiseaserVo> listSuperviseData(JqGridParam gparam, PhcOccupationalDiseaserParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PhcSuperviseOccupationalDiseaserVo> superviseDataList = this.getSuperviseDataList(param);
        return new PageInfo(superviseDataList);
    }

    public Integer getSuperviseNum(PhcOccupationalDiseaserParam param) {
        if (param.getCid() == null) {
            return 0;
        }
        return ((PhcOccupationalDiseaserMapper)this.dao).getSuperviseNum(param);
    }

    public List<PhcSuperviseOccupationalDiseaserVo> getSuperviseDataList(PhcOccupationalDiseaserParam param) {
        param.setKeywordEncrypt(param.getKeyword());
        List<PhcSuperviseOccupationalDiseaserVo> list = ((PhcOccupationalDiseaserMapper)this.dao).listSuperviseData(param);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        list.forEach(l -> this.setOtherInfos((PhcSuperviseOccupationalDiseaserVo)l));
        return list;
    }

    public Integer diseaserCount(PhcOccupationalDiseaserParam param) {
        JqGridParam gridParam = new JqGridParam();
        gridParam.setRows(Integer.MAX_VALUE);
        gridParam.setPage(1);
        List list = this.listSuperviseData(gridParam, param).getList();
        HashSet<Long> staffIds = new HashSet<Long>();
        for (PhcSuperviseOccupationalDiseaserVo vo : list) {
            staffIds.add(vo.getStaffId());
        }
        return staffIds.size();
    }

    public Set<Long> diseaserCids(Date begin, Date end) {
        return new HashSet<Long>(((PhcOccupationalDiseaserMapper)this.dao).diseaserCids(begin, end));
    }

    public Map<Long, Integer> diseaserCidCount(Date begin, Date end) {
        List<CidDiseaserCount> list = ((PhcOccupationalDiseaserMapper)this.dao).diseaserCidCount(begin, end);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (CidDiseaserCount count : list) {
            map.put(count.getCid(), count.getNum());
        }
        return map;
    }

    @Transactional(readOnly=false)
    public void updateSuperviseStatus(Long diseaerId, Integer superviseStatus) {
        ((PhcOccupationalDiseaserMapper)this.dao).updateSuperviseStatus(diseaerId, superviseStatus);
    }

    private void setOtherInfos(PhcSuperviseOccupationalDiseaserVo l) {
        if (IDCardUtil.isIDCard((String)l.getIdCard())) {
            l.setAge(Integer.valueOf(IDCardUtil.getAge((String)l.getIdCard())));
            l.setGender(IDCardUtil.getGenderName((String)l.getIdCard()));
            l.setBirthday(IDCardUtil.getBirthday((String)l.getIdCard()));
        }
        l.setHarmNames(this.harmFactorService.getHarmNames(l.getHarmIds()));
        l.setDiagnosedTimeStr(DateUtils.formatCheckTime((Date)l.getDiagnosedTime(), (Date)l.getDiagnosedEndTime(), (String)" \u81f3 "));
    }

    public PhcOccupationalDiseaser getDetailById(Long id) {
        PhcOccupationalDiseaser data = ((PhcOccupationalDiseaserMapper)this.dao).getDetailById(id);
        if (data != null) {
            if (data.getStaffId() != null) {
                data.setStaffName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(data.getStaffId()));
            }
            data.setDetails(this.detailService.getChildrenByPid(id));
        }
        return data;
    }

    public List<PhcOccupationalDiseaserVo> listDetails(PhcOccupationalDiseaserParam param) {
        List<PhcOccupationalDiseaserVo> list = ((PhcOccupationalDiseaserMapper)this.dao).listDetails(param);
        if (list == null) {
            return list;
        }
        for (PhcOccupationalDiseaserVo l : list) {
            if (l.getStaffId() != null) {
                l.setStaffName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(l.getStaffId()));
            }
            if (l.getCheckDeptId() != null) {
                l.setCheckDeptName(this.orgService.getOrgNameById(l.getCheckDeptId()));
            }
            if (l.getCheckWorkId() == null) continue;
            l.setCheckWorkName(this.workRoleService.getWorkNameIncludeOrgName(l.getCheckWorkId()));
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long staffId) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(PhcOccupationalDiseaser.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        PhcOccupationalDiseaser data = new PhcOccupationalDiseaser();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        ((PhcOccupationalDiseaserMapper)this.dao).updateByExampleSelective(data, example);
    }

    @Transactional(readOnly=false)
    public PhcOccupationalDiseaser insertOrUpdate(PhcOccupationalDiseaser data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        if (data.getId() == null) {
            data = this.add(data, staffId, cid);
        } else {
            this.update(data, staffId);
        }
        return data;
    }

    public void addByProcess(PhcDiagnoseDiseaseProcess data, Long cid, Long staffId) {
        if (data == null) {
            return;
        }
        List details = data.getDetails();
        if (details == null || details.size() == 0) {
            return;
        }
        PhcOccupationalDiseaser diseaser = this.getByStaffId(data.getStaffId());
        ArrayList<PhcOccupationalDiseaserDetail> diseaserDetails = new ArrayList<PhcOccupationalDiseaserDetail>();
        for (PhcCheckResultDetail d : details) {
            if (d.getIsDisease() == null || !d.getIsDisease().booleanValue()) continue;
            if (diseaser == null) {
                diseaser = this.convertToDiseaser(data);
            }
            PhcOccupationalDiseaserDetail diseaserDetail = this.convertToDiseaserDetail(d, data);
            diseaserDetails.add(diseaserDetail);
        }
        if (diseaserDetails.size() == 0 || diseaser == null) {
            return;
        }
        diseaser = this.insertOrUpdate(diseaser, cid, staffId);
        this.detailService.addList(diseaser, diseaserDetails);
    }

    private PhcOccupationalDiseaser getByStaffId(Long staffId) {
        Example example = new Example(PhcOccupationalDiseaser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("staffId", (Object)staffId);
        criteria.andEqualTo("isValid", (Object)true);
        List diseasers = ((PhcOccupationalDiseaserMapper)this.dao).selectByExample(example);
        return diseasers == null || diseasers.size() == 0 ? null : (PhcOccupationalDiseaser)diseasers.get(0);
    }

    private PhcOccupationalDiseaserDetail convertToDiseaserDetail(PhcCheckResultDetail d, PhcDiagnoseDiseaseProcess data) {
        PhcOccupationalDiseaserDetail detail = new PhcOccupationalDiseaserDetail();
        detail.setCid(data.getCid());
        detail.setCheckResultId(d.getCheckResultId());
        detail.setDiagnosedId(d.getDiagnosedId());
        detail.setDiagnosedName(d.getDiagnosedName());
        detail.setDiagnosedTime(d.getDiagnosedTime());
        detail.setDiseaseName(d.getDiseaseName());
        detail.setLevel(d.getLevel());
        detail.setHarmYear(d.getHarmYear());
        detail.setCertId(d.getCertId());
        detail.setCertIds(d.getCertIds());
        detail.setCredenceIds(d.getCredenceIds());
        detail.setDealTypeInfo(d.getDealTypeInfo());
        detail.setIsSure(d.getIsSure());
        detail.setInfoDesc(d.getInfoDesc());
        detail.setDealDesc(d.getDealDesc());
        detail.setIsValid(Boolean.valueOf(true));
        this.setCheckInfo(detail);
        return detail;
    }

    private void setCheckInfo(PhcOccupationalDiseaserDetail detail) {
        Long checkResultId = detail.getCheckResultId();
        if (checkResultId == null) {
            return;
        }
        PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
        result.setId(checkResultId);
        PhcPhysicalCheckResultDeal resultDealInfo = this.resultService.getResultDealInfo(result);
        if (resultDealInfo == null) {
            return;
        }
        detail.setCheckType(resultDealInfo.getCheckType());
        detail.setCheckDeptId(resultDealInfo.getStaffDeptId());
        detail.setCheckDeptName(resultDealInfo.getStaffDeptName());
        detail.setCheckWorkId(resultDealInfo.getStaffWorkId());
        detail.setCheckWorkName(resultDealInfo.getStaffWorkName());
    }

    private PhcOccupationalDiseaser convertToDiseaser(PhcDiagnoseDiseaseProcess data) {
        PhcOccupationalDiseaser diseaser = new PhcOccupationalDiseaser();
        diseaser.setCid(data.getCid());
        diseaser.setStaffId(data.getStaffId());
        diseaser.setStaffName(data.getStaffName());
        diseaser.setStaffWorkNo(data.getStaffWorkNo());
        diseaser.setIsValid(Boolean.valueOf(true));
        diseaser.setOrgId(data.getOrgId());
        return diseaser;
    }

    public Integer countYearDiseasers(PhcYearCheckInfo params) {
        Integer count = ((PhcOccupationalDiseaserMapper)this.dao).countYearDiseasers(params);
        return count == null ? 0 : count;
    }

    public List<PhcPhysicalResultInfo> getResultInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcOccupationalDiseaserMapper)this.dao).getResultInfo(query);
    }

    public List<PhcPhysicalResultInfo> getDeptOrWorkYearResultInfo(PhcPhysicalYearCountQuery query) {
        if (query == null || query.getCid() == null || query.getBeginYear() == null || query.getEndYear() == null) {
            return null;
        }
        return ((PhcOccupationalDiseaserMapper)this.dao).getDeptOrWorkYearResultInfo(query);
    }

    public List<PhcDiseaserConfirmedDetail> getConfirmedListByQuery(PhcDiseaserUnProcessParam param) {
        List<PhcDiseaserConfirmedDetail> list = ((PhcOccupationalDiseaserMapper)this.dao).getConfirmedListByQuery(param);
        if (list == null || list.size() == 0) {
            return list;
        }
        for (PhcDiseaserConfirmedDetail l : list) {
            this.getFilesByIds(l);
        }
        return list;
    }

    public List<PhcDiseaserConfirmedDetail> getConfirmedListFromViewByQuery(PhcDiseaserUnProcessParam param) {
        DataScopeHelper.startDataScope("healthCheck", "phc_diseaser_confirmed_view");
        List<PhcDiseaserConfirmedDetail> list = ((PhcOccupationalDiseaserMapper)this.dao).getConfirmedListFromViewByQuery(param);
        if (list == null || list.size() == 0) {
            return list;
        }
        for (PhcDiseaserConfirmedDetail l : list) {
            this.getFilesByIds(l);
        }
        return list;
    }

    private void getFilesByIds(PhcDiseaserConfirmedDetail data) {
        if (data == null) {
            return;
        }
        List ids = data.getCredenceIds();
        if (ids == null || ids.size() == 0) {
            return;
        }
        ArrayList<SysFileModel> files = new ArrayList<SysFileModel>();
        Object names = "";
        for (Long id : ids) {
            SysFileModel file = this.sysFileService.getFileById(id);
            if (file == null) continue;
            files.add(file);
            names = (String)names + file.getFileName() + " ";
        }
        data.setCredenceFiles(files);
        data.setCredenceFileNames((String)names);
    }

    public List<PhcDiseaserConfirmedDetail> doc6Table4_2(PhcDiseaserUnProcessParam param) {
        return ((PhcOccupationalDiseaserMapper)this.dao).doc6Table4_2(param);
    }

    public List<PhcDiseaserConfirmedDetail> getDiseaserInfosByQuery(PhcDiseaserUnProcessParam param) {
        return ((PhcOccupationalDiseaserMapper)this.dao).getDiseaserInfosByQuery(param);
    }

    public Integer getNewOccupationalDiseasesNum(PhcOccupationalDiseaserParam param) {
        return ((PhcOccupationalDiseaserMapper)this.dao).getNewOccupationalDiseasesNum(param);
    }

    public Integer getOccupationalDiseasesNum(Long cid) {
        return ((PhcOccupationalDiseaserMapper)this.dao).getOccupationalDiseasesNum(cid);
    }

    public PhcSuperviseOccupationalDiseaserVo getSuperviseInfo(Long id) {
        PhcSuperviseOccupationalDiseaserVo vo = ((PhcOccupationalDiseaserMapper)this.dao).getSuperviseInfo(id);
        this.setOtherInfos(vo);
        return vo;
    }
}

