/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.check.PhcOccupationalDiseaserDetailMapper;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaser;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaserDetail;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserDetailService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcOccupationalDiseaserDetailServiceImpl
extends BaseServiceImpl<PhcOccupationalDiseaserDetailMapper, PhcOccupationalDiseaserDetail>
implements IPhcOccupationalDiseaserDetailService {
    @Autowired
    ICompanyOrganizationService orgService;
    @Autowired
    IWorkRoleInfoService workRoleService;

    public List<PhcOccupationalDiseaserDetail> getChildrenByPid(Long id) {
        Example example = new Example(PhcOccupationalDiseaserDetail.class);
        example.createCriteria().andEqualTo("diseaserId", (Object)id);
        List list = ((PhcOccupationalDiseaserDetailMapper)this.dao).selectByExample(example);
        if (list == null) {
            return list;
        }
        for (PhcOccupationalDiseaserDetail l : list) {
            if (l.getCheckDeptId() != null) {
                l.setCheckDeptName(this.orgService.getOrgNameById(l.getCheckDeptId()));
            }
            if (l.getCheckWorkId() == null) continue;
            l.setCheckWorkName(this.workRoleService.getWorkNameIncludeOrgName(l.getCheckWorkId()));
        }
        return list;
    }

    @Transactional(readOnly=false)
    public PhcOccupationalDiseaserDetail insertOrUpdate(PhcOccupationalDiseaserDetail data, Long staffId, Long cid) {
        if (data.getId() != null) {
            this.update(data, staffId);
        } else {
            this.add(data, staffId, cid);
        }
        return data;
    }

    @Transactional(readOnly=false)
    public void deleteById(Long id) {
        ((PhcOccupationalDiseaserDetailMapper)this.dao).deleteByPrimaryKey(id);
    }

    @Transactional(readOnly=false)
    public void addList(PhcOccupationalDiseaser diseaser, List<PhcOccupationalDiseaserDetail> diseaserDetails) {
        Long cid = diseaser.getCid();
        Long createBy = diseaser.getCreateBy();
        for (PhcOccupationalDiseaserDetail d : diseaserDetails) {
            d.setDiseaserId(diseaser.getId());
            this.add(d, createBy, cid);
        }
    }

    @Transactional(readOnly=false)
    public void deleteByResultIds(List<Long> resultIds) {
        Example example = new Example(PhcOccupationalDiseaserDetail.class);
        example.createCriteria().andIn("checkResultId", resultIds);
        ((PhcOccupationalDiseaserDetailMapper)this.dao).deleteByExample(example);
    }

    public PhcOccupationalDiseaserDetail getByDiseaserId(Long diseaserId) {
        Example example = new Example(PhcOccupationalDiseaserDetail.class);
        example.createCriteria().andEqualTo("diseaserId", (Object)diseaserId);
        List list = this.getListByExample(example);
        if (list != null && !list.isEmpty()) {
            return (PhcOccupationalDiseaserDetail)list.get(0);
        }
        return null;
    }
}

