/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.check.PhcDiseaserReportMapper;
import cn.smarthse.modules.health.entity.work.check.PhcCheckResultDetail;
import cn.smarthse.modules.health.entity.work.check.PhcDiagnoseDiseaseProcess;
import cn.smarthse.modules.health.entity.work.check.PhcDiseaserReport;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserReportGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserReportInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserReportQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckStaffResultInfo;
import cn.smarthse.modules.health.enums.check.DealTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcDiseaserReportService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcDiseaserReportServiceImpl
extends BaseServiceImpl<PhcDiseaserReportMapper, PhcDiseaserReport>
implements IPhcDiseaserReportService {
    @Autowired
    IPhcPhysicalCheckDataResultService checkResultService;
    @Autowired
    IPhcPhysicalCheckService checkService;
    @Autowired
    IStaffInfoService staffInfoService;

    @Transactional(readOnly=false)
    public void addReportByCheck(PhcPhysicalCheck data) {
        if (data == null || data.getId() == null || data.getStatus() == null || data.getStatus() != 1) {
            return;
        }
        Long checkId = data.getId();
        this.deleteReportByCheckId(checkId);
        int diseaserCount = this.checkResultService.countSDieasers(checkId);
        if (diseaserCount < 2) {
            return;
        }
        PhcDiseaserReport report = this.convertByCheck(data);
        report.setSuspectedCount(Integer.valueOf(diseaserCount));
        report.setSureCount(Integer.valueOf(0));
        report.setUnsureCount(Integer.valueOf(0));
        report.setOrgId(data.getOrgId());
        this.add(report, data.getUpdateBy(), data.getCid());
    }

    public PhcDiseaserReport convertByCheck(PhcPhysicalCheck data) {
        PhcDiseaserReport report = new PhcDiseaserReport();
        report.setCheckId(data.getId());
        report.setCheckName(data.getWorkName());
        report.setCheckBeginTime(data.getBeginTime());
        report.setCheckEndTime(data.getEndTime());
        report.setStatus(Byte.valueOf((byte)0));
        report.setIsValid(Boolean.valueOf(true));
        return report;
    }

    private void deleteReportByCheckId(Long checkId) {
        Example example = new Example(PhcDiseaserReport.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkId", (Object)checkId);
        ((PhcDiseaserReportMapper)this.dao).deleteByExample(example);
    }

    public PhcDieaserReportGroup getDieaseInfosByCheckId(Long checkId) {
        PhcDieaserReportGroup result = new PhcDieaserReportGroup();
        if (checkId == null) {
            return result;
        }
        List<PhcDieaserReportInfo> reports = ((PhcDiseaserReportMapper)this.dao).getDieaseInfosByCheckId(checkId);
        if (reports == null || reports.size() == 0) {
            return result;
        }
        HashMap<Long, PhcDieaserReportInfo> suspectedStaff = new HashMap<Long, PhcDieaserReportInfo>();
        HashMap<Long, PhcDieaserReportInfo> sureStaff = new HashMap<Long, PhcDieaserReportInfo>();
        HashMap<Long, PhcDieaserReportInfo> unsureStaff = new HashMap<Long, PhcDieaserReportInfo>();
        for (PhcDieaserReportInfo report : reports) {
            if (!ExamResultEnum.so.getCode().equals(String.valueOf(report.getExamResult()))) continue;
            suspectedStaff.put(report.getStaffId(), report);
            if (!DealTypeEnum.diagnose.getCode().equals(String.valueOf(report.getDealType())) || report.getDealStatus() == null || 1 != report.getDealStatus()) continue;
            if (report.getIsFinish() == null || !report.getIsFinish().booleanValue()) {
                unsureStaff.put(report.getStaffId(), report);
                continue;
            }
            if (report.getIsDisease() == null || !report.getIsDisease().booleanValue()) continue;
            sureStaff.put(report.getStaffId(), report);
        }
        result.setSureStaff(sureStaff);
        result.setSuspectedStaff(suspectedStaff);
        result.setUnsureStaff(unsureStaff);
        return result;
    }

    @Transactional(readOnly=false)
    public void udpateReportByCheckId(PhcDiagnoseDiseaseProcess process, Long cid, Long staffId) {
        boolean flag = this.isDieaser(process);
        if (!flag) {
            return;
        }
        Long checkId = process.getCheckId();
        PhcDieaserReportGroup group = this.getDieaseInfosByCheckId(checkId);
        Map suspectedMap = group.getSuspectedStaff();
        if (suspectedMap == null || suspectedMap.size() == 0) {
            return;
        }
        PhcDiseaserReport report = new PhcDiseaserReport();
        report.setSuspectedCount(Integer.valueOf(suspectedMap.size()));
        report.setUnsureCount(Integer.valueOf(group.getUnsureStaff() == null ? 0 : group.getUnsureStaff().size()));
        report.setSureCount(Integer.valueOf(group.getSureStaff() == null ? 0 : group.getSureStaff().size()));
        PhcDiseaserReport alreadExistReport = this.getByCheckId(checkId);
        if (alreadExistReport == null) {
            PhcPhysicalCheck data = (PhcPhysicalCheck)this.checkService.getById(checkId);
            report.setCheckId(data.getId());
            report.setCheckName(data.getWorkName());
            report.setCheckBeginTime(data.getBeginTime());
            report.setCheckEndTime(data.getEndTime());
            report.setStatus(Byte.valueOf((byte)0));
            report.setIsValid(Boolean.valueOf(true));
            report.setOrgId(data.getOrgId());
            this.add(report, staffId, cid);
        } else {
            Example example = new Example(PhcDiseaserReport.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("checkId", (Object)checkId);
            ((PhcDiseaserReportMapper)this.dao).updateByExampleSelective(report, example);
        }
    }

    private boolean isDieaser(PhcDiagnoseDiseaseProcess process) {
        if (process == null) {
            return false;
        }
        List details = process.getDetails();
        if (details == null || details.size() == 0) {
            return false;
        }
        for (PhcCheckResultDetail d : details) {
            if (d.getIsDisease() == null || !d.getIsDisease().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private PhcDiseaserReport getByCheckId(Long checkId) {
        Example example = new Example(PhcDiseaserReport.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkId", (Object)checkId);
        criteria.andEqualTo("isValid", (Object)true);
        List list = ((PhcDiseaserReportMapper)this.dao).selectByExample(example);
        return list == null || list.size() == 0 ? null : (PhcDiseaserReport)list.get(0);
    }

    public PageInfo<PhcDiseaserReport> getList(JqGridParam gparam, PhcDiseaserReportQuery param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.listDetails(param));
    }

    @Transactional(readOnly=false)
    public PhcDiseaserReport insertOrUpdate(PhcDiseaserReport data, Long cid, Long staffId) {
        if (data.getId() == null) {
            data.setIsValid(Boolean.valueOf(true));
            data = this.add(data, staffId, cid);
        } else {
            ((PhcDiseaserReportMapper)this.dao).updateById(data);
        }
        return data;
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long staffId) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(PhcDiseaserReport.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        PhcDiseaserReport data = new PhcDiseaserReport();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        ((PhcDiseaserReportMapper)this.dao).updateByExampleSelective(data, example);
    }

    public List<PhcDiseaserReport> listDetails(PhcDiseaserReportQuery data) {
        DataScopeHelper.startDataScope("healthCheck", "phc_diseaser_report");
        List<PhcDiseaserReport> list = ((PhcDiseaserReportMapper)this.dao).getListByQuery(data);
        if (list == null || list.size() == 0) {
            return list;
        }
        for (PhcDiseaserReport report : list) {
            if (report.getCreateBy() == null) continue;
            report.setCreateByName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(report.getCreateBy()));
        }
        return list;
    }

    public void deleteByCheckIds(List<Long> idArray) {
        Example example = new Example(PhcDiseaserReport.class);
        example.createCriteria().andIn("checkId", idArray);
        ((PhcDiseaserReportMapper)this.dao).deleteByExample(example);
    }

    public List<PhcPhysicalCheckStaffResultInfo> queryCheckDiseaserInfo(Long checkId, Boolean isDiseaser) {
        if (checkId == null) {
            return Collections.emptyList();
        }
        return ((PhcDiseaserReportMapper)this.dao).queryCheckDiseaserInfo(checkId, isDiseaser);
    }
}

