/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.work.check.PhcDiagnoseDiseaseProcessMapper;
import cn.smarthse.modules.health.entity.work.check.PhcCheckResultDetail;
import cn.smarthse.modules.health.entity.work.check.PhcDiagnoseDiseaseProcess;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserUnprocessInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedDetail;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckSuspectDiseaseInfo;
import cn.smarthse.modules.health.service.work.check.IPhcCheckResultDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcDiagnoseDiseaseProcessService;
import cn.smarthse.modules.health.service.work.check.IPhcDiseaserReportService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PhcDiagnoseDiseaseProcessServiceImpl
extends BaseServiceImpl<PhcDiagnoseDiseaseProcessMapper, PhcDiagnoseDiseaseProcess>
implements IPhcDiagnoseDiseaseProcessService {
    @Autowired
    IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    IPhcCheckResultDetailService childService;
    @Autowired
    IPhcDiseaserReportService reportService;
    @Autowired
    IPhcOccupationalDiseaserService diseaserService;
    @Autowired
    IHarmfactorWorkService harmService;

    @Transactional(readOnly=false)
    public void addByResult(PhcPhysicalCheckDataResult result) {
        PhcPhysicalCheckResultDeal resultDealInfo = this.resultService.getResultDealInfo(result);
        if (resultDealInfo == null) {
            return;
        }
        PhcDiagnoseDiseaseProcess data = this.convertResult(resultDealInfo);
        data.setId(Long.valueOf(this.idworker.nextId()));
        ((PhcDiagnoseDiseaseProcessMapper)this.dao).insert(data);
        this.childService.addChild(resultDealInfo, data);
    }

    public void updateByResult(PhcPhysicalCheckDataResult result) {
        PhcCheckResultDetail child = this.childService.getByCheckResultId(result.getId());
        if (child == null || child.getDiagnoseDiseaseProcess() == null) {
            return;
        }
        PhcDiagnoseDiseaseProcess process = new PhcDiagnoseDiseaseProcess();
        process.setId(child.getDiagnoseDiseaseProcess());
        process.setIsFinish(Boolean.valueOf(true));
        ((PhcDiagnoseDiseaseProcessMapper)this.dao).updateByPrimaryKeySelective(process);
    }

    private PhcDiagnoseDiseaseProcess convertResult(PhcPhysicalCheckResultDeal resultDealInfo) {
        PhcDiagnoseDiseaseProcess data = new PhcDiagnoseDiseaseProcess();
        data.setCid(resultDealInfo.getCid());
        data.setCheckId(resultDealInfo.getCheckId());
        data.setIsFinish(Boolean.valueOf(false));
        data.setIsValid(Boolean.valueOf(true));
        data.setStaffId(resultDealInfo.getStaffId());
        data.setStaffName(resultDealInfo.getStaffName());
        data.setStaffWorkNo(resultDealInfo.getStaffWorkNo());
        data.setStaffDeptName(resultDealInfo.getStaffDeptName());
        data.setStaffWorkName(resultDealInfo.getStaffWorkName());
        data.setCreateBy(resultDealInfo.getUpdateBy());
        data.setCreateDate(new Date());
        data.setUpdateBy(resultDealInfo.getUpdateBy());
        data.setUpdateDate(new Date());
        return data;
    }

    @Transactional(readOnly=false)
    public void setIsFinishByIds(String ids, boolean b, Long updateBy) {
        List idList = StringUtils.parseToLongList((String)ids, (String)",");
        for (Long id : idList) {
            this.setIsFinishById(id, b, updateBy);
        }
    }

    @Transactional(readOnly=false)
    public void setIsFinishById(Long id, Boolean isFinish, Long updateBy) {
        PhcDiagnoseDiseaseProcess record = new PhcDiagnoseDiseaseProcess();
        record.setIsFinish(isFinish);
        record.setId(id);
        this.update(record, updateBy);
    }

    public PageInfo<PhcDieaserUnprocessInfo> getUnprocessPage(JqGridParam gparam, PhcDiseaserUnProcessParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("healthCheck", "phc_diagnose_disease_process");
        return new PageInfo(this.listDetails(param));
    }

    public List<PhcDieaserUnprocessInfo> listDetails(PhcDiseaserUnProcessParam data) {
        return ((PhcDiagnoseDiseaseProcessMapper)this.dao).getListByQuery(data);
    }

    public PhcDiagnoseDiseaseProcess getDetailById(Long id) {
        PhcDiagnoseDiseaseProcess process = (PhcDiagnoseDiseaseProcess)((PhcDiagnoseDiseaseProcessMapper)this.dao).selectByPrimaryKey(id);
        if (process != null) {
            process.setDetails(this.childService.getChildrenByPid(id));
            this.setCheckInfos(process);
        }
        return process;
    }

    private void setCheckInfos(PhcDiagnoseDiseaseProcess process) {
        PhcPhysicalCheckAbnormalParam param = new PhcPhysicalCheckAbnormalParam();
        param.setCheckId(process.getCheckId());
        param.setStaffId(process.getStaffId());
        List<Long> checkResultIds = this.getCheckResultIds(process);
        List checkInfos = this.resultService.getSuspectDiseaseList(param);
        ArrayList<PhcPhysicalCheckAbnormal> checkResultInfos = new ArrayList<PhcPhysicalCheckAbnormal>();
        if (checkInfos == null || checkInfos.size() == 0) {
            return;
        }
        PhcPhysicalCheckSuspectDiseaseInfo suspectDiseaseInfo = new PhcPhysicalCheckSuspectDiseaseInfo();
        ArrayList<String> checkTypeNames = new ArrayList<String>();
        Object checkTypeNameStr = "";
        for (PhcPhysicalCheckAbnormal checkInfo : checkInfos) {
            if (checkResultIds.contains(checkInfo.getId())) {
                checkResultInfos.add(checkInfo);
            }
            suspectDiseaseInfo.setCheckDate(checkInfo.getCheckDate());
            suspectDiseaseInfo.setCheckNo(checkInfo.getCheckNo());
            suspectDiseaseInfo.setDeptName(checkInfo.getDeptName());
            suspectDiseaseInfo.setWorkName(checkInfo.getWorkName());
            suspectDiseaseInfo.setWorkHarms(this.harmService.getHarmNamesByWork(process.getCid(), checkInfo.getStaffWorkId(), " "));
            suspectDiseaseInfo.setHospitalName(checkInfo.getHospitalName());
            String checkTypeName = checkInfo.getCheckTypeName();
            if (checkTypeNames.contains(checkTypeName)) continue;
            checkTypeNames.add(checkTypeName);
            checkTypeNameStr = (String)checkTypeNameStr + checkTypeName + " ";
        }
        suspectDiseaseInfo.setCheckTypeName((String)checkTypeNameStr);
        suspectDiseaseInfo.setResults(checkResultInfos);
        process.setSuspectDiseaseInfo(suspectDiseaseInfo);
    }

    private List<Long> getCheckResultIds(PhcDiagnoseDiseaseProcess process) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (process == null) {
            return ids;
        }
        List details = process.getDetails();
        if (details == null) {
            return ids;
        }
        for (PhcCheckResultDetail detail : details) {
            ids.add(detail.getCheckResultId());
        }
        return ids;
    }

    @Transactional(readOnly=false)
    public PhcDiagnoseDiseaseProcess insertOrUpdate(PhcDiagnoseDiseaseProcess data, Long cid, Long staffId) {
        if (data.getId() != null) {
            this.update(data, staffId);
        }
        this.childService.updateByParent(data);
        if (data.getIsFinish() == null || !data.getIsFinish().booleanValue()) {
            return data;
        }
        this.diseaserService.addByProcess(data, cid, staffId);
        if (data.getCheckId() == null) {
            return data;
        }
        this.reportService.udpateReportByCheckId(data, cid, staffId);
        return data;
    }

    public PhcDiagnoseDiseaseProcess getDetailByInfo(PhcDiagnoseDiseaseProcess data) {
        PhcDiagnoseDiseaseProcess result = null;
        try {
            Example example = new Example(PhcDiagnoseDiseaseProcess.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("checkId", (Object)data.getCheckId());
            criteria.andEqualTo("staffId", (Object)data.getStaffId());
            example.setOrderByClause("update_date desc");
            List list = ((PhcDiagnoseDiseaseProcessMapper)this.dao).selectByExample(example);
            if (list != null && list.size() > 0) {
                result = (PhcDiagnoseDiseaseProcess)list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        if (result != null && result.getId() != null) {
            result.setDetails(this.childService.getChildrenByPid(result.getId()));
        }
        return result;
    }

    public List<PhcDiseaserConfirmedDetail> getConfirmedListByQuery(PhcDiseaserUnProcessParam param) {
        return ((PhcDiagnoseDiseaseProcessMapper)this.dao).getConfirmedListByQuery(param);
    }

    public List<PhcDiseaserConfirmedDetail> doc6Table4_2(PhcDiseaserUnProcessParam param) {
        return ((PhcDiagnoseDiseaseProcessMapper)this.dao).doc6Table4_2(param);
    }

    public Integer getConfirmedCountByYear(Long cid, String year) {
        List<PhcDiseaserConfirmedDetail> list;
        PhcDiseaserUnProcessParam query = new PhcDiseaserUnProcessParam();
        query.setCid(cid);
        if (StringUtils.isNotEmpty((String)year)) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            query.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            query.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        return (list = this.getConfirmedListByQuery(query)) == null ? 0 : list.size();
    }

    @Transactional(readOnly=false)
    public void deleteByCheckId(Long checkId) {
        Example example = new Example(PhcDiagnoseDiseaseProcess.class);
        example.createCriteria().andEqualTo("checkId", (Object)checkId);
        ((PhcDiagnoseDiseaseProcessMapper)this.dao).deleteByExample(example);
    }
}

