/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.check;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.check.PhcCheckResultDetailMapper;
import cn.smarthse.modules.health.entity.work.check.PhcCheckResultDetail;
import cn.smarthse.modules.health.entity.work.check.PhcDiagnoseDiseaseProcess;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultDeal;
import cn.smarthse.modules.health.service.work.check.IPhcCheckResultDetailService;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class PhcCheckResultDetailServiceImpl
extends BaseServiceImpl<PhcCheckResultDetailMapper, PhcCheckResultDetail>
implements IPhcCheckResultDetailService {
    @Transactional(readOnly=false)
    public void addChild(PhcPhysicalCheckResultDeal resultDealInfo, PhcDiagnoseDiseaseProcess parent) {
        if (parent == null || parent.getId() == null || resultDealInfo == null || resultDealInfo.getResultId() == null) {
            return;
        }
        PhcCheckResultDetail child = this.getChild(resultDealInfo, parent);
        child.setId(Long.valueOf(this.idworker.nextId()));
        ((PhcCheckResultDetailMapper)this.dao).insert(child);
    }

    private PhcCheckResultDetail getChild(PhcPhysicalCheckResultDeal resultDealInfo, PhcDiagnoseDiseaseProcess parent) {
        PhcCheckResultDetail data = new PhcCheckResultDetail();
        data.setDiagnoseDiseaseProcess(parent.getId());
        data.setCheckResultId(resultDealInfo.getResultId());
        data.setCid(parent.getCid());
        data.setHarmDesc(resultDealInfo.getHarmDesc());
        data.setHarmYear(resultDealInfo.getHarmYear());
        data.setCreateBy(parent.getUpdateBy());
        data.setCreateDate(new Date());
        data.setIsValid(parent.getIsValid());
        data.setUpdateBy(parent.getUpdateBy());
        data.setUpdateDate(new Date());
        return data;
    }

    public List<PhcCheckResultDetail> getChildrenByPid(Long pid) {
        if (pid == null) {
            return null;
        }
        return ((PhcCheckResultDetailMapper)this.dao).getDetailByPid(pid);
    }

    @Transactional(readOnly=false)
    public void updateByParent(PhcDiagnoseDiseaseProcess data) {
        List details = data.getDetails();
        if (details == null) {
            return;
        }
        for (PhcCheckResultDetail d : details) {
            d.setUpdateBy(data.getUpdateBy());
            d.setUpdateDate(d.getUpdateDate());
            ((PhcCheckResultDetailMapper)this.dao).updateInfo(d);
        }
    }

    public PhcCheckResultDetail getByCheckResultId(Long id) {
        Example example = new Example(PhcCheckResultDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("checkResultId", (Object)id);
        List list = ((PhcCheckResultDetailMapper)this.dao).selectByExample(example);
        return list == null || list.size() == 0 ? null : (PhcCheckResultDetail)list.get(0);
    }
}

