/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.certificate.CertificateStaffMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.vo.summary.CertificateNumSummVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffDetailVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateWorkItemVo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.util.common.date.DateUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CertificateStaffServiceImpl
extends BaseServiceImpl<CertificateStaffMapper, CertificateStaff>
implements ICertificateStaffService {
    @Autowired
    CertificateStaffMapper certificateStaffMapper;
    @Autowired
    private ICertificateStaffDetailService certificateStaffDetailService;
    @Autowired
    private ICertificateCompanyService certificateCompanyService;
    @Autowired
    private ICertificateDeviceService certificateDeviceService;
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    private IStaffInfoService stafInfoService;
    @Value(value="${isActualize}")
    private String isActualize;

    public PageInfo<CertificateStaff> getCertficateList(CertificateStaff info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<Object> list = this.certificateStaffMapper.getByParam(info);
        for (CertificateStaff cert : list) {
            int num = 0;
            Object names = null;
            List staffList = this.certificateStaffDetailService.getListNoIncludeNoWorkedByCertId(cert.getId());
            for (CertificateStaffDetail staff : staffList) {
                Object staffName = null;
                if (staff.getDataSource() != null && staff.getDataSource().intValue() == 2 && staff.getStaffId() != null) {
                    StaffBasicVo staffBasicVo = this.stafInfoService.getStaffBasicVoFromOrgById(staff.getStaffId());
                    if (staffBasicVo != null) {
                        staffName = staffBasicVo.getStaffName();
                    }
                } else {
                    staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(staff.getStaffId());
                    if (staffName == null || ((String)staffName).equals("")) {
                        staffName = "\uff08\u5df2\u5220\u9664\uff09" + staff.getStaffName();
                    }
                }
                ++num;
                if (names == null) {
                    names = staffName;
                    continue;
                }
                names = (String)names + "," + (String)staffName;
            }
            cert.setStaffNum(Integer.valueOf(num));
            cert.setStaffNames(names);
        }
        list = list.stream().sorted(Comparator.comparing(CertificateStaff::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        return new PageInfo(list);
    }

    public List<CertificateStaff> getCertficateListByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        List<CertificateStaff> list = this.certificateStaffMapper.getByParam(info);
        for (CertificateStaff cert : list) {
            if (cert.getNameId() == null || cert.getNameId() != 12L && cert.getNameId() != 13L) continue;
            List staffList = this.certificateStaffDetailService.getListNoIncludeNoWorkedByCertId(cert.getId());
            cert.setStaffs(staffList);
        }
        return list;
    }

    public Date getHseCertExpireDate(Long cid) {
        return this.certificateStaffMapper.getHseCertExpireDate(cid);
    }

    public List<CertificateStaff> getExportListByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        int serialNum = 1;
        List<CertificateStaff> list = this.certificateStaffMapper.getByParam(info);
        for (CertificateStaff cert : list) {
            cert.setSerialNum(serialNum);
            ++serialNum;
            int num = 0;
            Object names = null;
            List staffList = this.certificateStaffDetailService.getListByCertId(cert.getId());
            for (CertificateStaffDetail staff : staffList) {
                Object staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(staff.getStaffId());
                if (staffName == null || ((String)staffName).equals("")) {
                    staffName = "\uff08\u5df2\u5220\u9664\uff09" + staff.getStaffName();
                }
                ++num;
                if (names == null) {
                    names = staff.getStaffName();
                    continue;
                }
                names = (String)names + "," + staff.getStaffName();
            }
            cert.setStaffNum(Integer.valueOf(num));
            cert.setStaffNames(names);
        }
        return list;
    }

    public CertificateWorkItemVo getCertTodoInfo(Long cid) {
        CertificateWorkItemVo vo = new CertificateWorkItemVo();
        Integer tipNum = 0;
        Integer year = DateUtils.getYear();
        Boolean haveCompManagerCert = this.certificateStaffDetailService.haveManagerCertificateByCid(cid, Long.valueOf(12L));
        if ("true".equals(this.isActualize)) {
            haveCompManagerCert = this.certificateStaffDetailService.haveManagerCertificate(cid, Long.valueOf(12L), null);
        }
        vo.setHaveCompManagerCert(haveCompManagerCert);
        if (!haveCompManagerCert.booleanValue()) {
            Boolean isIgnore = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.staffCertificate_leader, cid, year.intValue());
            if (isIgnore.booleanValue()) {
                vo.setHaveCompManagerCert(Boolean.valueOf(true));
            } else {
                tipNum = tipNum + 1;
            }
        }
        Boolean haveHseManagerCert = this.certificateStaffDetailService.haveManagerCertificateByCid(cid, Long.valueOf(13L));
        if ("true".equals(this.isActualize)) {
            haveHseManagerCert = this.certificateStaffDetailService.haveManagerCertificate(cid, Long.valueOf(13L), null);
        }
        vo.setHaveHseManagerCert(haveHseManagerCert);
        if (!haveHseManagerCert.booleanValue()) {
            Boolean isIgnore = this.sysCoreWorkModuleCorrelationService.hasIgnoreData(TodlistInfoTypeEnum.staffCertificate_manager, cid, year.intValue());
            if (isIgnore.booleanValue()) {
                vo.setHaveHseManagerCert(Boolean.valueOf(true));
            } else {
                tipNum = tipNum + 1;
            }
        }
        vo.setTipNum(tipNum);
        vo.setCertOfExpireCertNum(this.getNumOfExpireCert(cid));
        int num = this.getNumofAllCert(cid);
        if (num == 0) {
            vo.setIsShowAdd(Boolean.valueOf(true));
        }
        return vo;
    }

    public Integer getNumOfExpireCert(Long cid) {
        Integer num = 0;
        int num1 = this.certificateStaffDetailService.getExpireCertficateNum(cid);
        return num1;
    }

    public Integer getNumofAllCert(Long cid) {
        Integer num = 0;
        int num1 = this.getCertNumByCid(cid);
        int num2 = this.certificateDeviceService.getNumOfDeviceCertByCid(cid);
        int num3 = this.certificateCompanyService.getCertficateNumByCid(cid);
        num = num1 + num2 + num3;
        return num;
    }

    public CertificateNumSummVo certStaffSummaryInfo(Long cid, Long nameId, Integer staffType) {
        CertificateNumSummVo certSummaryInfo = new CertificateNumSummVo();
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("cid", cid);
        params.put("nameId", nameId);
        params.put("type", staffType);
        List list = this.certificateStaffDetailService.getCertListByParam(params);
        Date thisDay = new Date();
        if (list != null && list.size() > 0) {
            int effectiveNum = 0;
            int reviewNum = 0;
            int overdueNum = 0;
            certSummaryInfo.setTotalNum(Integer.valueOf(list.size()));
            for (CertificateStaffDetail cert : list) {
                if (cert.getValidityDate() != null) {
                    if (thisDay.before(cert.getValidityDate())) {
                        if (cert.getRepeatData() != null) {
                            if (thisDay.before(cert.getRepeatData())) {
                                ++effectiveNum;
                                continue;
                            }
                            ++reviewNum;
                            continue;
                        }
                        ++effectiveNum;
                        continue;
                    }
                    ++overdueNum;
                    continue;
                }
                if (cert.getRepeatData() != null) {
                    if (thisDay.before(cert.getRepeatData())) {
                        ++effectiveNum;
                        continue;
                    }
                    ++reviewNum;
                    continue;
                }
                ++effectiveNum;
            }
            certSummaryInfo.setEffectiveNum(Integer.valueOf(effectiveNum));
            certSummaryInfo.setOverdueNum(Integer.valueOf(overdueNum));
            certSummaryInfo.setReviewNum(Integer.valueOf(reviewNum));
        }
        return certSummaryInfo;
    }

    public int getCertNumByCid(Long cid) {
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        List<CertificateStaff> list = this.certificateStaffMapper.getByParam(info);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public void updateWithHistory(CertificateStaff record, Long staffid) {
        this.update(record, staffid);
    }

    @Transactional(readOnly=false)
    public CertificateStaff addWithHistory(CertificateStaff data, Long staffid, Long cid) {
        data = this.add(data, staffid, cid);
        return data;
    }

    public Boolean haveThisName(Long nameId, Long cid) {
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        info.setNameId(nameId);
        info.setIsValid(Boolean.valueOf(true));
        List list = this.certificateStaffMapper.select(info);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    public CertificateStaff getByNameId(Long nameId, Long cid) {
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        info.setNameId(nameId);
        info.setIsValid(Boolean.valueOf(true));
        List list = this.certificateStaffMapper.select(info);
        if (list != null && list.size() > 0) {
            return (CertificateStaff)list.get(0);
        }
        return null;
    }

    public TrainCertificateInfo getTrainCertificateInfo(Long cid) {
        TrainCertificateInfo info = new TrainCertificateInfo();
        CertificateNumSummVo vo1 = this.certStaffSummaryInfo(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.MAIN.getCode());
        CertificateNumSummVo vo2 = this.certStaffSummaryInfo(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.OccHeaMan.getCode());
        CertificateNumSummVo vo3 = this.certStaffSummaryInfo(cid, CertificateStaffTypeEnum.OccTrain.getId(), null);
        info.setEhsTrainCertificateNum(vo3.getTotalNum().intValue());
        info.setManagerTrainCertificateNum(vo1.getTotalNum().intValue());
        info.setManagerTrainCertificateNumValid(vo1.getEffectiveNum() + vo1.getReviewNum());
        info.setEhsManagerTrainCertificateNum(vo2.getTotalNum().intValue());
        info.setEhsManagerTrainCertificateNumValid(vo2.getEffectiveNum() + vo2.getReviewNum());
        return info;
    }

    @Transactional(readOnly=false)
    public void deleteWithHis(CertificateStaff info, Long staffid, Long cid) {
        info.setIsValid(Boolean.valueOf(false));
        this.update(info, staffid);
        this.certificateStaffDetailService.delByCertId(info.getId());
    }

    public List<CertificateStaffDetailVo> getCertStaffByParam(CertificateStaff info) {
        List<CertificateStaffDetailVo> list = ((CertificateStaffMapper)this.dao).getCertStaffByParam(info);
        return list;
    }

    public List<CertificateStaffDetailVo> getCertStaffNoIncludeNoWorkedByParam(CertificateStaff info) {
        HashMap companyOrganizationMap = new HashMap();
        List<CertificateStaffDetailVo> list = ((CertificateStaffMapper)this.dao).getCertStaffNoIncludeNoWorkedByParam(info);
        for (CertificateStaffDetailVo cert : list) {
            ArrayList workNames = new ArrayList();
            ArrayList orgNames = new ArrayList();
            List workRoleInfos = this.workRoleInfoService.getCurrentAndPluralityWorkRoleInfosByCid(cert.getStaffId());
            workRoleInfos.forEach(s -> {
                if (companyOrganizationMap.get(s.getOrgId()) == null) {
                    companyOrganizationMap.put(s.getOrgId(), (CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId()));
                }
                Object workName = "";
                if (s.getIsValid() != null && !s.getIsValid().booleanValue()) {
                    workName = (String)workName + "(\u5df2\u5220\u9664)";
                }
                Object orgName = "";
                CompanyOrganization co = (CompanyOrganization)companyOrganizationMap.get(s.getOrgId());
                if (co != null) {
                    if (co.getIsValid() != null && !co.getIsValid().booleanValue()) {
                        orgName = (String)orgName + "(\u5df2\u5220\u9664)";
                    }
                    orgName = (String)orgName + co.getOrganizationName();
                    orgNames.add(orgName);
                }
                workNames.add((String)workName + s.getWorkName() + "/" + (String)orgName);
            });
            cert.setWorkNames(workNames.stream().distinct().collect(Collectors.joining(",")));
            cert.setOrgNames(orgNames.stream().distinct().collect(Collectors.joining(",")));
        }
        return list;
    }

    public CertificateStaff getHseTrainCert(Long cid, Long nameId) {
        if (cid == null || nameId == null) {
            return null;
        }
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        info.setNameId(nameId);
        List<CertificateStaff> list = this.certificateStaffMapper.getByParam(info);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

