/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.component.event.HomeDataEvent;
import cn.smarthse.modules.health.dao.work.certificate.CertificateStaffDetailMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffQuery;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.certificate.CertificateImportVo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateRepeatNoteEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffDetailDataSourceEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialEquipOperationsDetailTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialEquipOperationsTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialOperationsDetailTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialOperationsTypeEnum;
import cn.smarthse.modules.health.enums.certificate.StStaffTypeEnum;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactory;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.entity.trainPlan.RaTuCertificateModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainCertModel;
import cn.smarthse.modules.health.supervise.enums.keyFactory.HistoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeEnergyEfficiencyVo;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffCountVo;
import cn.smarthse.modules.health.vo.work.staffCert.StaffCertDetailVo;
import cn.smarthse.services.wanda.api.entity.WandaTrainData;
import cn.smarthse.services.wanda.api.service.IWandaTrainDataService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CertificateStaffDetailServiceImpl
extends BaseServiceImpl<CertificateStaffDetailMapper, CertificateStaffDetail>
implements ICertificateStaffDetailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateStaffDetailServiceImpl.class);
    @Autowired
    CertificateStaffDetailMapper certificateStaffDetailMapper;
    @Autowired
    ICertificateFilesService certificateFilesService;
    @Autowired
    OssClientBean ossClientBean;
    @Autowired
    private IStaffInfoService stafInfoService;
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    ApplicationContext ac;
    @DubboReference
    IKeyFactoryApprovalHistoryService historyService;
    @DubboReference
    private IKeyFactoryService keyFactoryService;
    @DubboReference
    private IKeyFactoryApprovalHistoryService keyFactoryApprovalHistoryService;
    @Resource
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IWandaTrainDataService wandaTrainDataService;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;

    public List<CertificateStaffDetail> getListByCertId(Long id) {
        CertificateStaffDetail record = new CertificateStaffDetail();
        record.setCertId(id);
        record.setIsValid(Boolean.valueOf(true));
        return this.certificateStaffDetailMapper.select(record);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long addWithFile(CertificateStaffDetail record, Long staffid, Long cid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.EDU_TRAINING));
        List fileList = record.getFiles();
        if (record.getRepeatNote() != null) {
            record.setInformPeriod(this.getReminderDays(record.getRepeatNote()));
        }
        record.setIsValid(Boolean.valueOf(true));
        record.setCreateDate(new Date());
        record.setUpdateDate(new Date());
        StaffQuery staffQuery = new StaffQuery();
        staffQuery.setCid(cid);
        staffQuery.setStaffName(record.getStaffName());
        List staffIdList = this.stafInfoService.getStaffIdByStaffQuery(staffQuery);
        if (CollUtil.isNotEmpty((Collection)staffIdList)) {
            record.setStaffId((Long)staffIdList.get(0));
        }
        CertificateStaffDetail newRecord = this.add(record, staffid, cid);
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            for (CertificateFiles file : fileList) {
                file.setCerId(record.getId());
                this.certificateFilesService.add((Object)file, staffid, cid);
            }
        }
        return newRecord.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateWithFile(CertificateStaffDetail record, Long staffid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(record.getCid(), HomeDataEventEnum.EDU_TRAINING));
        List fileList = record.getFiles();
        if (record.getRepeatNote() != null) {
            record.setInformPeriod(this.getReminderDays(record.getRepeatNote()));
        }
        this.update(record, staffid);
        CertificateFiles entity = new CertificateFiles();
        entity.setCerId(record.getId());
        this.certificateFilesService.delete((Object)entity);
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            for (CertificateFiles file : fileList) {
                file.setCerId(record.getId());
                this.certificateFilesService.add((Object)file, staffid, record.getCid());
            }
        }
    }

    public int daysBetween(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            if (year1 < year2) {
                for (int i = year1; i < year2; ++i) {
                    if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                        timeDistance += 366;
                        continue;
                    }
                    timeDistance += 365;
                }
            } else {
                for (int i = year2; i < year1; ++i) {
                    if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                        timeDistance -= 366;
                        continue;
                    }
                    timeDistance -= 365;
                }
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public Integer getReminderDays(Byte remindType) {
        if (remindType != null) {
            if (remindType.equals(CertificateRepeatNoteEnum.Fifteen.getValue())) {
                return CertificateRepeatNoteEnum.Fifteen.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Thirty.getValue())) {
                return CertificateRepeatNoteEnum.Thirty.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Sixty.getValue())) {
                return CertificateRepeatNoteEnum.Sixty.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Ninety.getValue())) {
                return CertificateRepeatNoteEnum.Ninety.getDays();
            }
            return null;
        }
        return null;
    }

    public PageInfo<CertificateStaffDetail> getPageDataByParam(CertificateStaffDetail info, Long nameId, JqGridParam param) {
        if (info == null || info.getCertId() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CertificateStaffDetail> list = this.getListByParam(info, nameId);
        return new PageInfo(list);
    }

    public PageInfo<CertificateStaffDetail> getLitePageDataByParam(CertificateStaffDetail info, JqGridParam param, Date nowDate, String paramYear) {
        if (info == null || info.getCid() == null) {
            return null;
        }
        List<Object> certList = this.certificateStaffDetailMapper.getLiteListByParam(info);
        if (CollUtil.isEmpty(certList)) {
            return null;
        }
        List<Long> certIdList = certList.stream().map(CertificateStaffDetail::getId).toList();
        Map<Long, List<CertificateFiles>> certFileMap = this.certificateFilesService.getByCertIdList(certIdList).stream().collect(Collectors.groupingBy(CertificateFiles::getCerId));
        certList.forEach(c -> c.setFiles((List)certFileMap.get(c.getId())));
        if (nowDate != null) {
            certList = certList.stream().filter(item -> item.getCertCreateDate() != null && item.getCertCreateDate().compareTo(nowDate) <= 0).collect(Collectors.toList());
            certList = certList.stream().filter(item -> item.getValidityDate() != null && item.getValidityDate().compareTo(nowDate) >= 0).collect(Collectors.toList());
        }
        if (paramYear != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            certList = certList.stream().filter(i -> paramYear.equals(sdf.format(i.getCertCreateDate()).substring(0, 4))).collect(Collectors.toList());
        }
        certList = Optional.of(certList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).filter(c -> {
            ApprovalStatusEnum status = ApprovalStatusEnum.getEnum((Byte)c.getStatus());
            return status == ApprovalStatusEnum.DRAFT || c.getCertCreateDate() != null && c.getCreateDate() != null;
        }).sorted(Comparator.comparing(CertificateStaffDetail::getCertCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(CertificateStaffDetail::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).toList();
        return PageUtil.getPageInfo(certList, (int)param.getPage(), (int)param.getRows());
    }

    public List<CertificateStaffDetail> getListByParam(CertificateStaffDetail info, Long nameId) {
        if (info == null || info.getCertId() == null) {
            return null;
        }
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getListByParam(info);
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                String workType;
                List files;
                if (cert.getDataSource() != null) {
                    StaffBasicVo cstaff;
                    if (cert.getDataSource().intValue() == 1) {
                        String staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(cert.getStaffId());
                        if (staffName != null && !staffName.equals("")) {
                            cert.setStaffName(staffName);
                        } else {
                            cert.setStaffName("\uff08\u5df2\u5220\u9664\uff09" + cert.getStaffName());
                        }
                    } else if (cert.getStaffId() != null && (cstaff = this.stafInfoService.getStaffBasicVoFromOrgById(cert.getStaffId())) != null) {
                        cert.setStaffName(cstaff.getStaffName());
                    }
                }
                if ((files = this.certificateFilesService.getByCerid(cert.getId())) != null && files.size() > 0 && cert.getDataSource() != null && cert.getDataSource().intValue() == 2) {
                    files.stream().filter(s -> s.getFileId() != null && StringUtils.isEmpty((CharSequence)s.getFileUrl()) && StringUtils.isEmpty((CharSequence)s.getFileName())).forEach(s -> {
                        SysFileModel file = this.sysFileServiceImpl.getFileById(s.getFileId());
                        if (file != null) {
                            s.setFileUrl(file.getOssUrl());
                            s.setFileName(file.getFileName());
                        }
                    });
                }
                cert.setFiles(files);
                if (nameId == null) continue;
                if (nameId.equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                    cert.setStaffTypeName(StStaffTypeEnum.getNameByCode((Integer)cert.getStaffType()));
                    continue;
                }
                if (nameId.equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                    cert.setStaffTypeName(OccHeaStaffTypeEnum.getNameByCode((Integer)cert.getStaffType()));
                    continue;
                }
                if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                    workType = SpecialOperationsTypeEnum.getNameByCode((Integer)cert.getWorkType()) + "-" + SpecialOperationsDetailTypeEnum.getNameByCode((Integer)cert.getWorkTypeDetail());
                    cert.setWorkTypeName(workType);
                    continue;
                }
                if (!nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) continue;
                workType = SpecialEquipOperationsTypeEnum.getNameByCode((Integer)cert.getWorkType()) + "-" + SpecialEquipOperationsDetailTypeEnum.getNameByCode((Integer)cert.getWorkTypeDetail());
                cert.setWorkTypeName(workType);
            }
        }
        return list;
    }

    public List<CertificateStaffDetail> getListNoIncludeNoWorkedByParam(CertificateStaffDetail info, Long nameId) {
        if (info == null || info.getCertId() == null) {
            return null;
        }
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getListNoIncludeNoWorkedByParam(info);
        HashMap companyOrganizationMap = new HashMap();
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                String workType;
                List files;
                if (cert.getDataSource() != null) {
                    StaffBasicVo cstaff;
                    if (cert.getDataSource().intValue() == 1) {
                        String staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(cert.getStaffId());
                        ArrayList workNames = new ArrayList();
                        ArrayList orgNames = new ArrayList();
                        List workRoleInfos = this.workRoleInfoService.getCurrentAndPluralityWorkRoleInfosByCid(cert.getStaffId());
                        workRoleInfos.forEach(s -> {
                            if (companyOrganizationMap.get(s.getOrgId()) == null) {
                                companyOrganizationMap.put(s.getOrgId(), (CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId()));
                            }
                            Object workName = "";
                            if (s.getIsValid() != null && !s.getIsValid().booleanValue()) {
                                workName = (String)workName + "(\u5df2\u5220\u9664)";
                            }
                            Object orgName = "";
                            CompanyOrganization co = (CompanyOrganization)companyOrganizationMap.get(s.getOrgId());
                            if (co != null) {
                                if (co.getIsValid() != null && !co.getIsValid().booleanValue()) {
                                    orgName = (String)orgName + "(\u5df2\u5220\u9664)";
                                }
                                orgName = (String)orgName + co.getOrganizationName();
                                orgNames.add(orgName);
                            }
                            workNames.add((String)workName + s.getWorkName() + "/" + (String)orgName);
                        });
                        cert.setWorkNames(workNames.stream().distinct().collect(Collectors.joining(",")));
                        cert.setOrgNames(orgNames.stream().distinct().collect(Collectors.joining(",")));
                        if (staffName != null && !staffName.equals("")) {
                            cert.setStaffName(staffName.substring(0, staffName.indexOf("/")));
                        } else {
                            cert.setStaffName("\uff08\u5df2\u5220\u9664\uff09" + cert.getStaffName());
                        }
                    } else if (cert.getStaffId() != null && (cstaff = this.stafInfoService.getStaffBasicVoFromOrgById(cert.getStaffId())) != null) {
                        cert.setStaffName(cstaff.getStaffName());
                    }
                }
                if ((files = this.certificateFilesService.getByCerid(cert.getId())) != null && files.size() > 0 && cert.getDataSource() != null && cert.getDataSource().intValue() == 2) {
                    files.stream().filter(s -> s.getFileId() != null && StringUtils.isEmpty((CharSequence)s.getFileUrl()) && StringUtils.isEmpty((CharSequence)s.getFileName())).forEach(s -> {
                        SysFileModel file = this.sysFileServiceImpl.getFileById(s.getFileId());
                        if (file != null) {
                            s.setFileUrl(file.getOssUrl());
                            s.setFileName(file.getFileName());
                        }
                    });
                }
                cert.setFiles(files);
                if (nameId == null) continue;
                if (nameId.equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                    cert.setStaffTypeName(StStaffTypeEnum.getNameByCode((Integer)cert.getStaffType()));
                    continue;
                }
                if (nameId.equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                    cert.setStaffTypeName(OccHeaStaffTypeEnum.getNameByCode((Integer)cert.getStaffType()));
                    continue;
                }
                if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                    workType = SpecialOperationsTypeEnum.getNameByCode((Integer)cert.getWorkType()) + "-" + SpecialOperationsDetailTypeEnum.getNameByCode((Integer)cert.getWorkTypeDetail());
                    cert.setWorkTypeName(workType);
                    continue;
                }
                if (!nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) continue;
                workType = SpecialEquipOperationsTypeEnum.getNameByCode((Integer)cert.getWorkType()) + "-" + SpecialEquipOperationsDetailTypeEnum.getNameByCode((Integer)cert.getWorkTypeDetail());
                cert.setWorkTypeName(workType);
            }
        }
        return list;
    }

    public List<CertificateStaffDetail> getListNoIncludeNoWorkedByCidAndNameIdsAndYear(Long cid, String nameIds, Integer year) {
        if (cid == null || StringUtils.isEmpty((CharSequence)nameIds)) {
            return null;
        }
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getListNoIncludeNoWorkedByCidAndNameIdsAndYear(cid, nameIds, year);
        HashMap companyOrganizationMap = new HashMap();
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                List files;
                if (cert.getDataSource() != null) {
                    StaffBasicVo cstaff;
                    if (cert.getDataSource().intValue() == 1) {
                        String staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(cert.getStaffId());
                        ArrayList workNames = new ArrayList();
                        ArrayList orgNames = new ArrayList();
                        List workRoleInfos = this.workRoleInfoService.getCurrentAndPluralityWorkRoleInfosByCid(cert.getStaffId());
                        workRoleInfos.forEach(s -> {
                            if (companyOrganizationMap.get(s.getOrgId()) == null) {
                                companyOrganizationMap.put(s.getOrgId(), (CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId()));
                            }
                            Object workName = "";
                            if (s.getIsValid() != null && !s.getIsValid().booleanValue()) {
                                workName = (String)workName + "(\u5df2\u5220\u9664)";
                            }
                            Object orgName = "";
                            CompanyOrganization co = (CompanyOrganization)companyOrganizationMap.get(s.getOrgId());
                            if (co != null) {
                                if (co.getIsValid() != null && !co.getIsValid().booleanValue()) {
                                    orgName = (String)orgName + "(\u5df2\u5220\u9664)";
                                }
                                orgName = (String)orgName + co.getOrganizationName();
                                orgNames.add(orgName);
                            }
                            workNames.add((String)workName + s.getWorkName() + "/" + (String)orgName);
                        });
                        cert.setWorkNames(workNames.stream().distinct().collect(Collectors.joining(",")));
                        cert.setOrgNames(orgNames.stream().distinct().collect(Collectors.joining(",")));
                        if (staffName != null && !staffName.equals("")) {
                            cert.setStaffName(staffName.substring(0, staffName.indexOf("/")));
                        } else {
                            cert.setStaffName("\uff08\u5df2\u5220\u9664\uff09" + cert.getStaffName());
                        }
                    } else if (cert.getStaffId() != null && (cstaff = this.stafInfoService.getStaffBasicVoFromOrgById(cert.getStaffId())) != null) {
                        cert.setStaffName(cstaff.getStaffName());
                    }
                }
                if ((files = this.certificateFilesService.getByCerid(cert.getId())) != null && files.size() > 0 && cert.getDataSource() != null && cert.getDataSource().intValue() == 2) {
                    for (CertificateFiles s2 : files) {
                        SysFileModel file = this.sysFileServiceImpl.getFileById(s2.getFileId());
                        if (file == null) continue;
                        s2.setFileUrl(file.getOssUrl());
                        s2.setFileName(file.getFileName());
                    }
                }
                cert.setFiles(files);
                List fileList = cert.getFiles();
                if (fileList == null) continue;
                StringBuilder fileNames = null;
                for (CertificateFiles file : fileList) {
                    String name = file.getFileName();
                    if (name != null) {
                        name = name.replace("&", "");
                    }
                    if (fileNames == null) {
                        fileNames = new StringBuilder(name);
                        continue;
                    }
                    fileNames.append(";").append(name);
                }
                if (fileNames == null) continue;
                cert.setFilesName(fileNames.toString());
            }
        }
        return list;
    }

    public CertificateStaffDetail getByIdWithFile(Long id) {
        CertificateStaffDetail info = (CertificateStaffDetail)this.getById(id);
        List files = this.certificateFilesService.getByCerid(info.getId());
        info.setFiles(files);
        return info;
    }

    public PageInfo<CertificateStaffDetail> getExpireCertficateList(CertificateStaffDetail info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getExpireCertficateList(info);
        for (CertificateStaffDetail cert : list) {
            if (cert.getStaffId() != null) {
                String staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(cert.getStaffId());
                if (staffName != null && !staffName.equals("")) {
                    cert.setStaffName(staffName);
                } else {
                    cert.setStaffName("\uff08\u5df2\u5220\u9664\uff09" + cert.getStaffName());
                }
            }
            int effday = 0;
            if (cert.getRepeatData() != null) {
                effday = this.daysBetween(new Date(), cert.getRepeatData());
            }
            if (cert.getValidityDate() != null) {
                int day2 = this.daysBetween(new Date(), cert.getValidityDate());
                if (effday == 0 || effday > day2) {
                    effday = day2;
                }
            }
            cert.setEffectiveDays(effday + "\u5929");
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public Integer getExpireCertficateNum(Long cid) {
        if (cid == null) {
            return 0;
        }
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getExpireCertficateList(info);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public Boolean haveManagerCertificate(Long cid, Long nameId, Integer type) {
        if (cid == null) {
            return Global.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        params.put("nameId", nameId);
        params.put("type", type);
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getManagerCertificate(params);
        if (list != null && list.size() > 0) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }

    public Date getCertificateValidate(Long cid, Long nameId, Integer type) {
        if (cid == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        params.put("nameId", nameId);
        params.put("type", type);
        Date date = this.certificateStaffDetailMapper.getCertificateValidate(params);
        return date;
    }

    public Boolean haveManagerCertificateByCid(Long cid, Long nameId) {
        if (cid == null) {
            return Global.FALSE;
        }
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getManagerCertificateByCidAndNameId(cid, nameId);
        if (list != null && list.size() > 0) {
            return Global.TRUE;
        }
        return Global.FALSE;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delByCertId(Long id) {
        CertificateStaffDetail record = new CertificateStaffDetail();
        record.setCertId(id);
        record.setIsValid(Boolean.valueOf(true));
        List list = this.certificateStaffDetailMapper.select(record);
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail info : list) {
                info.setIsValid(Boolean.valueOf(false));
                this.update(info);
            }
        }
    }

    public List<CertificateStaffDetail> getBatchEditList(CertificateStaffDetail info, Long nameId) {
        if (info == null || info.getCertId() == null) {
            return null;
        }
        info.setDataSource(Byte.valueOf((byte)1));
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getListByParam(info);
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                List detailList;
                List files = this.certificateFilesService.getByCerid(cert.getId());
                cert.setFiles(files);
                if (nameId == null) continue;
                if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                    detailList = SpecialOperationsDetailTypeEnum.getListByFcode((Integer)cert.getWorkType());
                    cert.setDetailList(detailList);
                    continue;
                }
                if (!nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) continue;
                detailList = SpecialEquipOperationsDetailTypeEnum.getListByFcode((Integer)cert.getWorkType());
                cert.setDetailList(detailList);
            }
        }
        return list;
    }

    public ResponseData<Boolean> isEqualOfCreateTime(Long certId) {
        ResponseData data = new ResponseData();
        CertificateStaffDetail record = new CertificateStaffDetail();
        record.setCertId(certId);
        record.setIsValid(Boolean.valueOf(true));
        record.setDataSource(Byte.valueOf((byte)1));
        List list = this.certificateStaffDetailMapper.select(record);
        data.setResult((Object)true);
        if (list == null || list.size() < 1) {
            data.setContent("\u6ca1\u6709\u53d6\u8bc1\u4eba\u5458\uff0c\u8bf7\u6dfb\u52a0");
            data.setResult((Object)false);
        } else if (list.size() == 1) {
            data.setResult((Object)true);
        } else {
            for (int i = 0; i < list.size() - 1; ++i) {
                int j;
                Boolean isEq;
                if (((CertificateStaffDetail)list.get(i)).getCertCreateDate() != null) {
                    isEq = false;
                    for (j = i + 1; j < list.size(); ++j) {
                        if (((CertificateStaffDetail)list.get(j)).getCertCreateDate() != null) {
                            if (((CertificateStaffDetail)list.get(i)).getCertCreateDate().equals(((CertificateStaffDetail)list.get(j)).getCertCreateDate())) continue;
                            data.setContent("\u53d6\u8bc1\u65f6\u95f4\u4e0d\u540c\uff0c\u4e0d\u80fd\u6279\u91cf\u4fee\u6539");
                            data.setResult((Object)false);
                            isEq = true;
                            break;
                        }
                        data.setContent("\u53d6\u8bc1\u65f6\u95f4\u4e0d\u540c\uff0c\u4e0d\u80fd\u6279\u91cf\u4fee\u6539");
                        data.setResult((Object)false);
                        isEq = true;
                        break;
                    }
                    if (!isEq.booleanValue()) continue;
                    break;
                }
                isEq = false;
                for (j = i + 1; j < list.size(); ++j) {
                    if (((CertificateStaffDetail)list.get(j)).getCertCreateDate() == null) continue;
                    data.setContent("\u53d6\u8bc1\u65f6\u95f4\u4e0d\u540c\uff0c\u4e0d\u80fd\u6279\u91cf\u4fee\u6539");
                    data.setResult((Object)false);
                    isEq = true;
                    break;
                }
                if (isEq.booleanValue()) break;
            }
        }
        return data;
    }

    public PageInfo<CertificateStaffDetail> getByStaffId(Long staffid, JqGridParam param) {
        if (staffid == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setStaffId(staffid);
        info.setCid(param.getCid());
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getCertficateByStaffId(info);
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                String workType;
                List files = this.certificateFilesService.getByCerid(cert.getId());
                cert.setFiles(files);
                if (cert.getCertNameId() == null) continue;
                if (cert.getCertNameId().equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                    cert.setStaffTypeName(StStaffTypeEnum.getNameByCode((Integer)cert.getStaffType()));
                    continue;
                }
                if (cert.getCertNameId().equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                    cert.setStaffTypeName(OccHeaStaffTypeEnum.getNameByCode((Integer)cert.getStaffType()));
                    continue;
                }
                if (cert.getCertNameId().equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                    workType = SpecialOperationsTypeEnum.getNameByCode((Integer)cert.getWorkType()) + "-" + SpecialOperationsDetailTypeEnum.getNameByCode((Integer)cert.getWorkTypeDetail());
                    cert.setStaffTypeName(workType);
                    continue;
                }
                if (cert.getCertNameId().equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                    workType = SpecialEquipOperationsTypeEnum.getNameByCode((Integer)cert.getWorkType()) + "-" + SpecialEquipOperationsDetailTypeEnum.getNameByCode((Integer)cert.getWorkTypeDetail());
                    cert.setStaffTypeName(workType);
                    continue;
                }
                cert.setStaffTypeName("-");
            }
        }
        return new PageInfo(list);
    }

    public List<CertificateStaffDetail> getCertListByParam(Map<String, Object> params) {
        return this.certificateStaffDetailMapper.getManagerCertificate(params);
    }

    public List<CertificateStaff> getCertStaffNumByCid(Long cid) {
        return this.certificateStaffDetailMapper.getCertStaffNumByCid(cid);
    }

    public Integer getCertNumByParam(Map<String, Object> params) {
        return this.certificateStaffDetailMapper.getCertNumByParam(params);
    }

    public List<CertificateStaffDetail> getCertByStaffId(Long staffid, Long cid) {
        if (staffid == null) {
            return null;
        }
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setStaffId(staffid);
        info.setCid(cid);
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getCertficateByStaffId(info);
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                List files = this.certificateFilesService.getByCerid(cert.getId());
                cert.setFiles(files);
            }
        }
        return list;
    }

    public PageInfo<CertificateStaffDetail> getStaffCertByStaffId(CertificateStaffDetail info, JqGridParam param) {
        if (info.getStaffId() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        info.setCid(param.getCid());
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getCertficateByStaffId(info);
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail cert : list) {
                List files = this.certificateFilesService.getByCerid(cert.getId());
                cert.setFiles(files);
            }
        }
        return new PageInfo(list);
    }

    public List<CertificateFiles> getCertFilesByCertId(Long certId) {
        List files = this.certificateFilesService.getByCerid(certId);
        for (CertificateFiles cf : files) {
            if (cf == null || !StringUtils.isNotEmpty((String)cf.getFileUrl())) continue;
            cf.setFileUrl(this.ossClientBean.getUrl(cf.getFileUrl()));
        }
        return files;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteWithHis(CertificateStaffDetail info, Long staffid, Long cid) {
        info.setIsValid(Boolean.valueOf(false));
        this.update(info, staffid);
    }

    public int getgetHaveEffectiveHseCertNumBycid(Long cid) {
        List<CertificateStaffDetail> list = this.certificateStaffDetailMapper.getHaveEffectiveHseCertListBycid(cid);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public Boolean haveMainEffectiveCertByCid(Long cid) {
        if (cid == null) {
            return false;
        }
        List<CertificateStaffDetail> certList = this.certificateStaffDetailMapper.getMainEffectiveCertByCid(cid);
        if (certList != null && certList.size() > 0) {
            return true;
        }
        return false;
    }

    public CertificateStaffDetail getCertForOrgByStaffId(Long staffId, Long certId, Long cid, Long reportId) {
        if (staffId == null) {
            return null;
        }
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setStaffId(staffId);
        info.setCid(cid);
        info.setCertId(certId);
        info.setDataSource(Byte.valueOf("2"));
        info.setReportId(reportId);
        info.setIsValid(Boolean.valueOf(true));
        List list = this.certificateStaffDetailMapper.select(info);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (CertificateStaffDetail)list.get(0);
        }
        return null;
    }

    public CertificateStaffDetail getCertForOrgByStaffIdAndCertType(Long staffId, Integer staffType, Long cid) {
        if (staffId == null) {
            return null;
        }
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setStaffId(staffId);
        info.setCid(cid);
        if (staffType != null && staffType == 1) {
            info.setCertId(Long.valueOf(12L));
        } else {
            info.setCertId(Long.valueOf(13L));
        }
        info.setIsValid(Boolean.valueOf(true));
        List list = this.certificateStaffDetailMapper.select(info);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (CertificateStaffDetail)list.get(0);
        }
        return null;
    }

    public CertificateStaffDetail getCertForOrgByStaffIdAndCertType(Long trainId, Long staffId, Integer staffType, Long cid) {
        if (staffId == null) {
            return null;
        }
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setStaffId(staffId);
        info.setCid(cid);
        if (staffType != null && staffType == 1) {
            info.setCertId(Long.valueOf(12L));
        } else {
            info.setCertId(Long.valueOf(13L));
        }
        info.setIsValid(Boolean.valueOf(true));
        info.setReportId(trainId);
        List list = this.certificateStaffDetailMapper.select(info);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (CertificateStaffDetail)list.get(0);
        }
        return null;
    }

    public CertificateStaffDetail getOnlineTrainCertBySyncInfo(TrainAttendModel certSync) {
        Long onlineTrainId = certSync.getOnlineTrainId();
        Long cid = certSync.getCid();
        String certNo = certSync.getCertNo();
        Integer certType = certSync.getCertType();
        CertificateStaffDetail certParam = new CertificateStaffDetail();
        certParam.setDataSource(cn.smarthse.common.util.Convert.toByte((Object)CertificateStaffDetailDataSourceEnum.ONLINE.getValue()));
        certParam.setReportId(onlineTrainId);
        certParam.setCid(cid);
        certParam.setCertNo(certNo);
        if (Objects.equals(certType, 1)) {
            certParam.setCertId(CertificateStaffNameTypeEnum.MainTrain.getId());
        }
        if (Objects.equals(certType, 2)) {
            certParam.setCertId(CertificateStaffNameTypeEnum.ManaTrain.getId());
        }
        certParam.setIsValid(Boolean.TRUE);
        List detailList = this.certificateStaffDetailMapper.select(certParam);
        return CollUtil.isEmpty((Collection)detailList) ? null : (CertificateStaffDetail)detailList.get(0);
    }

    public CertificateStaffDetail getSpecialCommitteeBySyncInfo(RaTuCertificateModel model) {
        CertificateStaffDetail certParam = new CertificateStaffDetail();
        certParam.setCid(model.getCid());
        certParam.setSourceId(StrUtil.join((CharSequence)"_", (Object[])new Object[]{model.getTid(), model.getId()}));
        certParam.setCertNo(model.getCertificateNo());
        certParam.setDataSource(Convert.toByte((Object)CertificateStaffDetailDataSourceEnum.SPECIAL_COMMITTEE.getValue()));
        certParam.setIsValid(Boolean.TRUE);
        if ("200001".equals(model.getCertType())) {
            certParam.setCertId(CertificateStaffNameTypeEnum.MainTrain.getId());
        } else if ("200002".equals(model.getCertType())) {
            certParam.setCertId(CertificateStaffNameTypeEnum.ManaTrain.getId());
        }
        List detailList = this.certificateStaffDetailMapper.select(certParam);
        return CollUtil.isEmpty((Collection)detailList) ? null : (CertificateStaffDetail)detailList.get(0);
    }

    public CertificateStaffDetail getDongYangCertBySyncInfo(TrainCertModel certSync) {
        CertificateStaffDetail certDetail = new CertificateStaffDetail();
        certDetail.setDataSource(cn.smarthse.common.util.Convert.toByte((Object)CertificateStaffDetailDataSourceEnum.OFFLINE.getValue()));
        certDetail.setCid(certSync.getCid());
        certDetail.setStaffName(certSync.getStaffName());
        certDetail.setCertId(certSync.getTrainPersonnelType());
        certDetail.setIsValid(Boolean.TRUE);
        List detailList = this.certificateStaffDetailMapper.select(certDetail);
        return CollUtil.isEmpty((Collection)detailList) ? null : (CertificateStaffDetail)detailList.get(0);
    }

    @Transactional(rollbackFor={Exception.class})
    public CertificateStaffDetail addCertStaffForOrg(CertificateStaffDetail info) {
        info.setDataSource(Byte.valueOf("2"));
        info.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
        this.add(info);
        return info;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateFileForOrg(Long[] fileIds, Long staffCertId, Long cid, Long staffid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.EDU_TRAINING));
        if (fileIds == null || fileIds.length == 0 || staffCertId == null || cid == null) {
            return;
        }
        List<Long> fileIdList = Arrays.asList(fileIds);
        List files = fileIdList.stream().map(s -> {
            CertificateFiles file = new CertificateFiles();
            file.setCid(cid);
            file.setCerId(staffCertId);
            file.setFileId(s);
            return file;
        }).collect(Collectors.toList());
        CertificateFiles entity = new CertificateFiles();
        entity.setCerId(staffCertId);
        this.certificateFilesService.delete((Object)entity);
        for (CertificateFiles f : files) {
            this.certificateFilesService.add((Object)f);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateFile(String fileIds, Long staffCertId, Long cid, Long staffid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.EDU_TRAINING));
        if (fileIds == null || staffCertId == null || cid == null) {
            return;
        }
        List fileIdList = StringUtils.parseToLongList((String)fileIds);
        List files = fileIdList.stream().map(s -> {
            CertificateFiles file = new CertificateFiles();
            file.setCid(cid);
            file.setCerId(staffCertId);
            file.setFileId(s);
            return file;
        }).collect(Collectors.toList());
        CertificateFiles entity = new CertificateFiles();
        entity.setCerId(staffCertId);
        this.certificateFilesService.delete((Object)entity);
        for (CertificateFiles f : files) {
            this.certificateFilesService.add((Object)f);
        }
    }

    public PageInfo<StaffCertDetailVo> getStaffCertListPageForOrg(CertificateStaffDetail info, JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<StaffCertDetailVo> list = this.certificateStaffDetailMapper.getStaffCertListForOrg(info);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(l -> {
                l.setIdCard(SpringEncryptUtils.decrypt((String)l.getIdCard()));
                l.setMobile(SpringEncryptUtils.decrypt((String)l.getMobile()));
                l.setRealName(SpringEncryptUtils.decrypt((String)l.getRealName()));
            });
        }
        return new PageInfo(list);
    }

    public PageInfo<StaffCertDetailVo> getStaffCertListPageForSup(CertificateStaffDetail info, JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<StaffCertDetailVo> staffCertList = this.certificateStaffDetailMapper.getStaffCertListForSupNew(info);
        for (StaffCertDetailVo staffCert : staffCertList) {
            String idCard = staffCert.getIdCard();
            staffCert.setAge(null);
            staffCert.setBirthday(null);
        }
        return new PageInfo(staffCertList);
    }

    public List<Long> getCerFileIds(List<Long> reportIds) {
        return ((CertificateStaffDetailMapper)this.dao).getCerFileIds(reportIds);
    }

    public List<StaffCertDetailVo> getStaffCertListForOrg(CertificateStaffDetail info) {
        return this.certificateStaffDetailMapper.getStaffCertListForSupNew(info);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateFile(List<SysFileModel> fileModelList, Long id, Long cid, Long staffId) {
        if (id == null || cid == null) {
            return;
        }
        CertificateFiles entity = new CertificateFiles();
        entity.setCerId(id);
        this.certificateFilesService.delete((Object)entity);
        if (fileModelList == null) {
            return;
        }
        for (SysFileModel file : fileModelList) {
            CertificateFiles f = new CertificateFiles();
            f.setCerId(id);
            f.setCid(cid);
            f.setFileId(file.getId());
            f.setFileUrl(file.getOssUrl());
            f.setFileName(file.getFileName());
            this.certificateFilesService.add((Object)f);
        }
    }

    public List<CertificateStaffDetail> getListNoIncludeNoWorkedByCertId(Long certId) {
        return this.certificateStaffDetailMapper.getListNoIncludeNoWorkedByCertId(certId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public List<CertificateImportVo> getCertInfoFromExcel(String ossfile) {
        List<CertificateImportVo> list = new ArrayList<CertificateImportVo>();
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    list = this.parseCertInfofromExcel((Sheet)sheet);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
        return list;
    }

    private List<CertificateImportVo> parseCertInfofromExcel(Sheet sheet) {
        ArrayList<CertificateImportVo> list = new ArrayList<CertificateImportVo>();
        int rowIndex = 0;
        int cellIndex = 5;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            boolean isNullRow = true;
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            HashMap cidMap = new HashMap();
            CertificateImportVo vo = new CertificateImportVo();
            vo.setErrorReason("");
            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
            block9: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (i != 5 && cell != null) {
                    cell.setCellType(CellType.STRING);
                }
                switch (i) {
                    case 0: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            isNullRow = false;
                            String companyName = cell.getStringCellValue().trim();
                            vo.setCompanyName(companyName);
                            continue block9;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block9;
                    }
                    case 1: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String creditCode = cell.getStringCellValue().trim();
                            vo.setCreditCode(creditCode);
                            Long cid = (Long)cidMap.get(creditCode);
                            if (cid != null) {
                                vo.setCid(cid);
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block9;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block9;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block9;
                    }
                    case 2: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String staffName = cell.getStringCellValue().trim();
                            vo.setStaffName(staffName);
                            continue block9;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block9;
                    }
                    case 3: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String type = cell.getStringCellValue().trim();
                            vo.setCertType(type);
                            if (type.equals("\u4e3b\u8981\u8d1f\u8d23\u4eba")) {
                                vo.setCertId(Long.valueOf(12L));
                                continue block9;
                            }
                            if (!type.equals("\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458")) continue block9;
                            vo.setCertId(Long.valueOf(13L));
                            continue block9;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block9;
                    }
                    case 4: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String idCard = cell.getStringCellValue().trim();
                            vo.setIdCard(idCard);
                            continue block9;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block9;
                    }
                    case 5: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block9;
                        isNullRow = false;
                        CertificateStaffDetailServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u53d6\u8bc1\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                            continue block9;
                        }
                        vo.setObtainCertDate(cell.getDateCellValue());
                    }
                }
            }
            if (isNullRow) break;
            list.add(vo);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public int importCertInfo(List<CertificateImportVo> list) throws Exception {
        if (list != null) {
            HashMap trainMap = new HashMap();
            int importNum = 0;
            for (CertificateImportVo vo : list) {
                if (vo.getCid() == null || vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue;
                ++importNum;
                StaffBasicVo staff = this.stafInfoService.getOrAddStaffInfoByQuery(vo.getCid(), vo.getStaffName(), vo.getIdCard(), null, null, null);
                CertificateStaffDetail cert = new CertificateStaffDetail();
                cert.setCid(vo.getCid());
                cert.setCertId(vo.getCertId());
                cert.setStaffId(staff.getStaffId());
                cert.setStaffName(vo.getStaffName());
                cert.setWorkNo(staff.getWorkNo());
                if (vo.getObtainCertDate() == null) {
                    cert.setCertCreateDate(DateUtil.getDate((String)"2022-09-30 12:00:00", (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    cert.setCertCreateDate(vo.getObtainCertDate());
                }
                if (cert.getCertId() != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(cert.getCertCreateDate());
                    if (cert.getCertId().equals(12L)) {
                        cal.add(1, 2);
                    } else {
                        cal.add(1, 1);
                    }
                    cert.setValidityDate(cal.getTime());
                }
                cert.setCreateDate(new Date());
                cert.setUpdateDate(new Date());
                this.add(cert);
            }
            return importNum;
        }
        return 0;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if ((cell.getCellType() == CellType.STRING || cell.getCellType() == CellType.FORMULA) && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                int year = date.getYear();
                if (year > 9999) {
                    cell.setCellType(CellType.BLANK);
                } else {
                    cell.setCellValue(date);
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchUpdateStaffName(List<CertificateStaffDetail> certificateList, String staffName) {
        if (CollectionUtils.isEmpty(certificateList)) {
            return 0;
        }
        return this.batchUpdateOrInsert(certificateList, CertificateStaffDetailMapper.class, (item, d) -> {
            CertificateFiles entity = new CertificateFiles();
            entity.setId(item.getId());
            entity.setCerId(item.getId());
            entity.setUpdateDate(new Date());
            this.certificateFilesService.delete((Object)entity);
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setStaffName(staffName);
            item.setUpdateDate(new Date());
            return d.insertSelective(item);
        });
    }

    public List<CertificateStaffDetail> getListByParam(Long staffId, Long cid, Long reportId) {
        if (staffId == null || cid == null || reportId == null) {
            return null;
        }
        Example example = new Example(CertificateStaffDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("cid", (Object)cid).andEqualTo("reportId", (Object)reportId);
        return this.getListByExample(example);
    }

    public List<CertificateStaffDetail> getManagePrincipalCert(Long cid) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(CertificateStaffDetail.class);
        List<Long> certIds = Arrays.asList(12L, 13L);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andIn("status", Arrays.asList(ApprovalStatusEnum.PASSED.getValue(), ApprovalStatusEnum.NONEEDAPPROVAL.getValue())).andCondition("validity_date>=", (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd")).andIn("certId", certIds);
        return this.getListByExample(example);
    }

    public Map<Long, CertificateStaffDetail> getCertificateMapByCid(List<Long> cidList, Integer type) {
        Map<Long, Object> map = new HashMap<Long, CertificateStaffDetail>();
        if (CollectionUtils.isEmpty(cidList)) {
            return map;
        }
        List<CertificateStaffDetail> list = ((CertificateStaffDetailMapper)this.dao).getCertificateListByCid(cidList, type);
        map = list.stream().collect(Collectors.toMap(CertificateStaffDetail::getCid, Function.identity(), (c1, c2) -> c1.getValidityDate().compareTo(c2.getValidityDate()) > 0 ? c1 : c2));
        return map;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long submitApproval(Company currentCompany, StaffInfo staffInfo, CertificateStaffDetail record) {
        Long keyFactoryId = null;
        if (Objects.equals(ApprovalStatusEnum.WAITAPPROVAL.getValue(), record.getStatus())) {
            keyFactoryId = this.keyFactoryService.submitKeyFactory(currentCompany, staffInfo.getId(), record.getId(), KeyFactoryTypeEnum.TRAIN);
            this.keyFactoryApprovalHistoryService.addNewRecord(currentCompany, staffInfo, record.getId(), KeyFactoryTypeEnum.TRAIN);
            if (record.getCertId().intValue() == 12) {
                this.reformItemBasicService.changeStatusByCidAndGenerationSource(currentCompany.getId(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformStatusEnum.DYS.getValue(), staffInfo.getId(), record.getId());
            } else {
                this.reformItemBasicService.changeStatusByCidAndGenerationSource(currentCompany.getId(), ReformGenerationSourceEnum.NOGLRY.getValue(), ReformStatusEnum.DYS.getValue(), staffInfo.getId(), record.getId());
            }
        }
        return keyFactoryId;
    }

    @Transactional(rollbackFor={Exception.class})
    public int approval(KeyFactory keyFactory, Byte status) {
        Byte generationSource = null;
        int i = ((CertificateStaffDetailMapper)this.dao).approval(keyFactory, status, ApprovalStatusEnum.WAITAPPROVAL.getValue());
        if (keyFactory != null && keyFactory.getBusinessId() != null) {
            CertificateStaffDetail detail = (CertificateStaffDetail)this.getById(keyFactory.getBusinessId());
            if (detail == null) {
                throw new ServiceException("\u5173\u952e\u56e0\u7d20\u753b\u50cf\u91cc\u9762\u7684\u57f9\u8badid\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            }
            if (Objects.equals(detail.getCertId(), 12L)) {
                generationSource = ReformGenerationSourceEnum.NOZYFZR.getValue();
            } else if (Objects.equals(detail.getCertId(), 13L)) {
                generationSource = ReformGenerationSourceEnum.NOGLRY.getValue();
            }
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(keyFactory.getCid(), generationSource, null, keyFactory.getUpdateBy(), keyFactory.getBusinessId());
        }
        return i;
    }

    @Transactional
    public Pair<String, Long> setTermination(CertificateStaffDetail csd, Long loginStaffId, Company currentCompany) {
        boolean refund;
        if (csd == null || csd.getId() == null) {
            return new Pair((Object)"\u6ca1\u6709\u4f20\u53c2id", null);
        }
        CertificateStaffDetail staffDetail = (CertificateStaffDetail)this.getById(csd.getId());
        boolean bl = refund = staffDetail != null && ApprovalStatusEnum.REFUND.getValue().equals(staffDetail.getStatus());
        if (refund) {
            staffDetail.setStatus(ApprovalStatusEnum.TERMINATED.getValue());
            this.updateByPrimaryKey(staffDetail, loginStaffId);
            KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(staffDetail.getId());
            keyFactory.setStatus(KeyFactoryStatusEnum.CLOSED.getCode());
            this.keyFactoryService.updateByPrimaryKey((Object)keyFactory, loginStaffId);
            KeyFactoryApprovalHistory history = new KeyFactoryApprovalHistory();
            history.setCid(staffDetail.getCid());
            history.setOperatorCompanyName(currentCompany.getName());
            history.setOperator(currentCompany.getName());
            history.setBusinessId(staffDetail.getId());
            history.setUpdateBy(loginStaffId);
            history.setCreateBy(loginStaffId);
            history.setType(KeyFactoryTypeEnum.TRAIN.getCode());
            history.setStatus(HistoryStatusEnum.CLOSED.getCode());
            this.historyService.addRecord(Collections.singletonList(history));
            return new Pair((Object)"\u6210\u529f", (Object)keyFactory.getId());
        }
        return new Pair((Object)"\u975e\u9000\u56de\u72b6\u6001", null);
    }

    @Transactional(readOnly=false)
    public void saveBatch(List<CertificateStaffDetail> details) {
        if (!CollUtil.isEmpty(details)) {
            List sourceIds = details.stream().map(CertificateStaffDetail::getSourceId).collect(Collectors.toList());
            Example example = new Example(CertificateStaffDetail.class);
            example.createCriteria().andIn("sourceId", sourceIds).andEqualTo("isValid", (Object)true);
            List dbList = this.getListByExample(example);
            ArrayList updateList = new ArrayList();
            ArrayList insertList = new ArrayList();
            details.forEach(item -> {
                CertificateStaffDetail detail = dbList.stream().filter(d -> d.getSourceId().equalsIgnoreCase(item.getSourceId())).findFirst().orElse(null);
                if (Objects.nonNull(detail)) {
                    item.setId(detail.getId());
                    updateList.add(item);
                } else {
                    insertList.add(item);
                }
            });
            if (CollectionUtils.isNotEmpty(insertList)) {
                ((CertificateStaffDetailMapper)this.dao).insertList2(insertList);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.batchUpdateOrInsert(updateList, CertificateStaffDetailMapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
                List certIds = dbList.stream().map(CertificateStaffDetail::getId).collect(Collectors.toList());
                this.certificateFilesService.deleteByCerIds(certIds);
            }
            List result = Stream.of(insertList, updateList).flatMap(Collection::stream).collect(Collectors.toList());
            List files = result.stream().map(d -> {
                CertificateFiles file = new CertificateFiles();
                file.setId(Long.valueOf(this.idworker.nextId()));
                file.setCid(d.getCid());
                file.setCerId(d.getCreateBy());
                file.setFileId(null);
                file.setCerId(d.getId());
                file.setFileUrl(d.getCertDownloadUrl());
                file.setCreateDate(new Date());
                file.setUpdateDate(new Date());
                file.setCreateBy(Long.valueOf(0L));
                file.setUpdateBy(Long.valueOf(0L));
                file.setIsValid(Boolean.valueOf(true));
                return file;
            }).collect(Collectors.toList());
            this.certificateFilesService.insertList(files);
        }
    }

    public List<CertificateStaffDetail> getLastUpdate(Long cidParam, Date updateDate) {
        if (updateDate == null) {
            updateDate = DateUtils.getStartTime((Date)DateUtils.addDay((Date)new Date(), (int)-1));
        }
        return ((CertificateStaffDetailMapper)this.dao).getLastUpdate(cidParam, updateDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceId(Long cid) {
        int pageNum = 1;
        int pageSize = 10000;
        List<CertificateStaffDetail> nullSourceIdList = ((CertificateStaffDetailMapper)this.dao).getNullSourceIdList(cid, (pageNum - 1) * pageSize, pageSize);
        while (CollectionUtils.isNotEmpty(nullSourceIdList)) {
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                List certNos = nullSourceIdList.stream().map(CertificateStaffDetail::getCertNo).collect(Collectors.toList());
                List wandaTrainData = this.wandaTrainDataService.listByCertNum(certNos);
                Map<String, List<WandaTrainData>> wandaMap = wandaTrainData.stream().collect(Collectors.groupingBy(WandaTrainData::getCertNum));
                nullSourceIdList.forEach(item -> {
                    List wandaTrainDataList = (List)wandaMap.get(item.getCertNo());
                    if (CollectionUtils.isNotEmpty((Collection)wandaTrainDataList)) {
                        item.setSourceId(((WandaTrainData)wandaTrainDataList.get(0)).getSourceId());
                    }
                });
                this.batchUpdateOrInsert(nullSourceIdList, CertificateStaffDetailMapper.class, (item, mapper) -> mapper.updateSourceId((CertificateStaffDetail)item));
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                this.logger.info("\u4e07\u8fbe\u4ed3\u57f9\u8bad\u6570\u636e\u63d2\u5165sourceId\u5931\u8d25");
                ++pageNum;
                this.transactionManager.rollback(status);
            }
            finally {
                nullSourceIdList.clear();
            }
        }
    }

    public HomeEnergyEfficiencyVo getCertificateRate(HomeIndexSearchVo searchVo, HomeEnergyEfficiencyVo efficiencyVo) {
        List<HomeEnergyEfficiencyVo> list = ((CertificateStaffDetailMapper)this.dao).getCertificateCountNumByCity(searchVo);
        if (CollectionUtils.isEmpty(list)) {
            return efficiencyVo;
        }
        int score = list.size();
        int rank = 1;
        int flag = 1;
        double previous = 1000.0;
        for (HomeEnergyEfficiencyVo item : list) {
            if (item == null) continue;
            if (previous > item.getRate()) {
                rank = flag;
                score = list.size() - flag + 1;
            }
            if (searchVo.getChooseAreaId().equals(item.getAreaId())) {
                efficiencyVo.setRate3(String.valueOf(item.getRate()));
                efficiencyVo.setRank3(Integer.valueOf(rank));
                efficiencyVo.setScore3(String.valueOf(score));
                break;
            }
            previous = item.getRate();
            ++flag;
        }
        return efficiencyVo;
    }

    public List<CertificateStaffDetail> selectAutoData(Long cid) {
        return ((CertificateStaffDetailMapper)this.dao).selectAutoData(cid);
    }

    public List<CertificateStaffCountVo> countCertByCids(List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return null;
        }
        return ((CertificateStaffDetailMapper)this.dao).countCertByCids(cids, null);
    }

    public List<CertificateStaffCountVo> countCertByCids(List<Long> cids, Date validityDate) {
        if (cids == null || cids.size() == 0) {
            return null;
        }
        return ((CertificateStaffDetailMapper)this.dao).countCertByCids(cids, validityDate);
    }

    public String checkCertStaffName(String ids) {
        HashSet<String> staffNameSet = new HashSet<String>();
        HashMap<Long, String> idNameMap = new HashMap<Long, String>();
        String name = null;
        for (String idStr : ids.split(",")) {
            Long id = Long.valueOf(idStr);
            Example example = new Example(CertificateStaffDetail.class);
            example.createCriteria().andEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
            CertificateStaffDetail certificateStaffDetail = (CertificateStaffDetail)((CertificateStaffDetailMapper)this.dao).selectOneByExample(example);
            if (certificateStaffDetail == null) continue;
            String staffName = certificateStaffDetail.getStaffName();
            staffNameSet.add(staffName);
            idNameMap.put(id, staffName);
            name = staffName;
        }
        if (staffNameSet.size() <= 1) {
            return name;
        }
        throw new HealthException("\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5bf9\u5e94\u8bc1\u660e\u4eba\u59d3\u540d\u662f\u5426\u4e00\u81f4");
    }
}

