/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.work.certificate.CertificateNameMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateName;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateNameService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.CertificateSummaryVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CertificateNameServiceImpl
extends BaseServiceImpl<CertificateNameMapper, CertificateName>
implements ICertificateNameService {
    @Autowired
    CertificateNameMapper certificateNameMapper;
    @Autowired
    private ICertificateStaffService certificateStaffService;
    @Autowired
    private ICertificateCompanyService certificateCompanyService;
    @Autowired
    private ICertificateDeviceDetailService certificateDeviceService;

    public PageInfo<CertificateName> getCertNameList(CertificateName info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CertificateName> list = this.certificateNameMapper.getByParam(info);
        for (CertificateName cert : list) {
            cert.setCreateName(SpringEncryptUtils.decrypt((String)cert.getCreateName()));
            cert.setUpdateName(SpringEncryptUtils.decrypt((String)cert.getUpdateName()));
            if (cert.getCid() == null) {
                cert.setShowStr("\u2014\u2014");
                cert.setUpdateName("\u7cfb\u7edf");
                continue;
            }
            String viewButt = "<a class='ui-pg-div' href='javascript:editName(\"" + cert.getId() + "\")' rel=''  data-rel='tooltip' data-original-title='\u7f16\u8f91' ><i class='ui-icon icon-ui-icon icon-ui-icon icon-edit blue'></i></a>";
            String delButt = "<a class='ui-pg-div' href='javascript:doDelName(\"" + cert.getId() + "\")' rel=''  data-rel='tooltip' data-original-title='\u5220\u9664' ><i class='ui-icon icon-trash red'></i></a>";
            cert.setShowStr(viewButt + delButt);
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Transactional(readOnly=false)
    public void updateWithHistory(CertificateName info, Long staffid) {
        this.update(info);
    }

    @Transactional(readOnly=false)
    public CertificateName addWithHistory(CertificateName info, Long staffid, Long cid) {
        info = this.add(info, staffid, cid);
        return info;
    }

    public List<CertificateName> getListByType(CertificateName info) {
        List<CertificateName> list = this.certificateNameMapper.getByParam(info);
        if (info.getNameType() == 1) {
            for (CertificateName name : list) {
                Boolean haveName = this.certificateCompanyService.haveThisName(name.getId(), info.getCid());
                name.setIsHave(haveName);
                name.setCreateName(SpringEncryptUtils.decrypt((String)name.getCreateName()));
                name.setUpdateName(SpringEncryptUtils.decrypt((String)name.getUpdateName()));
            }
        } else if (info.getNameType() == 2) {
            for (CertificateName name : list) {
                Boolean haveName = this.certificateStaffService.haveThisName(name.getId(), info.getCid());
                name.setIsHave(haveName);
                name.setCreateName(SpringEncryptUtils.decrypt((String)name.getCreateName()));
                name.setUpdateName(SpringEncryptUtils.decrypt((String)name.getUpdateName()));
            }
        } else if (info.getNameType() == 3) {
            for (CertificateName name : list) {
                Boolean haveName = this.certificateDeviceService.haveThisName(name.getId(), info.getCid(), info.getCertId());
                name.setIsHave(haveName);
                name.setCreateName(SpringEncryptUtils.decrypt((String)name.getCreateName()));
                name.setUpdateName(SpringEncryptUtils.decrypt((String)name.getUpdateName()));
            }
        } else {
            list.forEach(l -> {
                l.setCreateName(SpringEncryptUtils.decrypt((String)l.getCreateName()));
                l.setUpdateName(SpringEncryptUtils.decrypt((String)l.getUpdateName()));
            });
        }
        return list;
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        CertificateSummaryVo vo = new CertificateSummaryVo();
        vo.setCompManagerCertInfo(this.certificateStaffService.certStaffSummaryInfo(cid, Long.valueOf(12L), null));
        vo.setHseManagerCertInfo(this.certificateStaffService.certStaffSummaryInfo(cid, Long.valueOf(13L), null));
        Integer total = vo.getCompManagerCertInfo().getTotalNum() + vo.getHseManagerCertInfo().getTotalNum();
        vo.setTotalCert(total);
        return vo;
    }

    public Boolean haveThisName(String name, Long cid, Byte nameType) {
        CertificateName info = new CertificateName();
        info.setName(name);
        info.setCid(cid);
        info.setNameType(nameType);
        List<CertificateName> list = this.certificateNameMapper.getByName(info);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void delWithHis(CertificateName info, Long staffid, Long cid) {
        this.update(info, staffid);
    }

    public List<CertificateName> getAllCustom() {
        Example example = new Example(CertificateName.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIsNotNull("cid");
        return ((CertificateNameMapper)this.dao).selectByExample(example);
    }
}

