/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.certificate.CertificateFilesMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CertificateFilesServiceImpl
extends BaseServiceImpl<CertificateFilesMapper, CertificateFiles>
implements ICertificateFilesService {
    @Autowired
    CertificateFilesMapper certificateFilesMapper;
    @DubboReference
    private ISysFileProvideService sysFileService;

    public void deleteByCerId(Long cerId) {
        this.certificateFilesMapper.deleteByCerId(cerId);
    }

    public List<CertificateFiles> getByCerid(Long id) {
        if (id == null) {
            return Collections.emptyList();
        }
        CertificateFiles record = new CertificateFiles();
        record.setCerId(id);
        List files = this.certificateFilesMapper.select(record);
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            files.stream().filter(s -> s.getFileId() != null && StringUtils.isEmpty((CharSequence)s.getFileUrl()) && StringUtils.isEmpty((CharSequence)s.getFileName())).forEach(s -> {
                SysFileModel file = this.sysFileService.getFileById(s.getFileId());
                if (file != null) {
                    s.setFileUrl(file.getOssUrl());
                    s.setFileName(file.getFileName());
                }
            });
        }
        return files;
    }

    public List<CertificateFiles> getByCertIdList(List<Long> certIdList) {
        if (CollUtil.isEmpty(certIdList)) {
            return Collections.emptyList();
        }
        List<CertificateFiles> certFileList = this.certificateFilesMapper.selectByCertIdList(certIdList);
        if (CollUtil.isEmpty(certFileList)) {
            return Collections.emptyList();
        }
        List<Long> needFileInfoIdList = certFileList.stream().filter(f -> f.getFileId() != null && (StrUtil.isBlank((CharSequence)f.getFileUrl()) || StrUtil.isBlank((CharSequence)f.getFileName()))).map(CertificateFiles::getFileId).toList();
        if (CollUtil.isNotEmpty(needFileInfoIdList)) {
            Map sysFileMap = this.sysFileService.getListByIds(needFileInfoIdList).stream().collect(Collectors.toMap(SysFileModel::getId, Function.identity(), (v1, v2) -> v2));
            certFileList.forEach(f -> {
                if (f.getFileId() != null && (StrUtil.isBlank((CharSequence)f.getFileUrl()) || StrUtil.isBlank((CharSequence)f.getFileName()))) {
                    Optional.ofNullable((SysFileModel)sysFileMap.get(f.getFileId())).ifPresent(file -> {
                        f.setFileUrl(file.getOssUrl());
                        f.setFileName(file.getFileName());
                    });
                }
            });
        }
        return certFileList;
    }

    @Transactional(readOnly=false)
    public void insertList(List<CertificateFiles> files) {
        if (CollectionUtils.isNotEmpty(files)) {
            ((CertificateFilesMapper)this.dao).insertList2(files);
        }
    }

    @Transactional(readOnly=false)
    public void deleteByCerIds(List<Long> certIds) {
        if (CollectionUtils.isNotEmpty(certIds)) {
            ((CertificateFilesMapper)this.dao).deleteByCerIds(certIds);
        }
    }

    public CertificateFiles getCertificateFileByModel(CertificateFiles cfModel) {
        if (cfModel == null) {
            return null;
        }
        return ((CertificateFilesMapper)this.dao).getCertificateFileByModel(cfModel);
    }
}

