/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.dao.work.certificate.CertificateDeviceMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDevice;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDeviceDetail;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CertificateDeviceServiceImpl
extends BaseServiceImpl<CertificateDeviceMapper, CertificateDevice>
implements ICertificateDeviceService {
    @Autowired
    CertificateDeviceMapper certificateDeviceMapper;
    @Autowired
    private ICertificateDeviceDetailService certificateDeviceDetailService;

    public PageInfo<CertificateDevice> getCertficateList(CertificateDevice info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("certificate", "certificate_device");
        List<CertificateDevice> list = this.certificateDeviceMapper.getByParam(info);
        for (CertificateDevice cert : list) {
            List certlist = this.certificateDeviceDetailService.getCertListByCertId(cert.getId());
            if (certlist == null) continue;
            Object certName = null;
            for (CertificateDeviceDetail deviceCert : certlist) {
                if (certName == null) {
                    certName = deviceCert.getName();
                    continue;
                }
                certName = (String)certName + "," + deviceCert.getName();
            }
            cert.setCertStr(certName);
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public List<CertificateDevice> getExportListByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        CertificateDevice device = new CertificateDevice();
        device.setCid(cid);
        int serialNum = 1;
        List<CertificateDevice> list = this.certificateDeviceMapper.getByParam(device);
        for (CertificateDevice cert : list) {
            cert.setSerialNum(Integer.valueOf(serialNum));
            ++serialNum;
            List certlist = this.certificateDeviceDetailService.getCertListByCertId(cert.getId());
            if (certlist == null) continue;
            Object certName = null;
            for (CertificateDeviceDetail deviceCert : certlist) {
                if (certName == null) {
                    certName = deviceCert.getName();
                    continue;
                }
                certName = (String)certName + "," + deviceCert.getName();
            }
            cert.setCertStr(certName);
        }
        return list;
    }

    public int getNumOfDeviceCertByCid(Long cid) {
        CertificateDevice info = new CertificateDevice();
        info.setCid(cid);
        List<CertificateDevice> list = this.certificateDeviceMapper.getByParam(info);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public void updateWithHistory(CertificateDevice record, Long staffid) {
        this.update(record, staffid);
    }

    @Transactional(readOnly=false)
    public CertificateDevice addWithHistory(CertificateDevice record, Long staffid, Long cid) {
        record = this.add(record, staffid, cid);
        return record;
    }

    public Boolean haveThisDevice(Long id, Long deviceId, Long cid) {
        CertificateDevice entity;
        CertificateDevice info = new CertificateDevice();
        if (id != null && (entity = (CertificateDevice)this.certificateDeviceMapper.selectByPrimaryKey(id)).getDeviceId() != null) {
            return false;
        }
        info.setCid(cid);
        info.setDeviceId(deviceId);
        info.setIsValid(Boolean.valueOf(true));
        List list = this.certificateDeviceMapper.select(info);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void delWithHis(CertificateDevice info, Long staffid, Long cid) {
        this.update(info, staffid);
        this.certificateDeviceDetailService.delByCertId(info.getId(), staffid);
    }
}

