/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.certificate.CertificateDeviceDetailMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDeviceDetail;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.enums.certificate.CertificateRepeatNoteEnum;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.vo.summary.CertificateNumSummVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CertificateDeviceDetailServiceImpl
extends BaseServiceImpl<CertificateDeviceDetailMapper, CertificateDeviceDetail>
implements ICertificateDeviceDetailService {
    @Autowired
    CertificateDeviceDetailMapper certificateDeviceDetailMapper;
    @Autowired
    ICertificateFilesService certificateFilesService;
    @Autowired
    OssClientBean ossClientBean;

    public List<CertificateDeviceDetail> getCertListByCertId(Long id) {
        if (id == null) {
            return null;
        }
        CertificateDeviceDetail record = new CertificateDeviceDetail();
        record.setCertId(id);
        record.setIsValid(Boolean.valueOf(true));
        List list = this.certificateDeviceDetailMapper.select(record);
        if (list != null && list.size() > 0) {
            for (CertificateDeviceDetail cert : list) {
                List files = this.certificateFilesService.getByCerid(cert.getId());
                cert.setFiles(files);
            }
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void addCertDeviceDetail(CertificateDeviceDetail record, Long staffid, Long cid) {
        List fileList = record.getFiles();
        if (record.getRepeatNote() != null) {
            record.setInformPeriod(this.getReminderDays(record.getRepeatNote()));
        }
        this.add(record, staffid, cid);
        if (fileList != null && fileList.size() != 0) {
            for (CertificateFiles file : fileList) {
                file.setCerId(record.getId());
                file.setId(null);
                this.certificateFilesService.add((Object)file, staffid, cid);
            }
        }
    }

    @Transactional(readOnly=false)
    public void updateCertDeviceDetail(CertificateDeviceDetail record, Long staffid, Long cid) {
        List fileList = record.getFiles();
        if (record.getRepeatNote() != null) {
            record.setInformPeriod(this.getReminderDays(record.getRepeatNote()));
        }
        this.update(record, staffid);
        CertificateFiles entity = new CertificateFiles();
        entity.setCerId(record.getId());
        this.certificateFilesService.delete((Object)entity);
        if (fileList != null && fileList.size() != 0) {
            for (CertificateFiles file : fileList) {
                file.setCerId(record.getId());
                file.setId(null);
                this.certificateFilesService.add((Object)file, staffid, record.getCid());
            }
        }
    }

    public int daysBetween(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            if (year1 < year2) {
                for (int i = year1; i < year2; ++i) {
                    if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                        timeDistance += 366;
                        continue;
                    }
                    timeDistance += 365;
                }
            } else {
                for (int i = year2; i < year1; ++i) {
                    if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                        timeDistance -= 366;
                        continue;
                    }
                    timeDistance -= 365;
                }
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public Integer getReminderDays(Byte remindType) {
        if (remindType != null) {
            if (remindType.equals(CertificateRepeatNoteEnum.Fifteen.getValue())) {
                return CertificateRepeatNoteEnum.Fifteen.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Thirty.getValue())) {
                return CertificateRepeatNoteEnum.Thirty.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Sixty.getValue())) {
                return CertificateRepeatNoteEnum.Sixty.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Ninety.getValue())) {
                return CertificateRepeatNoteEnum.Ninety.getDays();
            }
            return null;
        }
        return null;
    }

    public CertificateDeviceDetail getByIdWithAll(Long id) {
        CertificateDeviceDetail info = (CertificateDeviceDetail)this.getById(id);
        List files = this.certificateFilesService.getByCerid(id);
        info.setFiles(files);
        return info;
    }

    public PageInfo<CertificateDeviceDetail> getExpireCertficateList(CertificateDeviceDetail info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CertificateDeviceDetail> list = this.certificateDeviceDetailMapper.getExpireCertficateList(info);
        for (CertificateDeviceDetail cert : list) {
            int effday = 0;
            if (cert.getRepeatData() != null) {
                effday = this.daysBetween(new Date(), cert.getRepeatData());
            }
            if (cert.getValidityDate() != null) {
                int day2 = this.daysBetween(new Date(), cert.getValidityDate());
                if (effday == 0 || effday > day2) {
                    effday = day2;
                }
            }
            cert.setEffectiveDays(effday + "\u5929");
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public Integer getExpireCertficateNum(Long cid) {
        if (cid == null) {
            return 0;
        }
        CertificateDeviceDetail info = new CertificateDeviceDetail();
        info.setCid(cid);
        List<CertificateDeviceDetail> list = this.certificateDeviceDetailMapper.getExpireCertficateList(info);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public void delByCertId(Long id, Long staffid) {
        CertificateDeviceDetail record = new CertificateDeviceDetail();
        record.setCertId(id);
        record.setIsValid(Boolean.valueOf(true));
        List list = this.certificateDeviceDetailMapper.select(record);
        if (list != null && list.size() > 0) {
            for (CertificateDeviceDetail info : list) {
                info.setIsValid(Boolean.valueOf(false));
                this.update(info, staffid);
            }
        }
    }

    public PageInfo<CertificateDeviceDetail> getCertListByDeviceId(Long deviceId, JqGridParam param) {
        if (param.getCid() == null || deviceId == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", param.getCid());
        params.put("deviceId", deviceId);
        List<CertificateDeviceDetail> list = this.certificateDeviceDetailMapper.getCertListByDeviceId(params);
        if (list != null) {
            for (CertificateDeviceDetail cert : list) {
                List files = this.certificateFilesService.getByCerid(cert.getId());
                cert.setFiles(files);
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public CertificateNumSummVo certDeviceSummaryInfo(Long cid, Long nameId) {
        CertificateDeviceDetail record = new CertificateDeviceDetail();
        record.setCid(cid);
        record.setIsValid(Boolean.valueOf(true));
        record.setNameId(nameId);
        List list = this.certificateDeviceDetailMapper.select(record);
        CertificateNumSummVo certSummaryInfo = new CertificateNumSummVo();
        Date thisDay = new Date();
        if (list != null && list.size() > 0) {
            int effectiveNum = 0;
            int reviewNum = 0;
            int overdueNum = 0;
            certSummaryInfo.setTotalNum(Integer.valueOf(list.size()));
            for (CertificateDeviceDetail cert : list) {
                if (cert.getValidityDate() != null) {
                    if (thisDay.before(cert.getValidityDate())) {
                        if (cert.getRepeatData() != null) {
                            if (thisDay.before(cert.getRepeatData())) {
                                ++effectiveNum;
                                continue;
                            }
                            ++reviewNum;
                            continue;
                        }
                        ++effectiveNum;
                        continue;
                    }
                    ++overdueNum;
                    continue;
                }
                if (cert.getRepeatData() != null) {
                    if (thisDay.before(cert.getRepeatData())) {
                        ++effectiveNum;
                        continue;
                    }
                    ++reviewNum;
                    continue;
                }
                ++effectiveNum;
            }
            certSummaryInfo.setEffectiveNum(Integer.valueOf(effectiveNum));
            certSummaryInfo.setOverdueNum(Integer.valueOf(overdueNum));
            certSummaryInfo.setReviewNum(Integer.valueOf(reviewNum));
        }
        return certSummaryInfo;
    }

    public Boolean haveThisName(Long nameId, Long cid, Long certId) {
        CertificateDeviceDetail info = new CertificateDeviceDetail();
        info.setCertId(certId);
        info.setNameId(nameId);
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        List list = this.certificateDeviceDetailMapper.select(info);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void delWithHis(CertificateDeviceDetail info, Long staffid, Long cid) {
        this.update(info, staffid);
    }
}

