/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.certificate;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.modules.health.dao.work.certificate.CertificateCompanyMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateCompany;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.enums.certificate.CertificateRepeatNoteEnum;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.vo.summary.CertificateNumSummVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CertificateCompanyServiceImpl
extends BaseServiceImpl<CertificateCompanyMapper, CertificateCompany>
implements ICertificateCompanyService {
    @Autowired
    CertificateCompanyMapper certificateCompanyMapper;
    @Autowired
    ICertificateFilesService certificateFilesService;
    @Autowired
    OssClientBean ossClientBean;

    public PageInfo<CertificateCompany> getCertficateList(CertificateCompany info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("certificate", "certificate_company");
        List<CertificateCompany> list = this.certificateCompanyMapper.getByParam(info);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Transactional(readOnly=false)
    public void updateCertComp(CertificateCompany record, Long staffid) {
        List fileList = record.getFiles();
        if (record.getRepeatNote() != null) {
            record.setInformPeriod(this.getReminderDays(record.getRepeatNote()));
        }
        this.update(record, staffid);
        CertificateFiles entity = new CertificateFiles();
        entity.setCerId(record.getId());
        this.certificateFilesService.delete((Object)entity);
        if (fileList != null && fileList.size() != 0) {
            for (CertificateFiles file : fileList) {
                file.setCerId(record.getId());
                this.certificateFilesService.add((Object)file, staffid, record.getCid());
            }
        }
    }

    @Transactional(readOnly=false)
    public void addCertComp(CertificateCompany record, Long staffid, Long cid) {
        List fileList = record.getFiles();
        if (record.getRepeatNote() != null) {
            record.setInformPeriod(this.getReminderDays(record.getRepeatNote()));
        }
        this.add(record, staffid, cid);
        if (fileList != null && fileList.size() != 0) {
            for (CertificateFiles file : fileList) {
                file.setCerId(record.getId());
                this.certificateFilesService.add((Object)file, staffid, cid);
            }
        }
    }

    public CertificateCompany getByIdWithFile(Long id) {
        CertificateCompany cert = (CertificateCompany)this.getById(id);
        List files = this.certificateFilesService.getByCerid(id);
        cert.setFiles(files);
        return cert;
    }

    public List<CertificateCompany> getExportListByCid(Long cid) {
        CertificateCompany info = new CertificateCompany();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        List<CertificateCompany> list = this.certificateCompanyMapper.getByParam(info);
        int serialNum = 1;
        for (CertificateCompany cert : list) {
            cert.setSerialNum(Integer.valueOf(serialNum));
            ++serialNum;
            Object filename = null;
            List files = this.certificateFilesService.getByCerid(cert.getId());
            if (files == null || files.size() == 0) continue;
            for (CertificateFiles file : files) {
                if (filename == null) {
                    filename = file.getFileName();
                    continue;
                }
                filename = (String)filename + "," + file.getFileName();
            }
            cert.setFileNames(filename);
        }
        return list;
    }

    public PageInfo<CertificateCompany> getExpireCertficateList(CertificateCompany info, JqGridParam param) {
        if (info.getCid() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CertificateCompany> list = this.certificateCompanyMapper.getExpireList(info);
        for (CertificateCompany cert : list) {
            int effday = 0;
            if (cert.getRepeatData() != null) {
                effday = this.daysBetween(new Date(), cert.getRepeatData());
            }
            if (cert.getValidityDate() != null) {
                int day2 = this.daysBetween(new Date(), cert.getValidityDate());
                if (effday == 0 || effday > day2) {
                    effday = day2;
                }
            }
            cert.setEffectiveDays(effday + "\u5929");
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public Integer getExpireCertficateNum(Long cid) {
        if (cid == null) {
            return 0;
        }
        CertificateCompany info = new CertificateCompany();
        info.setCid(cid);
        List<CertificateCompany> list = this.certificateCompanyMapper.getExpireList(info);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public int daysBetween(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            if (year1 < year2) {
                for (int i = year1; i < year2; ++i) {
                    if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                        timeDistance += 366;
                        continue;
                    }
                    timeDistance += 365;
                }
            } else {
                for (int i = year2; i < year1; ++i) {
                    if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                        timeDistance -= 366;
                        continue;
                    }
                    timeDistance -= 365;
                }
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public Integer getReminderDays(Byte remindType) {
        if (remindType != null) {
            if (remindType.equals(CertificateRepeatNoteEnum.Fifteen.getValue())) {
                return CertificateRepeatNoteEnum.Fifteen.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Thirty.getValue())) {
                return CertificateRepeatNoteEnum.Thirty.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Sixty.getValue())) {
                return CertificateRepeatNoteEnum.Sixty.getDays();
            }
            if (remindType.equals(CertificateRepeatNoteEnum.Ninety.getValue())) {
                return CertificateRepeatNoteEnum.Ninety.getDays();
            }
            return null;
        }
        return null;
    }

    public CertificateCompany getBusinessLicenseByCid(Long cid) {
        CertificateCompany record = new CertificateCompany();
        record.setCid(cid);
        record.setName("\u8425\u4e1a\u6267\u7167");
        record.setIsValid(Boolean.valueOf(true));
        List list = this.certificateCompanyMapper.select(record);
        CertificateCompany info = new CertificateCompany();
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                info = (CertificateCompany)list.get(0);
            } else {
                info = (CertificateCompany)list.get(0);
                if (info.getValidityDate() == null) {
                    List files = this.certificateFilesService.getByCerid(info.getId());
                    info.setFiles(files);
                    return info;
                }
                for (CertificateCompany cert : list) {
                    if (cert.getValidityDate() == null) {
                        info = cert;
                        break;
                    }
                    if (!cert.getValidityDate().after(info.getValidityDate())) continue;
                    info = cert;
                }
            }
            List files = this.certificateFilesService.getByCerid(info.getId());
            info.setFiles(files);
            return info;
        }
        return null;
    }

    public CertificateNumSummVo getCertStaffSummaryInfo(Long cid) {
        CertificateNumSummVo certSummaryInfo = new CertificateNumSummVo();
        CertificateCompany info = new CertificateCompany();
        info.setCid(cid);
        info.setIsValid(Boolean.valueOf(true));
        List<CertificateCompany> list = this.certificateCompanyMapper.getByParam(info);
        Date thisDay = new Date();
        if (list != null && list.size() > 0) {
            int effectiveNum = 0;
            int reviewNum = 0;
            int overdueNum = 0;
            certSummaryInfo.setTotalNum(Integer.valueOf(list.size()));
            for (CertificateCompany cert : list) {
                if (cert.getValidityDate() != null) {
                    if (thisDay.before(cert.getValidityDate())) {
                        if (cert.getRepeatData() != null) {
                            if (thisDay.before(cert.getRepeatData())) {
                                ++effectiveNum;
                                continue;
                            }
                            ++reviewNum;
                            continue;
                        }
                        ++effectiveNum;
                        continue;
                    }
                    ++overdueNum;
                    continue;
                }
                if (cert.getRepeatData() != null) {
                    if (thisDay.before(cert.getRepeatData())) {
                        ++effectiveNum;
                        continue;
                    }
                    ++reviewNum;
                    continue;
                }
                ++effectiveNum;
            }
            certSummaryInfo.setEffectiveNum(Integer.valueOf(effectiveNum));
            certSummaryInfo.setOverdueNum(Integer.valueOf(overdueNum));
            certSummaryInfo.setReviewNum(Integer.valueOf(reviewNum));
        }
        return certSummaryInfo;
    }

    public int getCertficateNumByCid(Long cid) {
        CertificateCompany info = new CertificateCompany();
        info.setCid(cid);
        List<CertificateCompany> list = this.certificateCompanyMapper.getByParam(info);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public Boolean haveThisName(Long nameId, Long cid) {
        CertificateCompany info = new CertificateCompany();
        info.setIsValid(Boolean.valueOf(true));
        info.setNameId(nameId);
        info.setCid(cid);
        List list = this.certificateCompanyMapper.select(info);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void deleWithHis(CertificateCompany info, Long staffid, Long cid) {
        this.update(info, staffid);
    }
}

