/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.assign;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.dao.work.assign.RiskAssignMapper;
import cn.smarthse.modules.health.entity.work.assign.RiskAssign;
import cn.smarthse.modules.health.entity.work.assign.param.RiskAssignSearch;
import cn.smarthse.modules.health.entity.work.assign.push.ChuangdePushRiskData;
import cn.smarthse.modules.health.entity.work.assign.push.ChuangdeRiskArea;
import cn.smarthse.modules.health.entity.work.assign.push.ChuangdeRiskOrg;
import cn.smarthse.modules.health.entity.work.assign.push.PushResult;
import cn.smarthse.modules.health.entity.work.assign.push.res.ChuangdeResponseJson;
import cn.smarthse.modules.health.entity.work.assign.push.res.ChuangdeResponseObj;
import cn.smarthse.modules.health.entity.work.assign.vo.RiskAssignVO;
import cn.smarthse.modules.health.service.work.assign.IRiskAssignService;
import cn.smarthse.modules.health.supervise.service.company.ISuCompanyService;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.http.HttpsUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(rollbackFor={Exception.class})
public class RiskAssignServiceImpl
extends BaseServiceImpl<RiskAssignMapper, RiskAssign>
implements IRiskAssignService {
    @DubboReference
    private ISuCompanyService suCompanyService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Value(value="${risk.pro.pushUrl}")
    private String riskPushUrlPro;
    @Value(value="${risk.dev.pushUrl}")
    private String riskPushUrlTest;
    @Value(value="${sensitive_log_online_or_offline_env}")
    private String isDev;
    private String riskPushUrl;
    private String systemId;
    private String ruleId;
    private String highRiskRuleId = "030u11";
    private String lowRiskRuleId = "030u13";
    @Autowired
    protected IdWorker idworker;
    private String cacheKeyArea = "assign_area_list";
    private String cacheKeyOrg = "assign_org_list";
    private String title = "\u63a5\u5230\u4e0a\u7ea7\u4ea4\u529e\u6216\u901a\u62a5\u7684\u7ebf\u7d22";

    @PostConstruct
    public void init() {
        if ("dev".equalsIgnoreCase(this.isDev)) {
            this.riskPushUrl = this.riskPushUrlTest;
            this.systemId = "070007";
            this.ruleId = "020101";
        } else {
            this.riskPushUrl = this.riskPushUrlPro;
            this.systemId = "000030";
        }
    }

    public PageInfo<RiskAssignVO> getPageList(JqGridParam param, RiskAssignSearch search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskAssignVO> pageList = ((RiskAssignMapper)this.dao).getPageList(search);
        for (RiskAssignVO riskAssignVO : pageList) {
            riskAssignVO.setDealWorker(RiskAssignServiceImpl.maskMultipleNames(riskAssignVO.getDealWorker()));
        }
        return new PageInfo(pageList);
    }

    public PageInfo<RiskAssignVO> getRiskCompanyList(JqGridParam param, RiskAssignSearch search) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskAssignVO> pageList = ((RiskAssignMapper)this.dao).getRiskCompanyList(search);
        for (RiskAssignVO riskAssignVO : pageList) {
            riskAssignVO.setDealWorker(RiskAssignServiceImpl.maskMultipleNames(riskAssignVO.getDealWorker()));
        }
        return new PageInfo(pageList);
    }

    public static String maskMultipleNames(String names) {
        if (names == null || names.trim().isEmpty()) {
            return names;
        }
        CharSequence[] nameArray = names.split(",");
        for (int i = 0; i < nameArray.length; ++i) {
            nameArray[i] = DesensitizationUtils.name((String)nameArray[i]);
        }
        return String.join((CharSequence)",", nameArray);
    }

    public List<RiskAssignVO> getPendingList(RiskAssignSearch search) {
        return ((RiskAssignMapper)this.dao).getRiskCompanyList(search);
    }

    public RiskAssignVO getInfoByWorkId(Long workId) {
        return ((RiskAssignMapper)this.dao).getInfoByWorkId(workId);
    }

    public RiskAssignVO getPushCount(Long workId, Byte areaLevel, Long areaId) {
        return ((RiskAssignMapper)this.dao).getPushCount(workId, areaLevel, areaId);
    }

    public Long saveWork(RiskAssignSearch search, Long loginUserId) {
        if (search.getWorkId() == null) {
            RiskAssign riskAssign = new RiskAssign();
            riskAssign.setId(Long.valueOf(this.idworker.nextId()));
            riskAssign.setWorkId(Long.valueOf(this.idworker.nextId()));
            riskAssign.setType(search.getType());
            riskAssign.setAreaDetailId(search.getAreaId());
            this.setBaseFields(riskAssign, loginUserId);
            ((RiskAssignMapper)this.dao).insertSelective(riskAssign);
            return riskAssign.getWorkId();
        }
        String cids = search.getCids();
        if (StringUtils.isEmpty((CharSequence)cids)) {
            throw new RuntimeException("\u53c2\u6570cids\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<String> cidList = Arrays.asList(cids.split(","));
        ArrayList<RiskAssign> riskList = new ArrayList<RiskAssign>();
        RiskAssignVO riskAssignVO = ((RiskAssignMapper)this.dao).getInfoByWorkId(search.getWorkId());
        for (String cid : cidList) {
            RiskAssign risk = this.getRisk(riskAssignVO, Long.valueOf(cid));
            if (risk == null) continue;
            this.setBaseFields(risk, loginUserId);
            riskList.add(risk);
        }
        this.batchUpdateOrInsert(riskList, RiskAssignMapper.class, (s, mapper) -> mapper.insertSelective(s));
        return search.getWorkId();
    }

    public void batchInsert(List<RiskAssign> riskList, Long workId, Long loginUserId) {
        RiskAssignVO riskAssignVO = this.getInfoByWorkId(workId);
        riskList.forEach(e -> {
            e.setId(Long.valueOf(this.idworker.nextId()));
            e.setWorkId(workId);
            e.setTitle(riskAssignVO.getTitle());
            e.setType(riskAssignVO.getType());
            e.setWarningContent(riskAssignVO.getWarningContent());
            e.setFileId(riskAssignVO.getFileId());
            e.setFileName(riskAssignVO.getFileName());
            this.setBaseFields((RiskAssign)e, loginUserId);
        });
        this.batchUpdateOrInsert(riskList, RiskAssignMapper.class, (e, mapper) -> mapper.insertSelective(e));
    }

    public void removePendingList(RiskAssignSearch search) {
        List<Long> cidList = Arrays.stream(search.getCids().split(",")).map(Long::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(cidList)) {
            ((RiskAssignMapper)this.dao).removePendingList(search.getWorkId(), cidList);
        }
    }

    public Long deleteWork(Long workId) {
        ((RiskAssignMapper)this.dao).deleteWork(workId);
        return workId;
    }

    public List<ChuangdePushRiskData> saveWorkRisk(RiskAssign risk, Boolean isPush, Long loginUserId) {
        ((RiskAssignMapper)this.dao).saveWorkRisk(risk, loginUserId);
        ArrayList<ChuangdePushRiskData> failRiskList = new ArrayList<ChuangdePushRiskData>();
        if (isPush != null && isPush.booleanValue()) {
            Example example = new Example(RiskAssign.class);
            example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("workId", (Object)risk.getWorkId()).andEqualTo("pushStatus", (Object)0).andIsNotNull("cid");
            List riskList = ((RiskAssignMapper)this.dao).selectByExample(example);
            int total = riskList.size();
            int pushSize = 100;
            for (int i = 0; i < riskList.size(); i += pushSize) {
                List<RiskAssign> list = riskList.subList(i, Math.min(i + pushSize, riskList.size()));
                List<ChuangdePushRiskData> pushRiskData = this.pushRiskInfo(list, loginUserId);
                if (!CollectionUtils.isNotEmpty(pushRiskData)) continue;
                failRiskList.addAll(pushRiskData);
            }
            if (failRiskList.size() > 0 && failRiskList.size() != total) {
                example = new Example(RiskAssign.class);
                example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("workId", (Object)risk.getWorkId()).andIsNull("cid");
                List list = ((RiskAssignMapper)this.dao).selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    RiskAssign riskAssign = (RiskAssign)list.get(0);
                    riskAssign.setId(Long.valueOf(this.idworker.nextId()));
                    riskAssign.setWorkId(Long.valueOf(this.idworker.nextId()));
                    riskAssign.setPushStatus(Integer.valueOf(0));
                    riskAssign.setPushTime(null);
                    riskAssign.setDealTime(null);
                    riskAssign.setStatus(null);
                    riskAssign.setDealDeptName(null);
                    riskAssign.setDealWorker(null);
                    riskAssign.setDealResult(null);
                    riskAssign.setUpdateDate(new Date());
                    ((RiskAssignMapper)this.dao).insertSelective(riskAssign);
                    ((RiskAssignMapper)this.dao).updateWorkId(riskAssign.getWorkId(), failRiskList.stream().map(e -> Long.valueOf(e.getRiskMainpartId())).collect(Collectors.toList()));
                }
            }
        }
        return failRiskList;
    }

    public List<ChuangdePushRiskData> pushRiskInfo(List<RiskAssign> riskList, Long loginUserId) {
        Date date = new Date();
        List<ChuangdePushRiskData> dataList = this.convertPushData(riskList, date);
        ChuangdeResponseJson<ChuangdeResponseObj> result = this.pushData(dataList);
        ArrayList<Object> failRiskList = new ArrayList<ChuangdePushRiskData>();
        ArrayList<Object> successRiskList = new ArrayList<Object>();
        ArrayList<ChuangdePushRiskData> chuangdePushRiskDataList = new ArrayList<ChuangdePushRiskData>();
        if ("true".equalsIgnoreCase(result.getCode()) && CollectionUtils.isNotEmpty(dataList)) {
            List successList = result.getSuccessList();
            List failList = result.getFailList();
            if (successList.size() + failList.size() != dataList.size()) {
                throw new RuntimeException("\u90e8\u5206\u98ce\u9669\u63a8\u9001\u5931\u8d25\u3002");
            }
            if (CollectionUtils.isNotEmpty((Collection)failList)) {
                Map<String, ChuangdeResponseObj> failMap = failList.stream().collect(Collectors.toMap(ChuangdeResponseObj::getUniqueId, e -> e));
                for (ChuangdePushRiskData chuangdePushRiskData : dataList) {
                    ChuangdeResponseObj responseObj = failMap.get(chuangdePushRiskData.getUniqueId());
                    if (responseObj == null) continue;
                    if ("\u98ce\u9669\u7ebf\u7d22\u5df2\u4e0a\u62a5\u6210\u529f\u7981\u6b62\u66f4\u65b0\uff01".equals(responseObj.getMessage())) {
                        chuangdePushRiskData.setIsProc(Integer.valueOf(2));
                        chuangdePushRiskData.setUpdateDate(date);
                        chuangdePushRiskData.setErrorMessage(responseObj.getMessage());
                        successRiskList.add(chuangdePushRiskData);
                        continue;
                    }
                    chuangdePushRiskData.setIsProc(Integer.valueOf(3));
                    chuangdePushRiskData.setUpdateDate(date);
                    chuangdePushRiskData.setErrorMessage(responseObj.getMessage());
                    failRiskList.add(chuangdePushRiskData);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)successList)) {
                List uniqueIdList = successList.stream().map(ChuangdeResponseObj::getUniqueId).collect(Collectors.toList());
                List collect = dataList.stream().filter(e -> {
                    if (uniqueIdList.contains(e.getUniqueId())) {
                        e.setIsProc(Integer.valueOf(2));
                        e.setUpdateDate(date);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                successRiskList.addAll(collect);
            }
            if (successRiskList.size() > 0) {
                List<Long> successIds = successRiskList.stream().map(e -> Long.valueOf(e.getRiskMainpartId())).collect(Collectors.toList());
                Long workId = ((RiskAssignMapper)this.dao).getWorkIdByIds(successIds);
                ((RiskAssignMapper)this.dao).updatePushStatus(workId, successIds, loginUserId);
            }
            if (successRiskList.size() > 0) {
                chuangdePushRiskDataList.addAll(successRiskList);
            }
            if (failRiskList.size() > 0) {
                chuangdePushRiskDataList.addAll(failRiskList);
                ArrayList<ChuangdePushRiskData> list = new ArrayList<ChuangdePushRiskData>();
                for (ChuangdePushRiskData chuangdePushRiskData : failRiskList) {
                    ChuangdePushRiskData failData = new ChuangdePushRiskData();
                    failData.setRiskMainpartId(chuangdePushRiskData.getRiskMainpartId());
                    failData.setCompanyName(chuangdePushRiskData.getCompanyName());
                    failData.setErrorMessage(chuangdePushRiskData.getErrorMessage());
                    list.add(failData);
                }
                failRiskList = new ArrayList(list);
            }
            if (chuangdePushRiskDataList.size() > 0) {
                ((RiskAssignMapper)this.dao).addRiskPushData(chuangdePushRiskDataList);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)result.getFailList())) {
            Map<String, ChuangdePushRiskData> map = Objects.requireNonNull(dataList).stream().collect(Collectors.toMap(ChuangdePushRiskData::getUniqueId, e -> e));
            for (ChuangdeResponseObj responseObj : result.getFailList()) {
                ChuangdePushRiskData pushRiskData = map.get(responseObj.getUniqueId());
                if (pushRiskData == null) continue;
                pushRiskData.setIsProc(Integer.valueOf(3));
                pushRiskData.setUpdateDate(date);
                pushRiskData.setErrorMessage(responseObj.getMessage());
                chuangdePushRiskDataList.add(pushRiskData);
                ChuangdePushRiskData chuangdePushRiskData = new ChuangdePushRiskData();
                chuangdePushRiskData.setRiskMainpartId(pushRiskData.getRiskMainpartId());
                chuangdePushRiskData.setCompanyName(pushRiskData.getCompanyName());
                chuangdePushRiskData.setErrorMessage(responseObj.getMessage());
                failRiskList.add(chuangdePushRiskData);
            }
            if (chuangdePushRiskDataList.size() > 0) {
                ((RiskAssignMapper)this.dao).addRiskPushData(chuangdePushRiskDataList);
            }
        }
        this.logger.error("RiskAssignServiceImpl---------------\u63a8\u9001\u98ce\u9669\u7684\u65e5\u5fd7\u8bb0\u5f55\uff0c{}", chuangdePushRiskDataList);
        return failRiskList;
    }

    public Map<Integer, Object> importListData(String fileUrl, Long workId, Long loginUserId) throws Exception {
        Row row;
        Workbook workbook = WorkbookFactory.create((InputStream)ExcelUtil.getInstance().getOssInputStream(fileUrl));
        Sheet sheet = workbook.getSheetAt(0);
        int rows = sheet.getPhysicalNumberOfRows();
        if (rows < 3) {
            throw new RuntimeException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        int cells = 2;
        ArrayList<Row> rowList = new ArrayList<Row>();
        for (int i = 2; i < rows; ++i) {
            row = sheet.getRow(i);
            if (row == null) continue;
            boolean flag = false;
            for (int j = 0; j < row.getPhysicalNumberOfCells(); ++j) {
                if (!StringUtils.isNotBlank((CharSequence)String.valueOf(row.getCell(j)))) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            rowList.add(row);
        }
        if (CollectionUtils.isEmpty(rowList)) {
            throw new RuntimeException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        ArrayList<RiskAssign> riskList = new ArrayList<RiskAssign>();
        Object error = "";
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        block2: for (int i = 0; i < rowList.size(); ++i) {
            row = (Row)rowList.get(i);
            String format = "\u884c\u53f7\uff1a" + (i + 3) + "\uff0c\u5217\u53f7\uff1a%s\uff0c%s\uff0c\u8bf7\u6838\u5b9e\uff1b";
            RiskAssign risk = new RiskAssign();
            CompanySuperviseModel model1 = null;
            for (int j = 0; j < cells; ++j) {
                List modelList;
                String cellValue;
                String string = cellValue = row.getCell(j) != null ? String.valueOf(row.getCell(j)) : null;
                if (j == 0) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) {
                        error = (String)error + String.format(format, j + 1, "\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                        continue block2;
                    }
                    modelList = this.suCompanyService.getListByNameOrCreditCode(cellValue, null, workId);
                    if (CollectionUtils.isEmpty((Collection)modelList)) {
                        error = (String)error + String.format(format, j + 1, "\u4f01\u4e1a\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                        continue block2;
                    }
                    model1 = (CompanySuperviseModel)modelList.get(0);
                    if (model1.getIsChoose() == 1) {
                        error = (String)error + String.format(format, j + 1, "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u6e05\u5355\u4e2d");
                        continue block2;
                    }
                    risk.setCid(model1.getId());
                    risk.setCompanyName(cellValue);
                    risk.setAreaDetailId(model1.getAreaDetailId());
                    risk.setCityId(model1.getCityId());
                    risk.setAreaId(model1.getAreaId());
                    risk.setSupervisionUnit(model1.getSupervisionUnit());
                    riskList.add(risk);
                    continue;
                }
                if (j != 1) continue;
                if (StringUtils.isBlank((CharSequence)cellValue)) {
                    error = (String)error + String.format(format, j + 1, "\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                modelList = this.suCompanyService.getListByNameOrCreditCode(null, cellValue, workId);
                if (CollectionUtils.isEmpty((Collection)modelList)) {
                    error = (String)error + String.format(format, j + 1, "\u4fe1\u7528\u4ee3\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    continue;
                }
                List modelList1 = this.suCompanyService.getListByNameOrCreditCode(String.valueOf(row.getCell(0)), cellValue, workId);
                if (CollectionUtils.isEmpty((Collection)modelList1) || !model1.getId().equals(((CompanySuperviseModel)modelList1.get(0)).getId())) {
                    error = (String)error + String.format(format, j + 1, "\u4fe1\u7528\u4ee3\u7801\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u5339\u914d");
                    continue;
                }
                risk.setUnifiedSocialCc(cellValue);
            }
        }
        if (!"".equals(error)) {
            error = ((String)error).substring(0, ((String)error).length() - 1);
            result.put(0, error);
        } else {
            this.batchInsert(riskList, workId, loginUserId);
            String pushString = "\u6210\u529f\u5bfc\u5165" + riskList.size() + "\u6761\u4f01\u4e1a\u6570\u636e\u3002";
            result.put(1, pushString);
        }
        return result;
    }

    public void syncRiskList() {
        List<ChuangdePushRiskData> pushedData = ((RiskAssignMapper)this.dao).getPushedData();
        if (CollectionUtils.isEmpty(pushedData)) {
            return;
        }
        List<RiskAssign> riskList = this.getPushResult(pushedData);
        if (CollectionUtils.isNotEmpty(riskList) && CollectionUtils.isNotEmpty(riskList)) {
            Date date = new Date();
            this.batchUpdateOrInsert(riskList, RiskAssignMapper.class, (e, mapper) -> {
                e.setUpdateDate(date);
                return mapper.updateByPrimaryKeySelective(e);
            }, 1000);
        }
    }

    public List<RiskAssign> getPushResult(List<ChuangdePushRiskData> pushedData) {
        ArrayList<RiskAssign> riskList = new ArrayList<RiskAssign>();
        List<String> uniqueIdList = pushedData.stream().map(ChuangdePushRiskData::getUniqueId).collect(Collectors.toList());
        Map<String, String> map = pushedData.stream().collect(Collectors.toMap(ChuangdePushRiskData::getUniqueId, ChuangdePushRiskData::getRiskMainpartId));
        List<PushResult> resultList = ((RiskAssignMapper)this.dao).getPushResult(uniqueIdList);
        if (CollectionUtils.isNotEmpty(resultList)) {
            for (PushResult result : resultList) {
                RiskAssign risk = new RiskAssign();
                Long riskId = Long.valueOf(map.get(result.getUniqueId()));
                BeanUtils.copyProperties((Object)result, (Object)risk);
                risk.setId(riskId);
                riskList.add(risk);
            }
        }
        return riskList;
    }

    private List<ChuangdePushRiskData> convertPushData(List<RiskAssign> list, Date date) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<ChuangdePushRiskData> dataList = new ArrayList<ChuangdePushRiskData>();
            for (RiskAssign riskAssign : list) {
                ChuangdePushRiskData pushRiskData = new ChuangdePushRiskData();
                if (!"dev".equalsIgnoreCase(this.isDev) && riskAssign.getType() != null) {
                    if (riskAssign.getType() == 1) {
                        this.ruleId = this.lowRiskRuleId;
                    } else if (riskAssign.getType() == 2) {
                        this.ruleId = this.highRiskRuleId;
                    }
                }
                pushRiskData.setId(Long.valueOf(this.idworker.nextId()));
                pushRiskData.setSystemId(this.systemId);
                pushRiskData.setRuleId(this.ruleId);
                pushRiskData.setUniqueId(this.systemId + this.ruleId + riskAssign.getId());
                pushRiskData.setCompanyId(riskAssign.getCid());
                pushRiskData.setCompanyName(riskAssign.getCompanyName());
                pushRiskData.setSourceId(riskAssign.getId().toString());
                pushRiskData.setRiskMainpartId(riskAssign.getId().toString());
                pushRiskData.setRiskMainpartName(riskAssign.getCompanyName());
                pushRiskData.setRiskDate(date);
                pushRiskData.setHandleDate(this.addMonths(date, 2));
                if (StringUtils.isBlank((CharSequence)riskAssign.getUnifiedSocialCc())) {
                    pushRiskData.setObjectType(Integer.valueOf(1));
                    pushRiskData.setCreditCode("");
                } else {
                    pushRiskData.setObjectType(Integer.valueOf(2));
                    pushRiskData.setCreditCode(riskAssign.getUnifiedSocialCc().toUpperCase());
                }
                pushRiskData.setCompanyAreaId(riskAssign.getAreaDetailId());
                this.setAreaAndOrgCode(pushRiskData, riskAssign);
                pushRiskData.setRiskTitle(this.title);
                String content = "\u9884\u8b66\u65f6\u95f4\uff1a" + DateUtils.formatDate((Date)pushRiskData.getRiskDate()) + "\uff0c\n\u540d\u79f0\uff1a" + pushRiskData.getCompanyName() + "\uff0c\n\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a" + pushRiskData.getCreditCode() + "\uff0c\n\n\u9884\u8b66\u5185\u5bb9\uff1a\n" + riskAssign.getWarningContent();
                pushRiskData.setRiskContent(content);
                pushRiskData.setIsProc(Integer.valueOf(1));
                dataList.add(pushRiskData);
            }
            return dataList;
        }
        return null;
    }

    private ChuangdeResponseJson<ChuangdeResponseObj> pushData(List<ChuangdePushRiskData> list) {
        ChuangdeResponseJson result = new ChuangdeResponseJson();
        List<Object> successList = new ArrayList();
        List<Object> failList = new ArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            JSONArray paramData = JSONArray.parseArray((String)JSONObject.toJSONString(list));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("list", (Object)paramData);
            String jsonStr = jsonObject.toString();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            try {
                String s = HttpsUtil.doPost((String)this.riskPushUrl, (String)jsonStr, (String)"utf-8", headers);
                this.logger.error("RiskAssignServiceImpl---------------\u63a8\u9001\u98ce\u9669\u8fd4\u56de\u4fe1\u606f\uff0c{}", (Object)s);
                JSONObject object = JSONObject.parseObject((String)s);
                if (object != null) {
                    JSONArray value = object.getJSONArray("value");
                    if (value != null) {
                        List jsonList = value.toJavaList(ChuangdeResponseObj.class);
                        successList = jsonList.stream().filter(e -> "success".equalsIgnoreCase(e.getStatus())).collect(Collectors.toList());
                        failList = jsonList.stream().filter(e -> !"success".equalsIgnoreCase(e.getStatus())).collect(Collectors.toList());
                        result.setSuccessList(successList);
                        result.setFailList(failList);
                    } else {
                        String exceptionContent = object.getString("exceptionContent");
                        if (exceptionContent == null) {
                            exceptionContent = object.getString("message");
                        }
                        for (ChuangdePushRiskData pushRiskData : list) {
                            ChuangdeResponseObj responseObj = new ChuangdeResponseObj();
                            responseObj.setUniqueId(pushRiskData.getUniqueId());
                            responseObj.setMessage(exceptionContent);
                            failList.add(responseObj);
                        }
                        result.setFailList(failList);
                    }
                    result.setCode(object.getString("success"));
                    if (!"true".equalsIgnoreCase(result.getCode())) {
                        result.setMsg("\u5f02\u5e38\u4fe1\u606f:" + object.getString("exceptionContent") + ",\u5f02\u5e38\u5177\u4f53\u539f\u56e0:" + object.getString("attachments"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)object.getString("error"))) {
                        result.setMsg(object.getString("message"));
                    }
                }
            }
            catch (Exception e2) {
                this.logger.error("RiskAssignServiceImpl---------------\u98ce\u9669\u63a8\u9001\u5f02\u5e38", (Throwable)e2);
                e2.printStackTrace();
            }
        }
        return result;
    }

    private void setAreaAndOrgCode(ChuangdePushRiskData riskData, RiskAssign riskAssign) {
        List<ChuangdeRiskArea> areaList = ((RiskAssignMapper)this.dao).getAllRiskArea();
        List<ChuangdeRiskOrg> orgList = ((RiskAssignMapper)this.dao).getAllRiskOrg();
        if (riskAssign.getAreaId() != null) {
            for (ChuangdeRiskArea chuangdeRiskArea : areaList) {
                if (!chuangdeRiskArea.getAreaId().equals(riskAssign.getAreaId())) continue;
                riskData.setRiskArea(chuangdeRiskArea.getAreaCode());
                riskData.setRiskLocation(chuangdeRiskArea.getAreaFullName());
                riskData.setRegionCode(chuangdeRiskArea.getAreaCode());
                if ("330604".equals(chuangdeRiskArea.getAreaCode())) {
                    riskData.setOrgcode("3306822");
                    continue;
                }
                for (ChuangdeRiskOrg org : orgList) {
                    orgCode = org.getOrgCode();
                    s = orgCode.substring(0, orgCode.length() - 1);
                    if (!((String)s).equals(riskData.getRegionCode())) continue;
                    riskData.setOrgcode(orgCode);
                    return;
                }
            }
        } else {
            for (ChuangdeRiskArea chuangdeRiskArea : areaList) {
                if (!chuangdeRiskArea.getAreaId().equals(riskAssign.getCityId())) continue;
                riskData.setRiskArea(chuangdeRiskArea.getAreaCode());
                riskData.setRiskLocation(chuangdeRiskArea.getAreaFullName());
                riskData.setRegionCode(chuangdeRiskArea.getAreaCode());
                for (ChuangdeRiskOrg org : orgList) {
                    orgCode = org.getOrgCode();
                    s = orgCode.substring(0, orgCode.length() - 2) + "0";
                    if (!((String)s).equals(riskData.getRegionCode())) continue;
                    riskData.setOrgcode(orgCode);
                    return;
                }
            }
        }
        if (riskAssign.getAreaId() != null) {
            Long areaId = Long.valueOf(riskAssign.getAreaDetailId().toString().substring(0, 6) + "000000");
            for (ChuangdeRiskArea chuangdeRiskArea : areaList) {
                if (!chuangdeRiskArea.getAreaId().equals(areaId)) continue;
                riskData.setRiskArea(chuangdeRiskArea.getAreaCode());
                riskData.setRiskLocation(chuangdeRiskArea.getAreaFullName());
                if (!"330604".equals(chuangdeRiskArea.getAreaCode())) continue;
                riskData.setRegionCode(chuangdeRiskArea.getAreaCode());
                riskData.setOrgcode("3306822");
                return;
            }
            Long l = Long.valueOf(riskAssign.getAreaId().toString().substring(0, 4) + "00000000");
            for (ChuangdeRiskArea chuangdeRiskArea : areaList) {
                if (!chuangdeRiskArea.getAreaId().equals(l)) continue;
                riskData.setRegionCode(chuangdeRiskArea.getAreaCode());
                for (ChuangdeRiskOrg chuangdeRiskOrg : orgList) {
                    String orgCode = chuangdeRiskOrg.getOrgCode();
                    String s = orgCode.substring(0, orgCode.length() - 2) + "0";
                    if (!s.equals(riskData.getRegionCode())) continue;
                    riskData.setOrgcode(orgCode);
                    return;
                }
            }
        }
    }

    private Date addMonths(Date startDate, Integer months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(2, months);
        return calendar.getTime();
    }

    private RiskAssign getRisk(RiskAssignVO riskAssignVO, Long cid) {
        CompanySuperviseModel model = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (model == null) {
            return null;
        }
        RiskAssign risk = new RiskAssign();
        risk.setId(Long.valueOf(this.idworker.nextId()));
        risk.setWorkId(riskAssignVO.getWorkId());
        risk.setTitle(riskAssignVO.getTitle());
        risk.setType(riskAssignVO.getType());
        risk.setWarningContent(riskAssignVO.getWarningContent());
        risk.setFileId(riskAssignVO.getFileId());
        risk.setFileName(riskAssignVO.getFileName());
        risk.setCid(model.getId());
        risk.setCompanyName(model.getName());
        risk.setUnifiedSocialCc(model.getUnifiedSocialCc());
        risk.setAreaDetailId(model.getAreaDetailId());
        risk.setCityId(model.getCityId());
        risk.setAreaId(model.getAreaId());
        risk.setSupervisionUnit(model.getSupervisionUnit());
        return risk;
    }

    private void setBaseFields(RiskAssign riskAssign, Long loginUserId) {
        Date date = new Date();
        riskAssign.setCreateBy(loginUserId);
        riskAssign.setUpdateBy(loginUserId);
        riskAssign.setCreateDate(date);
        riskAssign.setUpdateDate(date);
    }
}

