/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.accident;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.accident.EmeAccidentMapper;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.accident.EmeAccident;
import cn.smarthse.modules.health.entity.work.accident.EmeAccidentFiles;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.accident.IEmeAccidentService;
import cn.smarthse.modules.health.service.work.impl.accident.EmeAccidentFilesServiceImpl;
import cn.smarthse.modules.health.vo.work.accident.AccidentTipVO;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class EmeAccidentServiceImpl
extends BaseServiceImpl<EmeAccidentMapper, EmeAccident>
implements IEmeAccidentService {
    @Autowired
    EmeAccidentFilesServiceImpl filesService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @DubboReference
    ISysFileProvideService sysFileService;

    public List<EmeAccident> listDetails(EmeAccident data) {
        List<EmeAccident> list = ((EmeAccidentMapper)this.dao).listDetails(data);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> e.setCreateByName(SpringEncryptUtils.decrypt((String)e.getCreateByName())));
        }
        return list;
    }

    public List<EmeAccident> exprotList(EmeAccident data) {
        DataScopeHelper.startDataScope("accident", "eme_accident");
        return this.listDetails(data);
    }

    public PageInfo<EmeAccident> listDetails(int pageIndex, EmeAccident data) {
        PageHelper.startPage((int)pageIndex, (int)10);
        List<EmeAccident> list = this.listDetails(data);
        return new PageInfo(list);
    }

    public EmeAccident getDetailById(Long id) {
        EmeAccident data = ((EmeAccidentMapper)this.dao).getDetailById(id);
        this.setFiles(data);
        return data;
    }

    private void setFiles(EmeAccident data) {
        if (data == null || data.getId() == null) {
            return;
        }
        List<EmeAccidentFiles> allFiles = this.filesService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        for (EmeAccidentFiles file : allFiles) {
            SysFileModel sysFile = this.sysFileService.getFileById(file.getId());
            if (sysFile != null) {
                file.setFileName(sysFile.getFileName());
                file.setFileUrl(sysFile.getOssUrl());
            }
            switch (file.getFileType()) {
                case 1: {
                    data.getPhotos().add(file);
                    break;
                }
                case 2: {
                    data.getReports().add(file);
                    break;
                }
                case 3: {
                    data.getOthers().add(file);
                    break;
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public EmeAccident insertOrUpdate(EmeAccident data, Long cid, Long staffId) {
        if (data == null) {
            return data;
        }
        data.setCid(cid);
        data.setUpdateBy(staffId);
        data.setUpdateDate(new Date());
        if (data.getId() == null) {
            data.setCreateBy(staffId);
            data.setCreateDate(new Date());
            data.setIsValid(Boolean.valueOf(true));
            this.add(data, staffId, cid);
        } else {
            ((EmeAccidentMapper)this.dao).updateById(data);
        }
        this.filesService.updateFilesByParent(data);
        if (data.getStatus() == 1) {
            this.sysCoreWorkModuleCorrelationService.accidentReportComplete(data.getId(), staffId, cid);
        }
        return data;
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long updateBy, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(EmeAccident.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        EmeAccident drill = new EmeAccident();
        drill.setIsValid(Boolean.valueOf(false));
        drill.setUpdateDate(new Date());
        drill.setUpdateBy(updateBy);
        ((EmeAccidentMapper)this.dao).updateByExampleSelective(drill, example);
    }

    public PageInfo<EmeAccident> getAccidentList(JqGridParam gparam, EmeAccident param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        DataScopeHelper.startDataScope("accident", "eme_accident");
        List<EmeAccident> emeAccidents = this.listDetails(param);
        return new PageInfo(emeAccidents);
    }

    private int getListSize(Long cid, Byte status) {
        EmeAccident param = new EmeAccident();
        param.setCid(cid);
        param.setStatus(status);
        List<EmeAccident> unfinished = this.listDetails(param);
        return unfinished == null ? 0 : unfinished.size();
    }

    public AccidentTipVO getTips(Long cid) {
        AccidentTipVO vo = new AccidentTipVO();
        int total = 0;
        DataScopeHelper.startDataScope("accident", "eme_accident");
        DataScope dataScope = DataScopeHelper.getDataScope();
        int unfinished = this.getListSize(cid, (byte)0);
        if (unfinished > 0) {
            vo.setUnfinish(Integer.valueOf(unfinished));
        }
        DataScopeHelper.setDataScope(dataScope);
        vo.setFinish(Integer.valueOf(this.getListSize(cid, (byte)1)));
        vo.setTotal(Integer.valueOf(total));
        return vo;
    }

    public List<EmeAccident> listAndFiles(EmeAccident data, Map<String, Object> result) {
        List<EmeAccident> list = ((EmeAccidentMapper)this.dao).listDetails(data);
        if (list == null) {
            return list;
        }
        for (EmeAccident l : list) {
            l.setCreateByName(SpringEncryptUtils.decrypt((String)l.getCreateByName()));
            this.setFiles(l, result);
        }
        return list;
    }

    private void setFiles(EmeAccident data, Map<String, Object> result) {
        if (data == null || data.getId() == null) {
            return;
        }
        List<EmeAccidentFiles> allFiles = this.filesService.getFilesByPid(data.getId());
        if (allFiles == null || allFiles.size() == 0) {
            return;
        }
        List doc5Table6Files = (List)(result.get("doc5Table6Files") == null ? new ArrayList() : result.get("doc5Table6Files"));
        String destPath = this.getDestPath(data.getHappenTime(), data.getName());
        for (EmeAccidentFiles file : allFiles) {
            SysFileModel sysFile = this.sysFileService.getFileById(file.getFileId());
            if (sysFile == null) continue;
            file.setFileName(sysFile.getFileName());
            file.setFileUrl(sysFile.getOssUrl());
            switch (file.getFileType()) {
                case 1: {
                    sysFile.setDestPath(destPath + File.separator + "\u73b0\u573a\u7167\u7247");
                    data.getPhotos().add(file);
                    break;
                }
                case 2: {
                    sysFile.setDestPath(destPath + File.separator + "\u4e8b\u6545\u62a5\u544a\u548c\u5904\u7406\u8bb0\u5f55\u8868");
                    data.getReports().add(file);
                    if (sysFile == null) break;
                    doc5Table6Files.add(sysFile);
                    break;
                }
                case 3: {
                    sysFile.setDestPath(destPath + File.separator + "\u5176\u4ed6\u9644\u4ef6");
                    data.getOthers().add(file);
                    if (sysFile == null) break;
                    doc5Table6Files.add(sysFile);
                    break;
                }
            }
        }
        result.put("doc5Table6Files", doc5Table6Files);
    }

    private String getDestPath(Date happenTime, String name) {
        return (happenTime == null ? "" : DateUtils.format((Date)happenTime, (String)"yyyyMMdd")) + " " + (name == null ? "" : name);
    }

    @Transactional(readOnly=false)
    public void cancelByIds(String ids, Long staffId, Long cid) {
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            return;
        }
        Example example = new Example(EmeAccident.class);
        example.createCriteria().andIn("id", (Iterable)idArray);
        EmeAccident data = new EmeAccident();
        data.setUpdateDate(new Date());
        data.setUpdateBy(staffId);
        data.setStatus(Byte.valueOf((byte)2));
        ((EmeAccidentMapper)this.dao).updateByExampleSelective(data, example);
    }
}

