/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.work.impl.accident;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.work.accident.EmeAccidentFilesMapper;
import cn.smarthse.modules.health.entity.work.accident.EmeAccident;
import cn.smarthse.modules.health.entity.work.accident.EmeAccidentFiles;
import cn.smarthse.modules.health.service.work.accident.IEmeAccidentFilesService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class EmeAccidentFilesServiceImpl
extends BaseServiceImpl<EmeAccidentFilesMapper, EmeAccidentFiles>
implements IEmeAccidentFilesService {
    @Autowired
    EmeAccidentFilesMapper emeAccidentFilesMapper;

    @Transactional(readOnly=true)
    public void updateFilesByParent(EmeAccident data) {
        if (data == null) {
            return;
        }
        this.deleteFilesByPid(data.getId());
        this.addFilesByType(data.getPhotos(), data, (byte)1);
        this.addFilesByType(data.getReports(), data, (byte)2);
        this.addFilesByType(data.getOthers(), data, (byte)3);
    }

    private void deleteFilesByPid(Long pid) {
        if (pid == null) {
            return;
        }
        Example example = new Example(EmeAccidentFiles.class);
        example.createCriteria().andEqualTo("accidentId", (Object)pid);
        ((EmeAccidentFilesMapper)this.dao).deleteByExample(example);
    }

    private void addFilesByType(List<EmeAccidentFiles> files, EmeAccident data, Byte fileType) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (EmeAccidentFiles file : files) {
            if (file.getFileId() == null) continue;
            this.setParentInfos(data, file);
            file.setFileType(fileType);
            file.setId(Long.valueOf(this.idworker.nextId()));
            this.emeAccidentFilesMapper.insert(file);
        }
    }

    private void setParentInfos(EmeAccident data, EmeAccidentFiles file) {
        file.setAccidentId(data.getId());
        file.setCid(data.getCid());
    }

    public List<EmeAccidentFiles> getFilesByPid(Long dataId) {
        if (dataId == null) {
            return null;
        }
        Example example = new Example(EmeAccidentFiles.class);
        example.createCriteria().andEqualTo("accidentId", (Object)dataId);
        return ((EmeAccidentFilesMapper)this.dao).selectByExample(example);
    }
}

