/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.workremind;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.workremind.SysWorkRemindMapper;
import cn.smarthse.modules.health.entity.sys.workremind.SysWorkRemind;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.provider.IHealthSysWorkRemindService;
import cn.smarthse.modules.health.service.sys.workremind.ISysWorkRemindService;
import cn.smarthse.util.common.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysWorkRemindServiceImpl
extends BaseServiceImpl<SysWorkRemindMapper, SysWorkRemind>
implements ISysWorkRemindService,
IHealthSysWorkRemindService {
    public SysWorkRemind getSysWorkRemind(Long cid, String modelCode) {
        SysWorkRemind sysWorkRemind = ((SysWorkRemindMapper)this.dao).getSysWorkRemind(cid, modelCode);
        return sysWorkRemind;
    }

    public Map<String, Integer> getRemindInfoByCid(Long cid) {
        Example e = new Example(SysWorkRemind.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(e);
        Map<String, Integer> dataMap = new HashMap<String, Integer>();
        if (CollectionUtils.isNotEmpty(listByExample)) {
            dataMap = listByExample.stream().collect(Collectors.toMap(k -> k.getModelCode(), v -> v.getStatus()));
        }
        return dataMap;
    }

    @Transactional(readOnly=false)
    public int clearState(Long cid, String modelCode) {
        Example e = new Example(SysWorkRemind.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("modelCode", (Object)modelCode);
        SysWorkRemind result = new SysWorkRemind();
        result.setStatus(Integer.valueOf(0));
        result.setUpdateDate(new Date());
        int i = ((SysWorkRemindMapper)this.dao).updateByExampleSelective(result, e);
        return i;
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public int updateWorkRemind(SysWorkRemind workRemind) {
        if (workRemind == null || workRemind.getCid() == null || StringUtils.isBlank((CharSequence)workRemind.getModelCode())) {
            return 0;
        }
        SysWorkRemind sysWorkRemind = this.getSysWorkRemind(workRemind.getCid(), workRemind.getModelCode());
        if (sysWorkRemind == null) {
            workRemind.setCreateDate(new Date());
            this.add(workRemind);
        } else {
            workRemind.setId(sysWorkRemind.getId());
            this.update(workRemind);
        }
        return 1;
    }

    @Transactional(readOnly=false)
    public int checkPlanUpdateWorkRemind(Long cid) {
        if (cid == null) {
            return 0;
        }
        SysWorkRemind workRemind = new SysWorkRemind();
        workRemind.setCid(cid);
        workRemind.setModelCode(HomeDataEventEnum.OCC_HAZARD_DETECTION.getModelCode());
        workRemind.setStatus(Integer.valueOf(1));
        return this.updateWorkRemind(workRemind);
    }
}

