/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.message;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.dao.sys.message.SysMessageMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.message.SysMessage;
import cn.smarthse.modules.health.entity.sys.message.SysMessageReceiver;
import cn.smarthse.modules.health.enums.sys.MessageStateEnum;
import cn.smarthse.modules.health.enums.sys.MessageTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.message.ISysMessageReceiverService;
import cn.smarthse.modules.health.service.sys.message.ISysMessageService;
import cn.smarthse.modules.health.vo.MessageTotalInfo;
import java.util.ArrayList;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SysMessageServiceImpl
extends BaseServiceImpl<SysMessageMapper, SysMessage>
implements ISysMessageService {
    @Autowired
    SysMessageMapper sysMessageMapper;
    @Autowired
    ISysMessageReceiverService receiverServcie;
    @Autowired
    IStaffInfoService staffServcie;

    private List<MessageTotalInfo> initMessageInfoList() {
        ArrayList<MessageTotalInfo> list = new ArrayList<MessageTotalInfo>();
        list.add(new MessageTotalInfo(MessageTypeEnum.remind));
        list.add(new MessageTotalInfo(MessageTypeEnum.work));
        list.add(new MessageTotalInfo(MessageTypeEnum.notice));
        list.add(new MessageTotalInfo(MessageTypeEnum.lawAndRegulations));
        list.add(new MessageTotalInfo(MessageTypeEnum.syatem));
        return list;
    }

    public List<MessageTotalInfo> getUnReadMessageInfoByStaffId(Long staffId) {
        List<MessageTotalInfo> list = this.initMessageInfoList();
        List unReadList = this.receiverServcie.getUnReadListByStaffId(staffId);
        block0: for (SysMessageReceiver smr : unReadList) {
            SysMessage message = (SysMessage)super.getById(smr.getMessageId());
            smr.setMessage(message);
            for (MessageTotalInfo messageInfo : list) {
                if (!messageInfo.getMessageType().getValue().equals(message.getMessageType())) continue;
                messageInfo.setValue(Integer.valueOf(messageInfo.getValue() + 1));
                continue block0;
            }
        }
        return list;
    }

    private void pushToReceiver(Long messageId, Long receiver, Long cid, Long loginStaffId) {
        SysMessageReceiver receive = new SysMessageReceiver();
        receive.setCid(cid);
        receive.setMessageId(messageId);
        receive.setMessageReveiver(receiver);
        receive.setMessageState(MessageStateEnum.unRead.getValue());
        this.receiverServcie.add((Object)receive, loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void pushMessage(SysMessage message, List<Long> receiverList, Long loginStaffId, Long cid) {
        block4: {
            block3: {
                if (message == null || receiverList == null || receiverList.size() == 0 || loginStaffId == null || cid == null) {
                    throw new HealthException(ErrorEnum.PARAMETER_ERROR);
                }
                ValidateUtil.valid((Object)message, (String)"add");
                super.add(message, loginStaffId, cid);
                if (receiverList.size() != 1 || !receiverList.get(0).equals(Constants.MESSAGE_RECEIVER_ALL_COMPANY)) break block3;
                List allStaff = this.staffServcie.getStaffInfoListByCid(cid);
                if (allStaff == null || allStaff.size() <= 0) break block4;
                for (StaffInfo staff : allStaff) {
                    this.pushToReceiver(message.getId(), staff.getId(), cid, loginStaffId);
                }
                break block4;
            }
            for (Long receiver : receiverList) {
                this.pushToReceiver(message.getId(), receiver, cid, loginStaffId);
            }
        }
    }
}

