/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.message;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.dao.sys.message.MessageUserMapper;
import cn.smarthse.modules.health.entity.sys.message.MessageUser;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageCount;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;
import cn.smarthse.modules.health.service.sys.message.IMessageUserService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MessageUserServiceImpl
extends BaseServiceImpl<MessageUserMapper, MessageUser>
implements IMessageUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageUserServiceImpl.class);
    @Autowired
    private RedissonClient redissonClient;
    private final byte readed = 1;
    private final byte ignored = (byte)2;
    private final byte deleted = (byte)3;

    protected MessageUser updateMessageUser(MessageUser messageUser) {
        this.deleteByMessageIdAndUserId(messageUser.getMessageId(), messageUser.getUserId());
        return this.add(messageUser);
    }

    @Transactional(readOnly=false)
    public void deleteByMessageIdAndUserId(Long messageId, Long userId) {
        if (messageId == null || userId == null) {
            return;
        }
        Example example = new Example(MessageUser.class);
        example.createCriteria().andEqualTo("messageId", (Object)messageId).andEqualTo("userId", (Object)userId);
        ((MessageUserMapper)this.dao).deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public MessageUser read(MessageUser messageUser) {
        messageUser.setMessageState(Byte.valueOf((byte)1));
        return this.updateMessageUser(messageUser);
    }

    @Transactional(readOnly=false)
    public MessageUser ignore(MessageUser messageUser) {
        messageUser.setMessageState(Byte.valueOf((byte)1));
        return this.updateMessageUser(messageUser);
    }

    @Transactional(readOnly=false)
    public MessageUser delay(MessageUser messageUser) {
        if (DateUtils.compareDate((Date)new Date(), (Date)messageUser.getRetipTime()) >= 0L) {
            return messageUser;
        }
        return this.updateMessageUser(messageUser);
    }

    @Transactional(readOnly=false)
    public void addDeleteMessage(MessageUser messageUser) {
        if (messageUser == null) {
            return;
        }
        messageUser.setMessageState(Byte.valueOf((byte)3));
        this.updateMessageUser(messageUser);
    }

    @Transactional(readOnly=false)
    public Boolean changeMessageState(List<Long> ids, MessageUser messageUser, Long loginStaffId) {
        int changeCount = ((MessageUserMapper)this.dao).changeMessageStatue(ids, messageUser, loginStaffId);
        return changeCount == ids.size() ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Boolean addMessageUser(MessageUser messageUser) {
        String key = messageUser.getMessageId() + ":" + messageUser.getUserId();
        RLock lock = this.redissonClient.getLock(key);
        if (lock.tryLock()) {
            try {
                Example example = new Example(MessageUser.class);
                example.createCriteria().andEqualTo("isValid", (Object)messageUser.getIsValid()).andEqualTo("messageId", (Object)messageUser.getMessageId()).andEqualTo("userId", (Object)messageUser.getUserId());
                if (CollUtil.isEmpty((Collection)((MessageUserMapper)this.dao).selectByExample(example))) {
                    Boolean bl = ((MessageUserMapper)this.dao).insert(messageUser) > 0 ? Boolean.TRUE : Boolean.FALSE;
                    return bl;
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        log.warn("\u901a\u77e5\u672a\u83b7\u53d6\u9501\u8d44\u6e90,messageId,{}", (Object)messageUser.getMessageId());
        return Boolean.FALSE;
    }

    public String getLatestMessageByUserId(Long loginStaffId, Integer bussinesFromType) {
        return ((MessageUserMapper)this.dao).getLatestNewsByUserId(loginStaffId, bussinesFromType);
    }

    public Boolean isExistByUserId(Long loginStaffId, Integer bussinesFromType) {
        int i = ((MessageUserMapper)this.dao).isExistByUserId(loginStaffId, bussinesFromType);
        return i > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public List<MessageCount> getNoReadCountBy(MessageParam param) {
        if (param == null || param.getCid() == null || param.getUserId() == null || param.getBussinesFromType() == null) {
            return null;
        }
        return ((MessageUserMapper)this.dao).getNoReadCountBy(param);
    }
}

