/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.message;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.sys.message.MessageMapper;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.entity.sys.message.MessageUser;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageCount;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.enums.sys.MessageStateEnum;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.service.sys.message.IMessageFileService;
import cn.smarthse.modules.health.service.sys.message.IMessageReceiverService;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.sys.message.IMessageUserService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class MessageServiceImpl
extends BaseServiceImpl<MessageMapper, Message>
implements IMessageService {
    @Autowired
    private IMessageFileService fileService;
    @Autowired
    private IMessageReceiverService receiverService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IMessageUserService messageUserService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public PageInfo<Message> getPage(JqGridParam gparam, MessageParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.getList(param));
    }

    private List<Message> getList(MessageParam param) {
        if (param == null || param.getCid() == null || param.getUserId() == null) {
            return null;
        }
        return ((MessageMapper)this.dao).selectList(param);
    }

    public List<MessageCount> getUnreadMessageCount(MessageParam param) {
        if (param == null || param.getCid() == null || param.getUserId() == null) {
            return null;
        }
        List<MessageCount> counts = ((MessageMapper)this.dao).unreadCount(param);
        return counts;
    }

    @Transactional(readOnly=false)
    public Message pushMessage(Message message, Long createBy, Long cid) {
        if (this.checkIsExist(message)) {
            return message;
        }
        this.addMessageInfos(message, createBy, cid);
        return message;
    }

    @Transactional(readOnly=false)
    public void pushManagerMessage(Message message, Long cid) {
        List userManager = this.sysUserService.getUserManager(cid);
        if (CollectionUtils.isNotEmpty((Collection)userManager)) {
            ArrayList receivers = new ArrayList();
            for (SysUser sysUser : userManager) {
                MessageReceiver receiver = new MessageReceiver();
                receiver.setReveiver(sysUser.getStaffId());
            }
            message.setReceivers(receivers);
            message.setSendTime(new Date());
            this.addMessageInfos(message, ((SysUser)userManager.get(0)).getStaffId(), cid);
        } else {
            this.logger.info("\u4f01\u4e1a\uff1a{} \u65e0\u7ba1\u7406\u5458\uff0c \u53d6\u6d88\u53d1\u9001\u63d0\u9192", (Object)cid);
        }
    }

    @Transactional(readOnly=false)
    public void addMessageInfos(Message message, Long createBy, Long cid) {
        this.add(message, createBy, cid);
        this.fileService.addFiles(message);
        this.receiverService.addReceiversByMessage(message);
    }

    @Transactional(readOnly=false)
    public Message multiPushMessage(Message message, Long createBy, Long cid) {
        this.addMessageInfos(message, createBy, cid);
        return message;
    }

    private boolean checkIsExist(Message message) {
        Example example = new Example(Message.class);
        Example.Criteria c = example.createCriteria();
        if (message.getBussinesFromType().intValue() == MessageBusinessFromEnum.workPlan.getValue().intValue()) {
            c.andEqualTo("bussinesName", (Object)message.getBussinesName()).andEqualTo("bussinessContent", (Object)message.getBussinessContent());
        }
        if (StringUtils.isNotEmpty((CharSequence)message.getBussinesNo()) && message.getBussinesFromType().intValue() == MessageBusinessFromEnum.systemUpdate.getValue().intValue()) {
            c.andEqualTo("bussinesNo", (Object)message.getBussinesNo());
        } else {
            c.andEqualTo("bussinesId", (Object)message.getBussinesId());
        }
        c.andEqualTo("isValid", (Object)true);
        List messages = ((MessageMapper)this.dao).selectByExample(example);
        return messages != null && messages.size() > 0;
    }

    @Transactional(readOnly=false)
    public void deleteById(Long id, Long loginStaffId) {
        if (id == null) {
            return;
        }
        Example example = new Example(Message.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        Message data = new Message();
        data.setIsValid(Boolean.valueOf(false));
        data.setUpdateDate(new Date());
        data.setUpdateBy(loginStaffId);
        ((MessageMapper)this.dao).updateByExampleSelective(data, example);
    }

    @Override
    public Message getById(Long id) {
        Message message = (Message)super.getById(id);
        if (message == null) {
            return message;
        }
        List files = this.fileService.getFilesByMessageId(id);
        message.setFiles(files);
        return message;
    }

    @Transactional(readOnly=false)
    public void sendMessage2Admin(String messageContent, Long createBy) {
        Map<Long, List<SysUser>> longListMap;
        List sysUserList = this.sysUserService.listAllAdmin();
        if (CollectionUtils.isNotEmpty((Collection)sysUserList) && MapUtils.isNotEmpty(longListMap = sysUserList.stream().collect(Collectors.groupingBy(SysUser::getCid)))) {
            Set<Long> cidSet = longListMap.keySet();
            for (Long aLong : cidSet) {
                Message message1 = new Message();
                message1.setCid(aLong);
                message1.setBussinesFrom("\u76d1\u7ba1\u7aef");
                message1.setBussinessContent(messageContent);
                message1.setBussinesName("\u884c\u653f\u533a\u5212\u53d8\u66f4");
                message1.setBussinesType(Byte.valueOf((byte)3));
                message1.setSendTime(new Date());
                this.add(message1, createBy, aLong);
                List<SysUser> sysUsers = longListMap.get(aLong);
                if (!CollectionUtils.isNotEmpty(sysUsers)) continue;
                ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
                for (SysUser sysUser : sysUsers) {
                    MessageReceiver receiver = new MessageReceiver();
                    receiver.setMessageId(message1.getId());
                    receiver.setReveiver(sysUser.getStaffId());
                    receiver.setCid(sysUser.getCid());
                    receivers.add(receiver);
                }
                message1.setReceivers(receivers);
                this.receiverService.addReceiversByMessage(message1);
            }
        }
    }

    @Transactional(readOnly=false)
    public void addTrainingVideoMessage(Message message, Long cid, Long createBy) {
        message.setBussinesType(MessageBusinessTypeEnum.remind.getValue());
        message.setCid(cid);
        message.setBussinesName("\u5728\u7ebf\u57f9\u8bad\u89c6\u9891");
        message.setBussinesFromType(Integer.valueOf(303));
        message.setSendTime(new Date());
        message = this.add(message, createBy, cid);
        List sysUserList = this.sysUserService.listAllAdmin();
        if (CollectionUtils.isNotEmpty((Collection)sysUserList) && CollectionUtils.isNotEmpty(sysUserList = sysUserList.stream().filter(s -> cid.equals(s.getCid())).collect(Collectors.toList()))) {
            ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
            for (SysUser sysUser : sysUserList) {
                MessageReceiver receiver = new MessageReceiver();
                receiver.setMessageId(message.getId());
                receiver.setReveiver(sysUser.getStaffId());
                receiver.setCid(sysUser.getCid());
                receivers.add(receiver);
            }
            message.setReceivers(receivers);
            this.receiverService.addReceiversByMessage(message);
        }
    }

    @Transactional
    public PageInfo<Message> getTrainingMessageListData(Byte type, Long cid, Long loginStaffId, JqGridParam param, Long areaId, Integer bussinesFromType, Integer belongType) {
        if (Objects.isNull(cid) || Objects.isNull(loginStaffId) || Objects.isNull(param) || Objects.isNull(areaId)) {
            return new PageInfo();
        }
        if (Objects.isNull(type)) {
            type = 1;
        }
        Boolean exist = this.messageUserService.isExistByUserId(loginStaffId, bussinesFromType);
        AreaModel areaById = this.sysAreaProvideService.getAreaById(areaId);
        ArrayList<Long> areaList = new ArrayList<Long>(4);
        if (areaById != null) {
            if (areaById.getProvinceId() != null) {
                areaList.add(areaById.getProvinceId());
            }
            if (areaById.getCityId() != null) {
                areaList.add(areaById.getCityId());
            }
            if (areaById.getAreaId() != null) {
                areaList.add(areaById.getAreaId());
            }
            if (areaById.getStreetId() != null) {
                areaList.add(areaById.getStreetId());
            }
        }
        List<Object> result = null;
        if (exist.booleanValue()) {
            result = ((MessageMapper)this.dao).getTrainingListDataRelevant(type, cid, loginStaffId, bussinesFromType);
            String oldDateNoParse = this.messageUserService.getLatestMessageByUserId(loginStaffId, bussinesFromType);
            String newDateNoParse = this.getLatestMessage(areaList, bussinesFromType);
            if (StrUtil.isEmpty((CharSequence)oldDateNoParse) || StrUtil.isEmpty((CharSequence)newDateNoParse)) {
                return new PageInfo(result);
            }
            DateTime oldDate = DateUtil.parse((CharSequence)oldDateNoParse);
            DateTime newDate = DateUtil.parse((CharSequence)newDateNoParse);
            if (newDate.after((Date)oldDate)) {
                List<Message> messageList = ((MessageMapper)this.dao).getTrainingListDataAllByCompanyAreaId(areaList, bussinesFromType, belongType);
                List resultFilter = null;
                if (CollectionUtils.isNotEmpty(messageList)) {
                    resultFilter = messageList.stream().filter(arg_0 -> MessageServiceImpl.lambda$getTrainingMessageListData$1((Date)oldDate, cid, arg_0)).filter(MessageServiceImpl.distinctByKey(Message::getBussinesId)).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty(resultFilter)) {
                    result.addAll(resultFilter);
                    result = result.stream().sorted(Comparator.comparing(Message::getMessageState, Comparator.nullsFirst(Byte::compareTo)).thenComparing(Message::getSendTime).reversed()).collect(Collectors.toList());
                    List finalResult = resultFilter;
                    this.threadPoolTaskExecutor.execute(() -> {
                        for (Message message : finalResult) {
                            MessageUser messageUser = new MessageUser();
                            messageUser.setId(Long.valueOf(this.idworker.nextId()));
                            messageUser.setCid(cid);
                            messageUser.setUserId(loginStaffId);
                            messageUser.setMessageId(message.getId());
                            messageUser.setMessageState(MessageStateEnum.unRead.getValue());
                            messageUser.setCreateDate(message.getSendTime());
                            messageUser.setIsValid(Boolean.TRUE);
                            this.messageUserService.addMessageUser(messageUser);
                        }
                    });
                }
            }
        } else {
            List<Message> messageList = ((MessageMapper)this.dao).getTrainingListDataAllByCompanyAreaId(areaList, bussinesFromType, belongType);
            if (CollectionUtils.isNotEmpty(messageList)) {
                result = messageList.stream().filter(i -> i.getCid() == null || cid.equals(i.getCid())).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty(result)) {
                List<Message> finalResult = result;
                this.threadPoolTaskExecutor.execute(() -> {
                    for (Message message : finalResult) {
                        MessageUser messageUser = new MessageUser();
                        messageUser.setId(Long.valueOf(this.idworker.nextId()));
                        messageUser.setCid(cid);
                        messageUser.setUserId(loginStaffId);
                        messageUser.setMessageId(message.getId());
                        messageUser.setMessageState(MessageStateEnum.unRead.getValue());
                        messageUser.setCreateDate(message.getSendTime());
                        messageUser.setIsValid(Boolean.TRUE);
                        this.messageUserService.addMessageUser(messageUser);
                    }
                });
            }
        }
        PageInfo messagePageInfo = null;
        if (CollectionUtils.isNotEmpty(result)) {
            long size = result.size();
            List messageList = result.stream().sorted(Comparator.comparing(Message::getSendTime).reversed()).skip((long)(param.getPage() - 1) * (long)param.getRows()).limit(param.getRows()).collect(Collectors.toList());
            messagePageInfo = new PageInfo(messageList);
            messagePageInfo.setTotal(size);
            messagePageInfo.setPageNum(param.getPage());
        }
        return messagePageInfo;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Transactional(readOnly=false)
    public Message addMessage(Message message) {
        return this.add(message);
    }

    public String getLatestMessage(List<Long> areaList, Integer bussinesFromType) {
        return ((MessageMapper)this.dao).getLatestMessage(areaList, bussinesFromType);
    }

    private static /* synthetic */ boolean lambda$getTrainingMessageListData$1(Date oldDate, Long cid, Message i) {
        return DateUtil.date((Date)i.getCreateDate()).after(oldDate) && (i.getCid() == null || cid.equals(i.getCid()));
    }
}

