/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.message;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.message.MessageReceiverMapper;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.service.sys.message.IMessageReceiverService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class MessageReceiverServiceImpl
extends BaseServiceImpl<MessageReceiverMapper, MessageReceiver>
implements IMessageReceiverService {
    @Transactional(readOnly=false)
    public void addReceiversByMessage(Message message) {
        if (message == null || message.getId() == null) {
            return;
        }
        List receivers = message.getReceivers();
        if (receivers == null || receivers.size() == 0) {
            return;
        }
        for (MessageReceiver r : receivers) {
            if (r.getReveiver() == null) continue;
            r.setMessageId(message.getId());
            this.add(r, message.getCreateBy(), message.getCid());
        }
    }

    @Transactional(readOnly=false)
    public MessageReceiver addMessageReceiver(MessageReceiver messageReceiver) {
        return this.add(messageReceiver);
    }
}

