/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.legal;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.sys.legal.SysLegalUploadFileMapper;
import cn.smarthse.modules.health.entity.sys.legal.SysLegal;
import cn.smarthse.modules.health.entity.sys.legal.SysLegalUploadFile;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalUploadFileService;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysLegalUploadFileServiceImpl
extends BaseServiceImpl<SysLegalUploadFileMapper, SysLegalUploadFile>
implements ISysLegalUploadFileService {
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    SysLegalUploadFileMapper sysLegalUploadFileMapper;

    public List<SysLegalUploadFile> getByLegalIdAndFileId(Long cid, Long id, Long fileId) {
        Example example = new Example(SysLegalUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("legalId", (Object)id).andEqualTo("fileId", (Object)fileId).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<SysLegalUploadFile> list = this.getListByExample(example);
        return list;
    }

    public boolean getExistsByLegalIdAndFileId(Long cid, Long id, Long fileId) {
        boolean isFile = this.sysLegalUploadFileMapper.selectExists(cid, id, fileId);
        return isFile;
    }

    @Transactional(readOnly=false)
    public void addFile(Long id, Integer fromTable, Long[] fileId2, Long cid, Long staffid) {
        for (int i = 0; i < fileId2.length; ++i) {
            boolean isFile = this.getExistsByLegalIdAndFileId(cid, id, fileId2[i]);
            if (isFile) continue;
            SysLegalUploadFile sysLegalUploadFile = new SysLegalUploadFile();
            sysLegalUploadFile.setLegalId(id);
            sysLegalUploadFile.setFromTable(fromTable);
            sysLegalUploadFile.setFileId(fileId2[i]);
            this.add(sysLegalUploadFile, staffid, cid);
        }
    }

    public List<SysLegal> setLegalUploadFileIdAndName(List<SysLegal> list, Long cid) {
        for (SysLegal sysLegal : list) {
            ArrayList<Long> fileIdList = new ArrayList<Long>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            Example example = new Example(SysLegalUploadFile.class);
            Example.Criteria c = example.createCriteria();
            c.andEqualTo("cid", (Object)cid).andEqualTo("legalId", (Object)sysLegal.getId()).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("fromTable", (Object)sysLegal.getFromTable());
            example.setOrderByClause("id asc");
            List fileList = this.getListByExample(example);
            if (fileList != null) {
                for (SysLegalUploadFile sysLegalUploadFile : fileList) {
                    if (sysLegalUploadFile.getFileId() == null) continue;
                    fileIdList.add(sysLegalUploadFile.getFileId());
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(sysLegalUploadFile.getFileId());
                    if (sysFile == null) continue;
                    fileNameList.add(sysFile.getFileName());
                }
            }
            sysLegal.setFileIds(fileIdList);
            sysLegal.setFileNames(fileNameList);
        }
        return list;
    }
}

