/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl.legal;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.legal.SysLegalMapper;
import cn.smarthse.modules.health.entity.sys.legal.SysLegal;
import cn.smarthse.modules.health.enums.syslegal.SysLegalStatusEnum;
import cn.smarthse.modules.health.enums.syslegal.SysLegalTypeEnum;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalFocusService;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalService;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalUploadFileService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysLegalServiceImpl
extends BaseServiceImpl<SysLegalMapper, SysLegal>
implements ISysLegalService {
    @Autowired
    ISysLegalFocusService sysLegalFocusServiceImpl;
    @Autowired
    ISysLegalUploadFileService sysLegalUploadFileServiceImpl;
    @Value(value="${isChangxing}")
    private String isChangxing;

    public PageInfo<SysLegal> getSysLegalListByGridParam(JqGridParam gparam, String typeCode) {
        String type = null;
        String status = null;
        String title = null;
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if (sField.getSearchField().equals("legalType")) {
                    type = sField.getSearchValue();
                }
                if (sField.getSearchField().equals("legalStatus")) {
                    status = sField.getSearchValue();
                }
                if (!sField.getSearchField().equals("title")) continue;
                title = sField.getSearchValue();
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cid", gparam.getCid());
        map.put("type", type);
        map.put("status", status);
        map.put("title", title);
        if ("true".equals(this.isChangxing)) {
            map.put("isChangxing", 1);
        } else {
            map.put("isChangxing", 0);
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<Object> list = new ArrayList();
        list = ((SysLegalMapper)this.dao).selectSysLegalListByTag(map);
        for (SysLegal sysLegal : list) {
            sysLegal.setFromTable(Integer.valueOf(1));
            sysLegal.setStatusName(SysLegalStatusEnum.getName((Integer)sysLegal.getLegalStatus()));
            sysLegal.setTypeName(SysLegalTypeEnum.getName((Integer)sysLegal.getLegalType()));
            if (sysLegal.getLastUpdateDate() == null || sysLegal.getLegalType().equals(SysLegalTypeEnum.type6.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type8.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type7.getValue())) continue;
            sysLegal.setExecuteDate(sysLegal.getLastUpdateDate());
        }
        if (gparam.getCid() != null) {
            list = this.sysLegalUploadFileServiceImpl.setLegalUploadFileIdAndName(list, gparam.getCid());
        }
        return new PageInfo(list);
    }

    public List<SysLegal> getSysLegalListByFocus(Long cid) {
        List<SysLegal> list = ((SysLegalMapper)this.dao).selectSysLegalListByFocus(cid);
        for (SysLegal sysLegal : list) {
            sysLegal.setStatusName(SysLegalStatusEnum.getName((Integer)sysLegal.getLegalStatus()));
            sysLegal.setTypeName(SysLegalTypeEnum.getName((Integer)sysLegal.getLegalType()));
        }
        return list;
    }

    public List<SysLegal> getSysLegalListByCidAndYear(Long cid, Integer year) {
        List<SysLegal> sysLegalList = ((SysLegalMapper)this.dao).getSysLegalListByCidAndYear(cid, year);
        for (SysLegal sysLegal : sysLegalList) {
            sysLegal.setStatusName(SysLegalStatusEnum.getName((Integer)sysLegal.getLegalStatus()));
            sysLegal.setTypeName(SysLegalTypeEnum.getName((Integer)sysLegal.getLegalType()));
        }
        return sysLegalList;
    }

    public SysLegal getSysLegalByTitleAndFileNo(String title, String fileNo) {
        Example example = new Example(SysLegal.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("title", (Object)title).andEqualTo("fileNo", (Object)fileNo).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        return (SysLegal)list.get(0);
    }

    public SysLegal getFromCsresByid(Long legalId) {
        List<SysLegal> list = ((SysLegalMapper)this.dao).getFromCsresByid(legalId);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }
}

