/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeUtils;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanyCidUserIdModel;
import cn.smarthse.modules.health.dao.sys.SysUserMapper;
import cn.smarthse.modules.health.dao.sys.SysUserTipMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserTip;
import cn.smarthse.modules.health.entity.sys.vo.UserDataScope;
import cn.smarthse.modules.health.entity.sys.vo.UserFormSuperviseInfo;
import cn.smarthse.modules.health.entity.sys.vo.UserFormVO;
import cn.smarthse.modules.health.service.base.company.ICompanySoftService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysLogService;
import cn.smarthse.modules.health.service.sys.ISysUserLoginService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.platform.model.UserModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysUserServiceImpl
extends BaseServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    ISecUserRoleService userRoleService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    ISysUserLoginService userLoginService;
    @Autowired
    ICompanySoftService companysoftService;
    @Autowired
    ISecRoleService secRoleService;
    @Autowired
    ISysLogService sysLogService;
    @Autowired
    private SysUserTipMapper sysUserTipMapper;
    @Autowired
    private RedisClient redisClient;

    private void updateHistory(SysUser newEntity, Long cid, Long staffId) {
    }

    public SysUser getUserByuserame(String username) {
        if (StrUtil.isBlank((CharSequence)username)) {
            return null;
        }
        SysUser param = new SysUser();
        param.setCount(Integer.valueOf(1));
        param.setUsername(username);
        username = username.replace("\uff08", "(");
        username = username.replace("\uff09", ")");
        param.setHalfUsername(SpringEncryptUtils.encrypt((String)username));
        username = username.replace("(", "\uff08");
        username = username.replace(")", "\uff09");
        param.setFullUsername(SpringEncryptUtils.encrypt((String)username));
        SysUser companyUser = ((SysUserMapper)this.dao).selectCompanyUserByUsername(param);
        return companyUser;
    }

    public SysUser getAvailableUserByuserame(String username) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("username", (Object)username).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("isForbidden", (Object)false);
        return (SysUser)this.getOneByExample(example);
    }

    public PageInfo<SysUser> getUserListByGridParam(JqGridParam gparam) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("isValid", (Object)Global.TRUE);
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                String searchValue = StrUtil.isBlank((CharSequence)sField.getSearchValue()) ? "" : SpringEncryptUtils.encrypt((String)sField.getSearchValue());
                if (sField.getSearchOper().equals(JqGridParam.operType.eq.toString())) {
                    c.andEqualTo(sField.getSearchField(), (Object)searchValue);
                    continue;
                }
                if (!sField.getSearchOper().equals(JqGridParam.operType.like.toString())) continue;
                c.andLike(sField.getSearchField(), "%" + searchValue + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            example.setOrderByClause(gparam.getSidx() + " " + gparam.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List list = this.getListByExample(example);
        for (SysUser user : list) {
            SecUserRole param = new SecUserRole();
            param.setSysUserId(user.getId());
            param.setSecRoleId(Long.valueOf(1L));
            List roles = this.userRoleService.getListByUserId(param);
            if (roles == null || roles.size() <= 0) continue;
            user.setIsSuperManger(Boolean.valueOf(true));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void deleteUser(SysUser viewUser, Long loginStaffId) {
        this.delete(viewUser, loginStaffId);
        this.userRoleService.deleteByUserId(viewUser.getId(), loginStaffId);
    }

    @Transactional(readOnly=false)
    public void addForm(UserFormVO userForm, Long loginStaffId, Long cid) throws ServiceException {
        if (userForm.getStaffId() != null && userForm.getStaffId() > 0L) {
            this.clearUserStaff(userForm.getStaffId(), loginStaffId);
        }
        SysUser user = new SysUser();
        user.setFullname(userForm.getStaffname());
        user.setIsManger(Global.FALSE);
        user.setIsForbidden(Global.FALSE);
        user.setUsername(userForm.getUsername());
        user.setStaffId(userForm.getStaffId());
        this.entryptPassword(user, userForm.getPassword());
        user = this.add(user, loginStaffId, cid);
        userForm.setUserid(user.getId());
        if (userForm.getUserRoleList() != null) {
            for (SecUserRole userRole : userForm.getUserRoleList()) {
                userRole.setSysUserId(user.getId());
                this.userRoleService.add((Object)userRole, loginStaffId, cid);
            }
        }
        DataScopeUtils.clearCache();
    }

    @Transactional(readOnly=false)
    public void editForm(UserFormVO userForm, Long updateBy, Long cid) throws ServiceException {
        SysUser user = (SysUser)this.getById(userForm.getUserid());
        if (StringUtils.isNotEmpty((String)userForm.getPassword())) {
            this.entryptPassword(user, userForm.getPassword());
        }
        if (userForm.getStaffId() != null && !userForm.getStaffId().equals(user.getStaffId())) {
            this.clearUserStaff(userForm.getStaffId(), updateBy);
            user.setStaffId(userForm.getStaffId());
            user.setFullname(userForm.getStaffname());
        } else if (userForm.getStaffId() == null) {
            user.setStaffId(null);
            user.setFullname(null);
        }
        user.setIsForbidden(userForm.getIsForbidden());
        this.updateByPrimaryKey(user, updateBy);
        this.userRoleService.deleteByUserId(user.getId(), updateBy);
        if (userForm.getUserRoleList() != null) {
            for (SecUserRole userRole : userForm.getUserRoleList()) {
                userRole.setSysUserId(user.getId());
                this.userRoleService.add((Object)userRole, updateBy, cid);
            }
        }
        DataScopeUtils.clearCache();
        this.updateHistory(user, cid, updateBy);
    }

    public SysUser entryptPassword(SysUser user, String plainPassword) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Encodes.hexDecode((String)user.getSalt());
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        return user;
    }

    public void clearUserStaff(Long staffId, Long updateBy) {
        SysUser user = new SysUser();
        user.setStaffId(staffId);
        user.setUpdateBy(updateBy);
        user.setUpdateDate(new Date());
        ((SysUserMapper)this.dao).clearUserStaff(user);
    }

    @Transactional(readOnly=false)
    public SysUser addManger(Long cid, Long staffId, UserModel userinfo) {
        if (userinfo.getIsManger().booleanValue()) {
            this.removeUserManagerRole(cid);
        }
        this.removeStaff(cid, staffId);
        SysUser user = new SysUser();
        user.setFullname(userinfo.getFullname());
        user.setIsManger(userinfo.getIsManger());
        user.setIsForbidden(Global.FALSE);
        user.setUsername(userinfo.getUsername());
        this.entryptPassword(user, userinfo.getPassword());
        user.setCid(cid);
        user.setStaffId(staffId);
        user.setCreateDate(new Date());
        user.setUpdateDate(new Date());
        user = this.add(user);
        if (userinfo.getIsManger().booleanValue()) {
            this.userRoleService.addSuperManagerRole(user.getId(), staffId, cid);
        } else {
            this.userRoleService.addNormalRole(user.getId(), staffId, cid);
        }
        return user;
    }

    @Transactional(readOnly=false)
    public void removeStaff(Long cid, Long staffId) {
        if (staffId == null || cid == null) {
            return;
        }
        SysUser user = new SysUser();
        user.setCid(cid);
        user.setStaffId(staffId);
        ((SysUserMapper)this.dao).clearUserStaff(user);
    }

    @Transactional(readOnly=false)
    public void clearUserManger(Long cid) {
        this.changeOldManagerRole(cid);
        this.clearOldManager(cid);
    }

    private void changeOldManagerRole(Long cid) {
        List<SysUser> managers = this.getUserManager(cid);
        SecRole normalRole = this.secRoleService.getNormalRole();
        if (managers == null || managers.size() == 0 || normalRole == null || normalRole.getId() == null) {
            return;
        }
        for (SysUser user : managers) {
            SecUserRole param = new SecUserRole();
            param.setSecRoleId(normalRole.getId());
            param.setSysUserId(user.getId());
            List userRoles = this.userRoleService.getListByUserId(param);
            if (userRoles != null && userRoles.size() > 0) {
                return;
            }
            SecUserRole userRole = new SecUserRole();
            userRole.setIsValid(Global.TRUE);
            userRole.setSecRoleId(normalRole.getId());
            userRole.setSysUserId(user.getId());
            this.userRoleService.add((Object)userRole, null, cid);
        }
    }

    private void clearOldManager(Long cid) {
        SysUser user = new SysUser();
        user.setIsManger(Global.FALSE);
        user.setUpdateDate(new Date());
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isManger", (Object)Global.TRUE);
        ((SysUserMapper)this.dao).updateByExampleSelective(user, example);
        this.userRoleService.removeUserManagerRole(cid);
    }

    @Transactional(readOnly=false)
    public void removeUserManagerRole(Long cid) {
        this.clearUserManger(cid);
        this.userRoleService.removeUserManagerRole(cid);
    }

    public List<SysUser> getUserListByStaff(Long staffId) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public SysUser updateUserFromStaffInfoForm(Long userId, Long cid, StaffInfo staffForm) {
        SysUser user = (SysUser)this.getById(userId);
        if (user == null) {
            throw new HealthException("\u7528\u6237Id\u9519\u8bef");
        }
        if (user.getStaffId() == null) {
            staffForm.setCid(cid);
            staffForm.setIsThirdParty(Global.FALSE);
            staffForm.setIsValid(Global.TRUE);
            staffForm.setCreateDate(new Date());
            staffForm.setUpdateDate(new Date());
            this.staffInfoService.addStaffInfoSubmit(staffForm);
        } else if (!user.getStaffId().equals(staffForm.getId())) {
            staffForm.setCid(cid);
            staffForm.setIsThirdParty(Global.FALSE);
            staffForm.setIsValid(Global.TRUE);
            staffForm.setCreateDate(new Date());
            staffForm.setUpdateDate(new Date());
            this.staffInfoService.addStaffInfoSubmit(staffForm);
        } else if (user.getStaffId().equals(staffForm.getId())) {
            staffForm.setUpdateDate(new Date());
            this.staffInfoService.editStaffInfoSubmit(staffForm, user.getStaffId());
        }
        user.setStaffId(staffForm.getId());
        if (staffForm.getStaffBasicInfo() != null && StringUtils.isNotEmpty((String)staffForm.getStaffBasicInfo().getRealName())) {
            user.setFullname(staffForm.getStaffBasicInfo().getRealName());
        }
        user.setUpdateDate(new Date());
        this.update(user);
        return user;
    }

    public Integer getCountByCid(Long cid) {
        SysUser user = new SysUser();
        user.setIsValid(Global.TRUE);
        user.setCid(cid);
        user.setIsManger(Global.FALSE);
        user.setIsForbidden(Global.FALSE);
        return ((SysUserMapper)this.dao).selectCount(user);
    }

    public List<SysUser> getUserManager(Long cid) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isManger", (Object)Global.TRUE).andEqualTo("isValid", (Object)Global.TRUE).andNotLike("username", "%-hse");
        return ((SysUserMapper)this.dao).selectByExample(example);
    }

    public List<UserDataScope> getAllDataScopeInfo(Long staffId) {
        return ((SysUserMapper)this.dao).getAllDataScope(staffId);
    }

    public String checkStaff(Long cid, Long staffId) {
        Byte result = this.staffInfoService.getOrgStatusByStaffId(staffId);
        if (result == null) {
            return "\u8be5\u5458\u5de5\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u4eba\u5458\u4fe1\u606f\u6a21\u5757\u5b8c\u5584\u8be5\u5458\u5de5\u4fe1\u606f\u3002";
        }
        if (result == 0 || result == 1) {
            return "\u8be5\u5458\u5de5\u4eba\u5458\u4fe1\u606f\u4e2d\u7684\u90e8\u95e8/\u8f66\u95f4\u4e3a\u7a7a\u6216\u90e8\u95e8\u5df2\u5220\u9664\uff0c\u8bf7\u524d\u5f80\u4eba\u5458\u4fe1\u606f\u6a21\u5757\u5b8c\u5584\u8be5\u5458\u5de5\u4fe1\u606f\u3002";
        }
        return null;
    }

    public SysUser getStaffUser(Long cid, Long staffId, Long userId) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)Global.TRUE).andNotEqualTo("id", (Object)userId);
        List list = ((SysUserMapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (SysUser)list.get(0);
    }

    @Transactional(readOnly=false)
    public Long addUserFromSupervise(UserFormSuperviseInfo userinfo) {
        if (userinfo.getUserid() == null) {
            StaffInfo staffForm = new StaffInfo();
            staffForm.setCid(userinfo.getCid());
            staffForm.setIsThirdParty(Global.FALSE);
            staffForm.setIsValid(Global.TRUE);
            staffForm.setCreateDate(new Date());
            staffForm.setUpdateDate(new Date());
            StaffBasicInfo bas = new StaffBasicInfo();
            bas.setCid(userinfo.getCid());
            bas.setRealName(userinfo.getStaffname());
            bas.setMobile(userinfo.getTel());
            staffForm.setStaffBasicInfo(bas);
            staffForm = this.staffInfoService.addStaffInfoSubmit(staffForm);
            SysUser user = new SysUser();
            user.setStaffId(staffForm.getId());
            user.setCid(userinfo.getCid());
            user.setUsername(userinfo.getUsername());
            user.setFullname(userinfo.getStaffname());
            user.setIsManger(Boolean.valueOf(true));
            user.setIsForbidden(Global.FALSE);
            user.setUsername(userinfo.getUsername());
            this.entryptPassword(user, userinfo.getPassword());
            user = this.add(user);
            SecUserRole userRole = new SecUserRole();
            userRole.setIsValid(Global.TRUE);
            userRole.setSecRoleId(userinfo.getRoleId());
            userRole.setSysUserId(user.getId());
            this.userRoleService.add((Object)userRole, null, userinfo.getCid());
            return user.getId();
        }
        SysUser user = (SysUser)this.getById(userinfo.getUserid());
        user.setUsername(userinfo.getUsername());
        this.entryptPassword(user, userinfo.getPassword());
        this.update(user);
        this.userRoleService.deleteByUserId(user.getId(), user.getStaffId());
        SecUserRole userRole = new SecUserRole();
        userRole.setIsValid(Global.TRUE);
        userRole.setSecRoleId(userinfo.getRoleId());
        userRole.setSysUserId(user.getId());
        this.userRoleService.add((Object)userRole, null, userinfo.getCid());
        return user.getId();
    }

    @Transactional
    public void editCustomUser(UserFormVO userForm, Long updateBy, Long cid) throws ServiceException {
        SysUser user = (SysUser)this.getById(userForm.getUserid());
        if (StrUtil.isNotBlank((CharSequence)userForm.getPassword())) {
            this.entryptPassword(user, userForm.getPassword());
        }
        if (userForm.getStaffId() != null && !userForm.getStaffId().equals(user.getStaffId())) {
            this.clearUserStaff(userForm.getStaffId(), updateBy);
            user.setStaffId(userForm.getStaffId());
        } else if (userForm.getStaffId() == null) {
            user.setStaffId(null);
        }
        user.setFullname(userForm.getFullname());
        user.setIsForbidden(userForm.getIsForbidden());
        this.updateByPrimaryKey(user, updateBy);
        if (userForm.getUserRoleList() != null) {
            this.userRoleService.deleteByUserId(user.getId(), updateBy);
            for (SecUserRole userRole : userForm.getUserRoleList()) {
                userRole.setSysUserId(user.getId());
                this.userRoleService.add((Object)userRole, updateBy, cid);
            }
        }
        DataScopeUtils.clearCache();
        this.updateHistory(user, cid, updateBy);
    }

    @Transactional
    public void addCustomUser(UserFormVO userForm, Long loginStaffId, Long cid) throws ServiceException {
        if (userForm.getStaffId() != null && userForm.getStaffId() > 0L) {
            this.clearUserStaff(userForm.getStaffId(), loginStaffId);
        }
        SysUser user = new SysUser();
        user.setFullname(userForm.getFullname());
        user.setIsManger(Global.FALSE);
        user.setIsForbidden(Global.FALSE);
        user.setUsername(userForm.getUsername());
        user.setStaffId(userForm.getStaffId());
        this.entryptPassword(user, userForm.getPassword());
        user = this.add(user, loginStaffId, cid);
        userForm.setUserid(user.getId());
        if (userForm.getUserRoleList() != null) {
            for (SecUserRole userRole : userForm.getUserRoleList()) {
                userRole.setSysUserId(user.getId());
                this.userRoleService.add((Object)userRole, loginStaffId, cid);
                this.userRoleService.addSysUserRoleV3(user.getId(), Long.valueOf(3000L));
            }
        }
        DataScopeUtils.clearCache();
    }

    @Transactional
    public Integer disableOrEnableUserByCid(Long cid, Integer flag, Long loginUserId) {
        if (cid == null) {
            return 0;
        }
        return this.disableOrEnableUserByCidList(Collections.singletonList(cid), flag, loginUserId);
    }

    @Transactional
    public Integer disableOrEnableUserByCids(String cids, Integer flag, Long loginUserId) {
        if (cids == null) {
            return 0;
        }
        List cidList = CommonUtil.str2LongList((String)cids, (String)",");
        return this.disableOrEnableUserByCidList(cidList, flag, loginUserId);
    }

    @Transactional
    public Integer disableOrEnableUserByCidList(List<Long> cidList, Integer flag, Long loginUserId) {
        if (CollUtil.isEmpty(cidList)) {
            return 0;
        }
        return ((SysUserMapper)this.dao).disableOrEnableUserByCidList(cidList, flag == 1, loginUserId);
    }

    @Transactional(readOnly=false)
    public Integer deleteOrRecoverUserByCid(Long cid, Integer flag) {
        if (cid == null) {
            return 0;
        }
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        Boolean iaValid = false;
        if (flag == 0) {
            iaValid = true;
        }
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)iaValid);
        List list = this.getListByExample(example);
        ((SysUserMapper)this.dao).deleteOrRecoverUserByCid(cid, iaValid == false);
        if (iaValid.booleanValue()) {
            SysLog log = new SysLog();
            log.setTitle("\u5220\u9664\u7528\u6237");
            log.setUsername("\u5220\u9664\u4f01\u4e1a\u7528\u6237");
            log.setFullname("\u5220\u9664\u4f01\u4e1a\u7528\u6237");
            log.setCreateBy(cid);
            log.setUpdateBy(cid);
            log.setCid(cid);
            this.sysLogService.addLog(log);
        }
        return list.size();
    }

    @Transactional
    public Integer resetPasswordByUserId(Long userId, String plainPassword, Long loginUserId) {
        if (userId == null || StringUtils.isEmpty((CharSequence)plainPassword)) {
            return 0;
        }
        SysUser resetUser = new SysUser();
        resetUser.setId(userId);
        resetUser.setUpdateBy(loginUserId);
        resetUser.setUpdateDate(new Date());
        String plain = Encodes.unescapeHtml((String)DigestUtils.md5DigestAsHex((byte[])plainPassword.getBytes()));
        byte[] salt = Digests.generateSalt((int)8);
        resetUser.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        resetUser.setPassword(Encodes.hexEncode((byte[])hashPassword));
        resetUser.setIsDefaultPwd(Boolean.valueOf(true));
        this.update(resetUser);
        SysUser byId = (SysUser)this.getById(userId);
        if (byId != null) {
            String username = byId.getUsername();
            String keyName = "smarthse-web" + Md5Utils.hash((String)username);
            String nullUserKeyname = keyName + "-nulluser";
            this.redisClient.del(new String[]{keyName});
            this.redisClient.del(new String[]{nullUserKeyname});
        }
        return 1;
    }

    @Transactional
    public Integer resetPasswordByUserId(List<Long> userIds, String plainPassword) {
        if (userIds == null || StringUtils.isEmpty((CharSequence)plainPassword)) {
            return 0;
        }
        for (Long userId : userIds) {
            SysUser resetUser = new SysUser();
            resetUser.setId(userId);
            String plain = Encodes.unescapeHtml((String)DigestUtils.md5DigestAsHex((byte[])plainPassword.getBytes()));
            byte[] salt = Digests.generateSalt((int)8);
            resetUser.setSalt(Encodes.hexEncode((byte[])salt));
            byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
            resetUser.setPassword(Encodes.hexEncode((byte[])hashPassword));
            resetUser.setIsDefaultPwd(Boolean.valueOf(true));
            this.update(resetUser);
        }
        return 1;
    }

    public Boolean isBindedPhone(String phone) {
        if (phone == null) {
            return false;
        }
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("mobile", (Object)phone).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    public SysUser getSysUserByMobile(String mobile) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("mobile", (Object)mobile).andEqualTo("isValid", (Object)true).andEqualTo("isForbidden", (Object)false);
        List users = ((SysUserMapper)this.dao).selectByExample(example);
        if (users != null && users.size() > 0) {
            return (SysUser)users.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public int resetPassword(String username, String plainPassword) {
        if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)plainPassword)) {
            return 1;
        }
        SysUser user = this.getUserByuserame(username);
        if (user == null) {
            return 1;
        }
        SysUser resetUser = new SysUser();
        resetUser.setId(user.getId());
        String plain = Encodes.unescapeHtml((String)DigestUtils.md5DigestAsHex((byte[])plainPassword.getBytes()));
        byte[] salt = Digests.generateSalt((int)8);
        resetUser.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        resetUser.setPassword(Encodes.hexEncode((byte[])hashPassword));
        if (Objects.equals("Zyj@2022", plainPassword)) {
            resetUser.setIsDefaultPwd(Boolean.valueOf(true));
        }
        this.update(resetUser);
        return 0;
    }

    @Transactional(readOnly=false)
    public int updateLastLoginTime(Long userId) {
        if (userId != null) {
            SysUser user = new SysUser();
            user.setId(userId);
            user.setLastLoginTime(new Date());
            this.update(user);
            return 1;
        }
        return 0;
    }

    public void clearDataScope() {
        DataScopeUtils.clearCache();
    }

    public List<SysUser> listAllAdmin() {
        return ((SysUserMapper)this.dao).listAllAdmin();
    }

    public SysUserTip getControlNotifByUserId(Long userId) {
        Example e = new Example(SysUserTip.class);
        e.createCriteria().andEqualTo("userId", (Object)userId);
        SysUserTip sysUserTip = (SysUserTip)this.sysUserTipMapper.selectOneByExample(e);
        return sysUserTip;
    }

    @Transactional(readOnly=false)
    public void saveControlNotif(Long userId, Integer controlNotif) {
        Example e = new Example(SysUserTip.class);
        e.createCriteria().andEqualTo("userId", (Object)userId);
        SysUserTip sysUserTip = (SysUserTip)this.sysUserTipMapper.selectOneByExample(e);
        if (sysUserTip == null) {
            SysUserTip tip = new SysUserTip();
            tip.setControlNotif(controlNotif);
            tip.setUserId(userId);
            tip.setControlNotifYear(Integer.valueOf(LocalDate.now().getYear()));
            tip.setCreateDate(new Date());
            this.sysUserTipMapper.insert(tip);
        } else {
            sysUserTip.setControlNotifYear(Integer.valueOf(LocalDate.now().getYear()));
            sysUserTip.setControlNotif(controlNotif);
            sysUserTip.setUpdateDate(new Date());
            this.sysUserTipMapper.updateByPrimaryKeySelective(sysUserTip);
        }
    }

    public SysUser getUserByuserameAndCid(String username, Long cid) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("username", (Object)SpringEncryptUtils.encrypt((String)username)).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        return (SysUser)this.getOneByExample(example);
    }

    @Transactional
    public Integer deleteUserByCid(List<Long> cidList, Long loginUserId) {
        if (CollUtil.isEmpty(cidList)) {
            return 0;
        }
        Example example = new Example(SysUser.class);
        example.createCriteria().andIn("cid", cidList).andEqualTo("isManger", (Object)Boolean.TRUE).andEqualTo("isValid", (Object)Boolean.TRUE);
        SysUser entity = new SysUser();
        entity.setIsValid(Boolean.FALSE);
        this.setUpdateInfo(entity, loginUserId);
        int i = ((SysUserMapper)this.dao).updateByExampleSelective(entity, example);
        try {
            if (i > 0) {
                ArrayList<CompanyCidUserIdModel> list3 = new ArrayList<CompanyCidUserIdModel>(cidList.size());
                cidList.forEach(cid -> {
                    CompanyCidUserIdModel model = new CompanyCidUserIdModel();
                    model.setCid(cid);
                    list3.add(model);
                });
                ((SysUserMapper)this.dao).updateCompanyUserIdList(list3);
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7528\u6237\u5220\u53bb\u4e3b\u8868userId\u51fa\u9519\u4e86", (Throwable)e);
        }
        return i;
    }

    @Transactional(readOnly=false)
    public void updatePassStateThreeMonth() {
        ((SysUserMapper)this.dao).updatePassStateThreeMonth();
    }

    public Boolean isHaveThisName(String name, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)name)) {
            throw new ServiceException("\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("username", (Object)name).andEqualTo("isValid", (Object)Boolean.TRUE);
        if (Objects.nonNull(excludeId)) {
            c.andNotEqualTo("id", (Object)excludeId);
        }
        return this.getCountByExample(example) > 0;
    }

    public Boolean isHaveThisName(List<String> nameList) {
        if (CollUtil.isEmpty(nameList)) {
            throw new ServiceException("\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        nameList = nameList.stream().map(SpringEncryptUtils::encrypt).collect(Collectors.toList());
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andIn("username", nameList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return this.getCountByExample(example) > 0;
    }

    @Transactional
    public void rollbackImportUserData(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        Example example = new Example(SysUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("cid", idList).andEqualTo("isValid", (Object)Boolean.TRUE);
        SysUser sysUser = new SysUser();
        sysUser.setIsValid(Boolean.FALSE);
        sysUser.setUpdateDate(new Date());
        ((SysUserMapper)this.dao).updateByExampleSelective(sysUser, example);
    }

    public List<SysUser> getUserInfoByCidList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        Example example = new Example(SysUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("cid", cidList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return ((SysUserMapper)this.dao).selectByExample(example);
    }

    @Transactional
    public List<SysUser> isDefaultPwdList() {
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isDefaultPwd", (Object)Boolean.FALSE).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = ((SysUserMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        String defaultPwdMD5 = MD5Utils.getMD5String((String)"Zyj@2022");
        String defaultSupervisePwdMD5 = MD5Utils.getMD5String((String)"Zjs@2022");
        List<SysUser> rst = list.parallelStream().filter(user -> {
            byte[] salt = Encodes.hexDecode((String)user.getSalt());
            byte[] hashPassword1 = Digests.sha1((byte[])defaultPwdMD5.getBytes(), (byte[])salt, (int)1024);
            String inputPasswordHash1 = Encodes.hexEncode((byte[])hashPassword1);
            byte[] hashPassword2 = Digests.sha1((byte[])defaultSupervisePwdMD5.getBytes(), (byte[])salt, (int)1024);
            String inputPasswordHash2 = Encodes.hexEncode((byte[])hashPassword2);
            return Objects.equals(inputPasswordHash1, user.getPassword()) || Objects.equals(inputPasswordHash2, user.getPassword());
        }).collect(Collectors.toList());
        this.batchUpdateOrInsert(rst, SysUserMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        return rst;
    }

    @Transactional
    public void logicDeleteMissDataSysUser(Long cid, String username) {
        if (cid == null || StrUtil.isBlank((CharSequence)username)) {
            return;
        }
        ((SysUserMapper)this.dao).logicDeleteMissDataSysUser(cid, SpringEncryptUtils.encrypt((String)username));
    }
}

