/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.sys.SysUserLayoutMapper;
import cn.smarthse.modules.health.entity.sys.SysUserLayout;
import cn.smarthse.modules.health.enums.sys.UserLayoutGroupEnum;
import cn.smarthse.modules.health.service.sys.ISysUserLayoutService;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysUserLayoutServiceImpl
extends BaseServiceImpl<SysUserLayoutMapper, SysUserLayout>
implements ISysUserLayoutService {
    public List<SysUserLayout> getUserLayoutList(Long staffId) {
        Example example = new Example(SysUserLayout.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public void clearUserLayout(Long staffId, String layoutGroup) {
        Example example = new Example(SysUserLayout.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("layoutGroup", (Object)layoutGroup).andEqualTo("isValid", (Object)Global.TRUE);
        SysUserLayout userLayout = new SysUserLayout();
        userLayout.setIsValid(Global.FALSE);
        userLayout.setUpdateDate(new Date());
        ((SysUserLayoutMapper)this.dao).updateByExampleSelective(userLayout, example);
    }

    public SysUserLayout getUserLayout(Long staffId, String layoutGroup) {
        if (staffId == null || StringUtils.isEmpty((CharSequence)layoutGroup)) {
            return null;
        }
        Example example = new Example(SysUserLayout.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("layoutGroup", (Object)layoutGroup).andEqualTo("isValid", (Object)Global.TRUE);
        return (SysUserLayout)this.getOneByExample(example);
    }

    public void updateAndCreateUserLayout(Long cid, Long staffId, UserLayoutGroupEnum layoutGroup, String layoutCodes) {
        SysUserLayout userLayout = this.getUserLayout(staffId, layoutGroup.getName());
        if (userLayout == null) {
            userLayout = new SysUserLayout();
            userLayout.setStaffId(staffId);
            userLayout.setCid(cid);
            userLayout.setLayoutCodes(layoutCodes);
            userLayout.setLayoutGroup(layoutGroup.getName());
            userLayout.setCreateDate(new Date());
            userLayout.setUpdateDate(new Date());
            userLayout.setIsValid(Global.TRUE);
            this.add(userLayout);
        } else {
            userLayout.setIsValid(Global.TRUE);
            userLayout.setLayoutCodes(layoutCodes);
            userLayout.setUpdateDate(new Date());
            this.update(userLayout);
        }
    }

    @Transactional(readOnly=false)
    public void saveUserIndexLayout(Long cid, Long staffId, String indexlayoutCodes, String worklayoutCodes) {
        if (StringUtils.isEmpty((CharSequence)indexlayoutCodes)) {
            this.clearUserLayout(staffId, UserLayoutGroupEnum.index.getName());
        } else {
            this.updateAndCreateUserLayout(cid, staffId, UserLayoutGroupEnum.index, indexlayoutCodes);
        }
        if (StringUtils.isEmpty((CharSequence)worklayoutCodes)) {
            this.clearUserLayout(staffId, UserLayoutGroupEnum.work.getName());
        } else {
            this.updateAndCreateUserLayout(cid, staffId, UserLayoutGroupEnum.work, worklayoutCodes);
        }
    }

    @Transactional(readOnly=false)
    public void saveUserBaseLayout(Long cid, Long staffId, String layoutCodes) {
        if (StringUtils.isEmpty((CharSequence)layoutCodes)) {
            this.clearUserLayout(staffId, UserLayoutGroupEnum.base.getName());
        } else {
            this.updateAndCreateUserLayout(cid, staffId, UserLayoutGroupEnum.base, layoutCodes);
        }
    }
}

