/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.sys.SysUserInviteMapper;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserInvite;
import cn.smarthse.modules.health.enums.sys.UserInviteStateEnum;
import cn.smarthse.modules.health.service.sys.ISysUserInviteService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysUserInviteServiceImpl
extends BaseServiceImpl<SysUserInviteMapper, SysUserInvite>
implements ISysUserInviteService {
    @Transactional(readOnly=false)
    public void initUsername(SysUser user, Long inviteStaffId, Long cid, Long loginStaffId) throws ServiceException {
        SysUserInvite userInvite = new SysUserInvite();
        userInvite.setCid(cid);
        userInvite.setSysUserId(user.getId());
        userInvite.setSysUserName(user.getUsername());
        userInvite.setInviteStaffId(inviteStaffId);
        userInvite.setInviteState(Byte.valueOf(UserInviteStateEnum.pending.getValue()));
        this.add(userInvite, loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void initAgain(Long id, Long cid, Long loginStaffId) {
        SysUserInvite userInvite = (SysUserInvite)this.getById(id);
        if (userInvite != null) {
            userInvite.setInviteState(Byte.valueOf(UserInviteStateEnum.pending.getValue()));
            this.update(userInvite, loginStaffId);
        }
    }

    public PageInfo<SysUserInvite> getListByGridParam(JqGridParam gparam) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        Example example = new Example(SysUserInvite.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("isValid", (Object)Global.TRUE);
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if (sField.getSearchOper().equals(JqGridParam.operType.eq)) {
                    c.andEqualTo(sField.getSearchField(), (Object)sField.getSearchValue());
                    continue;
                }
                if (!sField.getSearchOper().equals(JqGridParam.operType.like)) continue;
                c.andLike(sField.getSearchField(), "%" + sField.getSearchValue() + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            example.setOrderByClause(gparam.getSidx() + " " + gparam.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.getListByExample(example));
    }
}

