/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.SysCoreWorkTodolistMapper;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkTodolist;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkTodolistService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanFirstPageVo;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysCoreWorkTodolistServiceImpl
extends BaseServiceImpl<SysCoreWorkTodolistMapper, SysCoreWorkTodolist>
implements ISysCoreWorkTodolistService {
    @Autowired
    private IHcCheckPlanService checkPlanService;

    @Transactional(readOnly=false)
    public Boolean initTodoList(Long cid, Long loginStaffId) {
        if (cid == null) {
            return false;
        }
        SysCoreWorkTodolist record = new SysCoreWorkTodolist();
        record.setCid(cid);
        record.setIsValid(Boolean.valueOf(true));
        int num = ((SysCoreWorkTodolistMapper)this.dao).selectCount(record);
        if (num == 0) {
            for (CoreWorkEnum coreWork : CoreWorkEnum.values()) {
                for (TodlistInfoTypeEnum type : coreWork.getTypes()) {
                    SysCoreWorkTodolist entity = new SysCoreWorkTodolist();
                    entity.setCoreWorkId(coreWork.getValue());
                    entity.setInfoType(type.getValue());
                    entity.setIsShow(Boolean.valueOf(false));
                    entity.setTitle(type.getName());
                    super.add(entity, loginStaffId, cid);
                }
            }
        }
        return true;
    }

    private List<SysCoreWorkTodolist> getDefaultList(CoreWorkEnum coreWorkEnum) {
        Example example = new Example(SysCoreWorkTodolist.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIsNull("cid").andEqualTo("coreWorkId", (Object)coreWorkEnum.getValue());
        return ((SysCoreWorkTodolistMapper)this.dao).selectByExample(example);
    }

    private List<SysCoreWorkTodolist> getThreeSimultaneityTodoList(Long cid) {
        List<SysCoreWorkTodolist> list = this.getDefaultList(CoreWorkEnum.threeSimultaneityManagement);
        boolean hasData = false;
        for (SysCoreWorkTodolist todolist : list) {
            if (!TodlistInfoTypeEnum.threeSimultaneity_doing.getValue().equals(todolist.getInfoType())) continue;
        }
        if (!hasData) {
            for (SysCoreWorkTodolist todolist : list) {
                if (!TodlistInfoTypeEnum.threeSimultaneity_add.getValue().equals(todolist.getInfoType())) continue;
                todolist.setIsShow(Boolean.valueOf(true));
            }
        }
        return list;
    }

    private List<SysCoreWorkTodolist> getHarmFactorTestTodoList(Long cid) {
        HcCheckPlanFirstPageVo vo = this.checkPlanService.getHcCheckPlanFirstPageVo(cid);
        if (vo == null) {
            return Collections.emptyList();
        }
        List<SysCoreWorkTodolist> list = this.getDefaultList(CoreWorkEnum.harmfactorTest);
        boolean hasData = false;
        for (SysCoreWorkTodolist todolist : list) {
            if (TodlistInfoTypeEnum.harmfactorTest_doing.getValue().equals(todolist.getInfoType())) {
                if (vo.getUnderwayCount() == null || vo.getUnderwayCount() <= 0) continue;
                hasData = true;
                todolist.setIsShow(Boolean.valueOf(true));
                todolist.setNumber(vo.getUnderwayCount());
                todolist.setTitle(todolist.getTitle().replace("X", "" + vo.getUnderwayCount()));
                continue;
            }
            if (TodlistInfoTypeEnum.harmfactorTest_hasAccident.getValue().equals(todolist.getInfoType())) {
                if (vo.getAccidentCount() == null || vo.getAccidentCount() <= 0) continue;
                todolist.setIsShow(Boolean.valueOf(true));
                todolist.setNumber(vo.getAccidentCount());
                todolist.setTitle(todolist.getTitle().replace("X", "" + vo.getAccidentCount()));
                continue;
            }
            if (TodlistInfoTypeEnum.harmfactorTest_hasInconformity.getValue().equals(todolist.getInfoType())) {
                if (!vo.getIsHasNoAccordItem().booleanValue()) continue;
                todolist.setIsShow(Boolean.valueOf(true));
                continue;
            }
            if (TodlistInfoTypeEnum.harmfactorTest_oneYearCheck.getValue().equals(todolist.getInfoType())) {
                if (!vo.getIsHasOneYearToCheck().booleanValue()) continue;
                todolist.setIsShow(Boolean.valueOf(true));
                continue;
            }
            if (TodlistInfoTypeEnum.harmfactorTest_projectRun.getValue().equals(todolist.getInfoType())) {
                if (vo.getThirdTimeList() == null || vo.getThirdTimeList().size() <= 0) continue;
                for (SysCoreWorkModuleCorrelation correlation : vo.getThirdTimeList()) {
                    SysCoreWorkTodolist thirdTime = new SysCoreWorkTodolist();
                    try {
                        thirdTime = (SysCoreWorkTodolist)todolist.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    thirdTime.setTitle(thirdTime.getTitle().replace("XXX", correlation.getBusinessName()));
                    Object url = thirdTime.getActionUrl();
                    if (!StringUtils.isNotEmpty((CharSequence)url)) continue;
                    String businsessIdStr = "&sourceBusinessId=" + correlation.getSurceBusinessId() + "?";
                    url = ((String)url).indexOf("&") > -1 ? ((String)url).replace("&", businsessIdStr) : (String)url + businsessIdStr;
                    thirdTime.setActionUrl((String)url);
                }
                continue;
            }
            if (TodlistInfoTypeEnum.harmfactorTest_reCheck.getValue().equals(todolist.getInfoType()) || !TodlistInfoTypeEnum.harmfactorTest_threeYearCheck.getValue().equals(todolist.getInfoType()) || !vo.getIsHasThreeYearsToCheck().booleanValue()) continue;
            todolist.setIsShow(Boolean.valueOf(true));
        }
        if (!hasData) {
            for (SysCoreWorkTodolist todolist : list) {
                if (!TodlistInfoTypeEnum.harmfactorTest_add.getValue().equals(todolist.getInfoType())) continue;
                todolist.setIsShow(Boolean.valueOf(true));
                break;
            }
        }
        return list;
    }

    @Deprecated
    private List<SysCoreWorkTodolist> getTodolistByModule(CoreWorkEnum coreWorkEnum, Long cid) {
        if (coreWorkEnum == null || cid == null) {
            return Collections.emptyList();
        }
        if (CoreWorkEnum.threeSimultaneityManagement.getValue().equals(coreWorkEnum.getValue())) {
            return this.getThreeSimultaneityTodoList(cid);
        }
        if (CoreWorkEnum.harmfactorTest.getValue().equals(coreWorkEnum.getValue())) {
            return this.getHarmFactorTestTodoList(cid);
        }
        if (CoreWorkEnum.accidentManement.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.emeManagement.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.harmfactorDeclare.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.healthCheck.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.informManagement.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.occupationHygieneInspection.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.personalDoseMonitoring.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.personalProtectionEquipment.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.protectionEquipmentMaintenance.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.reformManagement.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.staffCertificate.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.trainPlan.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.WarningSigns.getValue().equals(coreWorkEnum.getValue()) || CoreWorkEnum.yearPlan.getValue().equals(coreWorkEnum.getValue())) {
            // empty if block
        }
        return null;
    }
}

