/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.component.event.HomeDataEvent;
import cn.smarthse.modules.health.dao.sys.SysCoreWorkModuleCorrelationMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkTodolistIgnore;
import cn.smarthse.modules.health.enums.homedata.HomeDataEventEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkTodolistIgnoreService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=false)
public class SysCoreWorkModuleCorrelationServiceImpl
extends BaseServiceImpl<SysCoreWorkModuleCorrelationMapper, SysCoreWorkModuleCorrelation>
implements ISysCoreWorkModuleCorrelationService {
    @Autowired
    SysCoreWorkModuleCorrelationMapper sysCoreWorkModuleCorrelationMapper;
    @Autowired
    private ICompanyAreaService areaService;
    @Autowired
    private IWorkRoleInfoService workServcie;
    @Autowired
    private ISysCoreWorkTodolistIgnoreService ignoreService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private ApplicationContext ac;

    private SysCoreWorkModuleCorrelation getOldCorrelation(Byte desModule, Byte sourceModule, Long surceBusinessId, Long loginStaffId, Byte stageSource) {
        return this.getOldCorrelation(desModule, sourceModule, surceBusinessId, loginStaffId, stageSource, null);
    }

    private SysCoreWorkModuleCorrelation getOldCorrelation(Byte desModule, Byte sourceModule, Long surceBusinessId, Long loginStaffId, Byte stageSource, Long cid) {
        SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
        entity.setDesModule(desModule);
        entity.setSourceModule(sourceModule);
        entity.setStatus(StatusEnum.none.getValue());
        entity.setSurceBusinessId(surceBusinessId);
        if (stageSource != null) {
            entity.setStageSource(stageSource);
        }
        if (cid != null) {
            entity.setCid(cid);
        }
        List oldEntityList = ((SysCoreWorkModuleCorrelationMapper)this.dao).select(entity);
        SysCoreWorkModuleCorrelation returnEnity = null;
        if (oldEntityList == null || oldEntityList.isEmpty()) {
            return null;
        }
        if (oldEntityList.size() == 1) {
            return (SysCoreWorkModuleCorrelation)oldEntityList.get(0);
        }
        int len = oldEntityList.size();
        for (int i = 0; i < len; ++i) {
            if (i == len) {
                returnEnity = (SysCoreWorkModuleCorrelation)oldEntityList.get(i);
                continue;
            }
            ((SysCoreWorkModuleCorrelation)oldEntityList.get(i)).setStatus(StatusEnum.draff.getValue());
            super.update((SysCoreWorkModuleCorrelation)oldEntityList.get(i), loginStaffId);
        }
        return returnEnity;
    }

    @Transactional(readOnly=false)
    public void threeSimultaneityProjectStudy(Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (businessId == null || StringUtils.isEmpty((CharSequence)businessName) || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getThreeSimultaneityProjectStudyRelationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.threeSimultaneityManagement.getValue(), businessId, loginStaffId, TsProjectPhraseEnum.STUDY.getCode());
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setBusinessName(businessName);
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.threeSimultaneityManagement.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setStageSource(TsProjectPhraseEnum.STUDY.getCode());
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void threeSimultaneityProjectRun(Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (businessId == null || StringUtils.isEmpty((CharSequence)businessName) || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getThreeSimultaneityProjectRunRelationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.threeSimultaneityManagement.getValue(), businessId, loginStaffId, TsProjectPhraseEnum.DEBUG.getCode());
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setBusinessName(businessName);
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.threeSimultaneityManagement.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setStageSource(TsProjectPhraseEnum.DEBUG.getCode());
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void threeSimultaneityComplete(Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (businessId == null || StringUtils.isEmpty((CharSequence)businessName) || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getThreeSimultaneityCompleteRelationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.threeSimultaneityManagement.getValue(), businessId, loginStaffId, TsProjectPhraseEnum.FINISH.getCode());
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setBusinessName(businessName);
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.threeSimultaneityManagement.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setStageSource(TsProjectPhraseEnum.FINISH.getCode());
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void accidentReportComplete(Long businessId, Long loginStaffId, Long cid) {
        if (businessId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getAccidentRelationModel()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.threeSimultaneityManagement.getValue(), businessId, loginStaffId, null);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.accidentManement.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void businessDelete(CoreWorkEnum coreWork, Long businessId, Long loginStaffId, Long cid) {
        block1: {
            if (businessId == null || coreWork == null || loginStaffId == null || cid == null) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            Example example = new Example(SysCoreWorkModuleCorrelation.class);
            example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("desBusinessId", (Object)businessId).andEqualTo("desModule", (Object)coreWork.getValue());
            List list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
            Iterator iterator = list.iterator();
            if (!iterator.hasNext()) break block1;
            SysCoreWorkModuleCorrelation entity = (SysCoreWorkModuleCorrelation)iterator.next();
            entity.setDesBusinessId(null);
            entity.setStatus(StatusEnum.none.getValue());
            super.update(entity, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void soureBusinessDelete(Long businessId, Long loginStaffId) {
        if (businessId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        Example example = new Example(SysCoreWorkModuleCorrelation.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("surceBusinessId", (Object)businessId);
        List list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        for (SysCoreWorkModuleCorrelation entity : list) {
            entity.setIsValid(Boolean.valueOf(false));
            super.update(entity, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void businessStart(CoreWorkEnum coreWork, CoreWorkEnum sourceCoreWork, Long desBusinessId, Long loginStaffId, Long cid, Long ... sourceBusinessIds) {
        if (sourceCoreWork == null || coreWork == null || loginStaffId == null || cid == null || desBusinessId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
        ArrayList list = null;
        entity.setDesModule(coreWork.getValue());
        entity.setStatus(StatusEnum.none.getValue());
        entity.setIsValid(Boolean.valueOf(true));
        if (sourceCoreWork.getValue().equals(CoreWorkEnum.accidentManement.getValue())) {
            entity.setSourceModule(sourceCoreWork.getValue());
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).select(entity);
        } else if (sourceCoreWork.getValue().equals(CoreWorkEnum.threeSimultaneityManagement.getValue()) || sourceCoreWork.getValue().equals(CoreWorkEnum.reformManagement.getValue()) || sourceCoreWork.getValue().equals(CoreWorkEnum.companyWorkType.getValue()) || sourceCoreWork.getValue().equals(CoreWorkEnum.companyArea.getValue()) || sourceCoreWork.getValue().equals(CoreWorkEnum.harmfactorTest.getValue())) {
            if (sourceBusinessIds == null || sourceBusinessIds.length < 1) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            list = new ArrayList();
            for (Long id : sourceBusinessIds) {
                entity.setSurceBusinessId(id);
                list.addAll(((SysCoreWorkModuleCorrelationMapper)this.dao).select(entity));
            }
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SysCoreWorkModuleCorrelation r : list) {
            r.setDesBusinessId(desBusinessId);
            r.setStatus(StatusEnum.draff.getValue());
            super.updateByPrimaryKey(r, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void businessComplete(CoreWorkEnum coreWork, CoreWorkEnum sourceCoreWork, Long desBusinessId, Long loginStaffId, Long cid, Long ... sourceBusinessId) {
        if (sourceCoreWork == null || coreWork == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        Example example = new Example(SysCoreWorkModuleCorrelation.class);
        if (sourceCoreWork.getValue().equals(CoreWorkEnum.accidentManement.getValue())) {
            Long[] criteria = example.or();
            criteria.andEqualTo("sourceModule", (Object)sourceCoreWork.getValue());
            criteria.andEqualTo("desModule", (Object)coreWork.getValue());
            criteria.andEqualTo("isValid", (Object)true);
        } else {
            if (sourceBusinessId == null || sourceBusinessId.length == 0) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            for (Long id : sourceBusinessId) {
                Example.Criteria criteria = example.or();
                criteria.andEqualTo("surceBusinessId", (Object)id);
                criteria.andEqualTo("desModule", (Object)coreWork.getValue());
                criteria.andEqualTo("isValid", (Object)true);
            }
        }
        if (example.getOredCriteria().isEmpty()) {
            return;
        }
        List list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        for (SysCoreWorkModuleCorrelation entity : list) {
            entity.setStatus(StatusEnum.finished.getValue());
            entity.setDesBusinessId(desBusinessId);
            super.updateByPrimaryKey(entity, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public List<SysCoreWorkModuleCorrelation> getListToRemind(CoreWorkEnum sourceCoreWork, CoreWorkEnum desCoreWork, Long cid) {
        if (sourceCoreWork == null || desCoreWork == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        SysCoreWorkModuleCorrelation record = new SysCoreWorkModuleCorrelation();
        record.setSourceModule(sourceCoreWork.getValue());
        record.setDesModule(desCoreWork.getValue());
        record.setStatus(StatusEnum.none.getValue());
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        List list = ((SysCoreWorkModuleCorrelationMapper)this.dao).select(record);
        if (CoreWorkEnum.harmfactorManagePost.name().equals(sourceCoreWork.name()) && list != null && !list.isEmpty()) {
            for (SysCoreWorkModuleCorrelation correlation : list) {
                WorkRoleInfo workRoleInfo = (WorkRoleInfo)this.workServcie.getById(correlation.getSurceBusinessId());
                if (workRoleInfo == null || workRoleInfo.getIsValid().booleanValue()) continue;
                correlation.setBusinessName(correlation.getBusinessName() + "(\u5df2\u5220\u9664)");
            }
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void reformComplete(Long businessId, Long loginStaffId, Long cid) {
        if (businessId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getReformRelationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.reformManagement.getValue(), businessId, loginStaffId, null);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.reformManagement.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void postHarmFactorChange(Long workId, Long loginStaffId, Long cid) {
        if (workId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getHarmfactorManagePostlationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.harmfactorManagePost.getValue(), workId, loginStaffId, null);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.harmfactorManagePost.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(workId);
            WorkRoleInfo work = (WorkRoleInfo)this.workServcie.getById(workId);
            if (work != null) {
                entity.setBusinessName(work.getWorkName());
            }
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional
    public void addHarmFactorManagerTodolistInfo(CoreWorkEnum sourceCoreWork, Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (sourceCoreWork == null || businessId == null || cid == null || businessName == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (CoreWorkEnum.companyArea.getValue().equals(sourceCoreWork.getValue())) {
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setSourceModule(sourceCoreWork.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setCid(cid);
            entity.setDesModule(CoreWorkEnum.harmfactorManageArea.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
            if (count > 0) {
                return;
            }
            super.add(entity, loginStaffId, cid);
        } else if (CoreWorkEnum.companyWorkType.getValue().equals(sourceCoreWork.getValue())) {
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setSourceModule(sourceCoreWork.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setCid(cid);
            entity.setDesModule(CoreWorkEnum.harmfactorManagePost.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
            if (count > 0) {
                return;
            }
            super.add(entity, loginStaffId, cid);
        } else if (CoreWorkEnum.harmfactorTest.getValue().equals(sourceCoreWork.getValue())) {
            CheckPlan hcCheckPlan = (CheckPlan)this.checkPlanService.getById((Serializable)businessId);
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setSourceModule(sourceCoreWork.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setCid(cid);
            entity.setDesModule(CoreWorkEnum.harmfactor.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
            if (count > 0) {
                return;
            }
            if (hcCheckPlan != null) {
                entity.setSourceCreatebyId(hcCheckPlan.getCreateBy());
                String orgIds = hcCheckPlan.getOrgIds();
                if (orgIds != null && orgIds.length() > 0) {
                    Long orgId = null;
                    orgId = orgIds.contains(",") ? Long.valueOf(Long.parseLong(orgIds.split(",")[0])) : Long.valueOf(Long.parseLong(orgIds));
                    entity.setSourceOrgId(orgId);
                }
            }
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void areaHarmFactorChange(Long areaId, Long loginStaffId, Long cid) {
        if (areaId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getHarmfactorManageArealationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.harmfactorManageArea.getValue(), areaId, loginStaffId, null);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.harmfactorManageArea.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(areaId);
            CompanyArea area = (CompanyArea)this.areaService.getById(areaId);
            if (area != null) {
                entity.setBusinessName(area.getAreaName());
            }
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void finishEvaluate(Long evaluateId, String workName, Byte evaluteType, Long loginStaffId, Long cid) {
        if (evaluateId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getEvaluatelationModule()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.evaluate.getValue(), evaluateId, loginStaffId, null);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.evaluate.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(evaluateId);
            entity.setBusinessName(workName);
            entity.setStageSource(evaluteType);
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public ResponseData<Boolean> ignore(TodlistInfoTypeEnum todolistType, CoreWorkEnum sourceCoreWork, CoreWorkEnum desCoreWork, Long sourceBusinessId, Long cid, Long loginStaffId, Byte sourceModule) {
        ResponseData data = new ResponseData();
        data.setContent("");
        if (todolistType != null && sourceCoreWork == null) {
            if (TodlistInfoTypeEnum.isIgnoreNotBusiness((TodlistInfoTypeEnum)todolistType)) {
                SysCoreWorkTodolistIgnore entity = this.ignoreService.getByInfoTypeAndCid(todolistType, cid);
                if (entity == null) {
                    entity = new SysCoreWorkTodolistIgnore();
                    entity.setInfoType(todolistType.getValue());
                    entity.setCid(cid);
                    entity.setIgnoreDate(new Date());
                    this.ignoreService.add((Object)entity, loginStaffId, cid);
                } else {
                    entity.setIgnoreDate(new Date());
                    this.ignoreService.updateByPrimaryKey((Object)entity, loginStaffId);
                }
                data.setResult((Object)true);
                return data;
            }
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (sourceCoreWork == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (desCoreWork == null || cid == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        List list = null;
        if (sourceCoreWork.getValue().equals(CoreWorkEnum.accidentManement.getValue())) {
            example = new Example(SysCoreWorkModuleCorrelation.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("sourceModule", (Object)sourceCoreWork.getValue()).andEqualTo("desModule", (Object)desCoreWork.getValue()).andEqualTo("status", (Object)StatusEnum.none.getValue());
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        } else if (sourceCoreWork.getValue().equals(CoreWorkEnum.threeSimultaneityManagement.getValue())) {
            Byte stageSource;
            if (sourceBusinessId == null) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            example = new Example(SysCoreWorkModuleCorrelation.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("sourceModule", (Object)sourceModule).andEqualTo("desModule", (Object)desCoreWork.getValue()).andEqualTo("surceBusinessId", (Object)sourceBusinessId);
            if (todolistType != null && (stageSource = TodlistInfoTypeEnum.getThreeTimeStageByValue((Byte)todolistType.getValue())) != null) {
                criteria.andEqualTo("stageSource", (Object)stageSource);
            }
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        } else if (CoreWorkEnum.harmfactorManagePost.getValue().equals(sourceCoreWork.getValue()) || CoreWorkEnum.harmfactorManageArea.getValue().equals(sourceCoreWork.getValue())) {
            if (sourceBusinessId == null) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            if (CoreWorkEnum.harmfactorManagePost.getValue().equals(sourceCoreWork.getValue())) {
                workRoleInfo = (WorkRoleInfo)this.workServcie.getById(sourceBusinessId);
                if (workRoleInfo == null || !workRoleInfo.getIsValid().booleanValue()) {
                    data.setContent("\u8be5\u5c97\u4f4d\u5df2\u5220\u9664");
                    data.setResult((Object)true);
                }
            } else if (CoreWorkEnum.harmfactorManageArea.getValue().equals(sourceCoreWork.getValue()) && ((area = (CompanyArea)this.areaService.getById(sourceBusinessId)) == null || !area.getIsValid().booleanValue())) {
                data.setContent("\u8be5\u533a\u57df\u5df2\u5220\u9664");
                data.setResult((Object)true);
            }
            example = new Example(SysCoreWorkModuleCorrelation.class);
            example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("sourceModule", (Object)sourceCoreWork.getValue()).andEqualTo("desModule", (Object)desCoreWork.getValue()).andEqualTo("surceBusinessId", (Object)sourceBusinessId);
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        } else if (CoreWorkEnum.companyArea.getValue().equals(sourceCoreWork.getValue()) || CoreWorkEnum.companyWorkType.getValue().equals(sourceCoreWork.getValue()) || CoreWorkEnum.harmfactorTest.getValue().equals(sourceCoreWork.getValue())) {
            if (sourceBusinessId == null) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            if (CoreWorkEnum.companyWorkType.getValue().equals(sourceCoreWork.getValue())) {
                workRoleInfo = (WorkRoleInfo)this.workServcie.getById(sourceBusinessId);
                if (workRoleInfo == null || !workRoleInfo.getIsValid().booleanValue()) {
                    data.setContent("\u8be5\u5c97\u4f4d\u5df2\u5220\u9664");
                    data.setResult((Object)true);
                }
            } else if (CoreWorkEnum.companyArea.getValue().equals(sourceCoreWork.getValue()) && ((area = (CompanyArea)this.areaService.getById(sourceBusinessId)) == null || !area.getIsValid().booleanValue())) {
                data.setContent("\u8be5\u533a\u57df\u5df2\u5220\u9664");
                data.setResult((Object)true);
            }
            example = new Example(SysCoreWorkModuleCorrelation.class);
            ArrayList<Byte> desModule = new ArrayList<Byte>();
            desModule.add(CoreWorkEnum.harmfactor.getValue());
            desModule.add(CoreWorkEnum.harmfactorManageArea.getValue());
            desModule.add(CoreWorkEnum.harmfactorManagePost.getValue());
            if (CoreWorkEnum.harmfactorTest.getValue().equals(desCoreWork.getValue())) {
                desModule.add(CoreWorkEnum.harmfactorTest.getValue());
            }
            example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("sourceModule", (Object)sourceCoreWork.getValue()).andIn("desModule", desModule).andEqualTo("surceBusinessId", (Object)sourceBusinessId);
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        } else if (sourceCoreWork.getValue().equals(CoreWorkEnum.evaluate.getValue())) {
            if (sourceBusinessId == null) {
                throw new HealthException(ErrorEnum.PARAMETER_ERROR);
            }
            example = new Example(SysCoreWorkModuleCorrelation.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("sourceModule", (Object)sourceCoreWork.getValue()).andEqualTo("desModule", (Object)desCoreWork.getValue()).andEqualTo("surceBusinessId", (Object)sourceBusinessId);
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        } else if (sourceCoreWork.getValue().equals(CoreWorkEnum.AllWork.getValue())) {
            example = new Example(SysCoreWorkModuleCorrelation.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("desModule", (Object)desCoreWork.getValue()).andEqualTo("surceBusinessId", (Object)sourceBusinessId);
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        } else {
            example = new Example(SysCoreWorkModuleCorrelation.class);
            criteria = example.createCriteria();
            criteria.andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("sourceModule", (Object)sourceCoreWork.getValue()).andEqualTo("desModule", (Object)desCoreWork.getValue()).andEqualTo("surceBusinessId", (Object)sourceBusinessId);
            list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        }
        if (list != null) {
            for (SysCoreWorkModuleCorrelation r : list) {
                r.setDesBusinessId(null);
                r.setStatus(StatusEnum.ignore.getValue());
                super.updateByPrimaryKey(r, loginStaffId);
            }
            data.setResult((Object)true);
            return data;
        }
        data.setResult((Object)false);
        data.setContent("\u672a\u627e\u5230\u9700\u8981\u5ffd\u7565\u7684\u4fe1\u606f");
        return data;
    }

    public Date getIgnoreLastDateTime(TodlistInfoTypeEnum todolistType, Long cid) {
        if (todolistType == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (!TodlistInfoTypeEnum.isIgnoreNotBusiness((TodlistInfoTypeEnum)todolistType)) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        SysCoreWorkTodolistIgnore entity = this.ignoreService.getByInfoTypeAndCid(todolistType, cid);
        if (entity == null) {
            return null;
        }
        return entity.getIgnoreDate();
    }

    public boolean hasIgnoreData(TodlistInfoTypeEnum type, Long cid, int year) {
        if (type == null || cid == null) {
            return false;
        }
        Date lastDate = this.getIgnoreLastDateTime(type, cid);
        if (lastDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendar.get(1) - year);
        return lastDate.getTime() >= calendar.getTimeInMillis();
    }

    public boolean hasThisYearIgnoreData(TodlistInfoTypeEnum type, Long cid, int year) {
        if (type == null || cid == null) {
            return false;
        }
        Date lastDate = this.getIgnoreLastDateTime(type, cid);
        if (lastDate == null) {
            return false;
        }
        Calendar ignoreDate = Calendar.getInstance();
        ignoreDate.setTime(lastDate);
        int ignoreYear = ignoreDate.get(1);
        return ignoreYear == year;
    }

    public boolean hasMonthIgnoreData(TodlistInfoTypeEnum type, Long cid, int month) {
        if (type == null || cid == null) {
            return false;
        }
        Date lastDate = this.getIgnoreLastDateTime(type, cid);
        if (lastDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) - month);
        return lastDate.getTime() >= calendar.getTimeInMillis();
    }

    @Transactional(readOnly=false)
    public void uploadedEvaluateByOrgan(Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (businessId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getUploadedEvaluateByOrgan()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.evaluate.getValue(), businessId, loginStaffId, null);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.evaluate.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void uploadedCheckByOrgan(Long businessId, String businessName, Byte businessState, Long loginStaffId, Long cid) {
        this.ac.publishEvent((ApplicationEvent)new HomeDataEvent(cid, HomeDataEventEnum.OCC_HEALTH_CHECK));
        if (businessId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getUploadedCheckByOrgan()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.healthCheck.getValue(), businessId, loginStaffId, null, cid);
            if (oldEntity == null) {
                SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
                entity.setDesModule(coreWork.getValue());
                entity.setSourceModule(CoreWorkEnum.healthCheck.getValue());
                entity.setStatus(StatusEnum.none.getValue());
                entity.setSurceBusinessId(businessId);
                entity.setBusinessName(businessName);
                entity.setBusinessState(businessState);
                super.add(entity, loginStaffId, cid);
                continue;
            }
            oldEntity.setBusinessState(businessState);
            super.update(oldEntity, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void uploadedDiseaserByOrgan(Long businessId, String diseaserName, Long loginStaffId, Long cid) {
        if (businessId == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        for (CoreWorkEnum coreWork : CoreWorkEnum.getUploadedDiseaserByOrgan()) {
            SysCoreWorkModuleCorrelation oldEntity = this.getOldCorrelation(coreWork.getValue(), CoreWorkEnum.diseaser.getValue(), businessId, loginStaffId, null, cid);
            if (oldEntity != null) continue;
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setDesModule(coreWork.getValue());
            entity.setSourceModule(CoreWorkEnum.diseaser.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(diseaserName);
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void appearHcCheckThirdPlan(CoreWorkEnum sourceCoreWork, Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (CoreWorkEnum.harmfactorTest.getValue().equals(sourceCoreWork.getValue())) {
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setSourceModule(sourceCoreWork.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setCid(cid);
            entity.setDesModule(CoreWorkEnum.harmfactorTest.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
            if (count > 0) {
                return;
            }
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void addByNoCheckPlan(CoreWorkEnum sourceCoreWork, Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (CoreWorkEnum.harmfactorNoCheck.getValue().equals(sourceCoreWork.getValue())) {
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setSourceModule(sourceCoreWork.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setCid(cid);
            entity.setDesModule(CoreWorkEnum.harmfactorNoCheck.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
            if (count > 0) {
                return;
            }
            super.add(entity, loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void businessStartPlan(CoreWorkEnum sourceCoreWork, Long sourceBusinessId, Long loginStaffId, Long cid, String businessName, Long desBusinessId) {
        SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
        entity.setSourceModule(sourceCoreWork.getValue());
        entity.setSurceBusinessId(sourceBusinessId);
        entity.setIsValid(Boolean.valueOf(true));
        entity.setCid(cid);
        entity.setDesModule(CoreWorkEnum.yearPlan.getValue());
        entity.setDesBusinessId(desBusinessId);
        entity.setStatus(StatusEnum.none.getValue());
        int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
        if (count > 0) {
            return;
        }
        entity.setBusinessName(businessName);
        super.add(entity, loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void businessCompletePlan(CoreWorkEnum sourceCoreWork, Long sourceBusinessId, Long loginStaffId, Long cid, String businessName) {
        if (sourceCoreWork == null || sourceCoreWork == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        Example example = new Example(SysCoreWorkModuleCorrelation.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("sourceModule", (Object)sourceCoreWork.getValue());
        criteria.andNotEqualTo("surceBusinessId", (Object)sourceBusinessId);
        criteria.andEqualTo("desModule", (Object)CoreWorkEnum.yearPlan.getValue());
        criteria.andEqualTo("isValid", (Object)true);
        List list = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectByExample(example);
        for (SysCoreWorkModuleCorrelation entity : list) {
            entity.setStatus(StatusEnum.complete.getValue());
            entity.setBusinessName(businessName);
            super.updateByPrimaryKey(entity, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public List<SysCoreWorkModuleCorrelation> getCompletedWorkListToRemind(Long cid, Long loginStaffId) {
        if (loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        SysCoreWorkModuleCorrelation record = new SysCoreWorkModuleCorrelation();
        record.setDesModule(CoreWorkEnum.yearPlan.getValue());
        record.setStatus(StatusEnum.complete.getValue());
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        record.setCreateBy(loginStaffId);
        List list = ((SysCoreWorkModuleCorrelationMapper)this.dao).select(record);
        return list;
    }

    @Transactional(readOnly=false)
    public void appearOrgTrainPlan(CoreWorkEnum sourceCoreWork, Long businessId, String businessName, Long loginStaffId, Long cid) {
        if (CoreWorkEnum.trainPlan.getValue().equals(sourceCoreWork.getValue())) {
            SysCoreWorkModuleCorrelation entity = new SysCoreWorkModuleCorrelation();
            entity.setSourceModule(sourceCoreWork.getValue());
            entity.setSurceBusinessId(businessId);
            entity.setBusinessName(businessName);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setCid(cid);
            entity.setDesModule(CoreWorkEnum.trainPlan.getValue());
            entity.setStatus(StatusEnum.none.getValue());
            int count = ((SysCoreWorkModuleCorrelationMapper)this.dao).selectCount(entity);
            if (count > 0) {
                return;
            }
            super.add(entity, loginStaffId, cid);
        }
    }
}

