/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.SecUserRoleMapper;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.vo.SecUserRoleVO;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SecUserRoleServiceImpl
extends BaseServiceImpl<SecUserRoleMapper, SecUserRole>
implements ISecUserRoleService {
    @Autowired
    ISecRoleService roleService;

    public List<SecUserRole> getListByUserId(Long userId) {
        Example example = new Example(SecUserRole.class);
        example.createCriteria().andEqualTo("sysUserId", (Object)userId).andEqualTo("isValid", (Object)Global.TRUE);
        return ((SecUserRoleMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void deleteByUserId(Long userId, Long updateBy) {
        Example example = new Example(SecUserRole.class);
        example.createCriteria().andEqualTo("sysUserId", (Object)userId).andEqualTo("isValid", (Object)Global.TRUE);
        SecUserRole userRole = new SecUserRole();
        userRole.setSysUserId(userId);
        userRole.setIsValid(Global.FALSE);
        userRole.setUpdateBy(updateBy);
        ((SecUserRoleMapper)this.dao).updateByExampleSelective(userRole, example);
    }

    public List<SecUserRoleVO> getUserRoleAndPermissionsByUserId(Long userId) {
        if (userId == null) {
            return null;
        }
        return ((SecUserRoleMapper)this.dao).getUserRoleAndPermissionsByUserId(userId);
    }

    public void addSuperManagerRole(Long userId, Long staffId, Long cid) {
        this.addUserRole(userId, staffId, cid, "superManager");
    }

    private void addUserRole(Long userId, Long staffId, Long cid, String roleName) {
        if (userId == null) {
            return;
        }
        SecRole role = null;
        role = "superManager".equals(roleName) ? this.roleService.getSuperManager() : this.roleService.getNormalRole();
        if (role == null || role.getId() == null) {
            return;
        }
        SecUserRole param = new SecUserRole();
        param.setSecRoleId(role.getId());
        param.setSysUserId(userId);
        List<SecUserRole> userRoles = this.getListByUserId(param);
        if (userRoles != null && userRoles.size() > 0) {
            return;
        }
        SecUserRole userRole = new SecUserRole();
        userRole.setIsValid(Global.TRUE);
        userRole.setSecRoleId(role.getId());
        userRole.setSysUserId(userId);
        this.add(userRole, staffId, cid);
    }

    public List<SecUserRole> getListByUserId(SecUserRole param) {
        Example example = new Example(SecUserRole.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Global.TRUE);
        if (param.getSysUserId() != null) {
            criteria.andEqualTo("sysUserId", (Object)param.getSysUserId());
        }
        if (param.getSecRoleId() != null) {
            criteria.andEqualTo("secRoleId", (Object)param.getSecRoleId());
        }
        return ((SecUserRoleMapper)this.dao).selectByExample(example);
    }

    public void removeUserManagerRole(Long cid) {
        if (cid == null) {
            return;
        }
        SecRole role = this.roleService.getSuperManager();
        if (role == null || role.getId() == null) {
            return;
        }
        ((SecUserRoleMapper)this.dao).removeUserManagerRole(cid, role.getId());
    }

    public void addNormalRole(Long userId, Long staffId, Long cid) {
        this.addUserRole(userId, staffId, cid, "normalUser");
    }

    public void addNormalRoleIfHaveNotRole(Long userId, Long staffId, Long cid) {
        SecRole role = this.roleService.getSuperManager();
        Example example = new Example(SecUserRole.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Global.TRUE);
        criteria.andEqualTo("sysUserId", (Object)userId);
        criteria.andNotEqualTo("secRoleId", (Object)role.getId());
        List otherRoles = ((SecUserRoleMapper)this.dao).selectByExample(example);
        if (otherRoles == null || otherRoles.size() == 0) {
            this.addUserRole(userId, staffId, cid, "normalUser");
        }
    }

    @Transactional
    public void addSysUserRoleV3(Long userId, Long roleId) {
        if (userId == null || roleId == null) {
            return;
        }
        ((SecUserRoleMapper)this.dao).addSysUserRoleV3(userId, roleId);
    }
}

