/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.SecRoleMapper;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SecRoleServiceImpl
extends BaseServiceImpl<SecRoleMapper, SecRole>
implements ISecRoleService {
    public PageInfo<SecRole> getRoleList(JqGridParam gparam, List<Long> roleIds) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return new PageInfo(this.getListBycid(gparam.getCid(), roleIds));
    }

    public List<SecRole> getListBycid(Long cid, List<Long> roleIds) {
        Example example = new Example(SecRole.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andIsNull("cid");
        if (roleIds != null && roleIds.size() > 0) {
            c.andIn("id", roleIds);
        }
        if (cid != null && cid > 0L) {
            Example.Criteria c_or = example.or();
            c_or.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid);
        }
        return this.getListByExample(example);
    }

    public List<SecRole> getListByQuery(SecPermissionParam query) {
        return ((SecRoleMapper)this.dao).getListByQuery(query);
    }

    public SecRole getSuperManager() {
        Example example = new Example(SecRole.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        c.andEqualTo("isSuperManager", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (SecRole)list.get(0);
    }

    public SecRole getNormalRole() {
        Example example = new Example(SecRole.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        c.andEqualTo("rolename", (Object)"\u4e00\u822c\u7528\u6237");
        List list = this.getListByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (SecRole)list.get(0);
    }

    public SecRole getByRoleName(String roleName) {
        Example example = new Example(SecRole.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        c.andEqualTo("rolename", (Object)roleName);
        List list = this.getListByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (SecRole)list.get(0);
    }
}

