/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeUtils;
import cn.smarthse.modules.health.dao.sys.SecRolePermissionMapper;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.SecRolePermission;
import cn.smarthse.modules.health.entity.sys.vo.RoleFormVO;
import cn.smarthse.modules.health.service.sys.ISecRolePermissionService;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SecRolePermissionServiceImpl
extends BaseServiceImpl<SecRolePermissionMapper, SecRolePermission>
implements ISecRolePermissionService {
    @Autowired
    ISecRoleService roleService;

    public List<SecRolePermission> getRolePermissionListByRoleId(Long roleId) {
        Example example = new Example(SecRolePermission.class);
        example.createCriteria().andEqualTo("secRoleId", (Object)roleId).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public SecRole editForm(RoleFormVO roleForm, Long loginStaffId, Long cid) throws ServiceException {
        SecRole role = null;
        if (roleForm.getId() == null || roleForm.getId() == 0L) {
            role = new SecRole();
            role.setRolename(roleForm.getRolename());
            role.setDescription(roleForm.getDescription());
            role.setDataScope(roleForm.getDataScope());
            role = (SecRole)this.roleService.add((Object)role, loginStaffId, cid);
        } else {
            role = (SecRole)this.roleService.getById(roleForm.getId());
            role.setRolename(roleForm.getRolename());
            role.setDescription(roleForm.getDescription());
            role.setDataScope(roleForm.getDataScope());
            this.roleService.update((Object)role, loginStaffId);
            DataScopeUtils.clearCache();
        }
        this.deleteRolePermissionByRoleId(role.getId());
        List rpList = roleForm.getRpList();
        if (rpList == null) {
            return role;
        }
        for (SecRolePermission rp : rpList) {
            rp.setSecRoleId(role.getId());
            this.add(rp, loginStaffId, cid);
        }
        return role;
    }

    private void deleteRolePermissionByRoleId(Long roleId) {
        if (roleId == null) {
            return;
        }
        Example example = new Example(SecRolePermission.class);
        example.createCriteria().andEqualTo("secRoleId", (Object)roleId);
        ((SecRolePermissionMapper)this.dao).deleteByExample(example);
    }
}

